package software.amazon.awscdk.services.batch;

/**
 * Props for EcsJobDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * EcsJobDefinition ecsJob = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * JobQueue queue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(ManagedEc2EcsComputeEnvironment.Builder.create(this, "managedEc2CE")
 *                         .vpc(vpc)
 *                         .build())
 *                 .order(1)
 *                 .build()))
 *         .priority(10)
 *         .build();
 * User user = new User(this, "MyUser");
 * ecsJob.grantSubmitJob(user, queue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:50.952Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(EcsJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsJobDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.JobDefinitionProps {

    /**
     * The container that this job will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IEcsContainerDefinition getContainer();

    /**
     * Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPropagateTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsJobDefinitionProps> {
        software.amazon.awscdk.services.batch.IEcsContainerDefinition container;
        java.lang.Boolean propagateTags;
        java.lang.String jobDefinitionName;
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.Number retryAttempts;
        java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies;
        java.lang.Number schedulingPriority;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getContainer}
         * @param container The container that this job will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder container(software.amazon.awscdk.services.batch.IEcsContainerDefinition container) {
            this.container = container;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getPropagateTags}
         * @param propagateTags Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(java.lang.Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of this job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getParameters}
         * @param parameters The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getRetryAttempts}
         * @param retryAttempts The number of times to retry a job.
         *                      The job is retried on failure the same number of attempts as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getRetryStrategies}
         * @param retryStrategies Defines the retry behavior for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder retryStrategies(java.util.List<? extends software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies) {
            this.retryStrategies = (java.util.List<software.amazon.awscdk.services.batch.RetryStrategy>)retryStrategies;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getSchedulingPriority}
         * @param schedulingPriority The priority of this Job.
         *                           Only used in Fairshare Scheduling
         *                           to decide which job to run first when there are multiple jobs
         *                           with the same share identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(java.lang.Number schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        /**
         * Sets the value of {@link EcsJobDefinitionProps#getTimeout}
         * @param timeout The timeout time for jobs that are submitted with this job definition.
         *                After the amount of time you specify passes,
         *                Batch terminates your jobs if they aren't finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsJobDefinitionProps {
        private final software.amazon.awscdk.services.batch.IEcsContainerDefinition container;
        private final java.lang.Boolean propagateTags;
        private final java.lang.String jobDefinitionName;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.Number retryAttempts;
        private final java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies;
        private final java.lang.Number schedulingPriority;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IEcsContainerDefinition.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.retryStrategies = software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class)));
            this.schedulingPriority = software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.container = java.util.Objects.requireNonNull(builder.container, "container is required");
            this.propagateTags = builder.propagateTags;
            this.jobDefinitionName = builder.jobDefinitionName;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.retryAttempts = builder.retryAttempts;
            this.retryStrategies = (java.util.List<software.amazon.awscdk.services.batch.RetryStrategy>)builder.retryStrategies;
            this.schedulingPriority = builder.schedulingPriority;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.batch.IEcsContainerDefinition getContainer() {
            return this.container;
        }

        @Override
        public final java.lang.Boolean getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
            return this.retryStrategies;
        }

        @Override
        public final java.lang.Number getSchedulingPriority() {
            return this.schedulingPriority;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("container", om.valueToTree(this.getContainer()));
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getRetryStrategies() != null) {
                data.set("retryStrategies", om.valueToTree(this.getRetryStrategies()));
            }
            if (this.getSchedulingPriority() != null) {
                data.set("schedulingPriority", om.valueToTree(this.getSchedulingPriority()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EcsJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsJobDefinitionProps.Jsii$Proxy that = (EcsJobDefinitionProps.Jsii$Proxy) o;

            if (!container.equals(that.container)) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            if (this.retryStrategies != null ? !this.retryStrategies.equals(that.retryStrategies) : that.retryStrategies != null) return false;
            if (this.schedulingPriority != null ? !this.schedulingPriority.equals(that.schedulingPriority) : that.schedulingPriority != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.container.hashCode();
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.retryStrategies != null ? this.retryStrategies.hashCode() : 0);
            result = 31 * result + (this.schedulingPriority != null ? this.schedulingPriority.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
