package software.amazon.awscdk.services.bedrock;

/**
 * Specifies a knowledge base as a resource in a top-level template. Minimally, you must specify the following properties:.
 * <p>
 * <ul>
 * <li>Name – Specify a name for the knowledge base.</li>
 * <li>RoleArn – Specify the Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-permissions.html">Create a service role for Knowledge base for Amazon Bedrock</a> .</li>
 * <li>KnowledgeBaseConfiguration – Specify the embeddings configuration of the knowledge base. The following sub-properties are required:</li>
 * <li>Type – Specify the value <code>VECTOR</code> .</li>
 * <li>StorageConfiguration – Specify information about the vector store in which the data source is stored. The following sub-properties are required:</li>
 * <li>Type – Specify the vector store service that you are using.</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * Redis Enterprise Cloud vector stores are currently unsupported in AWS CloudFormation .
 * <p>
 * </blockquote>
 * <p>
 * For more information about using knowledge bases in Amazon Bedrock , see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Knowledge base for Amazon Bedrock</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnKnowledgeBase cfnKnowledgeBase = CfnKnowledgeBase.Builder.create(this, "MyCfnKnowledgeBase")
 *         .knowledgeBaseConfiguration(KnowledgeBaseConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .kendraKnowledgeBaseConfiguration(KendraKnowledgeBaseConfigurationProperty.builder()
 *                         .kendraIndexArn("kendraIndexArn")
 *                         .build())
 *                 .sqlKnowledgeBaseConfiguration(SqlKnowledgeBaseConfigurationProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .redshiftConfiguration(RedshiftConfigurationProperty.builder()
 *                                 .queryEngineConfiguration(RedshiftQueryEngineConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .provisionedConfiguration(RedshiftProvisionedConfigurationProperty.builder()
 *                                                 .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .databaseUser("databaseUser")
 *                                                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
 *                                                         .build())
 *                                                 .clusterIdentifier("clusterIdentifier")
 *                                                 .build())
 *                                         .serverlessConfiguration(RedshiftServerlessConfigurationProperty.builder()
 *                                                 .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
 *                                                         .build())
 *                                                 .workgroupArn("workgroupArn")
 *                                                 .build())
 *                                         .build())
 *                                 .storageConfigurations(List.of(RedshiftQueryEngineStorageConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
 *                                                 .tableNames(List.of("tableNames"))
 *                                                 .build())
 *                                         .redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
 *                                                 .databaseName("databaseName")
 *                                                 .build())
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .queryGenerationConfiguration(QueryGenerationConfigurationProperty.builder()
 *                                         .executionTimeoutSeconds(123)
 *                                         .generationContext(QueryGenerationContextProperty.builder()
 *                                                 .curatedQueries(List.of(CuratedQueryProperty.builder()
 *                                                         .naturalLanguage("naturalLanguage")
 *                                                         .sql("sql")
 *                                                         .build()))
 *                                                 .tables(List.of(QueryGenerationTableProperty.builder()
 *                                                         .name("name")
 *                                                         // the properties below are optional
 *                                                         .columns(List.of(QueryGenerationColumnProperty.builder()
 *                                                                 .description("description")
 *                                                                 .inclusion("inclusion")
 *                                                                 .name("name")
 *                                                                 .build()))
 *                                                         .description("description")
 *                                                         .inclusion("inclusion")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfigurationProperty.builder()
 *                         .embeddingModelArn("embeddingModelArn")
 *                         // the properties below are optional
 *                         .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
 *                                 .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
 *                                         .dimensions(123)
 *                                         .embeddingDataType("embeddingDataType")
 *                                         .build())
 *                                 .build())
 *                         .supplementalDataStorageConfiguration(SupplementalDataStorageConfigurationProperty.builder()
 *                                 .supplementalDataStorageLocations(List.of(SupplementalDataStorageLocationProperty.builder()
 *                                         .supplementalDataStorageLocationType("supplementalDataStorageLocationType")
 *                                         // the properties below are optional
 *                                         .s3Location(S3LocationProperty.builder()
 *                                                 .uri("uri")
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .storageConfiguration(StorageConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .mongoDbAtlasConfiguration(MongoDbAtlasConfigurationProperty.builder()
 *                         .collectionName("collectionName")
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .databaseName("databaseName")
 *                         .endpoint("endpoint")
 *                         .fieldMapping(MongoDbAtlasFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         // the properties below are optional
 *                         .endpointServiceName("endpointServiceName")
 *                         .textIndexName("textIndexName")
 *                         .build())
 *                 .neptuneAnalyticsConfiguration(NeptuneAnalyticsConfigurationProperty.builder()
 *                         .fieldMapping(NeptuneAnalyticsFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .build())
 *                         .graphArn("graphArn")
 *                         .build())
 *                 .opensearchManagedClusterConfiguration(OpenSearchManagedClusterConfigurationProperty.builder()
 *                         .domainArn("domainArn")
 *                         .domainEndpoint("domainEndpoint")
 *                         .fieldMapping(OpenSearchManagedClusterFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         .build())
 *                 .opensearchServerlessConfiguration(OpenSearchServerlessConfigurationProperty.builder()
 *                         .collectionArn("collectionArn")
 *                         .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         .build())
 *                 .pineconeConfiguration(PineconeConfigurationProperty.builder()
 *                         .connectionString("connectionString")
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .fieldMapping(PineconeFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .build())
 *                         // the properties below are optional
 *                         .namespace("namespace")
 *                         .build())
 *                 .rdsConfiguration(RdsConfigurationProperty.builder()
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .databaseName("databaseName")
 *                         .fieldMapping(RdsFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .primaryKeyField("primaryKeyField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 // the properties below are optional
 *                                 .customMetadataField("customMetadataField")
 *                                 .build())
 *                         .resourceArn("resourceArn")
 *                         .tableName("tableName")
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.212Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase")
public class CfnKnowledgeBase extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKnowledgeBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time the knowledge base was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A list of reasons that the API operation on the knowledge base failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrFailureReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrFailureReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseArn() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for a knowledge base associated with the inline agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseId() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the knowledge base was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKnowledgeBaseConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseConfiguration", java.util.Objects.requireNonNull(value, "knowledgeBaseConfiguration is required"));
    }

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseConfiguration", java.util.Objects.requireNonNull(value, "knowledgeBaseConfiguration is required"));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The description of the knowledge base associated with the inline agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the knowledge base associated with the inline agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "storageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageConfiguration", value);
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.StorageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "storageConfiguration", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The vector configuration details for the Bedrock embeddings model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * BedrockEmbeddingModelConfigurationProperty bedrockEmbeddingModelConfigurationProperty = BedrockEmbeddingModelConfigurationProperty.builder()
     *         .dimensions(123)
     *         .embeddingDataType("embeddingDataType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BedrockEmbeddingModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BedrockEmbeddingModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-bedrockembeddingmodelconfiguration-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-bedrockembeddingmodelconfiguration-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDimensions() {
            return null;
        }

        /**
         * The data type for the vectors when using a model to convert text into vector embeddings.
         * <p>
         * The model must support the specified data type for vector embeddings. Floating-point (float32) is the default data type, and is supported by most models for vector embeddings. See <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported embeddings models</a> for information on the available models and their vector data types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-bedrockembeddingmodelconfiguration-embeddingdatatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-bedrockembeddingmodelconfiguration-embeddingdatatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmbeddingDataType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BedrockEmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BedrockEmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BedrockEmbeddingModelConfigurationProperty> {
            java.lang.Number dimensions;
            java.lang.String embeddingDataType;

            /**
             * Sets the value of {@link BedrockEmbeddingModelConfigurationProperty#getDimensions}
             * @param dimensions The dimensions details for the vector configuration used on the Bedrock embeddings model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.lang.Number dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link BedrockEmbeddingModelConfigurationProperty#getEmbeddingDataType}
             * @param embeddingDataType The data type for the vectors when using a model to convert text into vector embeddings.
             *                          The model must support the specified data type for vector embeddings. Floating-point (float32) is the default data type, and is supported by most models for vector embeddings. See <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported embeddings models</a> for information on the available models and their vector data types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingDataType(java.lang.String embeddingDataType) {
                this.embeddingDataType = embeddingDataType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BedrockEmbeddingModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BedrockEmbeddingModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BedrockEmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockEmbeddingModelConfigurationProperty {
            private final java.lang.Number dimensions;
            private final java.lang.String embeddingDataType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.embeddingDataType = software.amazon.jsii.Kernel.get(this, "embeddingDataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.embeddingDataType = builder.embeddingDataType;
            }

            @Override
            public final java.lang.Number getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getEmbeddingDataType() {
                return this.embeddingDataType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getEmbeddingDataType() != null) {
                    data.set("embeddingDataType", om.valueToTree(this.getEmbeddingDataType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BedrockEmbeddingModelConfigurationProperty.Jsii$Proxy that = (BedrockEmbeddingModelConfigurationProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.embeddingDataType != null ? this.embeddingDataType.equals(that.embeddingDataType) : that.embeddingDataType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.embeddingDataType != null ? this.embeddingDataType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a query, each of which defines information about example queries to help the query engine generate appropriate SQL queries.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * CuratedQueryProperty curatedQueryProperty = CuratedQueryProperty.builder()
     *         .naturalLanguage("naturalLanguage")
     *         .sql("sql")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-curatedquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-curatedquery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.CuratedQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(CuratedQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CuratedQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An example natural language query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-curatedquery.html#cfn-bedrock-knowledgebase-curatedquery-naturallanguage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-curatedquery.html#cfn-bedrock-knowledgebase-curatedquery-naturallanguage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNaturalLanguage();

        /**
         * The SQL equivalent of the natural language query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-curatedquery.html#cfn-bedrock-knowledgebase-curatedquery-sql">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-curatedquery.html#cfn-bedrock-knowledgebase-curatedquery-sql</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSql();

        /**
         * @return a {@link Builder} of {@link CuratedQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CuratedQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CuratedQueryProperty> {
            java.lang.String naturalLanguage;
            java.lang.String sql;

            /**
             * Sets the value of {@link CuratedQueryProperty#getNaturalLanguage}
             * @param naturalLanguage An example natural language query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder naturalLanguage(java.lang.String naturalLanguage) {
                this.naturalLanguage = naturalLanguage;
                return this;
            }

            /**
             * Sets the value of {@link CuratedQueryProperty#getSql}
             * @param sql The SQL equivalent of the natural language query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sql(java.lang.String sql) {
                this.sql = sql;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CuratedQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CuratedQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CuratedQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CuratedQueryProperty {
            private final java.lang.String naturalLanguage;
            private final java.lang.String sql;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.naturalLanguage = software.amazon.jsii.Kernel.get(this, "naturalLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.naturalLanguage = java.util.Objects.requireNonNull(builder.naturalLanguage, "naturalLanguage is required");
                this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
            }

            @Override
            public final java.lang.String getNaturalLanguage() {
                return this.naturalLanguage;
            }

            @Override
            public final java.lang.String getSql() {
                return this.sql;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("naturalLanguage", om.valueToTree(this.getNaturalLanguage()));
                data.set("sql", om.valueToTree(this.getSql()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.CuratedQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CuratedQueryProperty.Jsii$Proxy that = (CuratedQueryProperty.Jsii$Proxy) o;

                if (!naturalLanguage.equals(that.naturalLanguage)) return false;
                return this.sql.equals(that.sql);
            }

            @Override
            public final int hashCode() {
                int result = this.naturalLanguage.hashCode();
                result = 31 * result + (this.sql.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration details for the embeddings model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * EmbeddingModelConfigurationProperty embeddingModelConfigurationProperty = EmbeddingModelConfigurationProperty.builder()
     *         .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
     *                 .dimensions(123)
     *                 .embeddingDataType("embeddingDataType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddingModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddingModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The vector configuration details on the Bedrock embeddings model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-embeddingmodelconfiguration-bedrockembeddingmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-embeddingmodelconfiguration-bedrockembeddingmodelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBedrockEmbeddingModelConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddingModelConfigurationProperty> {
            java.lang.Object bedrockEmbeddingModelConfiguration;

            /**
             * Sets the value of {@link EmbeddingModelConfigurationProperty#getBedrockEmbeddingModelConfiguration}
             * @param bedrockEmbeddingModelConfiguration The vector configuration details on the Bedrock embeddings model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockEmbeddingModelConfiguration(software.amazon.awscdk.IResolvable bedrockEmbeddingModelConfiguration) {
                this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EmbeddingModelConfigurationProperty#getBedrockEmbeddingModelConfiguration}
             * @param bedrockEmbeddingModelConfiguration The vector configuration details on the Bedrock embeddings model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockEmbeddingModelConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty bedrockEmbeddingModelConfiguration) {
                this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddingModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddingModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddingModelConfigurationProperty {
            private final java.lang.Object bedrockEmbeddingModelConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bedrockEmbeddingModelConfiguration = software.amazon.jsii.Kernel.get(this, "bedrockEmbeddingModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bedrockEmbeddingModelConfiguration = builder.bedrockEmbeddingModelConfiguration;
            }

            @Override
            public final java.lang.Object getBedrockEmbeddingModelConfiguration() {
                return this.bedrockEmbeddingModelConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBedrockEmbeddingModelConfiguration() != null) {
                    data.set("bedrockEmbeddingModelConfiguration", om.valueToTree(this.getBedrockEmbeddingModelConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmbeddingModelConfigurationProperty.Jsii$Proxy that = (EmbeddingModelConfigurationProperty.Jsii$Proxy) o;

                return this.bedrockEmbeddingModelConfiguration != null ? this.bedrockEmbeddingModelConfiguration.equals(that.bedrockEmbeddingModelConfiguration) : that.bedrockEmbeddingModelConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bedrockEmbeddingModelConfiguration != null ? this.bedrockEmbeddingModelConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for an Amazon Kendra knowledge base.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * KendraKnowledgeBaseConfigurationProperty kendraKnowledgeBaseConfigurationProperty = KendraKnowledgeBaseConfigurationProperty.builder()
     *         .kendraIndexArn("kendraIndexArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-kendraknowledgebaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-kendraknowledgebaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KendraKnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KendraKnowledgeBaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KendraKnowledgeBaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon Kendra index.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-kendraknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-kendraknowledgebaseconfiguration-kendraindexarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-kendraknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-kendraknowledgebaseconfiguration-kendraindexarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKendraIndexArn();

        /**
         * @return a {@link Builder} of {@link KendraKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KendraKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KendraKnowledgeBaseConfigurationProperty> {
            java.lang.String kendraIndexArn;

            /**
             * Sets the value of {@link KendraKnowledgeBaseConfigurationProperty#getKendraIndexArn}
             * @param kendraIndexArn The ARN of the Amazon Kendra index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraIndexArn(java.lang.String kendraIndexArn) {
                this.kendraIndexArn = kendraIndexArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KendraKnowledgeBaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KendraKnowledgeBaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KendraKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KendraKnowledgeBaseConfigurationProperty {
            private final java.lang.String kendraIndexArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kendraIndexArn = software.amazon.jsii.Kernel.get(this, "kendraIndexArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kendraIndexArn = java.util.Objects.requireNonNull(builder.kendraIndexArn, "kendraIndexArn is required");
            }

            @Override
            public final java.lang.String getKendraIndexArn() {
                return this.kendraIndexArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kendraIndexArn", om.valueToTree(this.getKendraIndexArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KendraKnowledgeBaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KendraKnowledgeBaseConfigurationProperty.Jsii$Proxy that = (KendraKnowledgeBaseConfigurationProperty.Jsii$Proxy) o;

                return this.kendraIndexArn.equals(that.kendraIndexArn);
            }

            @Override
            public final int hashCode() {
                int result = this.kendraIndexArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Configurations to apply to a knowledge base attached to the agent during query.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html#session-state-kb">Knowledge base retrieval configurations</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * KnowledgeBaseConfigurationProperty knowledgeBaseConfigurationProperty = KnowledgeBaseConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .kendraKnowledgeBaseConfiguration(KendraKnowledgeBaseConfigurationProperty.builder()
     *                 .kendraIndexArn("kendraIndexArn")
     *                 .build())
     *         .sqlKnowledgeBaseConfiguration(SqlKnowledgeBaseConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .redshiftConfiguration(RedshiftConfigurationProperty.builder()
     *                         .queryEngineConfiguration(RedshiftQueryEngineConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .provisionedConfiguration(RedshiftProvisionedConfigurationProperty.builder()
     *                                         .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
     *                                                 .type("type")
     *                                                 // the properties below are optional
     *                                                 .databaseUser("databaseUser")
     *                                                 .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                                                 .build())
     *                                         .clusterIdentifier("clusterIdentifier")
     *                                         .build())
     *                                 .serverlessConfiguration(RedshiftServerlessConfigurationProperty.builder()
     *                                         .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
     *                                                 .type("type")
     *                                                 // the properties below are optional
     *                                                 .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                                                 .build())
     *                                         .workgroupArn("workgroupArn")
     *                                         .build())
     *                                 .build())
     *                         .storageConfigurations(List.of(RedshiftQueryEngineStorageConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
     *                                         .tableNames(List.of("tableNames"))
     *                                         .build())
     *                                 .redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
     *                                         .databaseName("databaseName")
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .queryGenerationConfiguration(QueryGenerationConfigurationProperty.builder()
     *                                 .executionTimeoutSeconds(123)
     *                                 .generationContext(QueryGenerationContextProperty.builder()
     *                                         .curatedQueries(List.of(CuratedQueryProperty.builder()
     *                                                 .naturalLanguage("naturalLanguage")
     *                                                 .sql("sql")
     *                                                 .build()))
     *                                         .tables(List.of(QueryGenerationTableProperty.builder()
     *                                                 .name("name")
     *                                                 // the properties below are optional
     *                                                 .columns(List.of(QueryGenerationColumnProperty.builder()
     *                                                         .description("description")
     *                                                         .inclusion("inclusion")
     *                                                         .name("name")
     *                                                         .build()))
     *                                                 .description("description")
     *                                                 .inclusion("inclusion")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfigurationProperty.builder()
     *                 .embeddingModelArn("embeddingModelArn")
     *                 // the properties below are optional
     *                 .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
     *                         .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
     *                                 .dimensions(123)
     *                                 .embeddingDataType("embeddingDataType")
     *                                 .build())
     *                         .build())
     *                 .supplementalDataStorageConfiguration(SupplementalDataStorageConfigurationProperty.builder()
     *                         .supplementalDataStorageLocations(List.of(SupplementalDataStorageLocationProperty.builder()
     *                                 .supplementalDataStorageLocationType("supplementalDataStorageLocationType")
     *                                 // the properties below are optional
     *                                 .s3Location(S3LocationProperty.builder()
     *                                         .uri("uri")
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of data that the data source is converted into for the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Settings for an Amazon Kendra knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-kendraknowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-kendraknowledgebaseconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKendraKnowledgeBaseConfiguration() {
            return null;
        }

        /**
         * Specifies configurations for a knowledge base connected to an SQL database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-sqlknowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-sqlknowledgebaseconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqlKnowledgeBaseConfiguration() {
            return null;
        }

        /**
         * Contains details about the model that's used to convert the data source into vector embeddings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-vectorknowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-vectorknowledgebaseconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVectorKnowledgeBaseConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseConfigurationProperty> {
            java.lang.String type;
            java.lang.Object kendraKnowledgeBaseConfiguration;
            java.lang.Object sqlKnowledgeBaseConfiguration;
            java.lang.Object vectorKnowledgeBaseConfiguration;

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getType}
             * @param type The type of data that the data source is converted into for the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getKendraKnowledgeBaseConfiguration}
             * @param kendraKnowledgeBaseConfiguration Settings for an Amazon Kendra knowledge base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraKnowledgeBaseConfiguration(software.amazon.awscdk.IResolvable kendraKnowledgeBaseConfiguration) {
                this.kendraKnowledgeBaseConfiguration = kendraKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getKendraKnowledgeBaseConfiguration}
             * @param kendraKnowledgeBaseConfiguration Settings for an Amazon Kendra knowledge base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraKnowledgeBaseConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.KendraKnowledgeBaseConfigurationProperty kendraKnowledgeBaseConfiguration) {
                this.kendraKnowledgeBaseConfiguration = kendraKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getSqlKnowledgeBaseConfiguration}
             * @param sqlKnowledgeBaseConfiguration Specifies configurations for a knowledge base connected to an SQL database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlKnowledgeBaseConfiguration(software.amazon.awscdk.IResolvable sqlKnowledgeBaseConfiguration) {
                this.sqlKnowledgeBaseConfiguration = sqlKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getSqlKnowledgeBaseConfiguration}
             * @param sqlKnowledgeBaseConfiguration Specifies configurations for a knowledge base connected to an SQL database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlKnowledgeBaseConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.SqlKnowledgeBaseConfigurationProperty sqlKnowledgeBaseConfiguration) {
                this.sqlKnowledgeBaseConfiguration = sqlKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getVectorKnowledgeBaseConfiguration}
             * @param vectorKnowledgeBaseConfiguration Contains details about the model that's used to convert the data source into vector embeddings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorKnowledgeBaseConfiguration(software.amazon.awscdk.IResolvable vectorKnowledgeBaseConfiguration) {
                this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getVectorKnowledgeBaseConfiguration}
             * @param vectorKnowledgeBaseConfiguration Contains details about the model that's used to convert the data source into vector embeddings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorKnowledgeBaseConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty vectorKnowledgeBaseConfiguration) {
                this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object kendraKnowledgeBaseConfiguration;
            private final java.lang.Object sqlKnowledgeBaseConfiguration;
            private final java.lang.Object vectorKnowledgeBaseConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kendraKnowledgeBaseConfiguration = software.amazon.jsii.Kernel.get(this, "kendraKnowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqlKnowledgeBaseConfiguration = software.amazon.jsii.Kernel.get(this, "sqlKnowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vectorKnowledgeBaseConfiguration = software.amazon.jsii.Kernel.get(this, "vectorKnowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.kendraKnowledgeBaseConfiguration = builder.kendraKnowledgeBaseConfiguration;
                this.sqlKnowledgeBaseConfiguration = builder.sqlKnowledgeBaseConfiguration;
                this.vectorKnowledgeBaseConfiguration = builder.vectorKnowledgeBaseConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getKendraKnowledgeBaseConfiguration() {
                return this.kendraKnowledgeBaseConfiguration;
            }

            @Override
            public final java.lang.Object getSqlKnowledgeBaseConfiguration() {
                return this.sqlKnowledgeBaseConfiguration;
            }

            @Override
            public final java.lang.Object getVectorKnowledgeBaseConfiguration() {
                return this.vectorKnowledgeBaseConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getKendraKnowledgeBaseConfiguration() != null) {
                    data.set("kendraKnowledgeBaseConfiguration", om.valueToTree(this.getKendraKnowledgeBaseConfiguration()));
                }
                if (this.getSqlKnowledgeBaseConfiguration() != null) {
                    data.set("sqlKnowledgeBaseConfiguration", om.valueToTree(this.getSqlKnowledgeBaseConfiguration()));
                }
                if (this.getVectorKnowledgeBaseConfiguration() != null) {
                    data.set("vectorKnowledgeBaseConfiguration", om.valueToTree(this.getVectorKnowledgeBaseConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBaseConfigurationProperty.Jsii$Proxy that = (KnowledgeBaseConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.kendraKnowledgeBaseConfiguration != null ? !this.kendraKnowledgeBaseConfiguration.equals(that.kendraKnowledgeBaseConfiguration) : that.kendraKnowledgeBaseConfiguration != null) return false;
                if (this.sqlKnowledgeBaseConfiguration != null ? !this.sqlKnowledgeBaseConfiguration.equals(that.sqlKnowledgeBaseConfiguration) : that.sqlKnowledgeBaseConfiguration != null) return false;
                return this.vectorKnowledgeBaseConfiguration != null ? this.vectorKnowledgeBaseConfiguration.equals(that.vectorKnowledgeBaseConfiguration) : that.vectorKnowledgeBaseConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.kendraKnowledgeBaseConfiguration != null ? this.kendraKnowledgeBaseConfiguration.hashCode() : 0);
                result = 31 * result + (this.sqlKnowledgeBaseConfiguration != null ? this.sqlKnowledgeBaseConfiguration.hashCode() : 0);
                result = 31 * result + (this.vectorKnowledgeBaseConfiguration != null ? this.vectorKnowledgeBaseConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in MongoDB Atlas.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * MongoDbAtlasConfigurationProperty mongoDbAtlasConfigurationProperty = MongoDbAtlasConfigurationProperty.builder()
     *         .collectionName("collectionName")
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .databaseName("databaseName")
     *         .endpoint("endpoint")
     *         .fieldMapping(MongoDbAtlasFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .vectorField("vectorField")
     *                 .build())
     *         .vectorIndexName("vectorIndexName")
     *         // the properties below are optional
     *         .endpointServiceName("endpointServiceName")
     *         .textIndexName("textIndexName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.MongoDbAtlasConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDbAtlasConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDbAtlasConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The collection name of the knowledge base in MongoDB Atlas.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-collectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-collectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionName();

        /**
         * The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that contains user credentials for your MongoDB Atlas cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * The database name in your MongoDB Atlas cluster for your knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The name of the MongoDB Atlas vector search index.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-vectorindexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-vectorindexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorIndexName();

        /**
         * The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-endpointservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-endpointservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointServiceName() {
            return null;
        }

        /**
         * The name of the text search index in the MongoDB collection.
         * <p>
         * This is required for using the hybrid search feature.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-textindexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasconfiguration.html#cfn-bedrock-knowledgebase-mongodbatlasconfiguration-textindexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextIndexName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDbAtlasConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDbAtlasConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDbAtlasConfigurationProperty> {
            java.lang.String collectionName;
            java.lang.String credentialsSecretArn;
            java.lang.String databaseName;
            java.lang.String endpoint;
            java.lang.Object fieldMapping;
            java.lang.String vectorIndexName;
            java.lang.String endpointServiceName;
            java.lang.String textIndexName;

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getCollectionName}
             * @param collectionName The collection name of the knowledge base in MongoDB Atlas. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionName(java.lang.String collectionName) {
                this.collectionName = collectionName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that contains user credentials for your MongoDB Atlas cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getDatabaseName}
             * @param databaseName The database name in your MongoDB Atlas cluster for your knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getEndpoint}
             * @param endpoint The endpoint URL of your MongoDB Atlas cluster for your knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.MongoDbAtlasFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getVectorIndexName}
             * @param vectorIndexName The name of the MongoDB Atlas vector search index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorIndexName(java.lang.String vectorIndexName) {
                this.vectorIndexName = vectorIndexName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getEndpointServiceName}
             * @param endpointServiceName The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointServiceName(java.lang.String endpointServiceName) {
                this.endpointServiceName = endpointServiceName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasConfigurationProperty#getTextIndexName}
             * @param textIndexName The name of the text search index in the MongoDB collection.
             *                      This is required for using the hybrid search feature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textIndexName(java.lang.String textIndexName) {
                this.textIndexName = textIndexName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDbAtlasConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDbAtlasConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDbAtlasConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDbAtlasConfigurationProperty {
            private final java.lang.String collectionName;
            private final java.lang.String credentialsSecretArn;
            private final java.lang.String databaseName;
            private final java.lang.String endpoint;
            private final java.lang.Object fieldMapping;
            private final java.lang.String vectorIndexName;
            private final java.lang.String endpointServiceName;
            private final java.lang.String textIndexName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionName = software.amazon.jsii.Kernel.get(this, "collectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vectorIndexName = software.amazon.jsii.Kernel.get(this, "vectorIndexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointServiceName = software.amazon.jsii.Kernel.get(this, "endpointServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textIndexName = software.amazon.jsii.Kernel.get(this, "textIndexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionName = java.util.Objects.requireNonNull(builder.collectionName, "collectionName is required");
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.vectorIndexName = java.util.Objects.requireNonNull(builder.vectorIndexName, "vectorIndexName is required");
                this.endpointServiceName = builder.endpointServiceName;
                this.textIndexName = builder.textIndexName;
            }

            @Override
            public final java.lang.String getCollectionName() {
                return this.collectionName;
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getVectorIndexName() {
                return this.vectorIndexName;
            }

            @Override
            public final java.lang.String getEndpointServiceName() {
                return this.endpointServiceName;
            }

            @Override
            public final java.lang.String getTextIndexName() {
                return this.textIndexName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionName", om.valueToTree(this.getCollectionName()));
                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("vectorIndexName", om.valueToTree(this.getVectorIndexName()));
                if (this.getEndpointServiceName() != null) {
                    data.set("endpointServiceName", om.valueToTree(this.getEndpointServiceName()));
                }
                if (this.getTextIndexName() != null) {
                    data.set("textIndexName", om.valueToTree(this.getTextIndexName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.MongoDbAtlasConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDbAtlasConfigurationProperty.Jsii$Proxy that = (MongoDbAtlasConfigurationProperty.Jsii$Proxy) o;

                if (!collectionName.equals(that.collectionName)) return false;
                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!endpoint.equals(that.endpoint)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                if (!vectorIndexName.equals(that.vectorIndexName)) return false;
                if (this.endpointServiceName != null ? !this.endpointServiceName.equals(that.endpointServiceName) : that.endpointServiceName != null) return false;
                return this.textIndexName != null ? this.textIndexName.equals(that.textIndexName) : that.textIndexName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.collectionName.hashCode();
                result = 31 * result + (this.credentialsSecretArn.hashCode());
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.endpoint.hashCode());
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.vectorIndexName.hashCode());
                result = 31 * result + (this.endpointServiceName != null ? this.endpointServiceName.hashCode() : 0);
                result = 31 * result + (this.textIndexName != null ? this.textIndexName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * MongoDbAtlasFieldMappingProperty mongoDbAtlasFieldMappingProperty = MongoDbAtlasFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .vectorField("vectorField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.MongoDbAtlasFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDbAtlasFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDbAtlasFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html#cfn-bedrock-knowledgebase-mongodbatlasfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html#cfn-bedrock-knowledgebase-mongodbatlasfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html#cfn-bedrock-knowledgebase-mongodbatlasfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html#cfn-bedrock-knowledgebase-mongodbatlasfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html#cfn-bedrock-knowledgebase-mongodbatlasfieldmapping-vectorfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-mongodbatlasfieldmapping.html#cfn-bedrock-knowledgebase-mongodbatlasfieldmapping-vectorfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorField();

        /**
         * @return a {@link Builder} of {@link MongoDbAtlasFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDbAtlasFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDbAtlasFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;
            java.lang.String vectorField;

            /**
             * Sets the value of {@link MongoDbAtlasFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbAtlasFieldMappingProperty#getVectorField}
             * @param vectorField The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorField(java.lang.String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDbAtlasFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDbAtlasFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDbAtlasFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDbAtlasFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;
            private final java.lang.String vectorField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorField = software.amazon.jsii.Kernel.get(this, "vectorField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
                this.vectorField = java.util.Objects.requireNonNull(builder.vectorField, "vectorField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            public final java.lang.String getVectorField() {
                return this.vectorField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));
                data.set("vectorField", om.valueToTree(this.getVectorField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.MongoDbAtlasFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDbAtlasFieldMappingProperty.Jsii$Proxy that = (MongoDbAtlasFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                if (!textField.equals(that.textField)) return false;
                return this.vectorField.equals(that.vectorField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                result = 31 * result + (this.vectorField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Amazon Neptune Analytics.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html">Create a vector index in Amazon Neptune Analytics</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * NeptuneAnalyticsConfigurationProperty neptuneAnalyticsConfigurationProperty = NeptuneAnalyticsConfigurationProperty.builder()
     *         .fieldMapping(NeptuneAnalyticsFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .build())
     *         .graphArn("graphArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.NeptuneAnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NeptuneAnalyticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NeptuneAnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsconfiguration.html#cfn-bedrock-knowledgebase-neptuneanalyticsconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsconfiguration.html#cfn-bedrock-knowledgebase-neptuneanalyticsconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The Amazon Resource Name (ARN) of the Neptune Analytics vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsconfiguration.html#cfn-bedrock-knowledgebase-neptuneanalyticsconfiguration-grapharn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsconfiguration.html#cfn-bedrock-knowledgebase-neptuneanalyticsconfiguration-grapharn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGraphArn();

        /**
         * @return a {@link Builder} of {@link NeptuneAnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NeptuneAnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NeptuneAnalyticsConfigurationProperty> {
            java.lang.Object fieldMapping;
            java.lang.String graphArn;

            /**
             * Sets the value of {@link NeptuneAnalyticsConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneAnalyticsConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.NeptuneAnalyticsFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneAnalyticsConfigurationProperty#getGraphArn}
             * @param graphArn The Amazon Resource Name (ARN) of the Neptune Analytics vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder graphArn(java.lang.String graphArn) {
                this.graphArn = graphArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NeptuneAnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NeptuneAnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NeptuneAnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NeptuneAnalyticsConfigurationProperty {
            private final java.lang.Object fieldMapping;
            private final java.lang.String graphArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.graphArn = software.amazon.jsii.Kernel.get(this, "graphArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.graphArn = java.util.Objects.requireNonNull(builder.graphArn, "graphArn is required");
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getGraphArn() {
                return this.graphArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("graphArn", om.valueToTree(this.getGraphArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.NeptuneAnalyticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NeptuneAnalyticsConfigurationProperty.Jsii$Proxy that = (NeptuneAnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (!fieldMapping.equals(that.fieldMapping)) return false;
                return this.graphArn.equals(that.graphArn);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldMapping.hashCode();
                result = 31 * result + (this.graphArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * NeptuneAnalyticsFieldMappingProperty neptuneAnalyticsFieldMappingProperty = NeptuneAnalyticsFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.NeptuneAnalyticsFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(NeptuneAnalyticsFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NeptuneAnalyticsFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsfieldmapping.html#cfn-bedrock-knowledgebase-neptuneanalyticsfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsfieldmapping.html#cfn-bedrock-knowledgebase-neptuneanalyticsfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsfieldmapping.html#cfn-bedrock-knowledgebase-neptuneanalyticsfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-neptuneanalyticsfieldmapping.html#cfn-bedrock-knowledgebase-neptuneanalyticsfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * @return a {@link Builder} of {@link NeptuneAnalyticsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NeptuneAnalyticsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NeptuneAnalyticsFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;

            /**
             * Sets the value of {@link NeptuneAnalyticsFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneAnalyticsFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NeptuneAnalyticsFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NeptuneAnalyticsFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NeptuneAnalyticsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NeptuneAnalyticsFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.NeptuneAnalyticsFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NeptuneAnalyticsFieldMappingProperty.Jsii$Proxy that = (NeptuneAnalyticsFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                return this.textField.equals(that.textField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the Managed Cluster configuration of the knowledge base in Amazon OpenSearch Service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html">Create a vector index in OpenSearch Managed Cluster</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OpenSearchManagedClusterConfigurationProperty openSearchManagedClusterConfigurationProperty = OpenSearchManagedClusterConfigurationProperty.builder()
     *         .domainArn("domainArn")
     *         .domainEndpoint("domainEndpoint")
     *         .fieldMapping(OpenSearchManagedClusterFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .vectorField("vectorField")
     *                 .build())
     *         .vectorIndexName("vectorIndexName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchManagedClusterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchManagedClusterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchManagedClusterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the OpenSearch domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-domainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-domainarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainArn();

        /**
         * The endpoint URL the OpenSearch domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-domainendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-domainendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainEndpoint();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The name of the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-vectorindexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterconfiguration.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterconfiguration-vectorindexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorIndexName();

        /**
         * @return a {@link Builder} of {@link OpenSearchManagedClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchManagedClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchManagedClusterConfigurationProperty> {
            java.lang.String domainArn;
            java.lang.String domainEndpoint;
            java.lang.Object fieldMapping;
            java.lang.String vectorIndexName;

            /**
             * Sets the value of {@link OpenSearchManagedClusterConfigurationProperty#getDomainArn}
             * @param domainArn The Amazon Resource Name (ARN) of the OpenSearch domain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainArn(java.lang.String domainArn) {
                this.domainArn = domainArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchManagedClusterConfigurationProperty#getDomainEndpoint}
             * @param domainEndpoint The endpoint URL the OpenSearch domain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainEndpoint(java.lang.String domainEndpoint) {
                this.domainEndpoint = domainEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchManagedClusterConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchManagedClusterConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.OpenSearchManagedClusterFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchManagedClusterConfigurationProperty#getVectorIndexName}
             * @param vectorIndexName The name of the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorIndexName(java.lang.String vectorIndexName) {
                this.vectorIndexName = vectorIndexName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchManagedClusterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchManagedClusterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchManagedClusterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchManagedClusterConfigurationProperty {
            private final java.lang.String domainArn;
            private final java.lang.String domainEndpoint;
            private final java.lang.Object fieldMapping;
            private final java.lang.String vectorIndexName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainEndpoint = software.amazon.jsii.Kernel.get(this, "domainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vectorIndexName = software.amazon.jsii.Kernel.get(this, "vectorIndexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainArn = java.util.Objects.requireNonNull(builder.domainArn, "domainArn is required");
                this.domainEndpoint = java.util.Objects.requireNonNull(builder.domainEndpoint, "domainEndpoint is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.vectorIndexName = java.util.Objects.requireNonNull(builder.vectorIndexName, "vectorIndexName is required");
            }

            @Override
            public final java.lang.String getDomainArn() {
                return this.domainArn;
            }

            @Override
            public final java.lang.String getDomainEndpoint() {
                return this.domainEndpoint;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getVectorIndexName() {
                return this.vectorIndexName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainArn", om.valueToTree(this.getDomainArn()));
                data.set("domainEndpoint", om.valueToTree(this.getDomainEndpoint()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("vectorIndexName", om.valueToTree(this.getVectorIndexName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchManagedClusterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchManagedClusterConfigurationProperty.Jsii$Proxy that = (OpenSearchManagedClusterConfigurationProperty.Jsii$Proxy) o;

                if (!domainArn.equals(that.domainArn)) return false;
                if (!domainEndpoint.equals(that.domainEndpoint)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                return this.vectorIndexName.equals(that.vectorIndexName);
            }

            @Override
            public final int hashCode() {
                int result = this.domainArn.hashCode();
                result = 31 * result + (this.domainEndpoint.hashCode());
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.vectorIndexName.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OpenSearchManagedClusterFieldMappingProperty openSearchManagedClusterFieldMappingProperty = OpenSearchManagedClusterFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .vectorField("vectorField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchManagedClusterFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchManagedClusterFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchManagedClusterFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping-vectorfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping.html#cfn-bedrock-knowledgebase-opensearchmanagedclusterfieldmapping-vectorfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorField();

        /**
         * @return a {@link Builder} of {@link OpenSearchManagedClusterFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchManagedClusterFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchManagedClusterFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;
            java.lang.String vectorField;

            /**
             * Sets the value of {@link OpenSearchManagedClusterFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchManagedClusterFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchManagedClusterFieldMappingProperty#getVectorField}
             * @param vectorField The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorField(java.lang.String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchManagedClusterFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchManagedClusterFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchManagedClusterFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchManagedClusterFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;
            private final java.lang.String vectorField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorField = software.amazon.jsii.Kernel.get(this, "vectorField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
                this.vectorField = java.util.Objects.requireNonNull(builder.vectorField, "vectorField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            public final java.lang.String getVectorField() {
                return this.vectorField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));
                data.set("vectorField", om.valueToTree(this.getVectorField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchManagedClusterFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchManagedClusterFieldMappingProperty.Jsii$Proxy that = (OpenSearchManagedClusterFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                if (!textField.equals(that.textField)) return false;
                return this.vectorField.equals(that.vectorField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                result = 31 * result + (this.vectorField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Amazon OpenSearch Service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create a vector index in Amazon OpenSearch Service</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OpenSearchServerlessConfigurationProperty openSearchServerlessConfigurationProperty = OpenSearchServerlessConfigurationProperty.builder()
     *         .collectionArn("collectionArn")
     *         .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .vectorField("vectorField")
     *                 .build())
     *         .vectorIndexName("vectorIndexName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchServerlessConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchServerlessConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-collectionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-collectionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionArn();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The name of the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-vectorindexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-vectorindexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorIndexName();

        /**
         * @return a {@link Builder} of {@link OpenSearchServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchServerlessConfigurationProperty> {
            java.lang.String collectionArn;
            java.lang.Object fieldMapping;
            java.lang.String vectorIndexName;

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getCollectionArn}
             * @param collectionArn The Amazon Resource Name (ARN) of the OpenSearch Service vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionArn(java.lang.String collectionArn) {
                this.collectionArn = collectionArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getVectorIndexName}
             * @param vectorIndexName The name of the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorIndexName(java.lang.String vectorIndexName) {
                this.vectorIndexName = vectorIndexName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchServerlessConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchServerlessConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchServerlessConfigurationProperty {
            private final java.lang.String collectionArn;
            private final java.lang.Object fieldMapping;
            private final java.lang.String vectorIndexName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionArn = software.amazon.jsii.Kernel.get(this, "collectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vectorIndexName = software.amazon.jsii.Kernel.get(this, "vectorIndexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionArn = java.util.Objects.requireNonNull(builder.collectionArn, "collectionArn is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.vectorIndexName = java.util.Objects.requireNonNull(builder.vectorIndexName, "vectorIndexName is required");
            }

            @Override
            public final java.lang.String getCollectionArn() {
                return this.collectionArn;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getVectorIndexName() {
                return this.vectorIndexName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionArn", om.valueToTree(this.getCollectionArn()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("vectorIndexName", om.valueToTree(this.getVectorIndexName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchServerlessConfigurationProperty.Jsii$Proxy that = (OpenSearchServerlessConfigurationProperty.Jsii$Proxy) o;

                if (!collectionArn.equals(that.collectionArn)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                return this.vectorIndexName.equals(that.vectorIndexName);
            }

            @Override
            public final int hashCode() {
                int result = this.collectionArn.hashCode();
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.vectorIndexName.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OpenSearchServerlessFieldMappingProperty openSearchServerlessFieldMappingProperty = OpenSearchServerlessFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .vectorField("vectorField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchServerlessFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchServerlessFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-vectorfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-vectorfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorField();

        /**
         * @return a {@link Builder} of {@link OpenSearchServerlessFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchServerlessFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchServerlessFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;
            java.lang.String vectorField;

            /**
             * Sets the value of {@link OpenSearchServerlessFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessFieldMappingProperty#getVectorField}
             * @param vectorField The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorField(java.lang.String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchServerlessFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchServerlessFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchServerlessFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchServerlessFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;
            private final java.lang.String vectorField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorField = software.amazon.jsii.Kernel.get(this, "vectorField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
                this.vectorField = java.util.Objects.requireNonNull(builder.vectorField, "vectorField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            public final java.lang.String getVectorField() {
                return this.vectorField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));
                data.set("vectorField", om.valueToTree(this.getVectorField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchServerlessFieldMappingProperty.Jsii$Proxy that = (OpenSearchServerlessFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                if (!textField.equals(that.textField)) return false;
                return this.vectorField.equals(that.vectorField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                result = 31 * result + (this.vectorField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Pinecone.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html">Create a vector index in Pinecone</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PineconeConfigurationProperty pineconeConfigurationProperty = PineconeConfigurationProperty.builder()
     *         .connectionString("connectionString")
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .fieldMapping(PineconeFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .build())
     *         // the properties below are optional
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PineconeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PineconeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint URL for your index management page.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-connectionstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-connectionstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectionString();

        /**
         * The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The namespace to be used to write new data to your database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PineconeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PineconeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PineconeConfigurationProperty> {
            java.lang.String connectionString;
            java.lang.String credentialsSecretArn;
            java.lang.Object fieldMapping;
            java.lang.String namespace;

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getConnectionString}
             * @param connectionString The endpoint URL for your index management page. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionString(java.lang.String connectionString) {
                this.connectionString = connectionString;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getNamespace}
             * @param namespace The namespace to be used to write new data to your database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PineconeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PineconeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PineconeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PineconeConfigurationProperty {
            private final java.lang.String connectionString;
            private final java.lang.String credentialsSecretArn;
            private final java.lang.Object fieldMapping;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionString = software.amazon.jsii.Kernel.get(this, "connectionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionString = java.util.Objects.requireNonNull(builder.connectionString, "connectionString is required");
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.String getConnectionString() {
                return this.connectionString;
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectionString", om.valueToTree(this.getConnectionString()));
                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PineconeConfigurationProperty.Jsii$Proxy that = (PineconeConfigurationProperty.Jsii$Proxy) o;

                if (!connectionString.equals(that.connectionString)) return false;
                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionString.hashCode();
                result = 31 * result + (this.credentialsSecretArn.hashCode());
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PineconeFieldMappingProperty pineconeFieldMappingProperty = PineconeFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(PineconeFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PineconeFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * @return a {@link Builder} of {@link PineconeFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PineconeFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PineconeFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;

            /**
             * Sets the value of {@link PineconeFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link PineconeFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PineconeFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PineconeFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PineconeFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PineconeFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PineconeFieldMappingProperty.Jsii$Proxy that = (PineconeFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                return this.textField.equals(that.textField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about a column in the current table for the query engine to consider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * QueryGenerationColumnProperty queryGenerationColumnProperty = QueryGenerationColumnProperty.builder()
     *         .description("description")
     *         .inclusion("inclusion")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryGenerationColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryGenerationColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description of the column that helps the query engine understand the contents of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html#cfn-bedrock-knowledgebase-querygenerationcolumn-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html#cfn-bedrock-knowledgebase-querygenerationcolumn-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Specifies whether to include or exclude the column during query generation.
         * <p>
         * If you specify <code>EXCLUDE</code> , the column will be ignored. If you specify <code>INCLUDE</code> , all other columns in the table will be ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html#cfn-bedrock-knowledgebase-querygenerationcolumn-inclusion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html#cfn-bedrock-knowledgebase-querygenerationcolumn-inclusion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInclusion() {
            return null;
        }

        /**
         * The name of the column for which the other fields in this object apply.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html#cfn-bedrock-knowledgebase-querygenerationcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcolumn.html#cfn-bedrock-knowledgebase-querygenerationcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryGenerationColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryGenerationColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryGenerationColumnProperty> {
            java.lang.String description;
            java.lang.String inclusion;
            java.lang.String name;

            /**
             * Sets the value of {@link QueryGenerationColumnProperty#getDescription}
             * @param description A description of the column that helps the query engine understand the contents of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationColumnProperty#getInclusion}
             * @param inclusion Specifies whether to include or exclude the column during query generation.
             *                  If you specify <code>EXCLUDE</code> , the column will be ignored. If you specify <code>INCLUDE</code> , all other columns in the table will be ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusion(java.lang.String inclusion) {
                this.inclusion = inclusion;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationColumnProperty#getName}
             * @param name The name of the column for which the other fields in this object apply.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryGenerationColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryGenerationColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryGenerationColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryGenerationColumnProperty {
            private final java.lang.String description;
            private final java.lang.String inclusion;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inclusion = software.amazon.jsii.Kernel.get(this, "inclusion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.inclusion = builder.inclusion;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInclusion() {
                return this.inclusion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInclusion() != null) {
                    data.set("inclusion", om.valueToTree(this.getInclusion()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryGenerationColumnProperty.Jsii$Proxy that = (QueryGenerationColumnProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inclusion != null ? !this.inclusion.equals(that.inclusion) : that.inclusion != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.inclusion != null ? this.inclusion.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for query generation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge base by connecting to a structured data source</a> in the Amazon Bedrock User Guide..
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * QueryGenerationConfigurationProperty queryGenerationConfigurationProperty = QueryGenerationConfigurationProperty.builder()
     *         .executionTimeoutSeconds(123)
     *         .generationContext(QueryGenerationContextProperty.builder()
     *                 .curatedQueries(List.of(CuratedQueryProperty.builder()
     *                         .naturalLanguage("naturalLanguage")
     *                         .sql("sql")
     *                         .build()))
     *                 .tables(List.of(QueryGenerationTableProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .columns(List.of(QueryGenerationColumnProperty.builder()
     *                                 .description("description")
     *                                 .inclusion("inclusion")
     *                                 .name("name")
     *                                 .build()))
     *                         .description("description")
     *                         .inclusion("inclusion")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryGenerationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryGenerationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time after which query generation will time out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationconfiguration.html#cfn-bedrock-knowledgebase-querygenerationconfiguration-executiontimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationconfiguration.html#cfn-bedrock-knowledgebase-querygenerationconfiguration-executiontimeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExecutionTimeoutSeconds() {
            return null;
        }

        /**
         * Specifies configurations for context to use during query generation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationconfiguration.html#cfn-bedrock-knowledgebase-querygenerationconfiguration-generationcontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationconfiguration.html#cfn-bedrock-knowledgebase-querygenerationconfiguration-generationcontext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenerationContext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryGenerationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryGenerationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryGenerationConfigurationProperty> {
            java.lang.Number executionTimeoutSeconds;
            java.lang.Object generationContext;

            /**
             * Sets the value of {@link QueryGenerationConfigurationProperty#getExecutionTimeoutSeconds}
             * @param executionTimeoutSeconds The time after which query generation will time out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionTimeoutSeconds(java.lang.Number executionTimeoutSeconds) {
                this.executionTimeoutSeconds = executionTimeoutSeconds;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationConfigurationProperty#getGenerationContext}
             * @param generationContext Specifies configurations for context to use during query generation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generationContext(software.amazon.awscdk.IResolvable generationContext) {
                this.generationContext = generationContext;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationConfigurationProperty#getGenerationContext}
             * @param generationContext Specifies configurations for context to use during query generation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generationContext(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.QueryGenerationContextProperty generationContext) {
                this.generationContext = generationContext;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryGenerationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryGenerationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryGenerationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryGenerationConfigurationProperty {
            private final java.lang.Number executionTimeoutSeconds;
            private final java.lang.Object generationContext;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "executionTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.generationContext = software.amazon.jsii.Kernel.get(this, "generationContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
                this.generationContext = builder.generationContext;
            }

            @Override
            public final java.lang.Number getExecutionTimeoutSeconds() {
                return this.executionTimeoutSeconds;
            }

            @Override
            public final java.lang.Object getGenerationContext() {
                return this.generationContext;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExecutionTimeoutSeconds() != null) {
                    data.set("executionTimeoutSeconds", om.valueToTree(this.getExecutionTimeoutSeconds()));
                }
                if (this.getGenerationContext() != null) {
                    data.set("generationContext", om.valueToTree(this.getGenerationContext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryGenerationConfigurationProperty.Jsii$Proxy that = (QueryGenerationConfigurationProperty.Jsii$Proxy) o;

                if (this.executionTimeoutSeconds != null ? !this.executionTimeoutSeconds.equals(that.executionTimeoutSeconds) : that.executionTimeoutSeconds != null) return false;
                return this.generationContext != null ? this.generationContext.equals(that.generationContext) : that.generationContext == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionTimeoutSeconds != null ? this.executionTimeoutSeconds.hashCode() : 0;
                result = 31 * result + (this.generationContext != null ? this.generationContext.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Contains configurations for context to use during query generation.<p></blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * QueryGenerationContextProperty queryGenerationContextProperty = QueryGenerationContextProperty.builder()
     *         .curatedQueries(List.of(CuratedQueryProperty.builder()
     *                 .naturalLanguage("naturalLanguage")
     *                 .sql("sql")
     *                 .build()))
     *         .tables(List.of(QueryGenerationTableProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .columns(List.of(QueryGenerationColumnProperty.builder()
     *                         .description("description")
     *                         .inclusion("inclusion")
     *                         .name("name")
     *                         .build()))
     *                 .description("description")
     *                 .inclusion("inclusion")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcontext.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcontext.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationContextProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryGenerationContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryGenerationContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of objects, each of which defines information about example queries to help the query engine generate appropriate SQL queries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcontext.html#cfn-bedrock-knowledgebase-querygenerationcontext-curatedqueries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcontext.html#cfn-bedrock-knowledgebase-querygenerationcontext-curatedqueries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCuratedQueries() {
            return null;
        }

        /**
         * An array of objects, each of which defines information about a table in the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcontext.html#cfn-bedrock-knowledgebase-querygenerationcontext-tables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationcontext.html#cfn-bedrock-knowledgebase-querygenerationcontext-tables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryGenerationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryGenerationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryGenerationContextProperty> {
            java.lang.Object curatedQueries;
            java.lang.Object tables;

            /**
             * Sets the value of {@link QueryGenerationContextProperty#getCuratedQueries}
             * @param curatedQueries An array of objects, each of which defines information about example queries to help the query engine generate appropriate SQL queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder curatedQueries(software.amazon.awscdk.IResolvable curatedQueries) {
                this.curatedQueries = curatedQueries;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationContextProperty#getCuratedQueries}
             * @param curatedQueries An array of objects, each of which defines information about example queries to help the query engine generate appropriate SQL queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder curatedQueries(java.util.List<? extends java.lang.Object> curatedQueries) {
                this.curatedQueries = curatedQueries;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationContextProperty#getTables}
             * @param tables An array of objects, each of which defines information about a table in the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tables(software.amazon.awscdk.IResolvable tables) {
                this.tables = tables;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationContextProperty#getTables}
             * @param tables An array of objects, each of which defines information about a table in the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tables(java.util.List<? extends java.lang.Object> tables) {
                this.tables = tables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryGenerationContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryGenerationContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryGenerationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryGenerationContextProperty {
            private final java.lang.Object curatedQueries;
            private final java.lang.Object tables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.curatedQueries = software.amazon.jsii.Kernel.get(this, "curatedQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tables = software.amazon.jsii.Kernel.get(this, "tables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.curatedQueries = builder.curatedQueries;
                this.tables = builder.tables;
            }

            @Override
            public final java.lang.Object getCuratedQueries() {
                return this.curatedQueries;
            }

            @Override
            public final java.lang.Object getTables() {
                return this.tables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCuratedQueries() != null) {
                    data.set("curatedQueries", om.valueToTree(this.getCuratedQueries()));
                }
                if (this.getTables() != null) {
                    data.set("tables", om.valueToTree(this.getTables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryGenerationContextProperty.Jsii$Proxy that = (QueryGenerationContextProperty.Jsii$Proxy) o;

                if (this.curatedQueries != null ? !this.curatedQueries.equals(that.curatedQueries) : that.curatedQueries != null) return false;
                return this.tables != null ? this.tables.equals(that.tables) : that.tables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.curatedQueries != null ? this.curatedQueries.hashCode() : 0;
                result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a table for the query engine to consider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * QueryGenerationTableProperty queryGenerationTableProperty = QueryGenerationTableProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .columns(List.of(QueryGenerationColumnProperty.builder()
     *                 .description("description")
     *                 .inclusion("inclusion")
     *                 .name("name")
     *                 .build()))
     *         .description("description")
     *         .inclusion("inclusion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationTableProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryGenerationTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryGenerationTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the table for which the other fields in this object apply.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * An array of objects, each of which defines information about a column in the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * A description of the table that helps the query engine understand the contents of the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Specifies whether to include or exclude the table during query generation.
         * <p>
         * If you specify <code>EXCLUDE</code> , the table will be ignored. If you specify <code>INCLUDE</code> , all other tables will be ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-inclusion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-querygenerationtable.html#cfn-bedrock-knowledgebase-querygenerationtable-inclusion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInclusion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryGenerationTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryGenerationTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryGenerationTableProperty> {
            java.lang.String name;
            java.lang.Object columns;
            java.lang.String description;
            java.lang.String inclusion;

            /**
             * Sets the value of {@link QueryGenerationTableProperty#getName}
             * @param name The name of the table for which the other fields in this object apply. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationTableProperty#getColumns}
             * @param columns An array of objects, each of which defines information about a column in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationTableProperty#getColumns}
             * @param columns An array of objects, each of which defines information about a column in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationTableProperty#getDescription}
             * @param description A description of the table that helps the query engine understand the contents of the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link QueryGenerationTableProperty#getInclusion}
             * @param inclusion Specifies whether to include or exclude the table during query generation.
             *                  If you specify <code>EXCLUDE</code> , the table will be ignored. If you specify <code>INCLUDE</code> , all other tables will be ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusion(java.lang.String inclusion) {
                this.inclusion = inclusion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryGenerationTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryGenerationTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryGenerationTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryGenerationTableProperty {
            private final java.lang.String name;
            private final java.lang.Object columns;
            private final java.lang.String description;
            private final java.lang.String inclusion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inclusion = software.amazon.jsii.Kernel.get(this, "inclusion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.columns = builder.columns;
                this.description = builder.description;
                this.inclusion = builder.inclusion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInclusion() {
                return this.inclusion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInclusion() != null) {
                    data.set("inclusion", om.valueToTree(this.getInclusion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.QueryGenerationTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryGenerationTableProperty.Jsii$Proxy that = (QueryGenerationTableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.inclusion != null ? this.inclusion.equals(that.inclusion) : that.inclusion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inclusion != null ? this.inclusion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Amazon RDS.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RdsConfigurationProperty rdsConfigurationProperty = RdsConfigurationProperty.builder()
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .databaseName("databaseName")
     *         .fieldMapping(RdsFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .primaryKeyField("primaryKeyField")
     *                 .textField("textField")
     *                 .vectorField("vectorField")
     *                 // the properties below are optional
     *                 .customMetadataField("customMetadataField")
     *                 .build())
     *         .resourceArn("resourceArn")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * The name of your Amazon RDS database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The Amazon Resource Name (ARN) of the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * The name of the table in the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link RdsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsConfigurationProperty> {
            java.lang.String credentialsSecretArn;
            java.lang.String databaseName;
            java.lang.Object fieldMapping;
            java.lang.String resourceArn;
            java.lang.String tableName;

            /**
             * Sets the value of {@link RdsConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getDatabaseName}
             * @param databaseName The name of your Amazon RDS database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RdsFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getTableName}
             * @param tableName The name of the table in the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsConfigurationProperty {
            private final java.lang.String credentialsSecretArn;
            private final java.lang.String databaseName;
            private final java.lang.Object fieldMapping;
            private final java.lang.String resourceArn;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsConfigurationProperty.Jsii$Proxy that = (RdsConfigurationProperty.Jsii$Proxy) o;

                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.credentialsSecretArn.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.resourceArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RdsFieldMappingProperty rdsFieldMappingProperty = RdsFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .primaryKeyField("primaryKeyField")
     *         .textField("textField")
     *         .vectorField("vectorField")
     *         // the properties below are optional
     *         .customMetadataField("customMetadataField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the ID for each entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-primarykeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-primarykeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrimaryKeyField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-vectorfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-vectorfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorField();

        /**
         * Provide a name for the universal metadata field where Amazon Bedrock will store any custom metadata from your data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-custommetadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-custommetadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomMetadataField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RdsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String primaryKeyField;
            java.lang.String textField;
            java.lang.String vectorField;
            java.lang.String customMetadataField;

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getPrimaryKeyField}
             * @param primaryKeyField The name of the field in which Amazon Bedrock stores the ID for each entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryKeyField(java.lang.String primaryKeyField) {
                this.primaryKeyField = primaryKeyField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getVectorField}
             * @param vectorField The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorField(java.lang.String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getCustomMetadataField}
             * @param customMetadataField Provide a name for the universal metadata field where Amazon Bedrock will store any custom metadata from your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMetadataField(java.lang.String customMetadataField) {
                this.customMetadataField = customMetadataField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String primaryKeyField;
            private final java.lang.String textField;
            private final java.lang.String vectorField;
            private final java.lang.String customMetadataField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryKeyField = software.amazon.jsii.Kernel.get(this, "primaryKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorField = software.amazon.jsii.Kernel.get(this, "vectorField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customMetadataField = software.amazon.jsii.Kernel.get(this, "customMetadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.primaryKeyField = java.util.Objects.requireNonNull(builder.primaryKeyField, "primaryKeyField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
                this.vectorField = java.util.Objects.requireNonNull(builder.vectorField, "vectorField is required");
                this.customMetadataField = builder.customMetadataField;
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getPrimaryKeyField() {
                return this.primaryKeyField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            public final java.lang.String getVectorField() {
                return this.vectorField;
            }

            @Override
            public final java.lang.String getCustomMetadataField() {
                return this.customMetadataField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("primaryKeyField", om.valueToTree(this.getPrimaryKeyField()));
                data.set("textField", om.valueToTree(this.getTextField()));
                data.set("vectorField", om.valueToTree(this.getVectorField()));
                if (this.getCustomMetadataField() != null) {
                    data.set("customMetadataField", om.valueToTree(this.getCustomMetadataField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsFieldMappingProperty.Jsii$Proxy that = (RdsFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                if (!primaryKeyField.equals(that.primaryKeyField)) return false;
                if (!textField.equals(that.textField)) return false;
                if (!vectorField.equals(that.vectorField)) return false;
                return this.customMetadataField != null ? this.customMetadataField.equals(that.customMetadataField) : that.customMetadataField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.primaryKeyField.hashCode());
                result = 31 * result + (this.textField.hashCode());
                result = 31 * result + (this.vectorField.hashCode());
                result = 31 * result + (this.customMetadataField != null ? this.customMetadataField.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for an Amazon Redshift database.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftConfigurationProperty redshiftConfigurationProperty = RedshiftConfigurationProperty.builder()
     *         .queryEngineConfiguration(RedshiftQueryEngineConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .provisionedConfiguration(RedshiftProvisionedConfigurationProperty.builder()
     *                         .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .databaseUser("databaseUser")
     *                                 .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                                 .build())
     *                         .clusterIdentifier("clusterIdentifier")
     *                         .build())
     *                 .serverlessConfiguration(RedshiftServerlessConfigurationProperty.builder()
     *                         .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                                 .build())
     *                         .workgroupArn("workgroupArn")
     *                         .build())
     *                 .build())
     *         .storageConfigurations(List.of(RedshiftQueryEngineStorageConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
     *                         .tableNames(List.of("tableNames"))
     *                         .build())
     *                 .redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
     *                         .databaseName("databaseName")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .queryGenerationConfiguration(QueryGenerationConfigurationProperty.builder()
     *                 .executionTimeoutSeconds(123)
     *                 .generationContext(QueryGenerationContextProperty.builder()
     *                         .curatedQueries(List.of(CuratedQueryProperty.builder()
     *                                 .naturalLanguage("naturalLanguage")
     *                                 .sql("sql")
     *                                 .build()))
     *                         .tables(List.of(QueryGenerationTableProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .columns(List.of(QueryGenerationColumnProperty.builder()
     *                                         .description("description")
     *                                         .inclusion("inclusion")
     *                                         .name("name")
     *                                         .build()))
     *                                 .description("description")
     *                                 .inclusion("inclusion")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies configurations for an Amazon Redshift query engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html#cfn-bedrock-knowledgebase-redshiftconfiguration-queryengineconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html#cfn-bedrock-knowledgebase-redshiftconfiguration-queryengineconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryEngineConfiguration();

        /**
         * Specifies configurations for Amazon Redshift database storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html#cfn-bedrock-knowledgebase-redshiftconfiguration-storageconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html#cfn-bedrock-knowledgebase-redshiftconfiguration-storageconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStorageConfigurations();

        /**
         * Specifies configurations for generating queries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html#cfn-bedrock-knowledgebase-redshiftconfiguration-querygenerationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftconfiguration.html#cfn-bedrock-knowledgebase-redshiftconfiguration-querygenerationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryGenerationConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftConfigurationProperty> {
            java.lang.Object queryEngineConfiguration;
            java.lang.Object storageConfigurations;
            java.lang.Object queryGenerationConfiguration;

            /**
             * Sets the value of {@link RedshiftConfigurationProperty#getQueryEngineConfiguration}
             * @param queryEngineConfiguration Specifies configurations for an Amazon Redshift query engine. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryEngineConfiguration(software.amazon.awscdk.IResolvable queryEngineConfiguration) {
                this.queryEngineConfiguration = queryEngineConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConfigurationProperty#getQueryEngineConfiguration}
             * @param queryEngineConfiguration Specifies configurations for an Amazon Redshift query engine. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryEngineConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftQueryEngineConfigurationProperty queryEngineConfiguration) {
                this.queryEngineConfiguration = queryEngineConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConfigurationProperty#getStorageConfigurations}
             * @param storageConfigurations Specifies configurations for Amazon Redshift database storage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageConfigurations(software.amazon.awscdk.IResolvable storageConfigurations) {
                this.storageConfigurations = storageConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConfigurationProperty#getStorageConfigurations}
             * @param storageConfigurations Specifies configurations for Amazon Redshift database storage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageConfigurations(java.util.List<? extends java.lang.Object> storageConfigurations) {
                this.storageConfigurations = storageConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConfigurationProperty#getQueryGenerationConfiguration}
             * @param queryGenerationConfiguration Specifies configurations for generating queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryGenerationConfiguration(software.amazon.awscdk.IResolvable queryGenerationConfiguration) {
                this.queryGenerationConfiguration = queryGenerationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConfigurationProperty#getQueryGenerationConfiguration}
             * @param queryGenerationConfiguration Specifies configurations for generating queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryGenerationConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.QueryGenerationConfigurationProperty queryGenerationConfiguration) {
                this.queryGenerationConfiguration = queryGenerationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftConfigurationProperty {
            private final java.lang.Object queryEngineConfiguration;
            private final java.lang.Object storageConfigurations;
            private final java.lang.Object queryGenerationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryEngineConfiguration = software.amazon.jsii.Kernel.get(this, "queryEngineConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storageConfigurations = software.amazon.jsii.Kernel.get(this, "storageConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryGenerationConfiguration = software.amazon.jsii.Kernel.get(this, "queryGenerationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryEngineConfiguration = java.util.Objects.requireNonNull(builder.queryEngineConfiguration, "queryEngineConfiguration is required");
                this.storageConfigurations = java.util.Objects.requireNonNull(builder.storageConfigurations, "storageConfigurations is required");
                this.queryGenerationConfiguration = builder.queryGenerationConfiguration;
            }

            @Override
            public final java.lang.Object getQueryEngineConfiguration() {
                return this.queryEngineConfiguration;
            }

            @Override
            public final java.lang.Object getStorageConfigurations() {
                return this.storageConfigurations;
            }

            @Override
            public final java.lang.Object getQueryGenerationConfiguration() {
                return this.queryGenerationConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryEngineConfiguration", om.valueToTree(this.getQueryEngineConfiguration()));
                data.set("storageConfigurations", om.valueToTree(this.getStorageConfigurations()));
                if (this.getQueryGenerationConfiguration() != null) {
                    data.set("queryGenerationConfiguration", om.valueToTree(this.getQueryGenerationConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftConfigurationProperty.Jsii$Proxy that = (RedshiftConfigurationProperty.Jsii$Proxy) o;

                if (!queryEngineConfiguration.equals(that.queryEngineConfiguration)) return false;
                if (!storageConfigurations.equals(that.storageConfigurations)) return false;
                return this.queryGenerationConfiguration != null ? this.queryGenerationConfiguration.equals(that.queryGenerationConfiguration) : that.queryGenerationConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryEngineConfiguration.hashCode();
                result = 31 * result + (this.storageConfigurations.hashCode());
                result = 31 * result + (this.queryGenerationConfiguration != null ? this.queryGenerationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for authentication to an Amazon Redshift provisioned data warehouse.
     * <p>
     * Specify the type of authentication to use in the <code>type</code> field and include the corresponding field. If you specify IAM authentication, you don't need to include another field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftProvisionedAuthConfigurationProperty redshiftProvisionedAuthConfigurationProperty = RedshiftProvisionedAuthConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .databaseUser("databaseUser")
     *         .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftProvisionedAuthConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftProvisionedAuthConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftProvisionedAuthConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of authentication to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedauthconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedauthconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The database username for authentication to an Amazon Redshift provisioned data warehouse.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedauthconfiguration-databaseuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedauthconfiguration-databaseuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseUser() {
            return null;
        }

        /**
         * The ARN of an Secrets Manager secret for authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedauthconfiguration-usernamepasswordsecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedauthconfiguration-usernamepasswordsecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsernamePasswordSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftProvisionedAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftProvisionedAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftProvisionedAuthConfigurationProperty> {
            java.lang.String type;
            java.lang.String databaseUser;
            java.lang.String usernamePasswordSecretArn;

            /**
             * Sets the value of {@link RedshiftProvisionedAuthConfigurationProperty#getType}
             * @param type The type of authentication to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftProvisionedAuthConfigurationProperty#getDatabaseUser}
             * @param databaseUser The database username for authentication to an Amazon Redshift provisioned data warehouse.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseUser(java.lang.String databaseUser) {
                this.databaseUser = databaseUser;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftProvisionedAuthConfigurationProperty#getUsernamePasswordSecretArn}
             * @param usernamePasswordSecretArn The ARN of an Secrets Manager secret for authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernamePasswordSecretArn(java.lang.String usernamePasswordSecretArn) {
                this.usernamePasswordSecretArn = usernamePasswordSecretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftProvisionedAuthConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftProvisionedAuthConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftProvisionedAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftProvisionedAuthConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.String databaseUser;
            private final java.lang.String usernamePasswordSecretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseUser = software.amazon.jsii.Kernel.get(this, "databaseUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usernamePasswordSecretArn = software.amazon.jsii.Kernel.get(this, "usernamePasswordSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.databaseUser = builder.databaseUser;
                this.usernamePasswordSecretArn = builder.usernamePasswordSecretArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getDatabaseUser() {
                return this.databaseUser;
            }

            @Override
            public final java.lang.String getUsernamePasswordSecretArn() {
                return this.usernamePasswordSecretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getDatabaseUser() != null) {
                    data.set("databaseUser", om.valueToTree(this.getDatabaseUser()));
                }
                if (this.getUsernamePasswordSecretArn() != null) {
                    data.set("usernamePasswordSecretArn", om.valueToTree(this.getUsernamePasswordSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftProvisionedAuthConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftProvisionedAuthConfigurationProperty.Jsii$Proxy that = (RedshiftProvisionedAuthConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.databaseUser != null ? !this.databaseUser.equals(that.databaseUser) : that.databaseUser != null) return false;
                return this.usernamePasswordSecretArn != null ? this.usernamePasswordSecretArn.equals(that.usernamePasswordSecretArn) : that.usernamePasswordSecretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.databaseUser != null ? this.databaseUser.hashCode() : 0);
                result = 31 * result + (this.usernamePasswordSecretArn != null ? this.usernamePasswordSecretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a provisioned Amazon Redshift query engine.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftProvisionedConfigurationProperty redshiftProvisionedConfigurationProperty = RedshiftProvisionedConfigurationProperty.builder()
     *         .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .databaseUser("databaseUser")
     *                 .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                 .build())
     *         .clusterIdentifier("clusterIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftProvisionedConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftProvisionedConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftProvisionedConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies configurations for authentication to Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedconfiguration-authconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedconfiguration-authconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAuthConfiguration();

        /**
         * The ID of the Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedconfiguration-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftprovisionedconfiguration.html#cfn-bedrock-knowledgebase-redshiftprovisionedconfiguration-clusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

        /**
         * @return a {@link Builder} of {@link RedshiftProvisionedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftProvisionedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftProvisionedConfigurationProperty> {
            java.lang.Object authConfiguration;
            java.lang.String clusterIdentifier;

            /**
             * Sets the value of {@link RedshiftProvisionedConfigurationProperty#getAuthConfiguration}
             * @param authConfiguration Specifies configurations for authentication to Amazon Redshift. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authConfiguration(software.amazon.awscdk.IResolvable authConfiguration) {
                this.authConfiguration = authConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftProvisionedConfigurationProperty#getAuthConfiguration}
             * @param authConfiguration Specifies configurations for authentication to Amazon Redshift. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftProvisionedAuthConfigurationProperty authConfiguration) {
                this.authConfiguration = authConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftProvisionedConfigurationProperty#getClusterIdentifier}
             * @param clusterIdentifier The ID of the Amazon Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftProvisionedConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftProvisionedConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftProvisionedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftProvisionedConfigurationProperty {
            private final java.lang.Object authConfiguration;
            private final java.lang.String clusterIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authConfiguration = software.amazon.jsii.Kernel.get(this, "authConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authConfiguration = java.util.Objects.requireNonNull(builder.authConfiguration, "authConfiguration is required");
                this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            }

            @Override
            public final java.lang.Object getAuthConfiguration() {
                return this.authConfiguration;
            }

            @Override
            public final java.lang.String getClusterIdentifier() {
                return this.clusterIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authConfiguration", om.valueToTree(this.getAuthConfiguration()));
                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftProvisionedConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftProvisionedConfigurationProperty.Jsii$Proxy that = (RedshiftProvisionedConfigurationProperty.Jsii$Proxy) o;

                if (!authConfiguration.equals(that.authConfiguration)) return false;
                return this.clusterIdentifier.equals(that.clusterIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.authConfiguration.hashCode();
                result = 31 * result + (this.clusterIdentifier.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations for storage in AWS Glue Data Catalog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty redshiftQueryEngineAwsDataCatalogStorageConfigurationProperty = RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
     *         .tableNames(List.of("tableNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineawsdatacatalogstorageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineawsdatacatalogstorageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of names of the tables to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineawsdatacatalogstorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineawsdatacatalogstorageconfiguration-tablenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineawsdatacatalogstorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineawsdatacatalogstorageconfiguration-tablenames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTableNames();

        /**
         * @return a {@link Builder} of {@link RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty> {
            java.util.List<java.lang.String> tableNames;

            /**
             * Sets the value of {@link RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty#getTableNames}
             * @param tableNames A list of names of the tables to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableNames(java.util.List<java.lang.String> tableNames) {
                this.tableNames = tableNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty {
            private final java.util.List<java.lang.String> tableNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableNames = software.amazon.jsii.Kernel.get(this, "tableNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableNames = java.util.Objects.requireNonNull(builder.tableNames, "tableNames is required");
            }

            @Override
            public final java.util.List<java.lang.String> getTableNames() {
                return this.tableNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableNames", om.valueToTree(this.getTableNames()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.Jsii$Proxy that = (RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.Jsii$Proxy) o;

                return this.tableNames.equals(that.tableNames);
            }

            @Override
            public final int hashCode() {
                int result = this.tableNames.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for an Amazon Redshift query engine.
     * <p>
     * Specify the type of query engine in <code>type</code> and include the corresponding field. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftQueryEngineConfigurationProperty redshiftQueryEngineConfigurationProperty = RedshiftQueryEngineConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .provisionedConfiguration(RedshiftProvisionedConfigurationProperty.builder()
     *                 .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .databaseUser("databaseUser")
     *                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                         .build())
     *                 .clusterIdentifier("clusterIdentifier")
     *                 .build())
     *         .serverlessConfiguration(RedshiftServerlessConfigurationProperty.builder()
     *                 .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                         .build())
     *                 .workgroupArn("workgroupArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftQueryEngineConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftQueryEngineConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of query engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies configurations for a provisioned Amazon Redshift query engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineconfiguration-provisionedconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineconfiguration-provisionedconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedConfiguration() {
            return null;
        }

        /**
         * Specifies configurations for a serverless Amazon Redshift query engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineconfiguration-serverlessconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineconfiguration-serverlessconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerlessConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftQueryEngineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftQueryEngineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftQueryEngineConfigurationProperty> {
            java.lang.String type;
            java.lang.Object provisionedConfiguration;
            java.lang.Object serverlessConfiguration;

            /**
             * Sets the value of {@link RedshiftQueryEngineConfigurationProperty#getType}
             * @param type The type of query engine. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineConfigurationProperty#getProvisionedConfiguration}
             * @param provisionedConfiguration Specifies configurations for a provisioned Amazon Redshift query engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedConfiguration(software.amazon.awscdk.IResolvable provisionedConfiguration) {
                this.provisionedConfiguration = provisionedConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineConfigurationProperty#getProvisionedConfiguration}
             * @param provisionedConfiguration Specifies configurations for a provisioned Amazon Redshift query engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftProvisionedConfigurationProperty provisionedConfiguration) {
                this.provisionedConfiguration = provisionedConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineConfigurationProperty#getServerlessConfiguration}
             * @param serverlessConfiguration Specifies configurations for a serverless Amazon Redshift query engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverlessConfiguration(software.amazon.awscdk.IResolvable serverlessConfiguration) {
                this.serverlessConfiguration = serverlessConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineConfigurationProperty#getServerlessConfiguration}
             * @param serverlessConfiguration Specifies configurations for a serverless Amazon Redshift query engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverlessConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftServerlessConfigurationProperty serverlessConfiguration) {
                this.serverlessConfiguration = serverlessConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftQueryEngineConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftQueryEngineConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftQueryEngineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftQueryEngineConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object provisionedConfiguration;
            private final java.lang.Object serverlessConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisionedConfiguration = software.amazon.jsii.Kernel.get(this, "provisionedConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverlessConfiguration = software.amazon.jsii.Kernel.get(this, "serverlessConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.provisionedConfiguration = builder.provisionedConfiguration;
                this.serverlessConfiguration = builder.serverlessConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getProvisionedConfiguration() {
                return this.provisionedConfiguration;
            }

            @Override
            public final java.lang.Object getServerlessConfiguration() {
                return this.serverlessConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getProvisionedConfiguration() != null) {
                    data.set("provisionedConfiguration", om.valueToTree(this.getProvisionedConfiguration()));
                }
                if (this.getServerlessConfiguration() != null) {
                    data.set("serverlessConfiguration", om.valueToTree(this.getServerlessConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftQueryEngineConfigurationProperty.Jsii$Proxy that = (RedshiftQueryEngineConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.provisionedConfiguration != null ? !this.provisionedConfiguration.equals(that.provisionedConfiguration) : that.provisionedConfiguration != null) return false;
                return this.serverlessConfiguration != null ? this.serverlessConfiguration.equals(that.serverlessConfiguration) : that.serverlessConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.provisionedConfiguration != null ? this.provisionedConfiguration.hashCode() : 0);
                result = 31 * result + (this.serverlessConfiguration != null ? this.serverlessConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for storage in Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftQueryEngineRedshiftStorageConfigurationProperty redshiftQueryEngineRedshiftStorageConfigurationProperty = RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
     *         .databaseName("databaseName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineredshiftstorageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineredshiftstorageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineRedshiftStorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftQueryEngineRedshiftStorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftQueryEngineRedshiftStorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon Redshift database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineredshiftstorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineredshiftstorageconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryengineredshiftstorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryengineredshiftstorageconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * @return a {@link Builder} of {@link RedshiftQueryEngineRedshiftStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftQueryEngineRedshiftStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftQueryEngineRedshiftStorageConfigurationProperty> {
            java.lang.String databaseName;

            /**
             * Sets the value of {@link RedshiftQueryEngineRedshiftStorageConfigurationProperty#getDatabaseName}
             * @param databaseName The name of the Amazon Redshift database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftQueryEngineRedshiftStorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftQueryEngineRedshiftStorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftQueryEngineRedshiftStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftQueryEngineRedshiftStorageConfigurationProperty {
            private final java.lang.String databaseName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineRedshiftStorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftQueryEngineRedshiftStorageConfigurationProperty.Jsii$Proxy that = (RedshiftQueryEngineRedshiftStorageConfigurationProperty.Jsii$Proxy) o;

                return this.databaseName.equals(that.databaseName);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for Amazon Redshift data storage.
     * <p>
     * Specify the data storage service to use in the <code>type</code> field and include the corresponding field. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftQueryEngineStorageConfigurationProperty redshiftQueryEngineStorageConfigurationProperty = RedshiftQueryEngineStorageConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
     *                 .tableNames(List.of("tableNames"))
     *                 .build())
     *         .redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
     *                 .databaseName("databaseName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineStorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftQueryEngineStorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftQueryEngineStorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data storage service to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies configurations for storage in AWS Glue Data Catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration-awsdatacatalogconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration-awsdatacatalogconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsDataCatalogConfiguration() {
            return null;
        }

        /**
         * Specifies configurations for storage in Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration-redshiftconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration.html#cfn-bedrock-knowledgebase-redshiftqueryenginestorageconfiguration-redshiftconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftQueryEngineStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftQueryEngineStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftQueryEngineStorageConfigurationProperty> {
            java.lang.String type;
            java.lang.Object awsDataCatalogConfiguration;
            java.lang.Object redshiftConfiguration;

            /**
             * Sets the value of {@link RedshiftQueryEngineStorageConfigurationProperty#getType}
             * @param type The data storage service to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineStorageConfigurationProperty#getAwsDataCatalogConfiguration}
             * @param awsDataCatalogConfiguration Specifies configurations for storage in AWS Glue Data Catalog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsDataCatalogConfiguration(software.amazon.awscdk.IResolvable awsDataCatalogConfiguration) {
                this.awsDataCatalogConfiguration = awsDataCatalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineStorageConfigurationProperty#getAwsDataCatalogConfiguration}
             * @param awsDataCatalogConfiguration Specifies configurations for storage in AWS Glue Data Catalog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsDataCatalogConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty awsDataCatalogConfiguration) {
                this.awsDataCatalogConfiguration = awsDataCatalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineStorageConfigurationProperty#getRedshiftConfiguration}
             * @param redshiftConfiguration Specifies configurations for storage in Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftConfiguration(software.amazon.awscdk.IResolvable redshiftConfiguration) {
                this.redshiftConfiguration = redshiftConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftQueryEngineStorageConfigurationProperty#getRedshiftConfiguration}
             * @param redshiftConfiguration Specifies configurations for storage in Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftQueryEngineRedshiftStorageConfigurationProperty redshiftConfiguration) {
                this.redshiftConfiguration = redshiftConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftQueryEngineStorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftQueryEngineStorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftQueryEngineStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftQueryEngineStorageConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object awsDataCatalogConfiguration;
            private final java.lang.Object redshiftConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsDataCatalogConfiguration = software.amazon.jsii.Kernel.get(this, "awsDataCatalogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftConfiguration = software.amazon.jsii.Kernel.get(this, "redshiftConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.awsDataCatalogConfiguration = builder.awsDataCatalogConfiguration;
                this.redshiftConfiguration = builder.redshiftConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getAwsDataCatalogConfiguration() {
                return this.awsDataCatalogConfiguration;
            }

            @Override
            public final java.lang.Object getRedshiftConfiguration() {
                return this.redshiftConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAwsDataCatalogConfiguration() != null) {
                    data.set("awsDataCatalogConfiguration", om.valueToTree(this.getAwsDataCatalogConfiguration()));
                }
                if (this.getRedshiftConfiguration() != null) {
                    data.set("redshiftConfiguration", om.valueToTree(this.getRedshiftConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftQueryEngineStorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftQueryEngineStorageConfigurationProperty.Jsii$Proxy that = (RedshiftQueryEngineStorageConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.awsDataCatalogConfiguration != null ? !this.awsDataCatalogConfiguration.equals(that.awsDataCatalogConfiguration) : that.awsDataCatalogConfiguration != null) return false;
                return this.redshiftConfiguration != null ? this.redshiftConfiguration.equals(that.redshiftConfiguration) : that.redshiftConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.awsDataCatalogConfiguration != null ? this.awsDataCatalogConfiguration.hashCode() : 0);
                result = 31 * result + (this.redshiftConfiguration != null ? this.redshiftConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies configurations for authentication to a Redshift Serverless.
     * <p>
     * Specify the type of authentication to use in the <code>type</code> field and include the corresponding field. If you specify IAM authentication, you don't need to include another field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftServerlessAuthConfigurationProperty redshiftServerlessAuthConfigurationProperty = RedshiftServerlessAuthConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessauthconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessauthconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftServerlessAuthConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftServerlessAuthConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftServerlessAuthConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of authentication to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessauthconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessauthconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The ARN of an Secrets Manager secret for authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessauthconfiguration-usernamepasswordsecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessauthconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessauthconfiguration-usernamepasswordsecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsernamePasswordSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftServerlessAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftServerlessAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftServerlessAuthConfigurationProperty> {
            java.lang.String type;
            java.lang.String usernamePasswordSecretArn;

            /**
             * Sets the value of {@link RedshiftServerlessAuthConfigurationProperty#getType}
             * @param type The type of authentication to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftServerlessAuthConfigurationProperty#getUsernamePasswordSecretArn}
             * @param usernamePasswordSecretArn The ARN of an Secrets Manager secret for authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernamePasswordSecretArn(java.lang.String usernamePasswordSecretArn) {
                this.usernamePasswordSecretArn = usernamePasswordSecretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftServerlessAuthConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftServerlessAuthConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftServerlessAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftServerlessAuthConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.String usernamePasswordSecretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usernamePasswordSecretArn = software.amazon.jsii.Kernel.get(this, "usernamePasswordSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.usernamePasswordSecretArn = builder.usernamePasswordSecretArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUsernamePasswordSecretArn() {
                return this.usernamePasswordSecretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getUsernamePasswordSecretArn() != null) {
                    data.set("usernamePasswordSecretArn", om.valueToTree(this.getUsernamePasswordSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftServerlessAuthConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftServerlessAuthConfigurationProperty.Jsii$Proxy that = (RedshiftServerlessAuthConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.usernamePasswordSecretArn != null ? this.usernamePasswordSecretArn.equals(that.usernamePasswordSecretArn) : that.usernamePasswordSecretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.usernamePasswordSecretArn != null ? this.usernamePasswordSecretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for authentication to Amazon Redshift Serverless.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RedshiftServerlessConfigurationProperty redshiftServerlessConfigurationProperty = RedshiftServerlessConfigurationProperty.builder()
     *         .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                 .build())
     *         .workgroupArn("workgroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftServerlessConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftServerlessConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftServerlessConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessconfiguration-authconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessconfiguration-authconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAuthConfiguration();

        /**
         * The ARN of the Amazon Redshift workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessconfiguration-workgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-redshiftserverlessconfiguration.html#cfn-bedrock-knowledgebase-redshiftserverlessconfiguration-workgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkgroupArn();

        /**
         * @return a {@link Builder} of {@link RedshiftServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftServerlessConfigurationProperty> {
            java.lang.Object authConfiguration;
            java.lang.String workgroupArn;

            /**
             * Sets the value of {@link RedshiftServerlessConfigurationProperty#getAuthConfiguration}
             * @param authConfiguration Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authConfiguration(software.amazon.awscdk.IResolvable authConfiguration) {
                this.authConfiguration = authConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftServerlessConfigurationProperty#getAuthConfiguration}
             * @param authConfiguration Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftServerlessAuthConfigurationProperty authConfiguration) {
                this.authConfiguration = authConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftServerlessConfigurationProperty#getWorkgroupArn}
             * @param workgroupArn The ARN of the Amazon Redshift workgroup. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupArn(java.lang.String workgroupArn) {
                this.workgroupArn = workgroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftServerlessConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftServerlessConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftServerlessConfigurationProperty {
            private final java.lang.Object authConfiguration;
            private final java.lang.String workgroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authConfiguration = software.amazon.jsii.Kernel.get(this, "authConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workgroupArn = software.amazon.jsii.Kernel.get(this, "workgroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authConfiguration = java.util.Objects.requireNonNull(builder.authConfiguration, "authConfiguration is required");
                this.workgroupArn = java.util.Objects.requireNonNull(builder.workgroupArn, "workgroupArn is required");
            }

            @Override
            public final java.lang.Object getAuthConfiguration() {
                return this.authConfiguration;
            }

            @Override
            public final java.lang.String getWorkgroupArn() {
                return this.workgroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authConfiguration", om.valueToTree(this.getAuthConfiguration()));
                data.set("workgroupArn", om.valueToTree(this.getWorkgroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RedshiftServerlessConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftServerlessConfigurationProperty.Jsii$Proxy that = (RedshiftServerlessConfigurationProperty.Jsii$Proxy) o;

                if (!authConfiguration.equals(that.authConfiguration)) return false;
                return this.workgroupArn.equals(that.workgroupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.authConfiguration.hashCode();
                result = 31 * result + (this.workgroupArn.hashCode());
                return result;
            }
        }
    }
    /**
     * A storage location in an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .uri("uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object URI starting with <code>s3://</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-s3location.html#cfn-bedrock-knowledgebase-s3location-uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-s3location.html#cfn-bedrock-knowledgebase-s3location-uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUri();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String uri;

            /**
             * Sets the value of {@link S3LocationProperty#getUri}
             * @param uri An object URI starting with <code>s3://</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uri = java.util.Objects.requireNonNull(builder.uri, "uri is required");
            }

            @Override
            public final java.lang.String getUri() {
                return this.uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("uri", om.valueToTree(this.getUri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                return this.uri.equals(that.uri);
            }

            @Override
            public final int hashCode() {
                int result = this.uri.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a knowledge base connected to an SQL database.
     * <p>
     * Specify the SQL database type in the <code>type</code> field and include the corresponding field. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SqlKnowledgeBaseConfigurationProperty sqlKnowledgeBaseConfigurationProperty = SqlKnowledgeBaseConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .redshiftConfiguration(RedshiftConfigurationProperty.builder()
     *                 .queryEngineConfiguration(RedshiftQueryEngineConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .provisionedConfiguration(RedshiftProvisionedConfigurationProperty.builder()
     *                                 .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .databaseUser("databaseUser")
     *                                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                                         .build())
     *                                 .clusterIdentifier("clusterIdentifier")
     *                                 .build())
     *                         .serverlessConfiguration(RedshiftServerlessConfigurationProperty.builder()
     *                                 .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
     *                                         .build())
     *                                 .workgroupArn("workgroupArn")
     *                                 .build())
     *                         .build())
     *                 .storageConfigurations(List.of(RedshiftQueryEngineStorageConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
     *                                 .tableNames(List.of("tableNames"))
     *                                 .build())
     *                         .redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
     *                                 .databaseName("databaseName")
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .queryGenerationConfiguration(QueryGenerationConfigurationProperty.builder()
     *                         .executionTimeoutSeconds(123)
     *                         .generationContext(QueryGenerationContextProperty.builder()
     *                                 .curatedQueries(List.of(CuratedQueryProperty.builder()
     *                                         .naturalLanguage("naturalLanguage")
     *                                         .sql("sql")
     *                                         .build()))
     *                                 .tables(List.of(QueryGenerationTableProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .columns(List.of(QueryGenerationColumnProperty.builder()
     *                                                 .description("description")
     *                                                 .inclusion("inclusion")
     *                                                 .name("name")
     *                                                 .build()))
     *                                         .description("description")
     *                                         .inclusion("inclusion")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-sqlknowledgebaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-sqlknowledgebaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SqlKnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SqlKnowledgeBaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqlKnowledgeBaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of SQL database to connect to the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-sqlknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-sqlknowledgebaseconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-sqlknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-sqlknowledgebaseconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies configurations for a knowledge base connected to an Amazon Redshift database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-sqlknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-sqlknowledgebaseconfiguration-redshiftconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-sqlknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-sqlknowledgebaseconfiguration-redshiftconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqlKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqlKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqlKnowledgeBaseConfigurationProperty> {
            java.lang.String type;
            java.lang.Object redshiftConfiguration;

            /**
             * Sets the value of {@link SqlKnowledgeBaseConfigurationProperty#getType}
             * @param type The type of SQL database to connect to the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SqlKnowledgeBaseConfigurationProperty#getRedshiftConfiguration}
             * @param redshiftConfiguration Specifies configurations for a knowledge base connected to an Amazon Redshift database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftConfiguration(software.amazon.awscdk.IResolvable redshiftConfiguration) {
                this.redshiftConfiguration = redshiftConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SqlKnowledgeBaseConfigurationProperty#getRedshiftConfiguration}
             * @param redshiftConfiguration Specifies configurations for a knowledge base connected to an Amazon Redshift database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RedshiftConfigurationProperty redshiftConfiguration) {
                this.redshiftConfiguration = redshiftConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqlKnowledgeBaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqlKnowledgeBaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqlKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqlKnowledgeBaseConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object redshiftConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redshiftConfiguration = software.amazon.jsii.Kernel.get(this, "redshiftConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.redshiftConfiguration = builder.redshiftConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getRedshiftConfiguration() {
                return this.redshiftConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getRedshiftConfiguration() != null) {
                    data.set("redshiftConfiguration", om.valueToTree(this.getRedshiftConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SqlKnowledgeBaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqlKnowledgeBaseConfigurationProperty.Jsii$Proxy that = (SqlKnowledgeBaseConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.redshiftConfiguration != null ? this.redshiftConfiguration.equals(that.redshiftConfiguration) : that.redshiftConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.redshiftConfiguration != null ? this.redshiftConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the storage configuration of the knowledge base.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageConfigurationProperty storageConfigurationProperty = StorageConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .mongoDbAtlasConfiguration(MongoDbAtlasConfigurationProperty.builder()
     *                 .collectionName("collectionName")
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .databaseName("databaseName")
     *                 .endpoint("endpoint")
     *                 .fieldMapping(MongoDbAtlasFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .vectorField("vectorField")
     *                         .build())
     *                 .vectorIndexName("vectorIndexName")
     *                 // the properties below are optional
     *                 .endpointServiceName("endpointServiceName")
     *                 .textIndexName("textIndexName")
     *                 .build())
     *         .neptuneAnalyticsConfiguration(NeptuneAnalyticsConfigurationProperty.builder()
     *                 .fieldMapping(NeptuneAnalyticsFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .build())
     *                 .graphArn("graphArn")
     *                 .build())
     *         .opensearchManagedClusterConfiguration(OpenSearchManagedClusterConfigurationProperty.builder()
     *                 .domainArn("domainArn")
     *                 .domainEndpoint("domainEndpoint")
     *                 .fieldMapping(OpenSearchManagedClusterFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .vectorField("vectorField")
     *                         .build())
     *                 .vectorIndexName("vectorIndexName")
     *                 .build())
     *         .opensearchServerlessConfiguration(OpenSearchServerlessConfigurationProperty.builder()
     *                 .collectionArn("collectionArn")
     *                 .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .vectorField("vectorField")
     *                         .build())
     *                 .vectorIndexName("vectorIndexName")
     *                 .build())
     *         .pineconeConfiguration(PineconeConfigurationProperty.builder()
     *                 .connectionString("connectionString")
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .fieldMapping(PineconeFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .build())
     *                 // the properties below are optional
     *                 .namespace("namespace")
     *                 .build())
     *         .rdsConfiguration(RdsConfigurationProperty.builder()
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .databaseName("databaseName")
     *                 .fieldMapping(RdsFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .primaryKeyField("primaryKeyField")
     *                         .textField("textField")
     *                         .vectorField("vectorField")
     *                         // the properties below are optional
     *                         .customMetadataField("customMetadataField")
     *                         .build())
     *                 .resourceArn("resourceArn")
     *                 .tableName("tableName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.StorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The vector store service in which the knowledge base is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Contains the storage configuration of the knowledge base in MongoDB Atlas.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-mongodbatlasconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-mongodbatlasconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbAtlasConfiguration() {
            return null;
        }

        /**
         * Contains details about the Neptune Analytics configuration of the knowledge base in Amazon Neptune.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html">Create a vector index in Amazon Neptune Analytics.</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-neptuneanalyticsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-neptuneanalyticsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNeptuneAnalyticsConfiguration() {
            return null;
        }

        /**
         * Contains details about the storage configuration of the knowledge base in OpenSearch Managed Cluster.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html">Create a vector index in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-opensearchmanagedclusterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-opensearchmanagedclusterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpensearchManagedClusterConfiguration() {
            return null;
        }

        /**
         * Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-opensearchserverlessconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-opensearchserverlessconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpensearchServerlessConfiguration() {
            return null;
        }

        /**
         * Contains the storage configuration of the knowledge base in Pinecone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-pineconeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-pineconeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPineconeConfiguration() {
            return null;
        }

        /**
         * Contains details about the storage configuration of the knowledge base in Amazon RDS.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-rdsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-rdsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRdsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageConfigurationProperty> {
            java.lang.String type;
            java.lang.Object mongoDbAtlasConfiguration;
            java.lang.Object neptuneAnalyticsConfiguration;
            java.lang.Object opensearchManagedClusterConfiguration;
            java.lang.Object opensearchServerlessConfiguration;
            java.lang.Object pineconeConfiguration;
            java.lang.Object rdsConfiguration;

            /**
             * Sets the value of {@link StorageConfigurationProperty#getType}
             * @param type The vector store service in which the knowledge base is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getMongoDbAtlasConfiguration}
             * @param mongoDbAtlasConfiguration Contains the storage configuration of the knowledge base in MongoDB Atlas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbAtlasConfiguration(software.amazon.awscdk.IResolvable mongoDbAtlasConfiguration) {
                this.mongoDbAtlasConfiguration = mongoDbAtlasConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getMongoDbAtlasConfiguration}
             * @param mongoDbAtlasConfiguration Contains the storage configuration of the knowledge base in MongoDB Atlas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbAtlasConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.MongoDbAtlasConfigurationProperty mongoDbAtlasConfiguration) {
                this.mongoDbAtlasConfiguration = mongoDbAtlasConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getNeptuneAnalyticsConfiguration}
             * @param neptuneAnalyticsConfiguration Contains details about the Neptune Analytics configuration of the knowledge base in Amazon Neptune.
             *                                      For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html">Create a vector index in Amazon Neptune Analytics.</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neptuneAnalyticsConfiguration(software.amazon.awscdk.IResolvable neptuneAnalyticsConfiguration) {
                this.neptuneAnalyticsConfiguration = neptuneAnalyticsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getNeptuneAnalyticsConfiguration}
             * @param neptuneAnalyticsConfiguration Contains details about the Neptune Analytics configuration of the knowledge base in Amazon Neptune.
             *                                      For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html">Create a vector index in Amazon Neptune Analytics.</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neptuneAnalyticsConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.NeptuneAnalyticsConfigurationProperty neptuneAnalyticsConfiguration) {
                this.neptuneAnalyticsConfiguration = neptuneAnalyticsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getOpensearchManagedClusterConfiguration}
             * @param opensearchManagedClusterConfiguration Contains details about the storage configuration of the knowledge base in OpenSearch Managed Cluster.
             *                                              For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html">Create a vector index in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder opensearchManagedClusterConfiguration(software.amazon.awscdk.IResolvable opensearchManagedClusterConfiguration) {
                this.opensearchManagedClusterConfiguration = opensearchManagedClusterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getOpensearchManagedClusterConfiguration}
             * @param opensearchManagedClusterConfiguration Contains details about the storage configuration of the knowledge base in OpenSearch Managed Cluster.
             *                                              For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html">Create a vector index in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder opensearchManagedClusterConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.OpenSearchManagedClusterConfigurationProperty opensearchManagedClusterConfiguration) {
                this.opensearchManagedClusterConfiguration = opensearchManagedClusterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getOpensearchServerlessConfiguration}
             * @param opensearchServerlessConfiguration Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder opensearchServerlessConfiguration(software.amazon.awscdk.IResolvable opensearchServerlessConfiguration) {
                this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getOpensearchServerlessConfiguration}
             * @param opensearchServerlessConfiguration Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder opensearchServerlessConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty opensearchServerlessConfiguration) {
                this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getPineconeConfiguration}
             * @param pineconeConfiguration Contains the storage configuration of the knowledge base in Pinecone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pineconeConfiguration(software.amazon.awscdk.IResolvable pineconeConfiguration) {
                this.pineconeConfiguration = pineconeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getPineconeConfiguration}
             * @param pineconeConfiguration Contains the storage configuration of the knowledge base in Pinecone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pineconeConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.PineconeConfigurationProperty pineconeConfiguration) {
                this.pineconeConfiguration = pineconeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getRdsConfiguration}
             * @param rdsConfiguration Contains details about the storage configuration of the knowledge base in Amazon RDS.
             *                         For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsConfiguration(software.amazon.awscdk.IResolvable rdsConfiguration) {
                this.rdsConfiguration = rdsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getRdsConfiguration}
             * @param rdsConfiguration Contains details about the storage configuration of the knowledge base in Amazon RDS.
             *                         For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RdsConfigurationProperty rdsConfiguration) {
                this.rdsConfiguration = rdsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object mongoDbAtlasConfiguration;
            private final java.lang.Object neptuneAnalyticsConfiguration;
            private final java.lang.Object opensearchManagedClusterConfiguration;
            private final java.lang.Object opensearchServerlessConfiguration;
            private final java.lang.Object pineconeConfiguration;
            private final java.lang.Object rdsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mongoDbAtlasConfiguration = software.amazon.jsii.Kernel.get(this, "mongoDbAtlasConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.neptuneAnalyticsConfiguration = software.amazon.jsii.Kernel.get(this, "neptuneAnalyticsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.opensearchManagedClusterConfiguration = software.amazon.jsii.Kernel.get(this, "opensearchManagedClusterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.opensearchServerlessConfiguration = software.amazon.jsii.Kernel.get(this, "opensearchServerlessConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pineconeConfiguration = software.amazon.jsii.Kernel.get(this, "pineconeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rdsConfiguration = software.amazon.jsii.Kernel.get(this, "rdsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.mongoDbAtlasConfiguration = builder.mongoDbAtlasConfiguration;
                this.neptuneAnalyticsConfiguration = builder.neptuneAnalyticsConfiguration;
                this.opensearchManagedClusterConfiguration = builder.opensearchManagedClusterConfiguration;
                this.opensearchServerlessConfiguration = builder.opensearchServerlessConfiguration;
                this.pineconeConfiguration = builder.pineconeConfiguration;
                this.rdsConfiguration = builder.rdsConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getMongoDbAtlasConfiguration() {
                return this.mongoDbAtlasConfiguration;
            }

            @Override
            public final java.lang.Object getNeptuneAnalyticsConfiguration() {
                return this.neptuneAnalyticsConfiguration;
            }

            @Override
            public final java.lang.Object getOpensearchManagedClusterConfiguration() {
                return this.opensearchManagedClusterConfiguration;
            }

            @Override
            public final java.lang.Object getOpensearchServerlessConfiguration() {
                return this.opensearchServerlessConfiguration;
            }

            @Override
            public final java.lang.Object getPineconeConfiguration() {
                return this.pineconeConfiguration;
            }

            @Override
            public final java.lang.Object getRdsConfiguration() {
                return this.rdsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getMongoDbAtlasConfiguration() != null) {
                    data.set("mongoDbAtlasConfiguration", om.valueToTree(this.getMongoDbAtlasConfiguration()));
                }
                if (this.getNeptuneAnalyticsConfiguration() != null) {
                    data.set("neptuneAnalyticsConfiguration", om.valueToTree(this.getNeptuneAnalyticsConfiguration()));
                }
                if (this.getOpensearchManagedClusterConfiguration() != null) {
                    data.set("opensearchManagedClusterConfiguration", om.valueToTree(this.getOpensearchManagedClusterConfiguration()));
                }
                if (this.getOpensearchServerlessConfiguration() != null) {
                    data.set("opensearchServerlessConfiguration", om.valueToTree(this.getOpensearchServerlessConfiguration()));
                }
                if (this.getPineconeConfiguration() != null) {
                    data.set("pineconeConfiguration", om.valueToTree(this.getPineconeConfiguration()));
                }
                if (this.getRdsConfiguration() != null) {
                    data.set("rdsConfiguration", om.valueToTree(this.getRdsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.StorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageConfigurationProperty.Jsii$Proxy that = (StorageConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.mongoDbAtlasConfiguration != null ? !this.mongoDbAtlasConfiguration.equals(that.mongoDbAtlasConfiguration) : that.mongoDbAtlasConfiguration != null) return false;
                if (this.neptuneAnalyticsConfiguration != null ? !this.neptuneAnalyticsConfiguration.equals(that.neptuneAnalyticsConfiguration) : that.neptuneAnalyticsConfiguration != null) return false;
                if (this.opensearchManagedClusterConfiguration != null ? !this.opensearchManagedClusterConfiguration.equals(that.opensearchManagedClusterConfiguration) : that.opensearchManagedClusterConfiguration != null) return false;
                if (this.opensearchServerlessConfiguration != null ? !this.opensearchServerlessConfiguration.equals(that.opensearchServerlessConfiguration) : that.opensearchServerlessConfiguration != null) return false;
                if (this.pineconeConfiguration != null ? !this.pineconeConfiguration.equals(that.pineconeConfiguration) : that.pineconeConfiguration != null) return false;
                return this.rdsConfiguration != null ? this.rdsConfiguration.equals(that.rdsConfiguration) : that.rdsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.mongoDbAtlasConfiguration != null ? this.mongoDbAtlasConfiguration.hashCode() : 0);
                result = 31 * result + (this.neptuneAnalyticsConfiguration != null ? this.neptuneAnalyticsConfiguration.hashCode() : 0);
                result = 31 * result + (this.opensearchManagedClusterConfiguration != null ? this.opensearchManagedClusterConfiguration.hashCode() : 0);
                result = 31 * result + (this.opensearchServerlessConfiguration != null ? this.opensearchServerlessConfiguration.hashCode() : 0);
                result = 31 * result + (this.pineconeConfiguration != null ? this.pineconeConfiguration.hashCode() : 0);
                result = 31 * result + (this.rdsConfiguration != null ? this.rdsConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies configurations for the storage location of the images extracted from multimodal documents in your data source.
     * <p>
     * These images can be retrieved and returned to the end user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SupplementalDataStorageConfigurationProperty supplementalDataStorageConfigurationProperty = SupplementalDataStorageConfigurationProperty.builder()
     *         .supplementalDataStorageLocations(List.of(SupplementalDataStorageLocationProperty.builder()
     *                 .supplementalDataStorageLocationType("supplementalDataStorageLocationType")
     *                 // the properties below are optional
     *                 .s3Location(S3LocationProperty.builder()
     *                         .uri("uri")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastorageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastorageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SupplementalDataStorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SupplementalDataStorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SupplementalDataStorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of supplemental data storage locations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastorageconfiguration.html#cfn-bedrock-knowledgebase-supplementaldatastorageconfiguration-supplementaldatastoragelocations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastorageconfiguration.html#cfn-bedrock-knowledgebase-supplementaldatastorageconfiguration-supplementaldatastoragelocations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSupplementalDataStorageLocations();

        /**
         * @return a {@link Builder} of {@link SupplementalDataStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SupplementalDataStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SupplementalDataStorageConfigurationProperty> {
            java.lang.Object supplementalDataStorageLocations;

            /**
             * Sets the value of {@link SupplementalDataStorageConfigurationProperty#getSupplementalDataStorageLocations}
             * @param supplementalDataStorageLocations List of supplemental data storage locations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supplementalDataStorageLocations(software.amazon.awscdk.IResolvable supplementalDataStorageLocations) {
                this.supplementalDataStorageLocations = supplementalDataStorageLocations;
                return this;
            }

            /**
             * Sets the value of {@link SupplementalDataStorageConfigurationProperty#getSupplementalDataStorageLocations}
             * @param supplementalDataStorageLocations List of supplemental data storage locations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supplementalDataStorageLocations(java.util.List<? extends java.lang.Object> supplementalDataStorageLocations) {
                this.supplementalDataStorageLocations = supplementalDataStorageLocations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SupplementalDataStorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SupplementalDataStorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SupplementalDataStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SupplementalDataStorageConfigurationProperty {
            private final java.lang.Object supplementalDataStorageLocations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.supplementalDataStorageLocations = software.amazon.jsii.Kernel.get(this, "supplementalDataStorageLocations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.supplementalDataStorageLocations = java.util.Objects.requireNonNull(builder.supplementalDataStorageLocations, "supplementalDataStorageLocations is required");
            }

            @Override
            public final java.lang.Object getSupplementalDataStorageLocations() {
                return this.supplementalDataStorageLocations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("supplementalDataStorageLocations", om.valueToTree(this.getSupplementalDataStorageLocations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SupplementalDataStorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SupplementalDataStorageConfigurationProperty.Jsii$Proxy that = (SupplementalDataStorageConfigurationProperty.Jsii$Proxy) o;

                return this.supplementalDataStorageLocations.equals(that.supplementalDataStorageLocations);
            }

            @Override
            public final int hashCode() {
                int result = this.supplementalDataStorageLocations.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about a storage location for images extracted from multimodal documents in your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SupplementalDataStorageLocationProperty supplementalDataStorageLocationProperty = SupplementalDataStorageLocationProperty.builder()
     *         .supplementalDataStorageLocationType("supplementalDataStorageLocationType")
     *         // the properties below are optional
     *         .s3Location(S3LocationProperty.builder()
     *                 .uri("uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastoragelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastoragelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SupplementalDataStorageLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(SupplementalDataStorageLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SupplementalDataStorageLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Supplemental data storage location type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastoragelocation.html#cfn-bedrock-knowledgebase-supplementaldatastoragelocation-supplementaldatastoragelocationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastoragelocation.html#cfn-bedrock-knowledgebase-supplementaldatastoragelocation-supplementaldatastoragelocationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSupplementalDataStorageLocationType();

        /**
         * Contains information about the Amazon S3 location for the extracted images.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastoragelocation.html#cfn-bedrock-knowledgebase-supplementaldatastoragelocation-s3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-supplementaldatastoragelocation.html#cfn-bedrock-knowledgebase-supplementaldatastoragelocation-s3location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Location() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SupplementalDataStorageLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SupplementalDataStorageLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SupplementalDataStorageLocationProperty> {
            java.lang.String supplementalDataStorageLocationType;
            java.lang.Object s3Location;

            /**
             * Sets the value of {@link SupplementalDataStorageLocationProperty#getSupplementalDataStorageLocationType}
             * @param supplementalDataStorageLocationType Supplemental data storage location type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supplementalDataStorageLocationType(java.lang.String supplementalDataStorageLocationType) {
                this.supplementalDataStorageLocationType = supplementalDataStorageLocationType;
                return this;
            }

            /**
             * Sets the value of {@link SupplementalDataStorageLocationProperty#getS3Location}
             * @param s3Location Contains information about the Amazon S3 location for the extracted images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Sets the value of {@link SupplementalDataStorageLocationProperty#getS3Location}
             * @param s3Location Contains information about the Amazon S3 location for the extracted images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SupplementalDataStorageLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SupplementalDataStorageLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SupplementalDataStorageLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SupplementalDataStorageLocationProperty {
            private final java.lang.String supplementalDataStorageLocationType;
            private final java.lang.Object s3Location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.supplementalDataStorageLocationType = software.amazon.jsii.Kernel.get(this, "supplementalDataStorageLocationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.supplementalDataStorageLocationType = java.util.Objects.requireNonNull(builder.supplementalDataStorageLocationType, "supplementalDataStorageLocationType is required");
                this.s3Location = builder.s3Location;
            }

            @Override
            public final java.lang.String getSupplementalDataStorageLocationType() {
                return this.supplementalDataStorageLocationType;
            }

            @Override
            public final java.lang.Object getS3Location() {
                return this.s3Location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("supplementalDataStorageLocationType", om.valueToTree(this.getSupplementalDataStorageLocationType()));
                if (this.getS3Location() != null) {
                    data.set("s3Location", om.valueToTree(this.getS3Location()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SupplementalDataStorageLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SupplementalDataStorageLocationProperty.Jsii$Proxy that = (SupplementalDataStorageLocationProperty.Jsii$Proxy) o;

                if (!supplementalDataStorageLocationType.equals(that.supplementalDataStorageLocationType)) return false;
                return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
            }

            @Override
            public final int hashCode() {
                int result = this.supplementalDataStorageLocationType.hashCode();
                result = 31 * result + (this.s3Location != null ? this.s3Location.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the model used to create vector embeddings for the knowledge base.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VectorKnowledgeBaseConfigurationProperty vectorKnowledgeBaseConfigurationProperty = VectorKnowledgeBaseConfigurationProperty.builder()
     *         .embeddingModelArn("embeddingModelArn")
     *         // the properties below are optional
     *         .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
     *                 .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
     *                         .dimensions(123)
     *                         .embeddingDataType("embeddingDataType")
     *                         .build())
     *                 .build())
     *         .supplementalDataStorageConfiguration(SupplementalDataStorageConfigurationProperty.builder()
     *                 .supplementalDataStorageLocations(List.of(SupplementalDataStorageLocationProperty.builder()
     *                         .supplementalDataStorageLocationType("supplementalDataStorageLocationType")
     *                         // the properties below are optional
     *                         .s3Location(S3LocationProperty.builder()
     *                                 .uri("uri")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorKnowledgeBaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorKnowledgeBaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEmbeddingModelArn();

        /**
         * The embeddings model configuration details for the vector model used in Knowledge Base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddingModelConfiguration() {
            return null;
        }

        /**
         * If you include multimodal data from your data source, use this object to specify configurations for the storage location of the images extracted from your documents.
         * <p>
         * These images can be retrieved and returned to the end user. They can also be used in generation when using <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html">RetrieveAndGenerate</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-supplementaldatastorageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-supplementaldatastorageconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSupplementalDataStorageConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorKnowledgeBaseConfigurationProperty> {
            java.lang.String embeddingModelArn;
            java.lang.Object embeddingModelConfiguration;
            java.lang.Object supplementalDataStorageConfiguration;

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getEmbeddingModelArn}
             * @param embeddingModelArn The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingModelArn(java.lang.String embeddingModelArn) {
                this.embeddingModelArn = embeddingModelArn;
                return this;
            }

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getEmbeddingModelConfiguration}
             * @param embeddingModelConfiguration The embeddings model configuration details for the vector model used in Knowledge Base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingModelConfiguration(software.amazon.awscdk.IResolvable embeddingModelConfiguration) {
                this.embeddingModelConfiguration = embeddingModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getEmbeddingModelConfiguration}
             * @param embeddingModelConfiguration The embeddings model configuration details for the vector model used in Knowledge Base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingModelConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty embeddingModelConfiguration) {
                this.embeddingModelConfiguration = embeddingModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getSupplementalDataStorageConfiguration}
             * @param supplementalDataStorageConfiguration If you include multimodal data from your data source, use this object to specify configurations for the storage location of the images extracted from your documents.
             *                                             These images can be retrieved and returned to the end user. They can also be used in generation when using <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html">RetrieveAndGenerate</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supplementalDataStorageConfiguration(software.amazon.awscdk.IResolvable supplementalDataStorageConfiguration) {
                this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getSupplementalDataStorageConfiguration}
             * @param supplementalDataStorageConfiguration If you include multimodal data from your data source, use this object to specify configurations for the storage location of the images extracted from your documents.
             *                                             These images can be retrieved and returned to the end user. They can also be used in generation when using <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html">RetrieveAndGenerate</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supplementalDataStorageConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.SupplementalDataStorageConfigurationProperty supplementalDataStorageConfiguration) {
                this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorKnowledgeBaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorKnowledgeBaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorKnowledgeBaseConfigurationProperty {
            private final java.lang.String embeddingModelArn;
            private final java.lang.Object embeddingModelConfiguration;
            private final java.lang.Object supplementalDataStorageConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.embeddingModelArn = software.amazon.jsii.Kernel.get(this, "embeddingModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.embeddingModelConfiguration = software.amazon.jsii.Kernel.get(this, "embeddingModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supplementalDataStorageConfiguration = software.amazon.jsii.Kernel.get(this, "supplementalDataStorageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.embeddingModelArn = java.util.Objects.requireNonNull(builder.embeddingModelArn, "embeddingModelArn is required");
                this.embeddingModelConfiguration = builder.embeddingModelConfiguration;
                this.supplementalDataStorageConfiguration = builder.supplementalDataStorageConfiguration;
            }

            @Override
            public final java.lang.String getEmbeddingModelArn() {
                return this.embeddingModelArn;
            }

            @Override
            public final java.lang.Object getEmbeddingModelConfiguration() {
                return this.embeddingModelConfiguration;
            }

            @Override
            public final java.lang.Object getSupplementalDataStorageConfiguration() {
                return this.supplementalDataStorageConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("embeddingModelArn", om.valueToTree(this.getEmbeddingModelArn()));
                if (this.getEmbeddingModelConfiguration() != null) {
                    data.set("embeddingModelConfiguration", om.valueToTree(this.getEmbeddingModelConfiguration()));
                }
                if (this.getSupplementalDataStorageConfiguration() != null) {
                    data.set("supplementalDataStorageConfiguration", om.valueToTree(this.getSupplementalDataStorageConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorKnowledgeBaseConfigurationProperty.Jsii$Proxy that = (VectorKnowledgeBaseConfigurationProperty.Jsii$Proxy) o;

                if (!embeddingModelArn.equals(that.embeddingModelArn)) return false;
                if (this.embeddingModelConfiguration != null ? !this.embeddingModelConfiguration.equals(that.embeddingModelConfiguration) : that.embeddingModelConfiguration != null) return false;
                return this.supplementalDataStorageConfiguration != null ? this.supplementalDataStorageConfiguration.equals(that.supplementalDataStorageConfiguration) : that.supplementalDataStorageConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.embeddingModelArn.hashCode();
                result = 31 * result + (this.embeddingModelConfiguration != null ? this.embeddingModelConfiguration.hashCode() : 0);
                result = 31 * result + (this.supplementalDataStorageConfiguration != null ? this.supplementalDataStorageConfiguration.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnKnowledgeBase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnKnowledgeBase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps.Builder();
        }

        /**
         * Contains details about the embeddings configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration</a>
         * @param knowledgeBaseConfiguration Contains details about the embeddings configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseConfiguration(final software.amazon.awscdk.IResolvable knowledgeBaseConfiguration) {
            this.props.knowledgeBaseConfiguration(knowledgeBaseConfiguration);
            return this;
        }
        /**
         * Contains details about the embeddings configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration</a>
         * @param knowledgeBaseConfiguration Contains details about the embeddings configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseConfiguration(final software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty knowledgeBaseConfiguration) {
            this.props.knowledgeBaseConfiguration(knowledgeBaseConfiguration);
            return this;
        }

        /**
         * The name of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-name</a>
         * @param name The name of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The description of the knowledge base associated with the inline agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-description</a>
         * @param description The description of the knowledge base associated with the inline agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Contains details about the storage configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration</a>
         * @param storageConfiguration Contains details about the storage configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfiguration(final software.amazon.awscdk.IResolvable storageConfiguration) {
            this.props.storageConfiguration(storageConfiguration);
            return this;
        }
        /**
         * Contains details about the storage configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration</a>
         * @param storageConfiguration Contains details about the storage configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfiguration(final software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.StorageConfigurationProperty storageConfiguration) {
            this.props.storageConfiguration(storageConfiguration);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-tags</a>
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnKnowledgeBase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnKnowledgeBase build() {
            return new software.amazon.awscdk.services.bedrock.CfnKnowledgeBase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
