package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnKnowledgeBase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnKnowledgeBaseProps cfnKnowledgeBaseProps = CfnKnowledgeBaseProps.builder()
 *         .knowledgeBaseConfiguration(KnowledgeBaseConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .kendraKnowledgeBaseConfiguration(KendraKnowledgeBaseConfigurationProperty.builder()
 *                         .kendraIndexArn("kendraIndexArn")
 *                         .build())
 *                 .sqlKnowledgeBaseConfiguration(SqlKnowledgeBaseConfigurationProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .redshiftConfiguration(RedshiftConfigurationProperty.builder()
 *                                 .queryEngineConfiguration(RedshiftQueryEngineConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .provisionedConfiguration(RedshiftProvisionedConfigurationProperty.builder()
 *                                                 .authConfiguration(RedshiftProvisionedAuthConfigurationProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .databaseUser("databaseUser")
 *                                                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
 *                                                         .build())
 *                                                 .clusterIdentifier("clusterIdentifier")
 *                                                 .build())
 *                                         .serverlessConfiguration(RedshiftServerlessConfigurationProperty.builder()
 *                                                 .authConfiguration(RedshiftServerlessAuthConfigurationProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .usernamePasswordSecretArn("usernamePasswordSecretArn")
 *                                                         .build())
 *                                                 .workgroupArn("workgroupArn")
 *                                                 .build())
 *                                         .build())
 *                                 .storageConfigurations(List.of(RedshiftQueryEngineStorageConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfigurationProperty.builder()
 *                                                 .tableNames(List.of("tableNames"))
 *                                                 .build())
 *                                         .redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfigurationProperty.builder()
 *                                                 .databaseName("databaseName")
 *                                                 .build())
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .queryGenerationConfiguration(QueryGenerationConfigurationProperty.builder()
 *                                         .executionTimeoutSeconds(123)
 *                                         .generationContext(QueryGenerationContextProperty.builder()
 *                                                 .curatedQueries(List.of(CuratedQueryProperty.builder()
 *                                                         .naturalLanguage("naturalLanguage")
 *                                                         .sql("sql")
 *                                                         .build()))
 *                                                 .tables(List.of(QueryGenerationTableProperty.builder()
 *                                                         .name("name")
 *                                                         // the properties below are optional
 *                                                         .columns(List.of(QueryGenerationColumnProperty.builder()
 *                                                                 .description("description")
 *                                                                 .inclusion("inclusion")
 *                                                                 .name("name")
 *                                                                 .build()))
 *                                                         .description("description")
 *                                                         .inclusion("inclusion")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfigurationProperty.builder()
 *                         .embeddingModelArn("embeddingModelArn")
 *                         // the properties below are optional
 *                         .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
 *                                 .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
 *                                         .dimensions(123)
 *                                         .embeddingDataType("embeddingDataType")
 *                                         .build())
 *                                 .build())
 *                         .supplementalDataStorageConfiguration(SupplementalDataStorageConfigurationProperty.builder()
 *                                 .supplementalDataStorageLocations(List.of(SupplementalDataStorageLocationProperty.builder()
 *                                         .supplementalDataStorageLocationType("supplementalDataStorageLocationType")
 *                                         // the properties below are optional
 *                                         .s3Location(S3LocationProperty.builder()
 *                                                 .uri("uri")
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .storageConfiguration(StorageConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .mongoDbAtlasConfiguration(MongoDbAtlasConfigurationProperty.builder()
 *                         .collectionName("collectionName")
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .databaseName("databaseName")
 *                         .endpoint("endpoint")
 *                         .fieldMapping(MongoDbAtlasFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         // the properties below are optional
 *                         .endpointServiceName("endpointServiceName")
 *                         .textIndexName("textIndexName")
 *                         .build())
 *                 .neptuneAnalyticsConfiguration(NeptuneAnalyticsConfigurationProperty.builder()
 *                         .fieldMapping(NeptuneAnalyticsFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .build())
 *                         .graphArn("graphArn")
 *                         .build())
 *                 .opensearchManagedClusterConfiguration(OpenSearchManagedClusterConfigurationProperty.builder()
 *                         .domainArn("domainArn")
 *                         .domainEndpoint("domainEndpoint")
 *                         .fieldMapping(OpenSearchManagedClusterFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         .build())
 *                 .opensearchServerlessConfiguration(OpenSearchServerlessConfigurationProperty.builder()
 *                         .collectionArn("collectionArn")
 *                         .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         .build())
 *                 .pineconeConfiguration(PineconeConfigurationProperty.builder()
 *                         .connectionString("connectionString")
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .fieldMapping(PineconeFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .build())
 *                         // the properties below are optional
 *                         .namespace("namespace")
 *                         .build())
 *                 .rdsConfiguration(RdsConfigurationProperty.builder()
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .databaseName("databaseName")
 *                         .fieldMapping(RdsFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .primaryKeyField("primaryKeyField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 // the properties below are optional
 *                                 .customMetadataField("customMetadataField")
 *                                 .build())
 *                         .resourceArn("resourceArn")
 *                         .tableName("tableName")
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.232Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBaseProps")
@software.amazon.jsii.Jsii.Proxy(CfnKnowledgeBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKnowledgeBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKnowledgeBaseConfiguration();

    /**
     * The name of the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The description of the knowledge base associated with the inline agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageConfiguration() {
        return null;
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnKnowledgeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKnowledgeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKnowledgeBaseProps> {
        java.lang.Object knowledgeBaseConfiguration;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.String description;
        java.lang.Object storageConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getKnowledgeBaseConfiguration}
         * @param knowledgeBaseConfiguration Contains details about the embeddings configuration of the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseConfiguration(software.amazon.awscdk.IResolvable knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getKnowledgeBaseConfiguration}
         * @param knowledgeBaseConfiguration Contains details about the embeddings configuration of the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getName}
         * @param name The name of the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getDescription}
         * @param description The description of the knowledge base associated with the inline agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getStorageConfiguration}
         * @param storageConfiguration Contains details about the storage configuration of the knowledge base.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfiguration(software.amazon.awscdk.IResolvable storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getStorageConfiguration}
         * @param storageConfiguration Contains details about the storage configuration of the knowledge base.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.StorageConfigurationProperty storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getTags}
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         *             <ul>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKnowledgeBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKnowledgeBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKnowledgeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKnowledgeBaseProps {
        private final java.lang.Object knowledgeBaseConfiguration;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.String description;
        private final java.lang.Object storageConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.knowledgeBaseConfiguration = software.amazon.jsii.Kernel.get(this, "knowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageConfiguration = software.amazon.jsii.Kernel.get(this, "storageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.knowledgeBaseConfiguration = java.util.Objects.requireNonNull(builder.knowledgeBaseConfiguration, "knowledgeBaseConfiguration is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.description = builder.description;
            this.storageConfiguration = builder.storageConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getKnowledgeBaseConfiguration() {
            return this.knowledgeBaseConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getStorageConfiguration() {
            return this.storageConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("knowledgeBaseConfiguration", om.valueToTree(this.getKnowledgeBaseConfiguration()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getStorageConfiguration() != null) {
                data.set("storageConfiguration", om.valueToTree(this.getStorageConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKnowledgeBaseProps.Jsii$Proxy that = (CfnKnowledgeBaseProps.Jsii$Proxy) o;

            if (!knowledgeBaseConfiguration.equals(that.knowledgeBaseConfiguration)) return false;
            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.storageConfiguration != null ? !this.storageConfiguration.equals(that.storageConfiguration) : that.storageConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.knowledgeBaseConfiguration.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.storageConfiguration != null ? this.storageConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
