package software.amazon.awscdk.services.cassandra;

/**
 * Properties for defining a <code>CfnType</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cassandra.*;
 * CfnTypeProps cfnTypeProps = CfnTypeProps.builder()
 *         .fields(List.of(FieldProperty.builder()
 *                 .fieldName("fieldName")
 *                 .fieldType("fieldType")
 *                 .build()))
 *         .keyspaceName("keyspaceName")
 *         .typeName("typeName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.340Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTypeProps")
@software.amazon.jsii.Jsii.Proxy(CfnTypeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTypeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of fields that define this type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html#cfn-cassandra-type-fields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html#cfn-cassandra-type-fields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFields();

    /**
     * The name of the keyspace to create the type in.
     * <p>
     * The keyspace must already exist.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html#cfn-cassandra-type-keyspacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html#cfn-cassandra-type-keyspacename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyspaceName();

    /**
     * The name of the user-defined type.
     * <p>
     * UDT names must contain 48 characters or less, must begin with an alphabetic character, and can only contain alpha-numeric characters and underscores. Amazon Keyspaces converts upper case characters automatically into lower case characters. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/keyspaces-create-udt.html">Create a user-defined type (UDT) in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html#cfn-cassandra-type-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-type.html#cfn-cassandra-type-typename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

    /**
     * @return a {@link Builder} of {@link CfnTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTypeProps> {
        java.lang.Object fields;
        java.lang.String keyspaceName;
        java.lang.String typeName;

        /**
         * Sets the value of {@link CfnTypeProps#getFields}
         * @param fields A list of fields that define this type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(software.amazon.awscdk.IResolvable fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnTypeProps#getFields}
         * @param fields A list of fields that define this type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.List<? extends java.lang.Object> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnTypeProps#getKeyspaceName}
         * @param keyspaceName The name of the keyspace to create the type in. This parameter is required.
         *                     The keyspace must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyspaceName(java.lang.String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTypeProps#getTypeName}
         * @param typeName The name of the user-defined type. This parameter is required.
         *                 UDT names must contain 48 characters or less, must begin with an alphabetic character, and can only contain alpha-numeric characters and underscores. Amazon Keyspaces converts upper case characters automatically into lower case characters. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/keyspaces-create-udt.html">Create a user-defined type (UDT) in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTypeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTypeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTypeProps {
        private final java.lang.Object fields;
        private final java.lang.String keyspaceName;
        private final java.lang.String typeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keyspaceName = software.amazon.jsii.Kernel.get(this, "keyspaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fields = java.util.Objects.requireNonNull(builder.fields, "fields is required");
            this.keyspaceName = java.util.Objects.requireNonNull(builder.keyspaceName, "keyspaceName is required");
            this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
        }

        @Override
        public final java.lang.Object getFields() {
            return this.fields;
        }

        @Override
        public final java.lang.String getKeyspaceName() {
            return this.keyspaceName;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fields", om.valueToTree(this.getFields()));
            data.set("keyspaceName", om.valueToTree(this.getKeyspaceName()));
            data.set("typeName", om.valueToTree(this.getTypeName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTypeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTypeProps.Jsii$Proxy that = (CfnTypeProps.Jsii$Proxy) o;

            if (!fields.equals(that.fields)) return false;
            if (!keyspaceName.equals(that.keyspaceName)) return false;
            return this.typeName.equals(that.typeName);
        }

        @Override
        public final int hashCode() {
            int result = this.fields.hashCode();
            result = 31 * result + (this.keyspaceName.hashCode());
            result = 31 * result + (this.typeName.hashCode());
            return result;
        }
    }
}
