package software.amazon.awscdk.services.cleanrooms;

/**
 * Creates a configured table association.
 * <p>
 * A configured table association links a configured table with a collaboration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnConfiguredTableAssociation cfnConfiguredTableAssociation = CfnConfiguredTableAssociation.Builder.create(this, "MyCfnConfiguredTableAssociation")
 *         .configuredTableIdentifier("configuredTableIdentifier")
 *         .membershipIdentifier("membershipIdentifier")
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .configuredTableAssociationAnalysisRules(List.of(ConfiguredTableAssociationAnalysisRuleProperty.builder()
 *                 .policy(ConfiguredTableAssociationAnalysisRulePolicyProperty.builder()
 *                         .v1(ConfiguredTableAssociationAnalysisRulePolicyV1Property.builder()
 *                                 .aggregation(ConfiguredTableAssociationAnalysisRuleAggregationProperty.builder()
 *                                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
 *                                         .allowedResultReceivers(List.of("allowedResultReceivers"))
 *                                         .build())
 *                                 .custom(ConfiguredTableAssociationAnalysisRuleCustomProperty.builder()
 *                                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
 *                                         .allowedResultReceivers(List.of("allowedResultReceivers"))
 *                                         .build())
 *                                 .list(ConfiguredTableAssociationAnalysisRuleListProperty.builder()
 *                                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
 *                                         .allowedResultReceivers(List.of("allowedResultReceivers"))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation")
public class CfnConfiguredTableAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnConfiguredTableAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfiguredTableAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfiguredTableAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the specified configured table association.
     * <p>
     * Example: <code>arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE33333</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique identifier of the specified configured table association.
     * <p>
     * Example: <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE33333</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfiguredTableAssociationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrConfiguredTableAssociationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A unique identifier for the configured table to be associated to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfiguredTableIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "configuredTableIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the configured table to be associated to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguredTableIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configuredTableIdentifier", java.util.Objects.requireNonNull(value, "configuredTableIdentifier is required"));
    }

    /**
     * The unique ID for the membership this configured table association belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID for the membership this configured table association belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMembershipIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "membershipIdentifier", java.util.Objects.requireNonNull(value, "membershipIdentifier is required"));
    }

    /**
     * The name of the configured table association, in lowercase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configured table association, in lowercase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The service will assume this role to access catalog metadata and query the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service will assume this role to access catalog metadata and query the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * An analysis rule for a configured table association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguredTableAssociationAnalysisRules() {
        return software.amazon.jsii.Kernel.get(this, "configuredTableAssociationAnalysisRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An analysis rule for a configured table association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguredTableAssociationAnalysisRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuredTableAssociationAnalysisRules", value);
    }

    /**
     * An analysis rule for a configured table association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguredTableAssociationAnalysisRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configuredTableAssociationAnalysisRules", value);
    }

    /**
     * A description of the configured table association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the configured table association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The configured table association analysis rule applied to a configured table with the aggregation analysis rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAssociationAnalysisRuleAggregationProperty configuredTableAssociationAnalysisRuleAggregationProperty = ConfiguredTableAssociationAnalysisRuleAggregationProperty.builder()
     *         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *         .allowedResultReceivers(List.of("allowedResultReceivers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleAggregationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationAnalysisRuleAggregationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAssociationAnalysisRuleAggregationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
         * <p>
         * The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule ( <code>AnalysisRuleList</code> ) and the custom analysis rule ( <code>AnalysisRuleCustom</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation-allowedadditionalanalyses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation-allowedadditionalanalyses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAdditionalAnalyses() {
            return null;
        }

        /**
         * The list of collaboration members who are allowed to receive results of queries run with this configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation-allowedresultreceivers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisruleaggregation-allowedresultreceivers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedResultReceivers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAssociationAnalysisRuleAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAssociationAnalysisRuleAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationAnalysisRuleAggregationProperty> {
            java.util.List<java.lang.String> allowedAdditionalAnalyses;
            java.util.List<java.lang.String> allowedResultReceivers;

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleAggregationProperty#getAllowedAdditionalAnalyses}
             * @param allowedAdditionalAnalyses The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
             *                                  The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule ( <code>AnalysisRuleList</code> ) and the custom analysis rule ( <code>AnalysisRuleCustom</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAdditionalAnalyses(java.util.List<java.lang.String> allowedAdditionalAnalyses) {
                this.allowedAdditionalAnalyses = allowedAdditionalAnalyses;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleAggregationProperty#getAllowedResultReceivers}
             * @param allowedResultReceivers The list of collaboration members who are allowed to receive results of queries run with this configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedResultReceivers(java.util.List<java.lang.String> allowedResultReceivers) {
                this.allowedResultReceivers = allowedResultReceivers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAssociationAnalysisRuleAggregationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAssociationAnalysisRuleAggregationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAssociationAnalysisRuleAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationAnalysisRuleAggregationProperty {
            private final java.util.List<java.lang.String> allowedAdditionalAnalyses;
            private final java.util.List<java.lang.String> allowedResultReceivers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedAdditionalAnalyses = software.amazon.jsii.Kernel.get(this, "allowedAdditionalAnalyses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedResultReceivers = software.amazon.jsii.Kernel.get(this, "allowedResultReceivers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
                this.allowedResultReceivers = builder.allowedResultReceivers;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAdditionalAnalyses() {
                return this.allowedAdditionalAnalyses;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedResultReceivers() {
                return this.allowedResultReceivers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedAdditionalAnalyses() != null) {
                    data.set("allowedAdditionalAnalyses", om.valueToTree(this.getAllowedAdditionalAnalyses()));
                }
                if (this.getAllowedResultReceivers() != null) {
                    data.set("allowedResultReceivers", om.valueToTree(this.getAllowedResultReceivers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleAggregationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAssociationAnalysisRuleAggregationProperty.Jsii$Proxy that = (ConfiguredTableAssociationAnalysisRuleAggregationProperty.Jsii$Proxy) o;

                if (this.allowedAdditionalAnalyses != null ? !this.allowedAdditionalAnalyses.equals(that.allowedAdditionalAnalyses) : that.allowedAdditionalAnalyses != null) return false;
                return this.allowedResultReceivers != null ? this.allowedResultReceivers.equals(that.allowedResultReceivers) : that.allowedResultReceivers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedAdditionalAnalyses != null ? this.allowedAdditionalAnalyses.hashCode() : 0;
                result = 31 * result + (this.allowedResultReceivers != null ? this.allowedResultReceivers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configured table association analysis rule applied to a configured table with the custom analysis rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAssociationAnalysisRuleCustomProperty configuredTableAssociationAnalysisRuleCustomProperty = ConfiguredTableAssociationAnalysisRuleCustomProperty.builder()
     *         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *         .allowedResultReceivers(List.of("allowedResultReceivers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleCustomProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationAnalysisRuleCustomProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAssociationAnalysisRuleCustomProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom-allowedadditionalanalyses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom-allowedadditionalanalyses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAdditionalAnalyses() {
            return null;
        }

        /**
         * The list of collaboration members who are allowed to receive results of queries run with this configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom-allowedresultreceivers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulecustom-allowedresultreceivers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedResultReceivers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAssociationAnalysisRuleCustomProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAssociationAnalysisRuleCustomProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationAnalysisRuleCustomProperty> {
            java.util.List<java.lang.String> allowedAdditionalAnalyses;
            java.util.List<java.lang.String> allowedResultReceivers;

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleCustomProperty#getAllowedAdditionalAnalyses}
             * @param allowedAdditionalAnalyses The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAdditionalAnalyses(java.util.List<java.lang.String> allowedAdditionalAnalyses) {
                this.allowedAdditionalAnalyses = allowedAdditionalAnalyses;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleCustomProperty#getAllowedResultReceivers}
             * @param allowedResultReceivers The list of collaboration members who are allowed to receive results of queries run with this configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedResultReceivers(java.util.List<java.lang.String> allowedResultReceivers) {
                this.allowedResultReceivers = allowedResultReceivers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAssociationAnalysisRuleCustomProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAssociationAnalysisRuleCustomProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAssociationAnalysisRuleCustomProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationAnalysisRuleCustomProperty {
            private final java.util.List<java.lang.String> allowedAdditionalAnalyses;
            private final java.util.List<java.lang.String> allowedResultReceivers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedAdditionalAnalyses = software.amazon.jsii.Kernel.get(this, "allowedAdditionalAnalyses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedResultReceivers = software.amazon.jsii.Kernel.get(this, "allowedResultReceivers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
                this.allowedResultReceivers = builder.allowedResultReceivers;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAdditionalAnalyses() {
                return this.allowedAdditionalAnalyses;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedResultReceivers() {
                return this.allowedResultReceivers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedAdditionalAnalyses() != null) {
                    data.set("allowedAdditionalAnalyses", om.valueToTree(this.getAllowedAdditionalAnalyses()));
                }
                if (this.getAllowedResultReceivers() != null) {
                    data.set("allowedResultReceivers", om.valueToTree(this.getAllowedResultReceivers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleCustomProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAssociationAnalysisRuleCustomProperty.Jsii$Proxy that = (ConfiguredTableAssociationAnalysisRuleCustomProperty.Jsii$Proxy) o;

                if (this.allowedAdditionalAnalyses != null ? !this.allowedAdditionalAnalyses.equals(that.allowedAdditionalAnalyses) : that.allowedAdditionalAnalyses != null) return false;
                return this.allowedResultReceivers != null ? this.allowedResultReceivers.equals(that.allowedResultReceivers) : that.allowedResultReceivers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedAdditionalAnalyses != null ? this.allowedAdditionalAnalyses.hashCode() : 0;
                result = 31 * result + (this.allowedResultReceivers != null ? this.allowedResultReceivers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configured table association analysis rule applied to a configured table with the list analysis rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAssociationAnalysisRuleListProperty configuredTableAssociationAnalysisRuleListProperty = ConfiguredTableAssociationAnalysisRuleListProperty.builder()
     *         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *         .allowedResultReceivers(List.of("allowedResultReceivers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleListProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationAnalysisRuleListProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAssociationAnalysisRuleListProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist-allowedadditionalanalyses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist-allowedadditionalanalyses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAdditionalAnalyses() {
            return null;
        }

        /**
         * The list of collaboration members who are allowed to receive results of queries run with this configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist-allowedresultreceivers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulelist-allowedresultreceivers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedResultReceivers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAssociationAnalysisRuleListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAssociationAnalysisRuleListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationAnalysisRuleListProperty> {
            java.util.List<java.lang.String> allowedAdditionalAnalyses;
            java.util.List<java.lang.String> allowedResultReceivers;

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleListProperty#getAllowedAdditionalAnalyses}
             * @param allowedAdditionalAnalyses The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAdditionalAnalyses(java.util.List<java.lang.String> allowedAdditionalAnalyses) {
                this.allowedAdditionalAnalyses = allowedAdditionalAnalyses;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleListProperty#getAllowedResultReceivers}
             * @param allowedResultReceivers The list of collaboration members who are allowed to receive results of queries run with this configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedResultReceivers(java.util.List<java.lang.String> allowedResultReceivers) {
                this.allowedResultReceivers = allowedResultReceivers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAssociationAnalysisRuleListProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAssociationAnalysisRuleListProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAssociationAnalysisRuleListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationAnalysisRuleListProperty {
            private final java.util.List<java.lang.String> allowedAdditionalAnalyses;
            private final java.util.List<java.lang.String> allowedResultReceivers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedAdditionalAnalyses = software.amazon.jsii.Kernel.get(this, "allowedAdditionalAnalyses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedResultReceivers = software.amazon.jsii.Kernel.get(this, "allowedResultReceivers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
                this.allowedResultReceivers = builder.allowedResultReceivers;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAdditionalAnalyses() {
                return this.allowedAdditionalAnalyses;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedResultReceivers() {
                return this.allowedResultReceivers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedAdditionalAnalyses() != null) {
                    data.set("allowedAdditionalAnalyses", om.valueToTree(this.getAllowedAdditionalAnalyses()));
                }
                if (this.getAllowedResultReceivers() != null) {
                    data.set("allowedResultReceivers", om.valueToTree(this.getAllowedResultReceivers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleListProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAssociationAnalysisRuleListProperty.Jsii$Proxy that = (ConfiguredTableAssociationAnalysisRuleListProperty.Jsii$Proxy) o;

                if (this.allowedAdditionalAnalyses != null ? !this.allowedAdditionalAnalyses.equals(that.allowedAdditionalAnalyses) : that.allowedAdditionalAnalyses != null) return false;
                return this.allowedResultReceivers != null ? this.allowedResultReceivers.equals(that.allowedResultReceivers) : that.allowedResultReceivers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedAdditionalAnalyses != null ? this.allowedAdditionalAnalyses.hashCode() : 0;
                result = 31 * result + (this.allowedResultReceivers != null ? this.allowedResultReceivers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Controls on the query specifications that can be run on an associated configured table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAssociationAnalysisRulePolicyProperty configuredTableAssociationAnalysisRulePolicyProperty = ConfiguredTableAssociationAnalysisRulePolicyProperty.builder()
     *         .v1(ConfiguredTableAssociationAnalysisRulePolicyV1Property.builder()
     *                 .aggregation(ConfiguredTableAssociationAnalysisRuleAggregationProperty.builder()
     *                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                         .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                         .build())
     *                 .custom(ConfiguredTableAssociationAnalysisRuleCustomProperty.builder()
     *                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                         .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                         .build())
     *                 .list(ConfiguredTableAssociationAnalysisRuleListProperty.builder()
     *                         .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                         .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRulePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationAnalysisRulePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAssociationAnalysisRulePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy for the configured table association analysis rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicy.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicy-v1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicy.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicy-v1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getV1();

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAssociationAnalysisRulePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAssociationAnalysisRulePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationAnalysisRulePolicyProperty> {
            java.lang.Object v1;

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyProperty#getV1}
             * @param v1 The policy for the configured table association analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder v1(software.amazon.awscdk.IResolvable v1) {
                this.v1 = v1;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyProperty#getV1}
             * @param v1 The policy for the configured table association analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder v1(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRulePolicyV1Property v1) {
                this.v1 = v1;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAssociationAnalysisRulePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAssociationAnalysisRulePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAssociationAnalysisRulePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationAnalysisRulePolicyProperty {
            private final java.lang.Object v1;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.v1 = software.amazon.jsii.Kernel.get(this, "v1", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.v1 = java.util.Objects.requireNonNull(builder.v1, "v1 is required");
            }

            @Override
            public final java.lang.Object getV1() {
                return this.v1;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("v1", om.valueToTree(this.getV1()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRulePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAssociationAnalysisRulePolicyProperty.Jsii$Proxy that = (ConfiguredTableAssociationAnalysisRulePolicyProperty.Jsii$Proxy) o;

                return this.v1.equals(that.v1);
            }

            @Override
            public final int hashCode() {
                int result = this.v1.hashCode();
                return result;
            }
        }
    }
    /**
     * Controls on the query specifications that can be run on an associated configured table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAssociationAnalysisRulePolicyV1Property configuredTableAssociationAnalysisRulePolicyV1Property = ConfiguredTableAssociationAnalysisRulePolicyV1Property.builder()
     *         .aggregation(ConfiguredTableAssociationAnalysisRuleAggregationProperty.builder()
     *                 .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                 .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                 .build())
     *         .custom(ConfiguredTableAssociationAnalysisRuleCustomProperty.builder()
     *                 .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                 .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                 .build())
     *         .list(ConfiguredTableAssociationAnalysisRuleListProperty.builder()
     *                 .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                 .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRulePolicyV1Property")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationAnalysisRulePolicyV1Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAssociationAnalysisRulePolicyV1Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Analysis rule type that enables only aggregation queries on a configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregation() {
            return null;
        }

        /**
         * Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables.
         * <p>
         * It supports differential privacy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1-custom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1-custom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustom() {
            return null;
        }

        /**
         * Analysis rule type that enables only list queries on a configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1-list">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrulepolicyv1-list</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationAnalysisRulePolicyV1Property> {
            java.lang.Object aggregation;
            java.lang.Object custom;
            java.lang.Object list;

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property#getAggregation}
             * @param aggregation Analysis rule type that enables only aggregation queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(software.amazon.awscdk.IResolvable aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property#getAggregation}
             * @param aggregation Analysis rule type that enables only aggregation queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleAggregationProperty aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property#getCustom}
             * @param custom Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables.
             *               It supports differential privacy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.IResolvable custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property#getCustom}
             * @param custom Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables.
             *               It supports differential privacy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleCustomProperty custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property#getList}
             * @param list Analysis rule type that enables only list queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder list(software.amazon.awscdk.IResolvable list) {
                this.list = list;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property#getList}
             * @param list Analysis rule type that enables only list queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder list(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleListProperty list) {
                this.list = list;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAssociationAnalysisRulePolicyV1Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAssociationAnalysisRulePolicyV1Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationAnalysisRulePolicyV1Property {
            private final java.lang.Object aggregation;
            private final java.lang.Object custom;
            private final java.lang.Object list;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.custom = software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.list = software.amazon.jsii.Kernel.get(this, "list", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregation = builder.aggregation;
                this.custom = builder.custom;
                this.list = builder.list;
            }

            @Override
            public final java.lang.Object getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.lang.Object getCustom() {
                return this.custom;
            }

            @Override
            public final java.lang.Object getList() {
                return this.list;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getCustom() != null) {
                    data.set("custom", om.valueToTree(this.getCustom()));
                }
                if (this.getList() != null) {
                    data.set("list", om.valueToTree(this.getList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRulePolicyV1Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAssociationAnalysisRulePolicyV1Property.Jsii$Proxy that = (ConfiguredTableAssociationAnalysisRulePolicyV1Property.Jsii$Proxy) o;

                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
                return this.list != null ? this.list.equals(that.list) : that.list == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregation != null ? this.aggregation.hashCode() : 0;
                result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
                result = 31 * result + (this.list != null ? this.list.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An analysis rule for a configured table association.
     * <p>
     * This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <em>collaboration analysis rule</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAssociationAnalysisRuleProperty configuredTableAssociationAnalysisRuleProperty = ConfiguredTableAssociationAnalysisRuleProperty.builder()
     *         .policy(ConfiguredTableAssociationAnalysisRulePolicyProperty.builder()
     *                 .v1(ConfiguredTableAssociationAnalysisRulePolicyV1Property.builder()
     *                         .aggregation(ConfiguredTableAssociationAnalysisRuleAggregationProperty.builder()
     *                                 .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                                 .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                                 .build())
     *                         .custom(ConfiguredTableAssociationAnalysisRuleCustomProperty.builder()
     *                                 .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                                 .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                                 .build())
     *                         .list(ConfiguredTableAssociationAnalysisRuleListProperty.builder()
     *                                 .allowedAdditionalAnalyses(List.of("allowedAdditionalAnalyses"))
     *                                 .allowedResultReceivers(List.of("allowedResultReceivers"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationAnalysisRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAssociationAnalysisRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy of the configured table association analysis rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule-policy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPolicy();

        /**
         * The type of the configured table association analysis rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrule-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAssociationAnalysisRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAssociationAnalysisRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationAnalysisRuleProperty> {
            java.lang.Object policy;
            java.lang.String type;

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleProperty#getPolicy}
             * @param policy The policy of the configured table association analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policy(software.amazon.awscdk.IResolvable policy) {
                this.policy = policy;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleProperty#getPolicy}
             * @param policy The policy of the configured table association analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policy(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRulePolicyProperty policy) {
                this.policy = policy;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAssociationAnalysisRuleProperty#getType}
             * @param type The type of the configured table association analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAssociationAnalysisRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAssociationAnalysisRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAssociationAnalysisRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationAnalysisRuleProperty {
            private final java.lang.Object policy;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getPolicy() {
                return this.policy;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policy", om.valueToTree(this.getPolicy()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTableAssociation.ConfiguredTableAssociationAnalysisRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAssociationAnalysisRuleProperty.Jsii$Proxy that = (ConfiguredTableAssociationAnalysisRuleProperty.Jsii$Proxy) o;

                if (!policy.equals(that.policy)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.policy.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociationProps.Builder();
        }

        /**
         * A unique identifier for the configured table to be associated to.
         * <p>
         * Currently accepts a configured table ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableidentifier</a>
         * @param configuredTableIdentifier A unique identifier for the configured table to be associated to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableIdentifier(final java.lang.String configuredTableIdentifier) {
            this.props.configuredTableIdentifier(configuredTableIdentifier);
            return this;
        }

        /**
         * The unique ID for the membership this configured table association belongs to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-membershipidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-membershipidentifier</a>
         * @param membershipIdentifier The unique ID for the membership this configured table association belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(final java.lang.String membershipIdentifier) {
            this.props.membershipIdentifier(membershipIdentifier);
            return this;
        }

        /**
         * The name of the configured table association, in lowercase.
         * <p>
         * The table is identified by this name when running protected queries against the underlying data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-name</a>
         * @param name The name of the configured table association, in lowercase. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The service will assume this role to access catalog metadata and query the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-rolearn</a>
         * @param roleArn The service will assume this role to access catalog metadata and query the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * An analysis rule for a configured table association.
         * <p>
         * This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <em>collaboration analysis rule</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrules</a>
         * @param configuredTableAssociationAnalysisRules An analysis rule for a configured table association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableAssociationAnalysisRules(final software.amazon.awscdk.IResolvable configuredTableAssociationAnalysisRules) {
            this.props.configuredTableAssociationAnalysisRules(configuredTableAssociationAnalysisRules);
            return this;
        }
        /**
         * An analysis rule for a configured table association.
         * <p>
         * This analysis rule specifies how data from the table can be used within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <em>collaboration analysis rule</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableassociationanalysisrules</a>
         * @param configuredTableAssociationAnalysisRules An analysis rule for a configured table association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableAssociationAnalysisRules(final java.util.List<? extends java.lang.Object> configuredTableAssociationAnalysisRules) {
            this.props.configuredTableAssociationAnalysisRules(configuredTableAssociationAnalysisRules);
            return this;
        }

        /**
         * A description of the configured table association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-description</a>
         * @param description A description of the configured table association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An optional label that you can assign to a resource when you create it.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-tags</a>
         * @param tags An optional label that you can assign to a resource when you create it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation build() {
            return new software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
