package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creating a custom cache policy for a Distribution -- all parameters optional
 * S3Origin bucketOrigin;
 * CachePolicy myCachePolicy = CachePolicy.Builder.create(this, "myCachePolicy")
 *         .cachePolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .defaultTtl(Duration.days(2))
 *         .minTtl(Duration.minutes(1))
 *         .maxTtl(Duration.days(10))
 *         .cookieBehavior(CacheCookieBehavior.all())
 *         .headerBehavior(CacheHeaderBehavior.allowList("X-CustomHeader"))
 *         .queryStringBehavior(CacheQueryStringBehavior.denyList("username"))
 *         .enableAcceptEncodingGzip(true)
 *         .enableAcceptEncodingBrotli(true)
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .cachePolicy(myCachePolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.558Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CacheCookieBehavior")
public class CacheCookieBehavior extends software.amazon.jsii.JsiiObject {

    protected CacheCookieBehavior(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CacheCookieBehavior(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * All cookies in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class));
    }

    /**
     * Only the provided <code>cookies</code> are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param cookies This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior allowList(final @org.jetbrains.annotations.NotNull java.lang.String... cookies) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "allowList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class), java.util.Arrays.<Object>stream(cookies).toArray(Object[]::new));
    }

    /**
     * All cookies except the provided <code>cookies</code> are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param cookies This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior denyList(final @org.jetbrains.annotations.NotNull java.lang.String... cookies) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "denyList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class), java.util.Arrays.<Object>stream(cookies).toArray(Object[]::new));
    }

    /**
     * Cookies in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheCookieBehavior none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class));
    }

    /**
     * The behavior of cookies: allow all, none, an allow list, or a deny list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cookies to allow or deny, if the behavior is an allow or deny list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCookies() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
