package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a Lambda Function URL Origin Access Control resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * FunctionUrl fnUrl = fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.AWS_IAM)
 *         .build());
 * // Define a custom OAC
 * FunctionUrlOriginAccessControl oac = FunctionUrlOriginAccessControl.Builder.create(this, "MyOAC")
 *         .originAccessControlName("CustomLambdaOAC")
 *         .signing(Signing.SIGV4_ALWAYS)
 *         .build();
 * // Set up Lambda Function URL with OAC in CloudFront Distribution
 * // Set up Lambda Function URL with OAC in CloudFront Distribution
 * Distribution.Builder.create(this, "MyDistribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(FunctionUrlOrigin.withOriginAccessControl(fnUrl, FunctionUrlOriginWithOACProps.builder()
 *                         .originAccessControl(oac)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.705Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionUrlOriginAccessControlProps")
@software.amazon.jsii.Jsii.Proxy(FunctionUrlOriginAccessControlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionUrlOriginAccessControlProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudfront.OriginAccessControlBaseProps {

    /**
     * @return a {@link Builder} of {@link FunctionUrlOriginAccessControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionUrlOriginAccessControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionUrlOriginAccessControlProps> {
        java.lang.String description;
        java.lang.String originAccessControlName;
        software.amazon.awscdk.services.cloudfront.Signing signing;

        /**
         * Sets the value of {@link FunctionUrlOriginAccessControlProps#getDescription}
         * @param description A description of the origin access control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlOriginAccessControlProps#getOriginAccessControlName}
         * @param originAccessControlName A name to identify the origin access control, with a maximum length of 64 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlName(java.lang.String originAccessControlName) {
            this.originAccessControlName = originAccessControlName;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlOriginAccessControlProps#getSigning}
         * @param signing Specifies which requests CloudFront signs and the signing protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signing(software.amazon.awscdk.services.cloudfront.Signing signing) {
            this.signing = signing;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionUrlOriginAccessControlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionUrlOriginAccessControlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionUrlOriginAccessControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionUrlOriginAccessControlProps {
        private final java.lang.String description;
        private final java.lang.String originAccessControlName;
        private final software.amazon.awscdk.services.cloudfront.Signing signing;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originAccessControlName = software.amazon.jsii.Kernel.get(this, "originAccessControlName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signing = software.amazon.jsii.Kernel.get(this, "signing", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Signing.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.originAccessControlName = builder.originAccessControlName;
            this.signing = builder.signing;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getOriginAccessControlName() {
            return this.originAccessControlName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.Signing getSigning() {
            return this.signing;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getOriginAccessControlName() != null) {
                data.set("originAccessControlName", om.valueToTree(this.getOriginAccessControlName()));
            }
            if (this.getSigning() != null) {
                data.set("signing", om.valueToTree(this.getSigning()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.FunctionUrlOriginAccessControlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionUrlOriginAccessControlProps.Jsii$Proxy that = (FunctionUrlOriginAccessControlProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.originAccessControlName != null ? !this.originAccessControlName.equals(that.originAccessControlName) : that.originAccessControlName != null) return false;
            return this.signing != null ? this.signing.equals(that.signing) : that.signing == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.originAccessControlName != null ? this.originAccessControlName.hashCode() : 0);
            result = 31 * result + (this.signing != null ? this.signing.hashCode() : 0);
            return result;
        }
    }
}
