package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFront VPC Origin configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * VpcOriginEndpoint vpcOriginEndpoint;
 * VpcOrigin vpcOrigin = VpcOrigin.Builder.create(this, "MyVpcOrigin")
 *         .endpoint(vpcOriginEndpoint)
 *         // the properties below are optional
 *         .httpPort(123)
 *         .httpsPort(123)
 *         .originSslProtocols(List.of(OriginSslPolicy.SSL_V3))
 *         .protocolPolicy(OriginProtocolPolicy.HTTP_ONLY)
 *         .vpcOriginName("vpcOriginName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.750Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.VpcOrigin")
public class VpcOrigin extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IVpcOrigin, software.amazon.awscdk.ITaggableV2 {

    protected VpcOrigin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcOrigin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.VpcOrigin.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VpcOrigin(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.VpcOriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing VPC origin from its ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param vpcOriginArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IVpcOrigin fromVpcOriginArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String vpcOriginArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.VpcOrigin.class, "fromVpcOriginArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IVpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(vpcOriginArn, "vpcOriginArn is required") });
    }

    /**
     * Import an existing VPC origin from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IVpcOrigin fromVpcOriginAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.VpcOriginAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.VpcOrigin.class, "fromVpcOriginAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IVpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing VPC origin from its ID.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param vpcOriginId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IVpcOrigin fromVpcOriginId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String vpcOriginId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.VpcOrigin.class, "fromVpcOriginId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IVpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(vpcOriginId, "vpcOriginId is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * TagManager to set, remove and format tags.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The VPC origin ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcOriginArn() {
        return software.amazon.jsii.Kernel.get(this, "vpcOriginArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VPC origin ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcOriginId() {
        return software.amazon.jsii.Kernel.get(this, "vpcOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name of the CloudFront VPC origin endpoint configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.VpcOrigin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.VpcOrigin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.VpcOriginProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.VpcOriginProps.Builder();
        }

        /**
         * The HTTP port for the CloudFront VPC origin endpoint configuration.
         * <p>
         * Default: 80
         * <p>
         * @return {@code this}
         * @param httpPort The HTTP port for the CloudFront VPC origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPort(final java.lang.Number httpPort) {
            this.props.httpPort(httpPort);
            return this;
        }

        /**
         * The HTTPS port of the CloudFront VPC origin endpoint configuration.
         * <p>
         * Default: 443
         * <p>
         * @return {@code this}
         * @param httpsPort The HTTPS port of the CloudFront VPC origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsPort(final java.lang.Number httpsPort) {
            this.props.httpsPort(httpsPort);
            return this;
        }

        /**
         * A list that contains allowed SSL/TLS protocols for this distribution.
         * <p>
         * Default: - TLSv1.2
         * <p>
         * @return {@code this}
         * @param originSslProtocols A list that contains allowed SSL/TLS protocols for this distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originSslProtocols(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.props.originSslProtocols(originSslProtocols);
            return this;
        }

        /**
         * The origin protocol policy for the CloudFront VPC origin endpoint configuration.
         * <p>
         * Default: OriginProtocolPolicy.MATCH_VIEWER
         * <p>
         * @return {@code this}
         * @param protocolPolicy The origin protocol policy for the CloudFront VPC origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolPolicy(final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.props.protocolPolicy(protocolPolicy);
            return this;
        }

        /**
         * The name of the CloudFront VPC origin endpoint configuration.
         * <p>
         * Default: - generated from the `id`
         * <p>
         * @return {@code this}
         * @param vpcOriginName The name of the CloudFront VPC origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOriginName(final java.lang.String vpcOriginName) {
            this.props.vpcOriginName(vpcOriginName);
            return this;
        }

        /**
         * The VPC origin endpoint.
         * <p>
         * @return {@code this}
         * @param endpoint The VPC origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.VpcOrigin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.VpcOrigin build() {
            return new software.amazon.awscdk.services.cloudfront.VpcOrigin(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
