package software.amazon.awscdk.services.cloudfront;

/**
 * The properties to import from the VPC origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * VpcOriginAttributes vpcOriginAttributes = VpcOriginAttributes.builder()
 *         .domainName("domainName")
 *         .vpcOriginArn("vpcOriginArn")
 *         .vpcOriginId("vpcOriginId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.751Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.VpcOriginAttributes")
@software.amazon.jsii.Jsii.Proxy(VpcOriginAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcOriginAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name of the CloudFront VPC origin endpoint configuration.
     * <p>
     * Default: - No domain name configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The ARN of the VPC origin.
     * <p>
     * At least one of vpcOriginArn and vpcOriginId must be provided.
     * <p>
     * Default: - derived from `vpcOriginId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcOriginArn() {
        return null;
    }

    /**
     * The ID of the VPC origin.
     * <p>
     * At least one of vpcOriginArn and vpcOriginId must be provided.
     * <p>
     * Default: - derived from `vpcOriginArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcOriginId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcOriginAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcOriginAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcOriginAttributes> {
        java.lang.String domainName;
        java.lang.String vpcOriginArn;
        java.lang.String vpcOriginId;

        /**
         * Sets the value of {@link VpcOriginAttributes#getDomainName}
         * @param domainName The domain name of the CloudFront VPC origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginAttributes#getVpcOriginArn}
         * @param vpcOriginArn The ARN of the VPC origin.
         *                     At least one of vpcOriginArn and vpcOriginId must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOriginArn(java.lang.String vpcOriginArn) {
            this.vpcOriginArn = vpcOriginArn;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginAttributes#getVpcOriginId}
         * @param vpcOriginId The ID of the VPC origin.
         *                    At least one of vpcOriginArn and vpcOriginId must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOriginId(java.lang.String vpcOriginId) {
            this.vpcOriginId = vpcOriginId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcOriginAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcOriginAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcOriginAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcOriginAttributes {
        private final java.lang.String domainName;
        private final java.lang.String vpcOriginArn;
        private final java.lang.String vpcOriginId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcOriginArn = software.amazon.jsii.Kernel.get(this, "vpcOriginArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcOriginId = software.amazon.jsii.Kernel.get(this, "vpcOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = builder.domainName;
            this.vpcOriginArn = builder.vpcOriginArn;
            this.vpcOriginId = builder.vpcOriginId;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getVpcOriginArn() {
            return this.vpcOriginArn;
        }

        @Override
        public final java.lang.String getVpcOriginId() {
            return this.vpcOriginId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getVpcOriginArn() != null) {
                data.set("vpcOriginArn", om.valueToTree(this.getVpcOriginArn()));
            }
            if (this.getVpcOriginId() != null) {
                data.set("vpcOriginId", om.valueToTree(this.getVpcOriginId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.VpcOriginAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcOriginAttributes.Jsii$Proxy that = (VpcOriginAttributes.Jsii$Proxy) o;

            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.vpcOriginArn != null ? !this.vpcOriginArn.equals(that.vpcOriginArn) : that.vpcOriginArn != null) return false;
            return this.vpcOriginId != null ? this.vpcOriginId.equals(that.vpcOriginId) : that.vpcOriginId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName != null ? this.domainName.hashCode() : 0;
            result = 31 * result + (this.vpcOriginArn != null ? this.vpcOriginArn.hashCode() : 0);
            result = 31 * result + (this.vpcOriginId != null ? this.vpcOriginId.hashCode() : 0);
            return result;
        }
    }
}
