package software.amazon.awscdk.services.cloudfront.origins;

/**
 * (deprecated) An Origin that is backed by an S3 bucket.
 * <p>
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling. Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding an existing Lambda&#64;Edge function created in a different stack
 * // to a CloudFront distribution.
 * Bucket s3Bucket;
 * IVersion functionVersion = Version.fromVersionArn(this, "Version", "arn:aws:lambda:us-east-1:123456789012:function:functionName:1");
 * Distribution.Builder.create(this, "distro")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(s3Bucket))
 *                 .edgeLambdas(List.of(EdgeLambda.builder()
 *                         .functionVersion(functionVersion)
 *                         .eventType(LambdaEdgeEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @deprecated Use <code>S3BucketOrigin</code> or <code>S3StaticWebsiteOrigin</code> instead.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.789Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
@Deprecated
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.S3Origin")
public class S3Origin extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudfront.IOrigin {

    protected S3Origin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Origin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public S3Origin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.S3OriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public S3Origin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * (deprecated) The method called when a given Origin is added (for the first time) to a Distribution.
     * <p>
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginBindConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginBindConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (deprecated) A fluent builder for {@link software.amazon.awscdk.services.cloudfront.origins.S3Origin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.origins.S3Origin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket) {
            return new Builder(bucket);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private software.amazon.awscdk.services.cloudfront.origins.S3OriginProps.Builder props;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
        }

        /**
         * The number of times that CloudFront attempts to connect to the origin;
         * <p>
         * valid values are 1, 2, or 3 attempts.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(final java.lang.Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * <p>
         * Valid values are 1-10 seconds, inclusive.
         * <p>
         * Default: Duration.seconds(10)
         * <p>
         * @return {@code this}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(final software.amazon.awscdk.Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        /**
         * A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(final java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        /**
         * The unique identifier of an origin access control for this origin.
         * <p>
         * Default: - no origin access control
         * <p>
         * @return {@code this}
         * @param originAccessControlId The unique identifier of an origin access control for this origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlId(final java.lang.String originAccessControlId) {
            this.props().originAccessControlId(originAccessControlId);
            return this;
        }

        /**
         * A unique identifier for the origin.
         * <p>
         * This value must be unique within the distribution.
         * <p>
         * Default: - an originid will be generated for you
         * <p>
         * @return {@code this}
         * @param originId A unique identifier for the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originId(final java.lang.String originId) {
            this.props().originId(originId);
            return this;
        }

        /**
         * Origin Shield is enabled by setting originShieldRegion to a valid region, after this to disable Origin Shield again you must set this flag to false.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param originShieldEnabled Origin Shield is enabled by setting originShieldRegion to a valid region, after this to disable Origin Shield again you must set this flag to false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldEnabled(final java.lang.Boolean originShieldEnabled) {
            this.props().originShieldEnabled(originShieldEnabled);
            return this;
        }

        /**
         * When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * <p>
         * Default: - origin shield not enabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html</a>
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldRegion(final java.lang.String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         * <p>
         * Must begin, but not end, with '/' (e.g., '/production/images').
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originPath(final java.lang.String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        /**
         * An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
         * <p>
         * Default: - An Origin Access Identity will be created.
         * <p>
         * @return {@code this}
         * @param originAccessIdentity An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessIdentity(final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity) {
            this.props().originAccessIdentity(originAccessIdentity);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.origins.S3Origin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public software.amazon.awscdk.services.cloudfront.origins.S3Origin build() {
            return new software.amazon.awscdk.services.cloudfront.origins.S3Origin(
                this.bucket,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.origins.S3OriginProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.origins.S3OriginProps.Builder();
            }
            return this.props;
        }
    }
}
