package software.amazon.awscdk.services.cloudtrail;

/**
 * Creates a custom dashboard or the Highlights dashboard.
 * <p>
 * <ul>
 * <li><em>Custom dashboards</em> - Custom dashboards allow you to query events in any event data store type. You can add up to 10 widgets to a custom dashboard. You can manually refresh a custom dashboard, or you can set a refresh schedule.</li>
 * <li><em>Highlights dashboard</em> - You can create the Highlights dashboard to see a summary of key user activities and API usage across all your event data stores. CloudTrail Lake manages the Highlights dashboard and refreshes the dashboard every 6 hours. To create the Highlights dashboard, you must set and enable a refresh schedule.</li>
 * </ul>
 * <p>
 * CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard">Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <em>AWS CloudTrail User Guide</em> .
 * <p>
 * To set a refresh schedule, CloudTrail must be granted permissions to run the <code>StartDashboardRefresh</code> operation to refresh the dashboard on your behalf. To provide permissions, run the <code>PutResourcePolicy</code> operation to attach a resource-based policy to the dashboard. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards">Resource-based policy example for a dashboard</a> in the <em>AWS CloudTrail User Guide</em> .
 * <p>
 * For more information about dashboards, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html">CloudTrail Lake dashboards</a> in the <em>AWS CloudTrail User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnDashboard cfnDashboard = CfnDashboard.Builder.create(this, "MyCfnDashboard")
 *         .name("name")
 *         .refreshSchedule(RefreshScheduleProperty.builder()
 *                 .frequency(FrequencyProperty.builder()
 *                         .unit("unit")
 *                         .value(123)
 *                         .build())
 *                 .status("status")
 *                 .timeOfDay("timeOfDay")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .widgets(List.of(WidgetProperty.builder()
 *                 .queryStatement("queryStatement")
 *                 // the properties below are optional
 *                 .queryParameters(List.of("queryParameters"))
 *                 .viewProperties(Map.of(
 *                         "viewPropertiesKey", "viewProperties"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.799Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnDashboard")
public class CfnDashboard extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDashboard(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDashboard(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudtrail.CfnDashboard.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDashboard(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.CfnDashboardProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDashboard(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp that shows when the dashboard was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDashboardArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDashboardArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrType() {
        return software.amazon.jsii.Kernel.get(this, "attrType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp that shows when the dashboard was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the dashboard.
     * <p>
     * The name must be unique to your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the dashboard.
     * <p>
     * The name must be unique to your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The schedule for a dashboard refresh.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRefreshSchedule() {
        return software.amazon.jsii.Kernel.get(this, "refreshSchedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schedule for a dashboard refresh.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "refreshSchedule", value);
    }

    /**
     * The schedule for a dashboard refresh.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.CfnDashboard.RefreshScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "refreshSchedule", value);
    }

    /**
     * A list of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Specifies whether termination protection is enabled for the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether termination protection is enabled for the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }

    /**
     * Specifies whether termination protection is enabled for the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }

    /**
     * An array of widgets for a custom dashboard.
     * <p>
     * A custom dashboard can have a maximum of ten widgets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWidgets() {
        return software.amazon.jsii.Kernel.get(this, "widgets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of widgets for a custom dashboard.
     * <p>
     * A custom dashboard can have a maximum of ten widgets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWidgets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "widgets", value);
    }

    /**
     * An array of widgets for a custom dashboard.
     * <p>
     * A custom dashboard can have a maximum of ten widgets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWidgets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnDashboard.WidgetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnDashboard.WidgetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "widgets", value);
    }
    /**
     * Specifies the frequency for a dashboard refresh schedule.
     * <p>
     * For a custom dashboard, you can schedule a refresh for every 1, 6, 12, or 24 hours, or every day.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * FrequencyProperty frequencyProperty = FrequencyProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-frequency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-frequency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnDashboard.FrequencyProperty")
    @software.amazon.jsii.Jsii.Proxy(FrequencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrequencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unit to use for the refresh.
         * <p>
         * For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code> .
         * <p>
         * For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-frequency.html#cfn-cloudtrail-dashboard-frequency-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-frequency.html#cfn-cloudtrail-dashboard-frequency-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * The value for the refresh schedule.
         * <p>
         * For custom dashboards, the following values are valid when the unit is <code>HOURS</code> : <code>1</code> , <code>6</code> , <code>12</code> , <code>24</code>
         * <p>
         * For custom dashboards, the only valid value when the unit is <code>DAYS</code> is <code>1</code> .
         * <p>
         * For the Highlights dashboard, the <code>Value</code> must be <code>6</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-frequency.html#cfn-cloudtrail-dashboard-frequency-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-frequency.html#cfn-cloudtrail-dashboard-frequency-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link FrequencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrequencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrequencyProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link FrequencyProperty#getUnit}
             * @param unit The unit to use for the refresh. This parameter is required.
             *             For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code> .
             *             <p>
             *             For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link FrequencyProperty#getValue}
             * @param value The value for the refresh schedule. This parameter is required.
             *              For custom dashboards, the following values are valid when the unit is <code>HOURS</code> : <code>1</code> , <code>6</code> , <code>12</code> , <code>24</code>
             *              <p>
             *              For custom dashboards, the only valid value when the unit is <code>DAYS</code> is <code>1</code> .
             *              <p>
             *              For the Highlights dashboard, the <code>Value</code> must be <code>6</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrequencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrequencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrequencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrequencyProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnDashboard.FrequencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrequencyProperty.Jsii$Proxy that = (FrequencyProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The schedule for a dashboard refresh.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * RefreshScheduleProperty refreshScheduleProperty = RefreshScheduleProperty.builder()
     *         .frequency(FrequencyProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .status("status")
     *         .timeOfDay("timeOfDay")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnDashboard.RefreshScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency at which you want the dashboard refreshed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html#cfn-cloudtrail-dashboard-refreshschedule-frequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html#cfn-cloudtrail-dashboard-refreshschedule-frequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFrequency() {
            return null;
        }

        /**
         * Specifies whether the refresh schedule is enabled.
         * <p>
         * Set the value to <code>ENABLED</code> to enable the refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html#cfn-cloudtrail-dashboard-refreshschedule-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html#cfn-cloudtrail-dashboard-refreshschedule-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The time of day in UTC to run the schedule;
         * <p>
         * for hourly only refer to minutes; default is 00:00.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html#cfn-cloudtrail-dashboard-refreshschedule-timeofday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-refreshschedule.html#cfn-cloudtrail-dashboard-refreshschedule-timeofday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeOfDay() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshScheduleProperty> {
            java.lang.Object frequency;
            java.lang.String status;
            java.lang.String timeOfDay;

            /**
             * Sets the value of {@link RefreshScheduleProperty#getFrequency}
             * @param frequency The frequency at which you want the dashboard refreshed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(software.amazon.awscdk.IResolvable frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleProperty#getFrequency}
             * @param frequency The frequency at which you want the dashboard refreshed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(software.amazon.awscdk.services.cloudtrail.CfnDashboard.FrequencyProperty frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleProperty#getStatus}
             * @param status Specifies whether the refresh schedule is enabled.
             *               Set the value to <code>ENABLED</code> to enable the refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleProperty#getTimeOfDay}
             * @param timeOfDay The time of day in UTC to run the schedule;.
             *                  for hourly only refer to minutes; default is 00:00.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeOfDay(java.lang.String timeOfDay) {
                this.timeOfDay = timeOfDay;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshScheduleProperty {
            private final java.lang.Object frequency;
            private final java.lang.String status;
            private final java.lang.String timeOfDay;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeOfDay = software.amazon.jsii.Kernel.get(this, "timeOfDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequency = builder.frequency;
                this.status = builder.status;
                this.timeOfDay = builder.timeOfDay;
            }

            @Override
            public final java.lang.Object getFrequency() {
                return this.frequency;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getTimeOfDay() {
                return this.timeOfDay;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFrequency() != null) {
                    data.set("frequency", om.valueToTree(this.getFrequency()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTimeOfDay() != null) {
                    data.set("timeOfDay", om.valueToTree(this.getTimeOfDay()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnDashboard.RefreshScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshScheduleProperty.Jsii$Proxy that = (RefreshScheduleProperty.Jsii$Proxy) o;

                if (this.frequency != null ? !this.frequency.equals(that.frequency) : that.frequency != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.timeOfDay != null ? this.timeOfDay.equals(that.timeOfDay) : that.timeOfDay == null;
            }

            @Override
            public final int hashCode() {
                int result = this.frequency != null ? this.frequency.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.timeOfDay != null ? this.timeOfDay.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a widget on a CloudTrail Lake dashboard.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * WidgetProperty widgetProperty = WidgetProperty.builder()
     *         .queryStatement("queryStatement")
     *         // the properties below are optional
     *         .queryParameters(List.of("queryParameters"))
     *         .viewProperties(Map.of(
     *                 "viewPropertiesKey", "viewProperties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnDashboard.WidgetProperty")
    @software.amazon.jsii.Jsii.Proxy(WidgetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WidgetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The query statement for the widget.
         * <p>
         * For custom dashboard widgets, you can query across multiple event data stores as long as all event data stores exist in your account.
         * <p>
         * <blockquote>
         * <p>
         * When a query uses <code>?</code> with <code>eventTime</code> , <code>?</code> must be surrounded by single quotes as follows: <code>'?'</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html#cfn-cloudtrail-dashboard-widget-querystatement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html#cfn-cloudtrail-dashboard-widget-querystatement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryStatement();

        /**
         * The optional query parameters.
         * <p>
         * The following query parameters are valid: <code>$StartTime$</code> , <code>$EndTime$</code> , and <code>$Period$</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html#cfn-cloudtrail-dashboard-widget-queryparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html#cfn-cloudtrail-dashboard-widget-queryparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryParameters() {
            return null;
        }

        /**
         * The view properties for the widget.
         * <p>
         * For more information about view properties, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html">View properties for widgets</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html#cfn-cloudtrail-dashboard-widget-viewproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-dashboard-widget.html#cfn-cloudtrail-dashboard-widget-viewproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getViewProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WidgetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WidgetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WidgetProperty> {
            java.lang.String queryStatement;
            java.util.List<java.lang.String> queryParameters;
            java.lang.Object viewProperties;

            /**
             * Sets the value of {@link WidgetProperty#getQueryStatement}
             * @param queryStatement The query statement for the widget. This parameter is required.
             *                       For custom dashboard widgets, you can query across multiple event data stores as long as all event data stores exist in your account.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       When a query uses <code>?</code> with <code>eventTime</code> , <code>?</code> must be surrounded by single quotes as follows: <code>'?'</code> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStatement(java.lang.String queryStatement) {
                this.queryStatement = queryStatement;
                return this;
            }

            /**
             * Sets the value of {@link WidgetProperty#getQueryParameters}
             * @param queryParameters The optional query parameters.
             *                        The following query parameters are valid: <code>$StartTime$</code> , <code>$EndTime$</code> , and <code>$Period$</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryParameters(java.util.List<java.lang.String> queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            /**
             * Sets the value of {@link WidgetProperty#getViewProperties}
             * @param viewProperties The view properties for the widget.
             *                       For more information about view properties, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html">View properties for widgets</a> in the <em>AWS CloudTrail User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewProperties(java.util.Map<java.lang.String, java.lang.String> viewProperties) {
                this.viewProperties = viewProperties;
                return this;
            }

            /**
             * Sets the value of {@link WidgetProperty#getViewProperties}
             * @param viewProperties The view properties for the widget.
             *                       For more information about view properties, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html">View properties for widgets</a> in the <em>AWS CloudTrail User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewProperties(software.amazon.awscdk.IResolvable viewProperties) {
                this.viewProperties = viewProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WidgetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WidgetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WidgetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WidgetProperty {
            private final java.lang.String queryStatement;
            private final java.util.List<java.lang.String> queryParameters;
            private final java.lang.Object viewProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryStatement = software.amazon.jsii.Kernel.get(this, "queryStatement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.viewProperties = software.amazon.jsii.Kernel.get(this, "viewProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryStatement = java.util.Objects.requireNonNull(builder.queryStatement, "queryStatement is required");
                this.queryParameters = builder.queryParameters;
                this.viewProperties = builder.viewProperties;
            }

            @Override
            public final java.lang.String getQueryStatement() {
                return this.queryStatement;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryParameters() {
                return this.queryParameters;
            }

            @Override
            public final java.lang.Object getViewProperties() {
                return this.viewProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryStatement", om.valueToTree(this.getQueryStatement()));
                if (this.getQueryParameters() != null) {
                    data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
                }
                if (this.getViewProperties() != null) {
                    data.set("viewProperties", om.valueToTree(this.getViewProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnDashboard.WidgetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WidgetProperty.Jsii$Proxy that = (WidgetProperty.Jsii$Proxy) o;

                if (!queryStatement.equals(that.queryStatement)) return false;
                if (this.queryParameters != null ? !this.queryParameters.equals(that.queryParameters) : that.queryParameters != null) return false;
                return this.viewProperties != null ? this.viewProperties.equals(that.viewProperties) : that.viewProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryStatement.hashCode();
                result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
                result = 31 * result + (this.viewProperties != null ? this.viewProperties.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.CfnDashboard}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.CfnDashboard> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudtrail.CfnDashboardProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the dashboard. The name must be unique to your account.
         * <p>
         * To create the Highlights dashboard, the name must be <code>AWSCloudTrail-Highlights</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-name</a>
         * @param name The name of the dashboard. The name must be unique to your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The schedule for a dashboard refresh.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-refreshschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-refreshschedule</a>
         * @param refreshSchedule The schedule for a dashboard refresh. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshSchedule(final software.amazon.awscdk.IResolvable refreshSchedule) {
            this.props().refreshSchedule(refreshSchedule);
            return this;
        }
        /**
         * The schedule for a dashboard refresh.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-refreshschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-refreshschedule</a>
         * @param refreshSchedule The schedule for a dashboard refresh. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshSchedule(final software.amazon.awscdk.services.cloudtrail.CfnDashboard.RefreshScheduleProperty refreshSchedule) {
            this.props().refreshSchedule(refreshSchedule);
            return this;
        }

        /**
         * A list of tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-tags</a>
         * @param tags A list of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies whether termination protection is enabled for the dashboard.
         * <p>
         * If termination protection is enabled, you cannot delete the dashboard until termination protection is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-terminationprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-terminationprotectionenabled</a>
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final java.lang.Boolean terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }
        /**
         * Specifies whether termination protection is enabled for the dashboard.
         * <p>
         * If termination protection is enabled, you cannot delete the dashboard until termination protection is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-terminationprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-terminationprotectionenabled</a>
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final software.amazon.awscdk.IResolvable terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }

        /**
         * An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets.
         * <p>
         * You do not need to specify widgets for the Highlights dashboard.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-widgets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-widgets</a>
         * @param widgets An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder widgets(final software.amazon.awscdk.IResolvable widgets) {
            this.props().widgets(widgets);
            return this;
        }
        /**
         * An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets.
         * <p>
         * You do not need to specify widgets for the Highlights dashboard.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-widgets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-widgets</a>
         * @param widgets An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder widgets(final java.util.List<? extends java.lang.Object> widgets) {
            this.props().widgets(widgets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.CfnDashboard}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.CfnDashboard build() {
            return new software.amazon.awscdk.services.cloudtrail.CfnDashboard(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudtrail.CfnDashboardProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudtrail.CfnDashboardProps.Builder();
            }
            return this.props;
        }
    }
}
