package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a GaugeWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Alarm errorAlarm;
 * Metric gaugeMetric;
 * dashboard.addWidgets(GaugeWidget.Builder.create()
 *         .metrics(List.of(gaugeMetric))
 *         .leftYAxis(YAxisProps.builder()
 *                 .min(0)
 *                 .max(1000)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.930Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.GaugeWidgetProps")
@software.amazon.jsii.Jsii.Proxy(GaugeWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GaugeWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {

    /**
     * Annotations for the left Y axis.
     * <p>
     * Default: - No annotations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> getAnnotations() {
        return null;
    }

    /**
     * The end of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * If you specify a value for end, you must also specify a value for start.
     * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the end date will be the current time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
        return null;
    }

    /**
     * Left Y axis.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
        return null;
    }

    /**
     * Position of the legend.
     * <p>
     * Default: - bottom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.LegendPosition getLegendPosition() {
        return null;
    }

    /**
     * Whether the graph should show live data.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLiveData() {
        return null;
    }

    /**
     * Metrics to display on left Y axis.
     * <p>
     * Default: - No metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics() {
        return null;
    }

    /**
     * The default period for all metrics in this widget.
     * <p>
     * The period is the length of time represented by one data point on the graph.
     * This default can be overridden within each metric definition.
     * <p>
     * Default: cdk.Duration.seconds(300)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
     * <p>
     * If false, values will be from the most recent period of your chosen time range;
     * if true, shows the value from the entire time range.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSetPeriodToTimeRange() {
        return null;
    }

    /**
     * The start of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * You can specify start without specifying end to specify a relative time range that ends with the current time.
     * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
     * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
     * You can also use start along with an end field, to specify an absolute time range.
     * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the start time will be the default time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
        return null;
    }

    /**
     * The default statistic to be displayed for each metric.
     * <p>
     * This default can be overridden within the definition of each individual metric
     * <p>
     * Default: - The statistic for each metric is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GaugeWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GaugeWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GaugeWidgetProps> {
        java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> annotations;
        java.lang.String end;
        software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis;
        software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition;
        java.lang.Boolean liveData;
        java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        software.amazon.awscdk.Duration period;
        java.lang.Boolean setPeriodToTimeRange;
        java.lang.String start;
        java.lang.String statistic;
        java.lang.Number height;
        java.lang.String region;
        java.lang.String title;
        java.lang.Number width;

        /**
         * Sets the value of {@link GaugeWidgetProps#getAnnotations}
         * @param annotations Annotations for the left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder annotations(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> annotations) {
            this.annotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation>)annotations;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getEnd}
         * @param end The end of the time range to use for each widget independently from those of the dashboard.
         *            If you specify a value for end, you must also specify a value for start.
         *            Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(java.lang.String end) {
            this.end = end;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getLeftYAxis}
         * @param leftYAxis Left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder leftYAxis(software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis) {
            this.leftYAxis = leftYAxis;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getLegendPosition}
         * @param legendPosition Position of the legend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder legendPosition(software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition) {
            this.legendPosition = legendPosition;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getLiveData}
         * @param liveData Whether the graph should show live data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveData(java.lang.Boolean liveData) {
            this.liveData = liveData;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getMetrics}
         * @param metrics Metrics to display on left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)metrics;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getPeriod}
         * @param period The default period for all metrics in this widget.
         *               The period is the length of time represented by one data point on the graph.
         *               This default can be overridden within each metric definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getSetPeriodToTimeRange}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
         *                             If false, values will be from the most recent period of your chosen time range;
         *                             if true, shows the value from the entire time range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(java.lang.Boolean setPeriodToTimeRange) {
            this.setPeriodToTimeRange = setPeriodToTimeRange;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getStart}
         * @param start The start of the time range to use for each widget independently from those of the dashboard.
         *              You can specify start without specifying end to specify a relative time range that ends with the current time.
         *              In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         *              minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         *              You can also use start along with an end field, to specify an absolute time range.
         *              When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(java.lang.String start) {
            this.start = start;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getStatistic}
         * @param statistic The default statistic to be displayed for each metric.
         *                  This default can be overridden within the definition of each individual metric
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getRegion}
         * @param region The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getTitle}
         * @param title Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link GaugeWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GaugeWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GaugeWidgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GaugeWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GaugeWidgetProps {
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> annotations;
        private final java.lang.String end;
        private final software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis;
        private final software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition;
        private final java.lang.Boolean liveData;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.Boolean setPeriodToTimeRange;
        private final java.lang.String start;
        private final java.lang.String statistic;
        private final java.lang.Number height;
        private final java.lang.String region;
        private final java.lang.String title;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.annotations = software.amazon.jsii.Kernel.get(this, "annotations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation.class)));
            this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.leftYAxis = software.amazon.jsii.Kernel.get(this, "leftYAxis", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.YAxisProps.class));
            this.legendPosition = software.amazon.jsii.Kernel.get(this, "legendPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.LegendPosition.class));
            this.liveData = software.amazon.jsii.Kernel.get(this, "liveData", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.setPeriodToTimeRange = software.amazon.jsii.Kernel.get(this, "setPeriodToTimeRange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.annotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation>)builder.annotations;
            this.end = builder.end;
            this.leftYAxis = builder.leftYAxis;
            this.legendPosition = builder.legendPosition;
            this.liveData = builder.liveData;
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)builder.metrics;
            this.period = builder.period;
            this.setPeriodToTimeRange = builder.setPeriodToTimeRange;
            this.start = builder.start;
            this.statistic = builder.statistic;
            this.height = builder.height;
            this.region = builder.region;
            this.title = builder.title;
            this.width = builder.width;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public final java.lang.String getEnd() {
            return this.end;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
            return this.leftYAxis;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.LegendPosition getLegendPosition() {
            return this.legendPosition;
        }

        @Override
        public final java.lang.Boolean getLiveData() {
            return this.liveData;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics() {
            return this.metrics;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.Boolean getSetPeriodToTimeRange() {
            return this.setPeriodToTimeRange;
        }

        @Override
        public final java.lang.String getStart() {
            return this.start;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAnnotations() != null) {
                data.set("annotations", om.valueToTree(this.getAnnotations()));
            }
            if (this.getEnd() != null) {
                data.set("end", om.valueToTree(this.getEnd()));
            }
            if (this.getLeftYAxis() != null) {
                data.set("leftYAxis", om.valueToTree(this.getLeftYAxis()));
            }
            if (this.getLegendPosition() != null) {
                data.set("legendPosition", om.valueToTree(this.getLegendPosition()));
            }
            if (this.getLiveData() != null) {
                data.set("liveData", om.valueToTree(this.getLiveData()));
            }
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getSetPeriodToTimeRange() != null) {
                data.set("setPeriodToTimeRange", om.valueToTree(this.getSetPeriodToTimeRange()));
            }
            if (this.getStart() != null) {
                data.set("start", om.valueToTree(this.getStart()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.GaugeWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GaugeWidgetProps.Jsii$Proxy that = (GaugeWidgetProps.Jsii$Proxy) o;

            if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) return false;
            if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
            if (this.leftYAxis != null ? !this.leftYAxis.equals(that.leftYAxis) : that.leftYAxis != null) return false;
            if (this.legendPosition != null ? !this.legendPosition.equals(that.legendPosition) : that.legendPosition != null) return false;
            if (this.liveData != null ? !this.liveData.equals(that.liveData) : that.liveData != null) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.setPeriodToTimeRange != null ? !this.setPeriodToTimeRange.equals(that.setPeriodToTimeRange) : that.setPeriodToTimeRange != null) return false;
            if (this.start != null ? !this.start.equals(that.start) : that.start != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public final int hashCode() {
            int result = this.annotations != null ? this.annotations.hashCode() : 0;
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.leftYAxis != null ? this.leftYAxis.hashCode() : 0);
            result = 31 * result + (this.legendPosition != null ? this.legendPosition.hashCode() : 0);
            result = 31 * result + (this.liveData != null ? this.liveData.hashCode() : 0);
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.setPeriodToTimeRange != null ? this.setPeriodToTimeRange.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
