package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a SingleValueWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(SingleValueWidget.Builder.create()
 *         .metrics(List.of())
 *         .period(Duration.minutes(15))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:51.960Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.SingleValueWidgetProps")
@software.amazon.jsii.Jsii.Proxy(SingleValueWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SingleValueWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {

    /**
     * Metrics to display.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics();

    /**
     * The end of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * If you specify a value for end, you must also specify a value for start.
     * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the end date will be the current time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
        return null;
    }

    /**
     * Whether to show as many digits as can fit, before rounding.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFullPrecision() {
        return null;
    }

    /**
     * The default period for all metrics in this widget.
     * <p>
     * The period is the length of time represented by one data point on the graph.
     * This default can be overridden within each metric definition.
     * <p>
     * Default: cdk.Duration.seconds(300)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * Whether to show the value from the entire time range.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSetPeriodToTimeRange() {
        return null;
    }

    /**
     * Whether to show a graph below the value illustrating the value for the whole time range.
     * <p>
     * Cannot be used in combination with <code>setPeriodToTimeRange</code>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSparkline() {
        return null;
    }

    /**
     * The start of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * You can specify start without specifying end to specify a relative time range that ends with the current time.
     * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
     * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
     * You can also use start along with an end field, to specify an absolute time range.
     * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the start time will be the default time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SingleValueWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SingleValueWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SingleValueWidgetProps> {
        java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        java.lang.String end;
        java.lang.Boolean fullPrecision;
        software.amazon.awscdk.Duration period;
        java.lang.Boolean setPeriodToTimeRange;
        java.lang.Boolean sparkline;
        java.lang.String start;
        java.lang.Number height;
        java.lang.String region;
        java.lang.String title;
        java.lang.Number width;

        /**
         * Sets the value of {@link SingleValueWidgetProps#getMetrics}
         * @param metrics Metrics to display. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)metrics;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getEnd}
         * @param end The end of the time range to use for each widget independently from those of the dashboard.
         *            If you specify a value for end, you must also specify a value for start.
         *            Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(java.lang.String end) {
            this.end = end;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getFullPrecision}
         * @param fullPrecision Whether to show as many digits as can fit, before rounding.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullPrecision(java.lang.Boolean fullPrecision) {
            this.fullPrecision = fullPrecision;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getPeriod}
         * @param period The default period for all metrics in this widget.
         *               The period is the length of time represented by one data point on the graph.
         *               This default can be overridden within each metric definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getSetPeriodToTimeRange}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(java.lang.Boolean setPeriodToTimeRange) {
            this.setPeriodToTimeRange = setPeriodToTimeRange;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getSparkline}
         * @param sparkline Whether to show a graph below the value illustrating the value for the whole time range.
         *                  Cannot be used in combination with <code>setPeriodToTimeRange</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sparkline(java.lang.Boolean sparkline) {
            this.sparkline = sparkline;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getStart}
         * @param start The start of the time range to use for each widget independently from those of the dashboard.
         *              You can specify start without specifying end to specify a relative time range that ends with the current time.
         *              In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         *              minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         *              You can also use start along with an end field, to specify an absolute time range.
         *              When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(java.lang.String start) {
            this.start = start;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getRegion}
         * @param region The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getTitle}
         * @param title Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingleValueWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SingleValueWidgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SingleValueWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleValueWidgetProps {
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        private final java.lang.String end;
        private final java.lang.Boolean fullPrecision;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.Boolean setPeriodToTimeRange;
        private final java.lang.Boolean sparkline;
        private final java.lang.String start;
        private final java.lang.Number height;
        private final java.lang.String region;
        private final java.lang.String title;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fullPrecision = software.amazon.jsii.Kernel.get(this, "fullPrecision", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.setPeriodToTimeRange = software.amazon.jsii.Kernel.get(this, "setPeriodToTimeRange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sparkline = software.amazon.jsii.Kernel.get(this, "sparkline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)java.util.Objects.requireNonNull(builder.metrics, "metrics is required");
            this.end = builder.end;
            this.fullPrecision = builder.fullPrecision;
            this.period = builder.period;
            this.setPeriodToTimeRange = builder.setPeriodToTimeRange;
            this.sparkline = builder.sparkline;
            this.start = builder.start;
            this.height = builder.height;
            this.region = builder.region;
            this.title = builder.title;
            this.width = builder.width;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics() {
            return this.metrics;
        }

        @Override
        public final java.lang.String getEnd() {
            return this.end;
        }

        @Override
        public final java.lang.Boolean getFullPrecision() {
            return this.fullPrecision;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.Boolean getSetPeriodToTimeRange() {
            return this.setPeriodToTimeRange;
        }

        @Override
        public final java.lang.Boolean getSparkline() {
            return this.sparkline;
        }

        @Override
        public final java.lang.String getStart() {
            return this.start;
        }

        @Override
        public final java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metrics", om.valueToTree(this.getMetrics()));
            if (this.getEnd() != null) {
                data.set("end", om.valueToTree(this.getEnd()));
            }
            if (this.getFullPrecision() != null) {
                data.set("fullPrecision", om.valueToTree(this.getFullPrecision()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getSetPeriodToTimeRange() != null) {
                data.set("setPeriodToTimeRange", om.valueToTree(this.getSetPeriodToTimeRange()));
            }
            if (this.getSparkline() != null) {
                data.set("sparkline", om.valueToTree(this.getSparkline()));
            }
            if (this.getStart() != null) {
                data.set("start", om.valueToTree(this.getStart()));
            }
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.SingleValueWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SingleValueWidgetProps.Jsii$Proxy that = (SingleValueWidgetProps.Jsii$Proxy) o;

            if (!metrics.equals(that.metrics)) return false;
            if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
            if (this.fullPrecision != null ? !this.fullPrecision.equals(that.fullPrecision) : that.fullPrecision != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.setPeriodToTimeRange != null ? !this.setPeriodToTimeRange.equals(that.setPeriodToTimeRange) : that.setPeriodToTimeRange != null) return false;
            if (this.sparkline != null ? !this.sparkline.equals(that.sparkline) : that.sparkline != null) return false;
            if (this.start != null ? !this.start.equals(that.start) : that.start != null) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metrics.hashCode();
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.fullPrecision != null ? this.fullPrecision.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.setPeriodToTimeRange != null ? this.setPeriodToTimeRange.hashCode() : 0);
            result = 31 * result + (this.sparkline != null ? this.sparkline.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
