package software.amazon.awscdk.services.codebuild;

/**
 * The <code>AWS::CodeBuild::Fleet</code> resource configures a compute fleet, a set of dedicated instances for your build environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * CfnFleet cfnFleet = CfnFleet.Builder.create(this, "MyCfnFleet")
 *         .baseCapacity(123)
 *         .computeConfiguration(ComputeConfigurationProperty.builder()
 *                 .disk(123)
 *                 .instanceType("instanceType")
 *                 .machineType("machineType")
 *                 .memory(123)
 *                 .vCpu(123)
 *                 .build())
 *         .computeType("computeType")
 *         .environmentType("environmentType")
 *         .fleetProxyConfiguration(ProxyConfigurationProperty.builder()
 *                 .defaultBehavior("defaultBehavior")
 *                 .orderedProxyRules(List.of(FleetProxyRuleProperty.builder()
 *                         .effect("effect")
 *                         .entities(List.of("entities"))
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .fleetServiceRole("fleetServiceRole")
 *         .fleetVpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .vpcId("vpcId")
 *                 .build())
 *         .imageId("imageId")
 *         .name("name")
 *         .overflowBehavior("overflowBehavior")
 *         .scalingConfiguration(ScalingConfigurationInputProperty.builder()
 *                 .maxCapacity(123)
 *                 .scalingType("scalingType")
 *                 .targetTrackingScalingConfigs(List.of(TargetTrackingScalingConfigurationProperty.builder()
 *                         .metricType("metricType")
 *                         .targetValue(123)
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.014Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet")
public class CfnFleet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.CfnFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
        return software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaseCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "baseCapacity", value);
    }

    /**
     * The compute configuration of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getComputeConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "computeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The compute configuration of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "computeConfiguration", value);
    }

    /**
     * The compute configuration of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnFleet.ComputeConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "computeConfiguration", value);
    }

    /**
     * Information about the compute resources the compute fleet uses.
     * <p>
     * Available values include:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputeType() {
        return software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Information about the compute resources the compute fleet uses.
     * <p>
     * Available values include:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computeType", value);
    }

    /**
     * The environment type of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentType() {
        return software.amazon.jsii.Kernel.get(this, "environmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The environment type of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentType", value);
    }

    /**
     * Information about the proxy configurations that apply network access control to your reserved capacity instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFleetProxyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "fleetProxyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the proxy configurations that apply network access control to your reserved capacity instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetProxyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fleetProxyConfiguration", value);
    }

    /**
     * Information about the proxy configurations that apply network access control to your reserved capacity instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetProxyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnFleet.ProxyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "fleetProxyConfiguration", value);
    }

    /**
     * The service role associated with the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFleetServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "fleetServiceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service role associated with the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetServiceRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fleetServiceRole", value);
    }

    /**
     * Information about the VPC configuration that AWS CodeBuild accesses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFleetVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "fleetVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the VPC configuration that AWS CodeBuild accesses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fleetVpcConfig", value);
    }

    /**
     * Information about the VPC configuration that AWS CodeBuild accesses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnFleet.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "fleetVpcConfig", value);
    }

    /**
     * The Amazon Machine Image (AMI) of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Machine Image (AMI) of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageId", value);
    }

    /**
     * The name of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The compute fleet overflow behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOverflowBehavior() {
        return software.amazon.jsii.Kernel.get(this, "overflowBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute fleet overflow behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOverflowBehavior(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "overflowBehavior", value);
    }

    /**
     * The scaling configuration of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scaling configuration of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * The scaling configuration of the compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnFleet.ScalingConfigurationInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * A list of tag key and value pairs associated with this compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tag key and value pairs associated with this compute fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains compute attributes.
     * <p>
     * These attributes only need be specified when your project's or fleet's <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code> or <code>CUSTOM_INSTANCE_TYPE</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ComputeConfigurationProperty computeConfigurationProperty = ComputeConfigurationProperty.builder()
     *         .disk(123)
     *         .instanceType("instanceType")
     *         .machineType("machineType")
     *         .memory(123)
     *         .vCpu(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet.ComputeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of disk space of the instance type included in your fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-disk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-disk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDisk() {
            return null;
        }

        /**
         * The EC2 instance type to be launched in your fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The machine type of the instance type included in your fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-machinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-machinetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMachineType() {
            return null;
        }

        /**
         * The amount of memory of the instance type included in your fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * The number of vCPUs of the instance type included in your fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-vcpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-computeconfiguration.html#cfn-codebuild-fleet-computeconfiguration-vcpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVCpu() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputeConfigurationProperty> {
            java.lang.Number disk;
            java.lang.String instanceType;
            java.lang.String machineType;
            java.lang.Number memory;
            java.lang.Number vCpu;

            /**
             * Sets the value of {@link ComputeConfigurationProperty#getDisk}
             * @param disk The amount of disk space of the instance type included in your fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disk(java.lang.Number disk) {
                this.disk = disk;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigurationProperty#getInstanceType}
             * @param instanceType The EC2 instance type to be launched in your fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigurationProperty#getMachineType}
             * @param machineType The machine type of the instance type included in your fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineType(java.lang.String machineType) {
                this.machineType = machineType;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigurationProperty#getMemory}
             * @param memory The amount of memory of the instance type included in your fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link ComputeConfigurationProperty#getVCpu}
             * @param vCpu The number of vCPUs of the instance type included in your fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpu(java.lang.Number vCpu) {
                this.vCpu = vCpu;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComputeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeConfigurationProperty {
            private final java.lang.Number disk;
            private final java.lang.String instanceType;
            private final java.lang.String machineType;
            private final java.lang.Number memory;
            private final java.lang.Number vCpu;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disk = software.amazon.jsii.Kernel.get(this, "disk", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.machineType = software.amazon.jsii.Kernel.get(this, "machineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.vCpu = software.amazon.jsii.Kernel.get(this, "vCpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disk = builder.disk;
                this.instanceType = builder.instanceType;
                this.machineType = builder.machineType;
                this.memory = builder.memory;
                this.vCpu = builder.vCpu;
            }

            @Override
            public final java.lang.Number getDisk() {
                return this.disk;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getMachineType() {
                return this.machineType;
            }

            @Override
            public final java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.Number getVCpu() {
                return this.vCpu;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisk() != null) {
                    data.set("disk", om.valueToTree(this.getDisk()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getMachineType() != null) {
                    data.set("machineType", om.valueToTree(this.getMachineType()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getVCpu() != null) {
                    data.set("vCpu", om.valueToTree(this.getVCpu()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleet.ComputeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputeConfigurationProperty.Jsii$Proxy that = (ComputeConfigurationProperty.Jsii$Proxy) o;

                if (this.disk != null ? !this.disk.equals(that.disk) : that.disk != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.machineType != null ? !this.machineType.equals(that.machineType) : that.machineType != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                return this.vCpu != null ? this.vCpu.equals(that.vCpu) : that.vCpu == null;
            }

            @Override
            public final int hashCode() {
                int result = this.disk != null ? this.disk.hashCode() : 0;
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.machineType != null ? this.machineType.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.vCpu != null ? this.vCpu.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the proxy rule for your reserved capacity instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * FleetProxyRuleProperty fleetProxyRuleProperty = FleetProxyRuleProperty.builder()
     *         .effect("effect")
     *         .entities(List.of("entities"))
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet.FleetProxyRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetProxyRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetProxyRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The behavior of the proxy rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html#cfn-codebuild-fleet-fleetproxyrule-effect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html#cfn-codebuild-fleet-fleetproxyrule-effect</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEffect() {
            return null;
        }

        /**
         * The destination of the proxy rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html#cfn-codebuild-fleet-fleetproxyrule-entities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html#cfn-codebuild-fleet-fleetproxyrule-entities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntities() {
            return null;
        }

        /**
         * The type of proxy rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html#cfn-codebuild-fleet-fleetproxyrule-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-fleetproxyrule.html#cfn-codebuild-fleet-fleetproxyrule-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetProxyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetProxyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetProxyRuleProperty> {
            java.lang.String effect;
            java.util.List<java.lang.String> entities;
            java.lang.String type;

            /**
             * Sets the value of {@link FleetProxyRuleProperty#getEffect}
             * @param effect The behavior of the proxy rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder effect(java.lang.String effect) {
                this.effect = effect;
                return this;
            }

            /**
             * Sets the value of {@link FleetProxyRuleProperty#getEntities}
             * @param entities The destination of the proxy rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entities(java.util.List<java.lang.String> entities) {
                this.entities = entities;
                return this;
            }

            /**
             * Sets the value of {@link FleetProxyRuleProperty#getType}
             * @param type The type of proxy rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetProxyRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetProxyRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetProxyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetProxyRuleProperty {
            private final java.lang.String effect;
            private final java.util.List<java.lang.String> entities;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.effect = software.amazon.jsii.Kernel.get(this, "effect", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entities = software.amazon.jsii.Kernel.get(this, "entities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.effect = builder.effect;
                this.entities = builder.entities;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getEffect() {
                return this.effect;
            }

            @Override
            public final java.util.List<java.lang.String> getEntities() {
                return this.entities;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEffect() != null) {
                    data.set("effect", om.valueToTree(this.getEffect()));
                }
                if (this.getEntities() != null) {
                    data.set("entities", om.valueToTree(this.getEntities()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleet.FleetProxyRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetProxyRuleProperty.Jsii$Proxy that = (FleetProxyRuleProperty.Jsii$Proxy) o;

                if (this.effect != null ? !this.effect.equals(that.effect) : that.effect != null) return false;
                if (this.entities != null ? !this.entities.equals(that.entities) : that.entities != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.effect != null ? this.effect.hashCode() : 0;
                result = 31 * result + (this.entities != null ? this.entities.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the proxy configurations that apply network access control to your reserved capacity instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ProxyConfigurationProperty proxyConfigurationProperty = ProxyConfigurationProperty.builder()
     *         .defaultBehavior("defaultBehavior")
     *         .orderedProxyRules(List.of(FleetProxyRuleProperty.builder()
     *                 .effect("effect")
     *                 .entities(List.of("entities"))
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-proxyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-proxyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet.ProxyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProxyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProxyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default behavior of outgoing traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-proxyconfiguration.html#cfn-codebuild-fleet-proxyconfiguration-defaultbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-proxyconfiguration.html#cfn-codebuild-fleet-proxyconfiguration-defaultbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultBehavior() {
            return null;
        }

        /**
         * An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to allow or deny network access control to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-proxyconfiguration.html#cfn-codebuild-fleet-proxyconfiguration-orderedproxyrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-proxyconfiguration.html#cfn-codebuild-fleet-proxyconfiguration-orderedproxyrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrderedProxyRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProxyConfigurationProperty> {
            java.lang.String defaultBehavior;
            java.lang.Object orderedProxyRules;

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getDefaultBehavior}
             * @param defaultBehavior The default behavior of outgoing traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultBehavior(java.lang.String defaultBehavior) {
                this.defaultBehavior = defaultBehavior;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getOrderedProxyRules}
             * @param orderedProxyRules An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to allow or deny network access control to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderedProxyRules(software.amazon.awscdk.IResolvable orderedProxyRules) {
                this.orderedProxyRules = orderedProxyRules;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getOrderedProxyRules}
             * @param orderedProxyRules An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to allow or deny network access control to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderedProxyRules(java.util.List<? extends java.lang.Object> orderedProxyRules) {
                this.orderedProxyRules = orderedProxyRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProxyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProxyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProxyConfigurationProperty {
            private final java.lang.String defaultBehavior;
            private final java.lang.Object orderedProxyRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultBehavior = software.amazon.jsii.Kernel.get(this, "defaultBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.orderedProxyRules = software.amazon.jsii.Kernel.get(this, "orderedProxyRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultBehavior = builder.defaultBehavior;
                this.orderedProxyRules = builder.orderedProxyRules;
            }

            @Override
            public final java.lang.String getDefaultBehavior() {
                return this.defaultBehavior;
            }

            @Override
            public final java.lang.Object getOrderedProxyRules() {
                return this.orderedProxyRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultBehavior() != null) {
                    data.set("defaultBehavior", om.valueToTree(this.getDefaultBehavior()));
                }
                if (this.getOrderedProxyRules() != null) {
                    data.set("orderedProxyRules", om.valueToTree(this.getOrderedProxyRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleet.ProxyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProxyConfigurationProperty.Jsii$Proxy that = (ProxyConfigurationProperty.Jsii$Proxy) o;

                if (this.defaultBehavior != null ? !this.defaultBehavior.equals(that.defaultBehavior) : that.defaultBehavior != null) return false;
                return this.orderedProxyRules != null ? this.orderedProxyRules.equals(that.orderedProxyRules) : that.orderedProxyRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultBehavior != null ? this.defaultBehavior.hashCode() : 0;
                result = 31 * result + (this.orderedProxyRules != null ? this.orderedProxyRules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The scaling configuration input of a compute fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ScalingConfigurationInputProperty scalingConfigurationInputProperty = ScalingConfigurationInputProperty.builder()
     *         .maxCapacity(123)
     *         .scalingType("scalingType")
     *         .targetTrackingScalingConfigs(List.of(TargetTrackingScalingConfigurationProperty.builder()
     *                 .metricType("metricType")
     *                 .targetValue(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet.ScalingConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of instances in the ﬂeet when auto-scaling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html#cfn-codebuild-fleet-scalingconfigurationinput-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html#cfn-codebuild-fleet-scalingconfigurationinput-maxcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * The scaling type for a compute fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html#cfn-codebuild-fleet-scalingconfigurationinput-scalingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html#cfn-codebuild-fleet-scalingconfigurationinput-scalingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScalingType() {
            return null;
        }

        /**
         * A list of <code>TargetTrackingScalingConfiguration</code> objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html#cfn-codebuild-fleet-scalingconfigurationinput-targettrackingscalingconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-scalingconfigurationinput.html#cfn-codebuild-fleet-scalingconfigurationinput-targettrackingscalingconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingScalingConfigs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConfigurationInputProperty> {
            java.lang.Number maxCapacity;
            java.lang.String scalingType;
            java.lang.Object targetTrackingScalingConfigs;

            /**
             * Sets the value of {@link ScalingConfigurationInputProperty#getMaxCapacity}
             * @param maxCapacity The maximum number of instances in the ﬂeet when auto-scaling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationInputProperty#getScalingType}
             * @param scalingType The scaling type for a compute fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingType(java.lang.String scalingType) {
                this.scalingType = scalingType;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationInputProperty#getTargetTrackingScalingConfigs}
             * @param targetTrackingScalingConfigs A list of <code>TargetTrackingScalingConfiguration</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingScalingConfigs(software.amazon.awscdk.IResolvable targetTrackingScalingConfigs) {
                this.targetTrackingScalingConfigs = targetTrackingScalingConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationInputProperty#getTargetTrackingScalingConfigs}
             * @param targetTrackingScalingConfigs A list of <code>TargetTrackingScalingConfiguration</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingScalingConfigs(java.util.List<? extends java.lang.Object> targetTrackingScalingConfigs) {
                this.targetTrackingScalingConfigs = targetTrackingScalingConfigs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConfigurationInputProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.String scalingType;
            private final java.lang.Object targetTrackingScalingConfigs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scalingType = software.amazon.jsii.Kernel.get(this, "scalingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetTrackingScalingConfigs = software.amazon.jsii.Kernel.get(this, "targetTrackingScalingConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = builder.maxCapacity;
                this.scalingType = builder.scalingType;
                this.targetTrackingScalingConfigs = builder.targetTrackingScalingConfigs;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.String getScalingType() {
                return this.scalingType;
            }

            @Override
            public final java.lang.Object getTargetTrackingScalingConfigs() {
                return this.targetTrackingScalingConfigs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getScalingType() != null) {
                    data.set("scalingType", om.valueToTree(this.getScalingType()));
                }
                if (this.getTargetTrackingScalingConfigs() != null) {
                    data.set("targetTrackingScalingConfigs", om.valueToTree(this.getTargetTrackingScalingConfigs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleet.ScalingConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConfigurationInputProperty.Jsii$Proxy that = (ScalingConfigurationInputProperty.Jsii$Proxy) o;

                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                if (this.scalingType != null ? !this.scalingType.equals(that.scalingType) : that.scalingType != null) return false;
                return this.targetTrackingScalingConfigs != null ? this.targetTrackingScalingConfigs.equals(that.targetTrackingScalingConfigs) : that.targetTrackingScalingConfigs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity != null ? this.maxCapacity.hashCode() : 0;
                result = 31 * result + (this.scalingType != null ? this.scalingType.hashCode() : 0);
                result = 31 * result + (this.targetTrackingScalingConfigs != null ? this.targetTrackingScalingConfigs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines when a new instance is auto-scaled into the compute fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * TargetTrackingScalingConfigurationProperty targetTrackingScalingConfigurationProperty = TargetTrackingScalingConfigurationProperty.builder()
     *         .metricType("metricType")
     *         .targetValue(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-targettrackingscalingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-targettrackingscalingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet.TargetTrackingScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type to determine auto-scaling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-targettrackingscalingconfiguration.html#cfn-codebuild-fleet-targettrackingscalingconfiguration-metrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-targettrackingscalingconfiguration.html#cfn-codebuild-fleet-targettrackingscalingconfiguration-metrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricType() {
            return null;
        }

        /**
         * The value of <code>metricType</code> when to start scaling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-targettrackingscalingconfiguration.html#cfn-codebuild-fleet-targettrackingscalingconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-targettrackingscalingconfiguration.html#cfn-codebuild-fleet-targettrackingscalingconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingConfigurationProperty> {
            java.lang.String metricType;
            java.lang.Number targetValue;

            /**
             * Sets the value of {@link TargetTrackingScalingConfigurationProperty#getMetricType}
             * @param metricType The metric type to determine auto-scaling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricType(java.lang.String metricType) {
                this.metricType = metricType;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingConfigurationProperty#getTargetValue}
             * @param targetValue The value of <code>metricType</code> when to start scaling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingScalingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingConfigurationProperty {
            private final java.lang.String metricType;
            private final java.lang.Number targetValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricType = software.amazon.jsii.Kernel.get(this, "metricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricType = builder.metricType;
                this.targetValue = builder.targetValue;
            }

            @Override
            public final java.lang.String getMetricType() {
                return this.metricType;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetricType() != null) {
                    data.set("metricType", om.valueToTree(this.getMetricType()));
                }
                if (this.getTargetValue() != null) {
                    data.set("targetValue", om.valueToTree(this.getTargetValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleet.TargetTrackingScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingScalingConfigurationProperty.Jsii$Proxy that = (TargetTrackingScalingConfigurationProperty.Jsii$Proxy) o;

                if (this.metricType != null ? !this.metricType.equals(that.metricType) : that.metricType != null) return false;
                return this.targetValue != null ? this.targetValue.equals(that.targetValue) : that.targetValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricType != null ? this.metricType.hashCode() : 0;
                result = 31 * result + (this.targetValue != null ? this.targetValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the VPC configuration that AWS CodeBuild accesses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleet.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of one or more security groups IDs in your Amazon VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html#cfn-codebuild-fleet-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html#cfn-codebuild-fleet-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * A list of one or more subnet IDs in your Amazon VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html#cfn-codebuild-fleet-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html#cfn-codebuild-fleet-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
            return null;
        }

        /**
         * The ID of the Amazon VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html#cfn-codebuild-fleet-vpcconfig-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-fleet-vpcconfig.html#cfn-codebuild-fleet-vpcconfig-vpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of one or more security groups IDs in your Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets A list of one or more subnet IDs in your Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getVpcId}
             * @param vpcId The ID of the Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnets = builder.subnets;
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnets() != null) {
                    data.set("subnets", om.valueToTree(this.getSubnets()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleet.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.CfnFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.CfnFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codebuild.CfnFleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-basecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-basecapacity</a>
         * @param baseCapacity The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(final java.lang.Number baseCapacity) {
            this.props().baseCapacity(baseCapacity);
            return this;
        }

        /**
         * The compute configuration of the compute fleet.
         * <p>
         * This is only required if <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code> or <code>CUSTOM_INSTANCE_TYPE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computeconfiguration</a>
         * @param computeConfiguration The compute configuration of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfiguration(final software.amazon.awscdk.IResolvable computeConfiguration) {
            this.props().computeConfiguration(computeConfiguration);
            return this;
        }
        /**
         * The compute configuration of the compute fleet.
         * <p>
         * This is only required if <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code> or <code>CUSTOM_INSTANCE_TYPE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computeconfiguration</a>
         * @param computeConfiguration The compute configuration of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfiguration(final software.amazon.awscdk.services.codebuild.CfnFleet.ComputeConfigurationProperty computeConfiguration) {
            this.props().computeConfiguration(computeConfiguration);
            return this;
        }

        /**
         * Information about the compute resources the compute fleet uses. Available values include:.
         * <p>
         * <ul>
         * <li><code>ATTRIBUTE_BASED_COMPUTE</code> : Specify the amount of vCPUs, memory, disk space, and the type of machine.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you use <code>ATTRIBUTE_BASED_COMPUTE</code> , you must define your attributes by using <code>computeConfiguration</code> . AWS CodeBuild will select the cheapest instance that satisfies your specified attributes. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types">Reserved capacity environment types</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 4 GiB memory and 2 vCPUs for builds.</li>
         * <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 8 GiB memory and 4 vCPUs for builds.</li>
         * <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 16 GiB memory and 8 vCPUs for builds, depending on your environment type.</li>
         * <li><code>BUILD_GENERAL1_XLARGE</code> : Use up to 72 GiB memory and 36 vCPUs for builds, depending on your environment type.</li>
         * <li><code>BUILD_GENERAL1_2XLARGE</code> : Use up to 144 GiB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.</li>
         * <li><code>BUILD_LAMBDA_1GB</code> : Use up to 1 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         * <li><code>BUILD_LAMBDA_2GB</code> : Use up to 2 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         * <li><code>BUILD_LAMBDA_4GB</code> : Use up to 4 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         * <li><code>BUILD_LAMBDA_8GB</code> : Use up to 8 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         * <li><code>BUILD_LAMBDA_10GB</code> : Use up to 10 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         * </ul>
         * <p>
         * If you use <code>BUILD_GENERAL1_SMALL</code> :
         * <p>
         * <ul>
         * <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 4 GiB memory and 2 vCPUs for builds.</li>
         * <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 16 GiB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.</li>
         * <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 4 GiB memory and 2 vCPUs on ARM-based processors for builds.</li>
         * </ul>
         * <p>
         * If you use <code>BUILD_GENERAL1_LARGE</code> :
         * <p>
         * <ul>
         * <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 16 GiB memory and 8 vCPUs for builds.</li>
         * <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 255 GiB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</li>
         * <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 16 GiB memory and 8 vCPUs on ARM-based processors for builds.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types">On-demand environment types</a> in the <em>AWS CodeBuild User Guide.</em>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computetype</a>
         * @param computeType Information about the compute resources the compute fleet uses. Available values include:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(final java.lang.String computeType) {
            this.props().computeType(computeType);
            return this;
        }

        /**
         * The environment type of the compute fleet.
         * <p>
         * <ul>
         * <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).</li>
         * <li>The environment type <code>ARM_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         * <li>The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         * <li>The environment type <code>LINUX_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         * <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).</li>
         * <li>The environment type <code>MAC_ARM</code> is available only in regions US East (Ohio), US East (N. Virginia), US West (Oregon), Europe (Frankfurt), and Asia Pacific (Sydney).</li>
         * <li>The environment type <code>WINDOWS_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         * <li>The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).</li>
         * <li>The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-environmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-environmenttype</a>
         * @param environmentType The environment type of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentType(final java.lang.String environmentType) {
            this.props().environmentType(environmentType);
            return this;
        }

        /**
         * Information about the proxy configurations that apply network access control to your reserved capacity instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetproxyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetproxyconfiguration</a>
         * @param fleetProxyConfiguration Information about the proxy configurations that apply network access control to your reserved capacity instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetProxyConfiguration(final software.amazon.awscdk.IResolvable fleetProxyConfiguration) {
            this.props().fleetProxyConfiguration(fleetProxyConfiguration);
            return this;
        }
        /**
         * Information about the proxy configurations that apply network access control to your reserved capacity instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetproxyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetproxyconfiguration</a>
         * @param fleetProxyConfiguration Information about the proxy configurations that apply network access control to your reserved capacity instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetProxyConfiguration(final software.amazon.awscdk.services.codebuild.CfnFleet.ProxyConfigurationProperty fleetProxyConfiguration) {
            this.props().fleetProxyConfiguration(fleetProxyConfiguration);
            return this;
        }

        /**
         * The service role associated with the compute fleet.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html">Allow a user to add a permission policy for a fleet service role</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetservicerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetservicerole</a>
         * @param fleetServiceRole The service role associated with the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetServiceRole(final java.lang.String fleetServiceRole) {
            this.props().fleetServiceRole(fleetServiceRole);
            return this;
        }

        /**
         * Information about the VPC configuration that AWS CodeBuild accesses.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetvpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetvpcconfig</a>
         * @param fleetVpcConfig Information about the VPC configuration that AWS CodeBuild accesses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetVpcConfig(final software.amazon.awscdk.IResolvable fleetVpcConfig) {
            this.props().fleetVpcConfig(fleetVpcConfig);
            return this;
        }
        /**
         * Information about the VPC configuration that AWS CodeBuild accesses.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetvpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetvpcconfig</a>
         * @param fleetVpcConfig Information about the VPC configuration that AWS CodeBuild accesses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetVpcConfig(final software.amazon.awscdk.services.codebuild.CfnFleet.VpcConfigProperty fleetVpcConfig) {
            this.props().fleetVpcConfig(fleetVpcConfig);
            return this;
        }

        /**
         * The Amazon Machine Image (AMI) of the compute fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-imageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-imageid</a>
         * @param imageId The Amazon Machine Image (AMI) of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(final java.lang.String imageId) {
            this.props().imageId(imageId);
            return this;
        }

        /**
         * The name of the compute fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-name</a>
         * @param name The name of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The compute fleet overflow behavior.
         * <p>
         * <ul>
         * <li>For overflow behavior <code>QUEUE</code> , your overflow builds need to wait on the existing fleet instance to become available.</li>
         * <li>For overflow behavior <code>ON_DEMAND</code> , your overflow builds run on CodeBuild on-demand.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you add the required VPC permissions to your project service role. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface">Example policy statement to allow CodeBuild access to AWS services required to create a VPC network interface</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-overflowbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-overflowbehavior</a>
         * @param overflowBehavior The compute fleet overflow behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overflowBehavior(final java.lang.String overflowBehavior) {
            this.props().overflowBehavior(overflowBehavior);
            return this;
        }

        /**
         * The scaling configuration of the compute fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-scalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-scalingconfiguration</a>
         * @param scalingConfiguration The scaling configuration of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }
        /**
         * The scaling configuration of the compute fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-scalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-scalingconfiguration</a>
         * @param scalingConfiguration The scaling configuration of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.services.codebuild.CfnFleet.ScalingConfigurationInputProperty scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }

        /**
         * A list of tag key and value pairs associated with this compute fleet.
         * <p>
         * These tags are available for use by AWS services that support AWS CodeBuild compute fleet tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-tags</a>
         * @param tags A list of tag key and value pairs associated with this compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.CfnFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.CfnFleet build() {
            return new software.amazon.awscdk.services.codebuild.CfnFleet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codebuild.CfnFleetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codebuild.CfnFleetProps.Builder();
            }
            return this.props;
        }
    }
}
