package software.amazon.awscdk.services.codebuild;

/**
 * Properties for defining a <code>CfnFleet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * CfnFleetProps cfnFleetProps = CfnFleetProps.builder()
 *         .baseCapacity(123)
 *         .computeConfiguration(ComputeConfigurationProperty.builder()
 *                 .disk(123)
 *                 .instanceType("instanceType")
 *                 .machineType("machineType")
 *                 .memory(123)
 *                 .vCpu(123)
 *                 .build())
 *         .computeType("computeType")
 *         .environmentType("environmentType")
 *         .fleetProxyConfiguration(ProxyConfigurationProperty.builder()
 *                 .defaultBehavior("defaultBehavior")
 *                 .orderedProxyRules(List.of(FleetProxyRuleProperty.builder()
 *                         .effect("effect")
 *                         .entities(List.of("entities"))
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .fleetServiceRole("fleetServiceRole")
 *         .fleetVpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .vpcId("vpcId")
 *                 .build())
 *         .imageId("imageId")
 *         .name("name")
 *         .overflowBehavior("overflowBehavior")
 *         .scalingConfiguration(ScalingConfigurationInputProperty.builder()
 *                 .maxCapacity(123)
 *                 .scalingType("scalingType")
 *                 .targetTrackingScalingConfigs(List.of(TargetTrackingScalingConfigurationProperty.builder()
 *                         .metricType("metricType")
 *                         .targetValue(123)
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.018Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-basecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-basecapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
        return null;
    }

    /**
     * The compute configuration of the compute fleet.
     * <p>
     * This is only required if <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code> or <code>CUSTOM_INSTANCE_TYPE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computeconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComputeConfiguration() {
        return null;
    }

    /**
     * Information about the compute resources the compute fleet uses. Available values include:.
     * <p>
     * <ul>
     * <li><code>ATTRIBUTE_BASED_COMPUTE</code> : Specify the amount of vCPUs, memory, disk space, and the type of machine.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you use <code>ATTRIBUTE_BASED_COMPUTE</code> , you must define your attributes by using <code>computeConfiguration</code> . AWS CodeBuild will select the cheapest instance that satisfies your specified attributes. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types">Reserved capacity environment types</a> in the <em>AWS CodeBuild User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 4 GiB memory and 2 vCPUs for builds.</li>
     * <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 8 GiB memory and 4 vCPUs for builds.</li>
     * <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 16 GiB memory and 8 vCPUs for builds, depending on your environment type.</li>
     * <li><code>BUILD_GENERAL1_XLARGE</code> : Use up to 72 GiB memory and 36 vCPUs for builds, depending on your environment type.</li>
     * <li><code>BUILD_GENERAL1_2XLARGE</code> : Use up to 144 GiB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.</li>
     * <li><code>BUILD_LAMBDA_1GB</code> : Use up to 1 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
     * <li><code>BUILD_LAMBDA_2GB</code> : Use up to 2 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
     * <li><code>BUILD_LAMBDA_4GB</code> : Use up to 4 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
     * <li><code>BUILD_LAMBDA_8GB</code> : Use up to 8 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
     * <li><code>BUILD_LAMBDA_10GB</code> : Use up to 10 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_SMALL</code> :
     * <p>
     * <ul>
     * <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 4 GiB memory and 2 vCPUs for builds.</li>
     * <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 16 GiB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.</li>
     * <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 4 GiB memory and 2 vCPUs on ARM-based processors for builds.</li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_LARGE</code> :
     * <p>
     * <ul>
     * <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 16 GiB memory and 8 vCPUs for builds.</li>
     * <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 255 GiB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</li>
     * <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 16 GiB memory and 8 vCPUs on ARM-based processors for builds.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types">On-demand environment types</a> in the <em>AWS CodeBuild User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeType() {
        return null;
    }

    /**
     * The environment type of the compute fleet.
     * <p>
     * <ul>
     * <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).</li>
     * <li>The environment type <code>ARM_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
     * <li>The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
     * <li>The environment type <code>LINUX_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
     * <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).</li>
     * <li>The environment type <code>MAC_ARM</code> is available only in regions US East (Ohio), US East (N. Virginia), US West (Oregon), Europe (Frankfurt), and Asia Pacific (Sydney).</li>
     * <li>The environment type <code>WINDOWS_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
     * <li>The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).</li>
     * <li>The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-environmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-environmenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentType() {
        return null;
    }

    /**
     * Information about the proxy configurations that apply network access control to your reserved capacity instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetproxyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetproxyconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFleetProxyConfiguration() {
        return null;
    }

    /**
     * The service role associated with the compute fleet.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html">Allow a user to add a permission policy for a fleet service role</a> in the <em>AWS CodeBuild User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetservicerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetservicerole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFleetServiceRole() {
        return null;
    }

    /**
     * Information about the VPC configuration that AWS CodeBuild accesses.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetvpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-fleetvpcconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFleetVpcConfig() {
        return null;
    }

    /**
     * The Amazon Machine Image (AMI) of the compute fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-imageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-imageid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
        return null;
    }

    /**
     * The name of the compute fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The compute fleet overflow behavior.
     * <p>
     * <ul>
     * <li>For overflow behavior <code>QUEUE</code> , your overflow builds need to wait on the existing fleet instance to become available.</li>
     * <li>For overflow behavior <code>ON_DEMAND</code> , your overflow builds run on CodeBuild on-demand.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you add the required VPC permissions to your project service role. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface">Example policy statement to allow CodeBuild access to AWS services required to create a VPC network interface</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-overflowbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-overflowbehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOverflowBehavior() {
        return null;
    }

    /**
     * The scaling configuration of the compute fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-scalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-scalingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return null;
    }

    /**
     * A list of tag key and value pairs associated with this compute fleet.
     * <p>
     * These tags are available for use by AWS services that support AWS CodeBuild compute fleet tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFleetProps> {
        java.lang.Number baseCapacity;
        java.lang.Object computeConfiguration;
        java.lang.String computeType;
        java.lang.String environmentType;
        java.lang.Object fleetProxyConfiguration;
        java.lang.String fleetServiceRole;
        java.lang.Object fleetVpcConfig;
        java.lang.String imageId;
        java.lang.String name;
        java.lang.String overflowBehavior;
        java.lang.Object scalingConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFleetProps#getBaseCapacity}
         * @param baseCapacity The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(java.lang.Number baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getComputeConfiguration}
         * @param computeConfiguration The compute configuration of the compute fleet.
         *                             This is only required if <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code> or <code>CUSTOM_INSTANCE_TYPE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfiguration(software.amazon.awscdk.IResolvable computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getComputeConfiguration}
         * @param computeConfiguration The compute configuration of the compute fleet.
         *                             This is only required if <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code> or <code>CUSTOM_INSTANCE_TYPE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfiguration(software.amazon.awscdk.services.codebuild.CfnFleet.ComputeConfigurationProperty computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getComputeType}
         * @param computeType Information about the compute resources the compute fleet uses. Available values include:.
         *                    <ul>
         *                    <li><code>ATTRIBUTE_BASED_COMPUTE</code> : Specify the amount of vCPUs, memory, disk space, and the type of machine.</li>
         *                    </ul>
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If you use <code>ATTRIBUTE_BASED_COMPUTE</code> , you must define your attributes by using <code>computeConfiguration</code> . AWS CodeBuild will select the cheapest instance that satisfies your specified attributes. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types">Reserved capacity environment types</a> in the <em>AWS CodeBuild User Guide</em> .
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    <ul>
         *                    <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 4 GiB memory and 2 vCPUs for builds.</li>
         *                    <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 8 GiB memory and 4 vCPUs for builds.</li>
         *                    <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 16 GiB memory and 8 vCPUs for builds, depending on your environment type.</li>
         *                    <li><code>BUILD_GENERAL1_XLARGE</code> : Use up to 72 GiB memory and 36 vCPUs for builds, depending on your environment type.</li>
         *                    <li><code>BUILD_GENERAL1_2XLARGE</code> : Use up to 144 GiB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.</li>
         *                    <li><code>BUILD_LAMBDA_1GB</code> : Use up to 1 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         *                    <li><code>BUILD_LAMBDA_2GB</code> : Use up to 2 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         *                    <li><code>BUILD_LAMBDA_4GB</code> : Use up to 4 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         *                    <li><code>BUILD_LAMBDA_8GB</code> : Use up to 8 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         *                    <li><code>BUILD_LAMBDA_10GB</code> : Use up to 10 GiB memory for builds. Only available for environment type <code>LINUX_LAMBDA_CONTAINER</code> and <code>ARM_LAMBDA_CONTAINER</code> .</li>
         *                    </ul>
         *                    <p>
         *                    If you use <code>BUILD_GENERAL1_SMALL</code> :
         *                    <p>
         *                    <ul>
         *                    <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 4 GiB memory and 2 vCPUs for builds.</li>
         *                    <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 16 GiB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.</li>
         *                    <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 4 GiB memory and 2 vCPUs on ARM-based processors for builds.</li>
         *                    </ul>
         *                    <p>
         *                    If you use <code>BUILD_GENERAL1_LARGE</code> :
         *                    <p>
         *                    <ul>
         *                    <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 16 GiB memory and 8 vCPUs for builds.</li>
         *                    <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 255 GiB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</li>
         *                    <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 16 GiB memory and 8 vCPUs on ARM-based processors for builds.</li>
         *                    </ul>
         *                    <p>
         *                    For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types">On-demand environment types</a> in the <em>AWS CodeBuild User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(java.lang.String computeType) {
            this.computeType = computeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEnvironmentType}
         * @param environmentType The environment type of the compute fleet.
         *                        <ul>
         *                        <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).</li>
         *                        <li>The environment type <code>ARM_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         *                        <li>The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         *                        <li>The environment type <code>LINUX_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         *                        <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).</li>
         *                        <li>The environment type <code>MAC_ARM</code> is available only in regions US East (Ohio), US East (N. Virginia), US West (Oregon), Europe (Frankfurt), and Asia Pacific (Sydney).</li>
         *                        <li>The environment type <code>WINDOWS_EC2</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         *                        <li>The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).</li>
         *                        <li>The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).</li>
         *                        </ul>
         *                        <p>
         *                        For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentType(java.lang.String environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetProxyConfiguration}
         * @param fleetProxyConfiguration Information about the proxy configurations that apply network access control to your reserved capacity instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetProxyConfiguration(software.amazon.awscdk.IResolvable fleetProxyConfiguration) {
            this.fleetProxyConfiguration = fleetProxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetProxyConfiguration}
         * @param fleetProxyConfiguration Information about the proxy configurations that apply network access control to your reserved capacity instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetProxyConfiguration(software.amazon.awscdk.services.codebuild.CfnFleet.ProxyConfigurationProperty fleetProxyConfiguration) {
            this.fleetProxyConfiguration = fleetProxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetServiceRole}
         * @param fleetServiceRole The service role associated with the compute fleet.
         *                         For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html">Allow a user to add a permission policy for a fleet service role</a> in the <em>AWS CodeBuild User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetServiceRole(java.lang.String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetVpcConfig}
         * @param fleetVpcConfig Information about the VPC configuration that AWS CodeBuild accesses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetVpcConfig(software.amazon.awscdk.IResolvable fleetVpcConfig) {
            this.fleetVpcConfig = fleetVpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetVpcConfig}
         * @param fleetVpcConfig Information about the VPC configuration that AWS CodeBuild accesses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetVpcConfig(software.amazon.awscdk.services.codebuild.CfnFleet.VpcConfigProperty fleetVpcConfig) {
            this.fleetVpcConfig = fleetVpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getImageId}
         * @param imageId The Amazon Machine Image (AMI) of the compute fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(java.lang.String imageId) {
            this.imageId = imageId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getName}
         * @param name The name of the compute fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getOverflowBehavior}
         * @param overflowBehavior The compute fleet overflow behavior.
         *                         <ul>
         *                         <li>For overflow behavior <code>QUEUE</code> , your overflow builds need to wait on the existing fleet instance to become available.</li>
         *                         <li>For overflow behavior <code>ON_DEMAND</code> , your overflow builds run on CodeBuild on-demand.</li>
         *                         </ul>
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you add the required VPC permissions to your project service role. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface">Example policy statement to allow CodeBuild access to AWS services required to create a VPC network interface</a> .
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overflowBehavior(java.lang.String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getScalingConfiguration}
         * @param scalingConfiguration The scaling configuration of the compute fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getScalingConfiguration}
         * @param scalingConfiguration The scaling configuration of the compute fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.services.codebuild.CfnFleet.ScalingConfigurationInputProperty scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getTags}
         * @param tags A list of tag key and value pairs associated with this compute fleet.
         *             These tags are available for use by AWS services that support AWS CodeBuild compute fleet tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFleetProps {
        private final java.lang.Number baseCapacity;
        private final java.lang.Object computeConfiguration;
        private final java.lang.String computeType;
        private final java.lang.String environmentType;
        private final java.lang.Object fleetProxyConfiguration;
        private final java.lang.String fleetServiceRole;
        private final java.lang.Object fleetVpcConfig;
        private final java.lang.String imageId;
        private final java.lang.String name;
        private final java.lang.String overflowBehavior;
        private final java.lang.Object scalingConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseCapacity = software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeConfiguration = software.amazon.jsii.Kernel.get(this, "computeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentType = software.amazon.jsii.Kernel.get(this, "environmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fleetProxyConfiguration = software.amazon.jsii.Kernel.get(this, "fleetProxyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fleetServiceRole = software.amazon.jsii.Kernel.get(this, "fleetServiceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fleetVpcConfig = software.amazon.jsii.Kernel.get(this, "fleetVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overflowBehavior = software.amazon.jsii.Kernel.get(this, "overflowBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingConfiguration = software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseCapacity = builder.baseCapacity;
            this.computeConfiguration = builder.computeConfiguration;
            this.computeType = builder.computeType;
            this.environmentType = builder.environmentType;
            this.fleetProxyConfiguration = builder.fleetProxyConfiguration;
            this.fleetServiceRole = builder.fleetServiceRole;
            this.fleetVpcConfig = builder.fleetVpcConfig;
            this.imageId = builder.imageId;
            this.name = builder.name;
            this.overflowBehavior = builder.overflowBehavior;
            this.scalingConfiguration = builder.scalingConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getBaseCapacity() {
            return this.baseCapacity;
        }

        @Override
        public final java.lang.Object getComputeConfiguration() {
            return this.computeConfiguration;
        }

        @Override
        public final java.lang.String getComputeType() {
            return this.computeType;
        }

        @Override
        public final java.lang.String getEnvironmentType() {
            return this.environmentType;
        }

        @Override
        public final java.lang.Object getFleetProxyConfiguration() {
            return this.fleetProxyConfiguration;
        }

        @Override
        public final java.lang.String getFleetServiceRole() {
            return this.fleetServiceRole;
        }

        @Override
        public final java.lang.Object getFleetVpcConfig() {
            return this.fleetVpcConfig;
        }

        @Override
        public final java.lang.String getImageId() {
            return this.imageId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOverflowBehavior() {
            return this.overflowBehavior;
        }

        @Override
        public final java.lang.Object getScalingConfiguration() {
            return this.scalingConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBaseCapacity() != null) {
                data.set("baseCapacity", om.valueToTree(this.getBaseCapacity()));
            }
            if (this.getComputeConfiguration() != null) {
                data.set("computeConfiguration", om.valueToTree(this.getComputeConfiguration()));
            }
            if (this.getComputeType() != null) {
                data.set("computeType", om.valueToTree(this.getComputeType()));
            }
            if (this.getEnvironmentType() != null) {
                data.set("environmentType", om.valueToTree(this.getEnvironmentType()));
            }
            if (this.getFleetProxyConfiguration() != null) {
                data.set("fleetProxyConfiguration", om.valueToTree(this.getFleetProxyConfiguration()));
            }
            if (this.getFleetServiceRole() != null) {
                data.set("fleetServiceRole", om.valueToTree(this.getFleetServiceRole()));
            }
            if (this.getFleetVpcConfig() != null) {
                data.set("fleetVpcConfig", om.valueToTree(this.getFleetVpcConfig()));
            }
            if (this.getImageId() != null) {
                data.set("imageId", om.valueToTree(this.getImageId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOverflowBehavior() != null) {
                data.set("overflowBehavior", om.valueToTree(this.getOverflowBehavior()));
            }
            if (this.getScalingConfiguration() != null) {
                data.set("scalingConfiguration", om.valueToTree(this.getScalingConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFleetProps.Jsii$Proxy that = (CfnFleetProps.Jsii$Proxy) o;

            if (this.baseCapacity != null ? !this.baseCapacity.equals(that.baseCapacity) : that.baseCapacity != null) return false;
            if (this.computeConfiguration != null ? !this.computeConfiguration.equals(that.computeConfiguration) : that.computeConfiguration != null) return false;
            if (this.computeType != null ? !this.computeType.equals(that.computeType) : that.computeType != null) return false;
            if (this.environmentType != null ? !this.environmentType.equals(that.environmentType) : that.environmentType != null) return false;
            if (this.fleetProxyConfiguration != null ? !this.fleetProxyConfiguration.equals(that.fleetProxyConfiguration) : that.fleetProxyConfiguration != null) return false;
            if (this.fleetServiceRole != null ? !this.fleetServiceRole.equals(that.fleetServiceRole) : that.fleetServiceRole != null) return false;
            if (this.fleetVpcConfig != null ? !this.fleetVpcConfig.equals(that.fleetVpcConfig) : that.fleetVpcConfig != null) return false;
            if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.overflowBehavior != null ? !this.overflowBehavior.equals(that.overflowBehavior) : that.overflowBehavior != null) return false;
            if (this.scalingConfiguration != null ? !this.scalingConfiguration.equals(that.scalingConfiguration) : that.scalingConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baseCapacity != null ? this.baseCapacity.hashCode() : 0;
            result = 31 * result + (this.computeConfiguration != null ? this.computeConfiguration.hashCode() : 0);
            result = 31 * result + (this.computeType != null ? this.computeType.hashCode() : 0);
            result = 31 * result + (this.environmentType != null ? this.environmentType.hashCode() : 0);
            result = 31 * result + (this.fleetProxyConfiguration != null ? this.fleetProxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.fleetServiceRole != null ? this.fleetServiceRole.hashCode() : 0);
            result = 31 * result + (this.fleetVpcConfig != null ? this.fleetVpcConfig.hashCode() : 0);
            result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.overflowBehavior != null ? this.overflowBehavior.hashCode() : 0);
            result = 31 * result + (this.scalingConfiguration != null ? this.scalingConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
