package software.amazon.awscdk.services.codebuild;

/**
 * Represents a report group.
 * <p>
 * A report group contains a collection of reports.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * CfnReportGroup cfnReportGroup = CfnReportGroup.Builder.create(this, "MyCfnReportGroup")
 *         .exportConfig(ReportExportConfigProperty.builder()
 *                 .exportConfigType("exportConfigType")
 *                 // the properties below are optional
 *                 .s3Destination(S3ReportExportConfigProperty.builder()
 *                         .bucket("bucket")
 *                         // the properties below are optional
 *                         .bucketOwner("bucketOwner")
 *                         .encryptionDisabled(false)
 *                         .encryptionKey("encryptionKey")
 *                         .packaging("packaging")
 *                         .path("path")
 *                         .build())
 *                 .build())
 *         .type("type")
 *         // the properties below are optional
 *         .deleteReports(false)
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.066Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnReportGroup")
public class CfnReportGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnReportGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReportGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.CfnReportGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReportGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnReportGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the AWS CodeBuild report group, such as <code>arn:aws:codebuild:region:123456789012:report-group/myReportGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getExportConfig() {
        return software.amazon.jsii.Kernel.get(this, "exportConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExportConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "exportConfig", java.util.Objects.requireNonNull(value, "exportConfig is required"));
    }

    /**
     * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExportConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnReportGroup.ReportExportConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "exportConfig", java.util.Objects.requireNonNull(value, "exportConfig is required"));
    }

    /**
     * The type of the <code>ReportGroup</code> .
     * <p>
     * This can be one of the following values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the <code>ReportGroup</code> .
     * <p>
     * This can be one of the following values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * When deleting a report group, specifies if reports within the report group should be deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteReports() {
        return software.amazon.jsii.Kernel.get(this, "deleteReports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When deleting a report group, specifies if reports within the report group should be deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteReports(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteReports", value);
    }

    /**
     * When deleting a report group, specifies if reports within the report group should be deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteReports(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteReports", value);
    }

    /**
     * The name of the <code>ReportGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>ReportGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A list of tag key and value pairs associated with this report group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tag key and value pairs associated with this report group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Information about the location where the run of a report is exported.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ReportExportConfigProperty reportExportConfigProperty = ReportExportConfigProperty.builder()
     *         .exportConfigType("exportConfigType")
     *         // the properties below are optional
     *         .s3Destination(S3ReportExportConfigProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .encryptionDisabled(false)
     *                 .encryptionKey("encryptionKey")
     *                 .packaging("packaging")
     *                 .path("path")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnReportGroup.ReportExportConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ReportExportConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReportExportConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The export configuration type. Valid values are:.
         * <p>
         * <ul>
         * <li><code>S3</code> : The report results are exported to an S3 bucket.</li>
         * <li><code>NO_EXPORT</code> : The report results are not exported.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-exportconfigtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-exportconfigtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExportConfigType();

        /**
         * A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of a report is exported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-s3destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-s3destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Destination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReportExportConfigProperty> {
            java.lang.String exportConfigType;
            java.lang.Object s3Destination;

            /**
             * Sets the value of {@link ReportExportConfigProperty#getExportConfigType}
             * @param exportConfigType The export configuration type. Valid values are:. This parameter is required.
             *                         <ul>
             *                         <li><code>S3</code> : The report results are exported to an S3 bucket.</li>
             *                         <li><code>NO_EXPORT</code> : The report results are not exported.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportConfigType(java.lang.String exportConfigType) {
                this.exportConfigType = exportConfigType;
                return this;
            }

            /**
             * Sets the value of {@link ReportExportConfigProperty#getS3Destination}
             * @param s3Destination A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of a report is exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Destination(software.amazon.awscdk.IResolvable s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            /**
             * Sets the value of {@link ReportExportConfigProperty#getS3Destination}
             * @param s3Destination A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of a report is exported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Destination(software.amazon.awscdk.services.codebuild.CfnReportGroup.S3ReportExportConfigProperty s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReportExportConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReportExportConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReportExportConfigProperty {
            private final java.lang.String exportConfigType;
            private final java.lang.Object s3Destination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exportConfigType = software.amazon.jsii.Kernel.get(this, "exportConfigType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Destination = software.amazon.jsii.Kernel.get(this, "s3Destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exportConfigType = java.util.Objects.requireNonNull(builder.exportConfigType, "exportConfigType is required");
                this.s3Destination = builder.s3Destination;
            }

            @Override
            public final java.lang.String getExportConfigType() {
                return this.exportConfigType;
            }

            @Override
            public final java.lang.Object getS3Destination() {
                return this.s3Destination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("exportConfigType", om.valueToTree(this.getExportConfigType()));
                if (this.getS3Destination() != null) {
                    data.set("s3Destination", om.valueToTree(this.getS3Destination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnReportGroup.ReportExportConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReportExportConfigProperty.Jsii$Proxy that = (ReportExportConfigProperty.Jsii$Proxy) o;

                if (!exportConfigType.equals(that.exportConfigType)) return false;
                return this.s3Destination != null ? this.s3Destination.equals(that.s3Destination) : that.s3Destination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exportConfigType.hashCode();
                result = 31 * result + (this.s3Destination != null ? this.s3Destination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the S3 bucket where the raw data of a report are exported.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * S3ReportExportConfigProperty s3ReportExportConfigProperty = S3ReportExportConfigProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .bucketOwner("bucketOwner")
     *         .encryptionDisabled(false)
     *         .encryptionKey("encryptionKey")
     *         .packaging("packaging")
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnReportGroup.S3ReportExportConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ReportExportConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ReportExportConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket where the raw data of a report are exported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The AWS account identifier of the owner of the Amazon S3 bucket.
         * <p>
         * This allows report data to be exported to an Amazon S3 bucket that is owned by an account other than the account running the build.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
            return null;
        }

        /**
         * A boolean value that specifies if the results of a report are encrypted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptiondisabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptiondisabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionDisabled() {
            return null;
        }

        /**
         * The encryption key for the report's encrypted raw data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKey() {
            return null;
        }

        /**
         * The type of build output artifact to create. Valid values include:.
         * <p>
         * <ul>
         * <li><code>NONE</code> : CodeBuild creates the raw data in the output bucket. This is the default if packaging is not specified.</li>
         * <li><code>ZIP</code> : CodeBuild creates a ZIP file with the raw data in the output bucket.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-packaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-packaging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPackaging() {
            return null;
        }

        /**
         * The path to the exported report's raw data results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ReportExportConfigProperty> {
            java.lang.String bucket;
            java.lang.String bucketOwner;
            java.lang.Object encryptionDisabled;
            java.lang.String encryptionKey;
            java.lang.String packaging;
            java.lang.String path;

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getBucket}
             * @param bucket The name of the S3 bucket where the raw data of a report are exported. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getBucketOwner}
             * @param bucketOwner The AWS account identifier of the owner of the Amazon S3 bucket.
             *                    This allows report data to be exported to an Amazon S3 bucket that is owned by an account other than the account running the build.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwner(java.lang.String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled A boolean value that specifies if the results of a report are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(java.lang.Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled A boolean value that specifies if the results of a report are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(software.amazon.awscdk.IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getEncryptionKey}
             * @param encryptionKey The encryption key for the report's encrypted raw data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(java.lang.String encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getPackaging}
             * @param packaging The type of build output artifact to create. Valid values include:.
             *                  <ul>
             *                  <li><code>NONE</code> : CodeBuild creates the raw data in the output bucket. This is the default if packaging is not specified.</li>
             *                  <li><code>ZIP</code> : CodeBuild creates a ZIP file with the raw data in the output bucket.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packaging(java.lang.String packaging) {
                this.packaging = packaging;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getPath}
             * @param path The path to the exported report's raw data results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ReportExportConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ReportExportConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ReportExportConfigProperty {
            private final java.lang.String bucket;
            private final java.lang.String bucketOwner;
            private final java.lang.Object encryptionDisabled;
            private final java.lang.String encryptionKey;
            private final java.lang.String packaging;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionDisabled = software.amazon.jsii.Kernel.get(this, "encryptionDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.packaging = software.amazon.jsii.Kernel.get(this, "packaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.bucketOwner = builder.bucketOwner;
                this.encryptionDisabled = builder.encryptionDisabled;
                this.encryptionKey = builder.encryptionKey;
                this.packaging = builder.packaging;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getBucketOwner() {
                return this.bucketOwner;
            }

            @Override
            public final java.lang.Object getEncryptionDisabled() {
                return this.encryptionDisabled;
            }

            @Override
            public final java.lang.String getEncryptionKey() {
                return this.encryptionKey;
            }

            @Override
            public final java.lang.String getPackaging() {
                return this.packaging;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getBucketOwner() != null) {
                    data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
                }
                if (this.getEncryptionDisabled() != null) {
                    data.set("encryptionDisabled", om.valueToTree(this.getEncryptionDisabled()));
                }
                if (this.getEncryptionKey() != null) {
                    data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                }
                if (this.getPackaging() != null) {
                    data.set("packaging", om.valueToTree(this.getPackaging()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnReportGroup.S3ReportExportConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ReportExportConfigProperty.Jsii$Proxy that = (S3ReportExportConfigProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
                if (this.encryptionDisabled != null ? !this.encryptionDisabled.equals(that.encryptionDisabled) : that.encryptionDisabled != null) return false;
                if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
                if (this.packaging != null ? !this.packaging.equals(that.packaging) : that.packaging != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
                result = 31 * result + (this.encryptionDisabled != null ? this.encryptionDisabled.hashCode() : 0);
                result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
                result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.CfnReportGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.CfnReportGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.CfnReportGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.CfnReportGroupProps.Builder();
        }

        /**
         * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig</a>
         * @param exportConfig Information about the destination where the raw data of this <code>ReportGroup</code> is exported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportConfig(final software.amazon.awscdk.IResolvable exportConfig) {
            this.props.exportConfig(exportConfig);
            return this;
        }
        /**
         * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig</a>
         * @param exportConfig Information about the destination where the raw data of this <code>ReportGroup</code> is exported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportConfig(final software.amazon.awscdk.services.codebuild.CfnReportGroup.ReportExportConfigProperty exportConfig) {
            this.props.exportConfig(exportConfig);
            return this;
        }

        /**
         * The type of the <code>ReportGroup</code> . This can be one of the following values:.
         * <p>
         * <ul>
         * <li><strong>CODE_COVERAGE</strong> - The report group contains code coverage reports.</li>
         * <li><strong>TEST</strong> - The report group contains test reports.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type</a>
         * @param type The type of the <code>ReportGroup</code> . This can be one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * When deleting a report group, specifies if reports within the report group should be deleted.
         * <p>
         * <ul>
         * <li><strong>true</strong> - Deletes any reports that belong to the report group before deleting the report group.</li>
         * <li><strong>false</strong> - You must delete any reports in the report group. This is the default value. If you delete a report group that contains one or more reports, an exception is thrown.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-deletereports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-deletereports</a>
         * @param deleteReports When deleting a report group, specifies if reports within the report group should be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteReports(final java.lang.Boolean deleteReports) {
            this.props.deleteReports(deleteReports);
            return this;
        }
        /**
         * When deleting a report group, specifies if reports within the report group should be deleted.
         * <p>
         * <ul>
         * <li><strong>true</strong> - Deletes any reports that belong to the report group before deleting the report group.</li>
         * <li><strong>false</strong> - You must delete any reports in the report group. This is the default value. If you delete a report group that contains one or more reports, an exception is thrown.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-deletereports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-deletereports</a>
         * @param deleteReports When deleting a report group, specifies if reports within the report group should be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteReports(final software.amazon.awscdk.IResolvable deleteReports) {
            this.props.deleteReports(deleteReports);
            return this;
        }

        /**
         * The name of the <code>ReportGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name</a>
         * @param name The name of the <code>ReportGroup</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of tag key and value pairs associated with this report group.
         * <p>
         * These tags are available for use by AWS services that support AWS CodeBuild report group tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags</a>
         * @param tags A list of tag key and value pairs associated with this report group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.CfnReportGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.CfnReportGroup build() {
            return new software.amazon.awscdk.services.codebuild.CfnReportGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
