package software.amazon.awscdk.services.codebuild;

/**
 * A convenience class for CodeBuild Projects that are used in CodePipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Cloudfront Web Distribution
 * import software.amazon.awscdk.services.cloudfront.*;
 * Distribution distribution;
 * // Create the build project that will invalidate the cache
 * PipelineProject invalidateBuildProject = PipelineProject.Builder.create(this, "InvalidateProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("aws cloudfront create-invalidation --distribution-id ${CLOUDFRONT_ID} --paths \"/*\""))))))
 *         .environmentVariables(Map.of(
 *                 "CLOUDFRONT_ID", BuildEnvironmentVariable.builder().value(distribution.getDistributionId()).build()))
 *         .build();
 * // Add Cloudfront invalidation permissions to the project
 * String distributionArn = String.format("arn:aws:cloudfront::%s:distribution/%s", this.account, distribution.getDistributionId());
 * invalidateBuildProject.addToRolePolicy(PolicyStatement.Builder.create()
 *         .resources(List.of(distributionArn))
 *         .actions(List.of("cloudfront:CreateInvalidation"))
 *         .build());
 * // Create the pipeline (here only the S3 deploy and Invalidate cache build)
 * Bucket deployBucket = new Bucket(this, "DeployBucket");
 * Artifact deployInput = new Artifact();
 * Pipeline.Builder.create(this, "Pipeline")
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Deploy")
 *                 .actions(List.of(
 *                     S3DeployAction.Builder.create()
 *                             .actionName("S3Deploy")
 *                             .bucket(deployBucket)
 *                             .input(deployInput)
 *                             .runOrder(1)
 *                             .build(),
 *                     CodeBuildAction.Builder.create()
 *                             .actionName("InvalidateCache")
 *                             .project(invalidateBuildProject)
 *                             .input(deployInput)
 *                             .runOrder(2)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.109Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.PipelineProject")
public class PipelineProject extends software.amazon.awscdk.services.codebuild.Project {

    protected PipelineProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.PipelineProject.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PipelineProject(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.PipelineProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PipelineProject(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.PipelineProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.PipelineProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codebuild.PipelineProjectProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Whether to allow the CodeBuild to send all network traffic.
         * <p>
         * If set to false, you must individually add traffic rules to allow the
         * CodeBuild project to connect to network targets.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the CodeBuild to send all network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props().allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * CodeBuild will automatically call retry build using the project's service role up to the auto-retry limit.
         * <p>
         * <code>autoRetryLimit</code> must be between 0 and 10.
         * <p>
         * Default: - no retry
         * <p>
         * @return {@code this}
         * @param autoRetryLimit CodeBuild will automatically call retry build using the project's service role up to the auto-retry limit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRetryLimit(final java.lang.Number autoRetryLimit) {
            this.props().autoRetryLimit(autoRetryLimit);
            return this;
        }

        /**
         * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         * <p>
         * For more information, see Build Badges Sample
         * in the AWS CodeBuild User Guide.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param badge Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badge(final java.lang.Boolean badge) {
            this.props().badge(badge);
            return this;
        }

        /**
         * Filename or contents of buildspec in JSON format.
         * <p>
         * Default: - Empty buildspec.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example">https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example</a>
         * @param buildSpec Filename or contents of buildspec in JSON format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.props().buildSpec(buildSpec);
            return this;
        }

        /**
         * Caching strategy to use.
         * <p>
         * Default: Cache.none
         * <p>
         * @return {@code this}
         * @param cache Caching strategy to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.services.codebuild.Cache cache) {
            this.props().cache(cache);
            return this;
        }

        /**
         * Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param checkSecretsInPlainTextEnvVariables Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder checkSecretsInPlainTextEnvVariables(final java.lang.Boolean checkSecretsInPlainTextEnvVariables) {
            this.props().checkSecretsInPlainTextEnvVariables(checkSecretsInPlainTextEnvVariables);
            return this;
        }

        /**
         * Maximum number of concurrent builds.
         * <p>
         * Minimum value is 1 and maximum is account build limit.
         * <p>
         * Default: - no explicit limit is set
         * <p>
         * @return {@code this}
         * @param concurrentBuildLimit Maximum number of concurrent builds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrentBuildLimit(final java.lang.Number concurrentBuildLimit) {
            this.props().concurrentBuildLimit(concurrentBuildLimit);
            return this;
        }

        /**
         * A description of the project.
         * <p>
         * Use the description to identify the purpose
         * of the project.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Encryption key to use to read and write artifacts.
         * <p>
         * Default: - The AWS-managed CMK for Amazon Simple Storage Service (Amazon S3) is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey Encryption key to use to read and write artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Build environment to use for the build.
         * <p>
         * Default: BuildEnvironment.LinuxBuildImage.STANDARD_7_0
         * <p>
         * @return {@code this}
         * @param environment Build environment to use for the build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.services.codebuild.BuildEnvironment environment) {
            this.props().environment(environment);
            return this;
        }

        /**
         * Additional environment variables to add to the build environment.
         * <p>
         * Default: - No additional environment variables are specified.
         * <p>
         * @return {@code this}
         * @param environmentVariables Additional environment variables to add to the build environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.props().environmentVariables(environmentVariables);
            return this;
        }

        /**
         * An  ProjectFileSystemLocation objects for a CodeBuild build project.
         * <p>
         * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         * and type of a file system created using Amazon Elastic File System.
         * <p>
         * Default: - no file system locations
         * <p>
         * @return {@code this}
         * @param fileSystemLocations An  ProjectFileSystemLocation objects for a CodeBuild build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.props().fileSystemLocations(fileSystemLocations);
            return this;
        }

        /**
         * Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
         * <p>
         * That is the standard report group that gets created when a simple name
         * (in contrast to an ARN)
         * is used in the 'reports' section of the buildspec of this project.
         * This is usually harmless, but you can turn these off if you don't plan on using test
         * reports in this project.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html">https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html</a>
         * @param grantReportGroupPermissions Add permissions to this project's role to create and use test report groups with name starting with the name of this project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantReportGroupPermissions(final java.lang.Boolean grantReportGroupPermissions) {
            this.props().grantReportGroupPermissions(grantReportGroupPermissions);
            return this;
        }

        /**
         * Information about logs for the build project.
         * <p>
         * A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
         * <p>
         * Default: - no log configuration is set
         * <p>
         * @return {@code this}
         * @param logging Information about logs for the build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.codebuild.LoggingOptions logging) {
            this.props().logging(logging);
            return this;
        }

        /**
         * The physical, human-readable name of the CodeBuild Project.
         * <p>
         * Default: - Name is automatically generated.
         * <p>
         * @return {@code this}
         * @param projectName The physical, human-readable name of the CodeBuild Project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props().projectName(projectName);
            return this;
        }

        /**
         * The number of minutes after which AWS CodeBuild stops the build if it's still in queue.
         * <p>
         * For valid values, see the timeoutInMinutes field in the AWS
         * CodeBuild User Guide.
         * <p>
         * Default: - no queue timeout is set
         * <p>
         * @return {@code this}
         * @param queuedTimeout The number of minutes after which AWS CodeBuild stops the build if it's still in queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queuedTimeout(final software.amazon.awscdk.Duration queuedTimeout) {
            this.props().queuedTimeout(queuedTimeout);
            return this;
        }

        /**
         * Service Role to assume while running the build.
         * <p>
         * Default: - A role will be created.
         * <p>
         * @return {@code this}
         * @param role Service Role to assume while running the build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * What security group to associate with the codebuild project's network interfaces.
         * <p>
         * If no security group is identified, one will be created automatically.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - Security group will be automatically created.
         * <p>
         * @return {@code this}
         * @param securityGroups What security group to associate with the codebuild project's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * Add the permissions necessary for debugging builds with SSM Session Manager.
         * <p>
         * If the following prerequisites have been met:
         * <p>
         * <ul>
         * <li>The necessary permissions have been added by setting this flag to true.</li>
         * <li>The build image has the SSM agent installed (true for default CodeBuild images).</li>
         * <li>The build is started with <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_StartBuild.html#CodeBuild-StartBuild-request-debugSessionEnabled">debugSessionEnabled</a> set to true.</li>
         * </ul>
         * <p>
         * Then the build container can be paused and inspected using Session Manager
         * by invoking the <code>codebuild-breakpoint</code> command somewhere during the build.
         * <p>
         * <code>codebuild-breakpoint</code> commands will be ignored if the build is not started
         * with <code>debugSessionEnabled=true</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html</a>
         * @param ssmSessionPermissions Add the permissions necessary for debugging builds with SSM Session Manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmSessionPermissions(final java.lang.Boolean ssmSessionPermissions) {
            this.props().ssmSessionPermissions(ssmSessionPermissions);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * To access AWS services, your CodeBuild project needs to be in one of the following types of subnets:
         * <p>
         * <ol>
         * <li>Subnets with access to the internet (of type PRIVATE_WITH_EGRESS).</li>
         * <li>Private subnets unconnected to the internet, but with <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/use-vpc-endpoints-with-codebuild.html">VPC endpoints</a> for the necessary services.</li>
         * </ol>
         * <p>
         * If you don't specify a subnet selection, the default behavior is to use PRIVATE_WITH_EGRESS subnets first if they exist,
         * then PRIVATE_WITHOUT_EGRESS, and finally PUBLIC subnets. If your VPC doesn't have PRIVATE_WITH_EGRESS subnets but you need
         * AWS service access, add VPC Endpoints to your private subnets.
         * <p>
         * Default: - private subnets if available else public subnets
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html</a>
         * @param subnetSelection Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props().subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         * <p>
         * For valid values, see the timeoutInMinutes field in the AWS
         * CodeBuild User Guide.
         * <p>
         * Default: Duration.hours(1)
         * <p>
         * @return {@code this}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * Specifies the visibility of the project's builds.
         * <p>
         * Default: - no visibility is set
         * <p>
         * @return {@code this}
         * @param visibility Specifies the visibility of the project's builds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(final software.amazon.awscdk.services.codebuild.ProjectVisibility visibility) {
            this.props().visibility(visibility);
            return this;
        }

        /**
         * VPC network to place codebuild network interfaces.
         * <p>
         * Specify this if the codebuild project needs to access resources in a VPC.
         * <p>
         * Default: - No VPC is specified.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place codebuild network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.PipelineProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.PipelineProject build() {
            return new software.amazon.awscdk.services.codebuild.PipelineProject(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codebuild.PipelineProjectProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codebuild.PipelineProjectProps.Builder();
            }
            return this.props;
        }
    }
}
