package software.amazon.awscdk.services.codebuild;

/**
 * The type of reports in the report group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Source source;
 * // create a new ReportGroup
 * ReportGroup reportGroup = ReportGroup.Builder.create(this, "ReportGroup")
 *         .type(ReportGroupType.CODE_COVERAGE)
 *         .build();
 * Project project = Project.Builder.create(this, "Project")
 *         .source(source)
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 // ...
 *                 "reports", Map.of(
 *                         reportGroup.getReportGroupArn(), Map.of(
 *                                 "files", "**&#47;*",
 *                                 "base-directory", "build/coverage-report.xml",
 *                                 "file-format", "JACOCOXML")))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.120Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.ReportGroupType")
public enum ReportGroupType {
    /**
     * The report group contains test reports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEST,
    /**
     * The report group contains code coverage reports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CODE_COVERAGE,
}
