package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for <code>EcsDeploymentGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsApplication myApplication;
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition;
 * ITargetGroup blueTargetGroup;
 * ITargetGroup greenTargetGroup;
 * IApplicationListener listener;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.CODE_DEPLOY)
 *                 .build())
 *         .build();
 * EcsDeploymentGroup.Builder.create(this, "BlueGreenDG")
 *         .service(service)
 *         .blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig.builder()
 *                 .blueTargetGroup(blueTargetGroup)
 *                 .greenTargetGroup(greenTargetGroup)
 *                 .listener(listener)
 *                 .build())
 *         .deploymentConfig(EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.222Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.EcsDeploymentGroupProps")
@software.amazon.jsii.Jsii.Proxy(EcsDeploymentGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration options for blue-green ECS deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig getBlueGreenDeploymentConfig();

    /**
     * The ECS service to deploy with this Deployment Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IBaseService getService();

    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * <p>
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * <p>
     * Alarms can also be added after the Deployment Group is created using the <code>#addAlarm</code> method.
     * <p>
     * Default: []
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html">https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
        return null;
    }

    /**
     * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     * <p>
     * Default: One will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.IEcsApplication getApplication() {
        return null;
    }

    /**
     * The auto-rollback configuration for this Deployment Group.
     * <p>
     * Default: - default AutoRollbackConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
        return null;
    }

    /**
     * The Deployment Configuration this Deployment Group uses.
     * <p>
     * Default: EcsDeploymentConfig.ALL_AT_ONCE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig getDeploymentConfig() {
        return null;
    }

    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * <p>
     * Default: An auto-generated name will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentGroupName() {
        return null;
    }

    /**
     * Whether to skip the step of checking CloudWatch alarms during the deployment process.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreAlarmConfiguration() {
        return null;
    }

    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnorePollAlarmsFailure() {
        return null;
    }

    /**
     * The service Role of this Deployment Group.
     * <p>
     * Default: - A new Role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsDeploymentGroupProps> {
        software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig blueGreenDeploymentConfig;
        software.amazon.awscdk.services.ecs.IBaseService service;
        java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms;
        software.amazon.awscdk.services.codedeploy.IEcsApplication application;
        software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback;
        software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig;
        java.lang.String deploymentGroupName;
        java.lang.Boolean ignoreAlarmConfiguration;
        java.lang.Boolean ignorePollAlarmsFailure;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getBlueGreenDeploymentConfig}
         * @param blueGreenDeploymentConfig The configuration options for blue-green ECS deployments. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueGreenDeploymentConfig(software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig blueGreenDeploymentConfig) {
            this.blueGreenDeploymentConfig = blueGreenDeploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getService}
         * @param service The ECS service to deploy with this Deployment Group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ecs.IBaseService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getAlarms}
         * @param alarms The CloudWatch alarms associated with this Deployment Group.
         *               CodeDeploy will stop (and optionally roll back)
         *               a deployment if during it any of the alarms trigger.
         *               <p>
         *               Alarms can also be added after the Deployment Group is created using the <code>#addAlarm</code> method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder alarms(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IAlarm> alarms) {
            this.alarms = (java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm>)alarms;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getApplication}
         * @param application The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.codedeploy.IEcsApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getAutoRollback}
         * @param autoRollback The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollback(software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getDeploymentConfig}
         * @param deploymentConfig The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getDeploymentGroupName}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getIgnoreAlarmConfiguration}
         * @param ignoreAlarmConfiguration Whether to skip the step of checking CloudWatch alarms during the deployment process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreAlarmConfiguration(java.lang.Boolean ignoreAlarmConfiguration) {
            this.ignoreAlarmConfiguration = ignoreAlarmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getIgnorePollAlarmsFailure}
         * @param ignorePollAlarmsFailure Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignorePollAlarmsFailure(java.lang.Boolean ignorePollAlarmsFailure) {
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupProps#getRole}
         * @param role The service Role of this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsDeploymentGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsDeploymentGroupProps {
        private final software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig blueGreenDeploymentConfig;
        private final software.amazon.awscdk.services.ecs.IBaseService service;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms;
        private final software.amazon.awscdk.services.codedeploy.IEcsApplication application;
        private final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback;
        private final software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig;
        private final java.lang.String deploymentGroupName;
        private final java.lang.Boolean ignoreAlarmConfiguration;
        private final java.lang.Boolean ignorePollAlarmsFailure;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blueGreenDeploymentConfig = software.amazon.jsii.Kernel.get(this, "blueGreenDeploymentConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IBaseService.class));
            this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarm.class)));
            this.application = software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsApplication.class));
            this.autoRollback = software.amazon.jsii.Kernel.get(this, "autoRollback", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class));
            this.deploymentConfig = software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
            this.deploymentGroupName = software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreAlarmConfiguration = software.amazon.jsii.Kernel.get(this, "ignoreAlarmConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignorePollAlarmsFailure = software.amazon.jsii.Kernel.get(this, "ignorePollAlarmsFailure", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blueGreenDeploymentConfig = java.util.Objects.requireNonNull(builder.blueGreenDeploymentConfig, "blueGreenDeploymentConfig is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.alarms = (java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm>)builder.alarms;
            this.application = builder.application;
            this.autoRollback = builder.autoRollback;
            this.deploymentConfig = builder.deploymentConfig;
            this.deploymentGroupName = builder.deploymentGroupName;
            this.ignoreAlarmConfiguration = builder.ignoreAlarmConfiguration;
            this.ignorePollAlarmsFailure = builder.ignorePollAlarmsFailure;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig getBlueGreenDeploymentConfig() {
            return this.blueGreenDeploymentConfig;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.IBaseService getService() {
            return this.service;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
            return this.alarms;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.IEcsApplication getApplication() {
            return this.application;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.autoRollback;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        public final java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final java.lang.Boolean getIgnoreAlarmConfiguration() {
            return this.ignoreAlarmConfiguration;
        }

        @Override
        public final java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.ignorePollAlarmsFailure;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("blueGreenDeploymentConfig", om.valueToTree(this.getBlueGreenDeploymentConfig()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getAlarms() != null) {
                data.set("alarms", om.valueToTree(this.getAlarms()));
            }
            if (this.getApplication() != null) {
                data.set("application", om.valueToTree(this.getApplication()));
            }
            if (this.getAutoRollback() != null) {
                data.set("autoRollback", om.valueToTree(this.getAutoRollback()));
            }
            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }
            if (this.getDeploymentGroupName() != null) {
                data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            }
            if (this.getIgnoreAlarmConfiguration() != null) {
                data.set("ignoreAlarmConfiguration", om.valueToTree(this.getIgnoreAlarmConfiguration()));
            }
            if (this.getIgnorePollAlarmsFailure() != null) {
                data.set("ignorePollAlarmsFailure", om.valueToTree(this.getIgnorePollAlarmsFailure()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.EcsDeploymentGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsDeploymentGroupProps.Jsii$Proxy that = (EcsDeploymentGroupProps.Jsii$Proxy) o;

            if (!blueGreenDeploymentConfig.equals(that.blueGreenDeploymentConfig)) return false;
            if (!service.equals(that.service)) return false;
            if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
            if (this.application != null ? !this.application.equals(that.application) : that.application != null) return false;
            if (this.autoRollback != null ? !this.autoRollback.equals(that.autoRollback) : that.autoRollback != null) return false;
            if (this.deploymentConfig != null ? !this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig != null) return false;
            if (this.deploymentGroupName != null ? !this.deploymentGroupName.equals(that.deploymentGroupName) : that.deploymentGroupName != null) return false;
            if (this.ignoreAlarmConfiguration != null ? !this.ignoreAlarmConfiguration.equals(that.ignoreAlarmConfiguration) : that.ignoreAlarmConfiguration != null) return false;
            if (this.ignorePollAlarmsFailure != null ? !this.ignorePollAlarmsFailure.equals(that.ignorePollAlarmsFailure) : that.ignorePollAlarmsFailure != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blueGreenDeploymentConfig.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
            result = 31 * result + (this.application != null ? this.application.hashCode() : 0);
            result = 31 * result + (this.autoRollback != null ? this.autoRollback.hashCode() : 0);
            result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
            result = 31 * result + (this.deploymentGroupName != null ? this.deploymentGroupName.hashCode() : 0);
            result = 31 * result + (this.ignoreAlarmConfiguration != null ? this.ignoreAlarmConfiguration.hashCode() : 0);
            result = 31 * result + (this.ignorePollAlarmsFailure != null ? this.ignorePollAlarmsFailure.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
