package software.amazon.awscdk.services.codepipeline;

/**
 * An output artifact of an action.
 * <p>
 * Artifacts can be used as input by some actions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline pipeline;
 * Artifact sourceOutput = new Artifact();
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("CodeStarConnectionsSourceAction")
 *         .output(sourceOutput)
 *         .connectionArn("your-connection-arn")
 *         .owner("your-owner")
 *         .repo("your-repo")
 *         .build();
 * Artifact scanOutput = new Artifact();
 * InspectorSourceCodeScanAction scanAction = InspectorSourceCodeScanAction.Builder.create()
 *         .actionName("InspectorSourceCodeScanAction")
 *         .input(sourceOutput)
 *         .output(scanOutput)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Scan")
 *         .actions(List.of(scanAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.274Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Artifact")
public class Artifact extends software.amazon.jsii.JsiiObject {

    protected Artifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Artifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * An output artifact of an action.
     * <p>
     * Artifacts can be used as input by some actions.
     * <p>
     * @param artifactName the (required) name of the Artifact.
     * @param artifactFiles file paths that you want to export as the output artifact for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Artifact(final @org.jetbrains.annotations.Nullable java.lang.String artifactName, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> artifactFiles) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { artifactName, artifactFiles });
    }

    /**
     * An output artifact of an action.
     * <p>
     * Artifacts can be used as input by some actions.
     * <p>
     * @param artifactName the (required) name of the Artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Artifact(final @org.jetbrains.annotations.Nullable java.lang.String artifactName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { artifactName });
    }

    /**
     * An output artifact of an action.
     * <p>
     * Artifacts can be used as input by some actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Artifact() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A static factory method used to create instances of the Artifact class.
     * <p>
     * Mainly meant to be used from <code>decdk</code>.
     * <p>
     * @param name the (required) name of the Artifact. This parameter is required.
     * @param files file paths that you want to export as the output artifact for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact artifact(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> files) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.Artifact.class, "artifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), files });
    }

    /**
     * A static factory method used to create instances of the Artifact class.
     * <p>
     * Mainly meant to be used from <code>decdk</code>.
     * <p>
     * @param name the (required) name of the Artifact. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact artifact(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.Artifact.class, "artifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Returns an ArtifactPath for a file within this artifact.
     * <p>
     * CfnOutput is in the form "<artifact-name>::<file-name>"
     * <p>
     * @param fileName The name of the file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ArtifactPath atPath(final @org.jetbrains.annotations.NotNull java.lang.String fileName) {
        return software.amazon.jsii.Kernel.call(this, "atPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ArtifactPath.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required") });
    }

    /**
     * Retrieve the metadata stored in this artifact under the given key.
     * <p>
     * If there is no metadata stored under the given key,
     * null will be returned.
     * <p>
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMetadata(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.Kernel.call(this, "getMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Returns a token for a value inside a JSON file within this artifact.
     * <p>
     * @param jsonFile The JSON file name. This parameter is required.
     * @param keyName The hash key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParam(final @org.jetbrains.annotations.NotNull java.lang.String jsonFile, final @org.jetbrains.annotations.NotNull java.lang.String keyName) {
        return software.amazon.jsii.Kernel.call(this, "getParam", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(jsonFile, "jsonFile is required"), java.util.Objects.requireNonNull(keyName, "keyName is required") });
    }

    /**
     * Add arbitrary extra payload to the artifact under a given key.
     * <p>
     * This can be used by CodePipeline actions to communicate data between themselves.
     * If metadata was already present under the given key,
     * it will be overwritten with the new value.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadata(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "setMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The artifact attribute for the name of the S3 bucket where the artifact is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The artifact attribute for The name of the .zip file that contains the artifact that is generated by AWS CodePipeline, such as 1ABCyZZ.zip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getObjectKey() {
        return software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the location of the .zip file in S3 that this Artifact represents. Used by Lambda's <code>CfnParametersCode</code> when being deployed in a CodePipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.Location getS3Location() {
        return software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
    }

    /**
     * The artifact attribute of the Amazon Simple Storage Service (Amazon S3) URL of the artifact, such as https://s3-us-west-2.amazonaws.com/artifactstorebucket-yivczw8jma0c/test/TemplateSo/1ABCyZZ.zip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The file paths that you want to export as the output artifact for the action.
     * <p>
     * This property can only be used in artifacts for <code>CommandsAction</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArtifactFiles() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "artifactFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getArtifactName() {
        return software.amazon.jsii.Kernel.get(this, "artifactName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
