package software.amazon.awscdk.services.codepipeline;

/**
 * The action to be done when the condition is met.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 // BeforeEntry condition - checks before entering the stage
 *                 .beforeEntry(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("LambdaCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "FunctionName", "LambdaFunctionName"))
 *                                         .build()))
 *                                 .result(Result.FAIL)
 *                                 .build()))
 *                         .build())
 *                 // OnSuccess condition - checks after successful stage completion
 *                 .onSuccess(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.FAIL)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("CloudWatchCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "AlarmName1",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName2"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 // OnFailure condition - handles stage failure
 *                 .onFailure(FailureConditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.ROLLBACK)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("RollBackOnFailure")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "Alarm",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName1"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.341Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Result")
public enum Result {
    /**
     * Rollback.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ROLLBACK,
    /**
     * Failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FAIL,
    /**
     * Retry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RETRY,
    /**
     * Skip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SKIP,
}
