package software.amazon.awscdk.services.cognito;

/**
 * The mapping of user pool attributes to the attributes provided by the identity providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * UserPoolIdentityProviderAmazon.Builder.create(this, "Amazon")
 *         .clientId("amzn-client-id")
 *         .clientSecret("amzn-client-secret")
 *         .userPool(userpool)
 *         .attributeMapping(AttributeMapping.builder()
 *                 .email(ProviderAttribute.AMAZON_EMAIL)
 *                 .website(ProviderAttribute.other("url")) // use other() when an attribute is not pre-defined in the CDK
 *                 .custom(Map.of(
 *                         // custom user pool attributes go here
 *                         "uniqueId", ProviderAttribute.AMAZON_USER_ID))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.514Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.AttributeMapping")
@software.amazon.jsii.Jsii.Proxy(AttributeMapping.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AttributeMapping extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user's postal address is a required attribute.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getAddress() {
        return null;
    }

    /**
     * The user's birthday.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getBirthdate() {
        return null;
    }

    /**
     * Specify custom attribute mapping here and mapping for any standard attributes not supported yet.
     * <p>
     * Default: - no custom attribute mapping
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ProviderAttribute> getCustom() {
        return null;
    }

    /**
     * The user's e-mail address.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getEmail() {
        return null;
    }

    /**
     * The user's e-mail address is verification.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getEmailVerified() {
        return null;
    }

    /**
     * The surname or last name of user.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getFamilyName() {
        return null;
    }

    /**
     * The user's full name in displayable form.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getFullname() {
        return null;
    }

    /**
     * The user's gender.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getGender() {
        return null;
    }

    /**
     * The user's first name or give name.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getGivenName() {
        return null;
    }

    /**
     * Time, the user's information was last updated.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getLastUpdateTime() {
        return null;
    }

    /**
     * The user's locale.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getLocale() {
        return null;
    }

    /**
     * The user's middle name.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getMiddleName() {
        return null;
    }

    /**
     * The user's nickname or casual name.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getNickname() {
        return null;
    }

    /**
     * The user's telephone number.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getPhoneNumber() {
        return null;
    }

    /**
     * The user's preferred username.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getPreferredUsername() {
        return null;
    }

    /**
     * The URL to the user's profile page.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getProfilePage() {
        return null;
    }

    /**
     * The URL to the user's profile picture.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getProfilePicture() {
        return null;
    }

    /**
     * The user's time zone.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getTimezone() {
        return null;
    }

    /**
     * The URL to the user's web page or blog.
     * <p>
     * Default: - not mapped
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ProviderAttribute getWebsite() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AttributeMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AttributeMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AttributeMapping> {
        software.amazon.awscdk.services.cognito.ProviderAttribute address;
        software.amazon.awscdk.services.cognito.ProviderAttribute birthdate;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ProviderAttribute> custom;
        software.amazon.awscdk.services.cognito.ProviderAttribute email;
        software.amazon.awscdk.services.cognito.ProviderAttribute emailVerified;
        software.amazon.awscdk.services.cognito.ProviderAttribute familyName;
        software.amazon.awscdk.services.cognito.ProviderAttribute fullname;
        software.amazon.awscdk.services.cognito.ProviderAttribute gender;
        software.amazon.awscdk.services.cognito.ProviderAttribute givenName;
        software.amazon.awscdk.services.cognito.ProviderAttribute lastUpdateTime;
        software.amazon.awscdk.services.cognito.ProviderAttribute locale;
        software.amazon.awscdk.services.cognito.ProviderAttribute middleName;
        software.amazon.awscdk.services.cognito.ProviderAttribute nickname;
        software.amazon.awscdk.services.cognito.ProviderAttribute phoneNumber;
        software.amazon.awscdk.services.cognito.ProviderAttribute preferredUsername;
        software.amazon.awscdk.services.cognito.ProviderAttribute profilePage;
        software.amazon.awscdk.services.cognito.ProviderAttribute profilePicture;
        software.amazon.awscdk.services.cognito.ProviderAttribute timezone;
        software.amazon.awscdk.services.cognito.ProviderAttribute website;

        /**
         * Sets the value of {@link AttributeMapping#getAddress}
         * @param address The user's postal address is a required attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder address(software.amazon.awscdk.services.cognito.ProviderAttribute address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getBirthdate}
         * @param birthdate The user's birthday.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder birthdate(software.amazon.awscdk.services.cognito.ProviderAttribute birthdate) {
            this.birthdate = birthdate;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getCustom}
         * @param custom Specify custom attribute mapping here and mapping for any standard attributes not supported yet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder custom(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cognito.ProviderAttribute> custom) {
            this.custom = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ProviderAttribute>)custom;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getEmail}
         * @param email The user's e-mail address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(software.amazon.awscdk.services.cognito.ProviderAttribute email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getEmailVerified}
         * @param emailVerified The user's e-mail address is verification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerified(software.amazon.awscdk.services.cognito.ProviderAttribute emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getFamilyName}
         * @param familyName The surname or last name of user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder familyName(software.amazon.awscdk.services.cognito.ProviderAttribute familyName) {
            this.familyName = familyName;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getFullname}
         * @param fullname The user's full name in displayable form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullname(software.amazon.awscdk.services.cognito.ProviderAttribute fullname) {
            this.fullname = fullname;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getGender}
         * @param gender The user's gender.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gender(software.amazon.awscdk.services.cognito.ProviderAttribute gender) {
            this.gender = gender;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getGivenName}
         * @param givenName The user's first name or give name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder givenName(software.amazon.awscdk.services.cognito.ProviderAttribute givenName) {
            this.givenName = givenName;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getLastUpdateTime}
         * @param lastUpdateTime Time, the user's information was last updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUpdateTime(software.amazon.awscdk.services.cognito.ProviderAttribute lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getLocale}
         * @param locale The user's locale.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(software.amazon.awscdk.services.cognito.ProviderAttribute locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getMiddleName}
         * @param middleName The user's middle name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder middleName(software.amazon.awscdk.services.cognito.ProviderAttribute middleName) {
            this.middleName = middleName;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getNickname}
         * @param nickname The user's nickname or casual name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nickname(software.amazon.awscdk.services.cognito.ProviderAttribute nickname) {
            this.nickname = nickname;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getPhoneNumber}
         * @param phoneNumber The user's telephone number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumber(software.amazon.awscdk.services.cognito.ProviderAttribute phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getPreferredUsername}
         * @param preferredUsername The user's preferred username.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredUsername(software.amazon.awscdk.services.cognito.ProviderAttribute preferredUsername) {
            this.preferredUsername = preferredUsername;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getProfilePage}
         * @param profilePage The URL to the user's profile page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilePage(software.amazon.awscdk.services.cognito.ProviderAttribute profilePage) {
            this.profilePage = profilePage;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getProfilePicture}
         * @param profilePicture The URL to the user's profile picture.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilePicture(software.amazon.awscdk.services.cognito.ProviderAttribute profilePicture) {
            this.profilePicture = profilePicture;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getTimezone}
         * @param timezone The user's time zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(software.amazon.awscdk.services.cognito.ProviderAttribute timezone) {
            this.timezone = timezone;
            return this;
        }

        /**
         * Sets the value of {@link AttributeMapping#getWebsite}
         * @param website The URL to the user's web page or blog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder website(software.amazon.awscdk.services.cognito.ProviderAttribute website) {
            this.website = website;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AttributeMapping}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AttributeMapping build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AttributeMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeMapping {
        private final software.amazon.awscdk.services.cognito.ProviderAttribute address;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute birthdate;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ProviderAttribute> custom;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute email;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute emailVerified;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute familyName;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute fullname;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute gender;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute givenName;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute lastUpdateTime;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute locale;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute middleName;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute nickname;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute phoneNumber;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute preferredUsername;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute profilePage;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute profilePicture;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute timezone;
        private final software.amazon.awscdk.services.cognito.ProviderAttribute website;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.birthdate = software.amazon.jsii.Kernel.get(this, "birthdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.custom = software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class)));
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.emailVerified = software.amazon.jsii.Kernel.get(this, "emailVerified", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.familyName = software.amazon.jsii.Kernel.get(this, "familyName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.fullname = software.amazon.jsii.Kernel.get(this, "fullname", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.gender = software.amazon.jsii.Kernel.get(this, "gender", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.givenName = software.amazon.jsii.Kernel.get(this, "givenName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.lastUpdateTime = software.amazon.jsii.Kernel.get(this, "lastUpdateTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.middleName = software.amazon.jsii.Kernel.get(this, "middleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.nickname = software.amazon.jsii.Kernel.get(this, "nickname", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.preferredUsername = software.amazon.jsii.Kernel.get(this, "preferredUsername", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.profilePage = software.amazon.jsii.Kernel.get(this, "profilePage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.profilePicture = software.amazon.jsii.Kernel.get(this, "profilePicture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
            this.website = software.amazon.jsii.Kernel.get(this, "website", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.address = builder.address;
            this.birthdate = builder.birthdate;
            this.custom = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ProviderAttribute>)builder.custom;
            this.email = builder.email;
            this.emailVerified = builder.emailVerified;
            this.familyName = builder.familyName;
            this.fullname = builder.fullname;
            this.gender = builder.gender;
            this.givenName = builder.givenName;
            this.lastUpdateTime = builder.lastUpdateTime;
            this.locale = builder.locale;
            this.middleName = builder.middleName;
            this.nickname = builder.nickname;
            this.phoneNumber = builder.phoneNumber;
            this.preferredUsername = builder.preferredUsername;
            this.profilePage = builder.profilePage;
            this.profilePicture = builder.profilePicture;
            this.timezone = builder.timezone;
            this.website = builder.website;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getAddress() {
            return this.address;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getBirthdate() {
            return this.birthdate;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ProviderAttribute> getCustom() {
            return this.custom;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getEmail() {
            return this.email;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getEmailVerified() {
            return this.emailVerified;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getFamilyName() {
            return this.familyName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getFullname() {
            return this.fullname;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getGender() {
            return this.gender;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getGivenName() {
            return this.givenName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getLocale() {
            return this.locale;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getMiddleName() {
            return this.middleName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getNickname() {
            return this.nickname;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getPreferredUsername() {
            return this.preferredUsername;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getProfilePage() {
            return this.profilePage;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getProfilePicture() {
            return this.profilePicture;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getTimezone() {
            return this.timezone;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ProviderAttribute getWebsite() {
            return this.website;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getBirthdate() != null) {
                data.set("birthdate", om.valueToTree(this.getBirthdate()));
            }
            if (this.getCustom() != null) {
                data.set("custom", om.valueToTree(this.getCustom()));
            }
            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getEmailVerified() != null) {
                data.set("emailVerified", om.valueToTree(this.getEmailVerified()));
            }
            if (this.getFamilyName() != null) {
                data.set("familyName", om.valueToTree(this.getFamilyName()));
            }
            if (this.getFullname() != null) {
                data.set("fullname", om.valueToTree(this.getFullname()));
            }
            if (this.getGender() != null) {
                data.set("gender", om.valueToTree(this.getGender()));
            }
            if (this.getGivenName() != null) {
                data.set("givenName", om.valueToTree(this.getGivenName()));
            }
            if (this.getLastUpdateTime() != null) {
                data.set("lastUpdateTime", om.valueToTree(this.getLastUpdateTime()));
            }
            if (this.getLocale() != null) {
                data.set("locale", om.valueToTree(this.getLocale()));
            }
            if (this.getMiddleName() != null) {
                data.set("middleName", om.valueToTree(this.getMiddleName()));
            }
            if (this.getNickname() != null) {
                data.set("nickname", om.valueToTree(this.getNickname()));
            }
            if (this.getPhoneNumber() != null) {
                data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
            }
            if (this.getPreferredUsername() != null) {
                data.set("preferredUsername", om.valueToTree(this.getPreferredUsername()));
            }
            if (this.getProfilePage() != null) {
                data.set("profilePage", om.valueToTree(this.getProfilePage()));
            }
            if (this.getProfilePicture() != null) {
                data.set("profilePicture", om.valueToTree(this.getProfilePicture()));
            }
            if (this.getTimezone() != null) {
                data.set("timezone", om.valueToTree(this.getTimezone()));
            }
            if (this.getWebsite() != null) {
                data.set("website", om.valueToTree(this.getWebsite()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.AttributeMapping"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AttributeMapping.Jsii$Proxy that = (AttributeMapping.Jsii$Proxy) o;

            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.birthdate != null ? !this.birthdate.equals(that.birthdate) : that.birthdate != null) return false;
            if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            if (this.emailVerified != null ? !this.emailVerified.equals(that.emailVerified) : that.emailVerified != null) return false;
            if (this.familyName != null ? !this.familyName.equals(that.familyName) : that.familyName != null) return false;
            if (this.fullname != null ? !this.fullname.equals(that.fullname) : that.fullname != null) return false;
            if (this.gender != null ? !this.gender.equals(that.gender) : that.gender != null) return false;
            if (this.givenName != null ? !this.givenName.equals(that.givenName) : that.givenName != null) return false;
            if (this.lastUpdateTime != null ? !this.lastUpdateTime.equals(that.lastUpdateTime) : that.lastUpdateTime != null) return false;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
            if (this.middleName != null ? !this.middleName.equals(that.middleName) : that.middleName != null) return false;
            if (this.nickname != null ? !this.nickname.equals(that.nickname) : that.nickname != null) return false;
            if (this.phoneNumber != null ? !this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber != null) return false;
            if (this.preferredUsername != null ? !this.preferredUsername.equals(that.preferredUsername) : that.preferredUsername != null) return false;
            if (this.profilePage != null ? !this.profilePage.equals(that.profilePage) : that.profilePage != null) return false;
            if (this.profilePicture != null ? !this.profilePicture.equals(that.profilePicture) : that.profilePicture != null) return false;
            if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) return false;
            return this.website != null ? this.website.equals(that.website) : that.website == null;
        }

        @Override
        public final int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.birthdate != null ? this.birthdate.hashCode() : 0);
            result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
            result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
            result = 31 * result + (this.emailVerified != null ? this.emailVerified.hashCode() : 0);
            result = 31 * result + (this.familyName != null ? this.familyName.hashCode() : 0);
            result = 31 * result + (this.fullname != null ? this.fullname.hashCode() : 0);
            result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
            result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
            result = 31 * result + (this.lastUpdateTime != null ? this.lastUpdateTime.hashCode() : 0);
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
            result = 31 * result + (this.nickname != null ? this.nickname.hashCode() : 0);
            result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
            result = 31 * result + (this.preferredUsername != null ? this.preferredUsername.hashCode() : 0);
            result = 31 * result + (this.profilePage != null ? this.profilePage.hashCode() : 0);
            result = 31 * result + (this.profilePicture != null ? this.profilePicture.hashCode() : 0);
            result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
            result = 31 * result + (this.website != null ? this.website.hashCode() : 0);
            return result;
        }
    }
}
