package software.amazon.awscdk.services.cognito;

/**
 * A set of attributes, useful to set Read and Write attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * ClientAttributes clientWriteAttributes = (new ClientAttributes()).withStandardAttributes(StandardAttributesMask.builder().fullname(true).email(true).build()).withCustomAttributes("favoritePizza", "favoriteBeverage");
 * ClientAttributes clientReadAttributes = clientWriteAttributes.withStandardAttributes(StandardAttributesMask.builder().emailVerified(true).build()).withCustomAttributes("pointsEarned");
 * pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .readAttributes(clientReadAttributes)
 *         .writeAttributes(clientWriteAttributes)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.613Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.ClientAttributes")
public class ClientAttributes extends software.amazon.jsii.JsiiObject {

    protected ClientAttributes(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClientAttributes(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a ClientAttributes with the specified attributes.
     * <p>
     * Default: - a ClientAttributes object without any attributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ClientAttributes() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The list of attributes represented by this ClientAttributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> attributes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "attributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Creates a custom ClientAttributes with the specified attributes.
     * <p>
     * @param attributes a list of custom attributes to add to the set. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.ClientAttributes withCustomAttributes(final @org.jetbrains.annotations.NotNull java.lang.String... attributes) {
        return software.amazon.jsii.Kernel.call(this, "withCustomAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ClientAttributes.class), java.util.Arrays.<Object>stream(attributes).toArray(Object[]::new));
    }

    /**
     * Creates a custom ClientAttributes with the specified attributes.
     * <p>
     * @param attributes a list of standard attributes to add to the set. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.ClientAttributes withStandardAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.StandardAttributesMask attributes) {
        return software.amazon.jsii.Kernel.call(this, "withStandardAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ClientAttributes.class), new Object[] { java.util.Objects.requireNonNull(attributes, "attributes is required") });
    }
}
