package software.amazon.awscdk.services.cognito;

/**
 * The branding version of managed login for the domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * // Use the new managed login page
 * pool.addDomain("CognitoDomainWithBlandingDesignManagedLogin", UserPoolDomainOptions.builder()
 *         .cognitoDomain(CognitoDomainOptions.builder()
 *                 .domainPrefix("blanding-design-ui")
 *                 .build())
 *         .managedLoginVersion(ManagedLoginVersion.NEWER_MANAGED_LOGIN)
 *         .build());
 * // Use the classic hosted UI
 * pool.addDomain("DomainWithClassicHostedUi", UserPoolDomainOptions.builder()
 *         .cognitoDomain(CognitoDomainOptions.builder()
 *                 .domainPrefix("classic-hosted-ui")
 *                 .build())
 *         .managedLoginVersion(ManagedLoginVersion.CLASSIC_HOSTED_UI)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.621Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.ManagedLoginVersion")
public enum ManagedLoginVersion {
    /**
     * The classic hosted UI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLASSIC_HOSTED_UI,
    /**
     * The newer managed login with the branding designer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEWER_MANAGED_LOGIN,
}
