package software.amazon.awscdk.services.config;

/**
 * Properties for defining a <code>CfnRemediationConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * Object parameters;
 * CfnRemediationConfigurationProps cfnRemediationConfigurationProps = CfnRemediationConfigurationProps.builder()
 *         .configRuleName("configRuleName")
 *         .targetId("targetId")
 *         .targetType("targetType")
 *         // the properties below are optional
 *         .automatic(false)
 *         .executionControls(ExecutionControlsProperty.builder()
 *                 .ssmControls(SsmControlsProperty.builder()
 *                         .concurrentExecutionRatePercentage(123)
 *                         .errorPercentage(123)
 *                         .build())
 *                 .build())
 *         .maximumAutomaticAttempts(123)
 *         .parameters(parameters)
 *         .resourceType("resourceType")
 *         .retryAttemptSeconds(123)
 *         .targetVersion("targetVersion")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.767Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnRemediationConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnRemediationConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRemediationConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the AWS Config rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-configrulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-configrulename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigRuleName();

    /**
     * Target ID is the name of the SSM document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetId();

    /**
     * The type of the target.
     * <p>
     * Target executes remediation. For example, SSM document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targettype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetType();

    /**
     * The remediation is triggered automatically.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-automatic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-automatic</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutomatic() {
        return null;
    }

    /**
     * An ExecutionControls object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-executioncontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-executioncontrols</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExecutionControls() {
        return null;
    }

    /**
     * The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
     * <p>
     * For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, AWS Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-maximumautomaticattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-maximumautomaticattempts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumAutomaticAttempts() {
        return null;
    }

    /**
     * An object of the RemediationParameterValue. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RemediationParameterValue.html">RemediationParameterValue</a> .
     * <p>
     * <blockquote>
     * <p>
     * The type is a map of strings to RemediationParameterValue.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * The type of a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-resourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts.
     * <p>
     * If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code> , a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.
     * <p>
     * For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, AWS Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-retryattemptseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-retryattemptseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttemptSeconds() {
        return null;
    }

    /**
     * Version of the target. For example, version of the SSM document.
     * <p>
     * <blockquote>
     * <p>
     * If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRemediationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRemediationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRemediationConfigurationProps> {
        java.lang.String configRuleName;
        java.lang.String targetId;
        java.lang.String targetType;
        java.lang.Object automatic;
        java.lang.Object executionControls;
        java.lang.Number maximumAutomaticAttempts;
        java.lang.Object parameters;
        java.lang.String resourceType;
        java.lang.Number retryAttemptSeconds;
        java.lang.String targetVersion;

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getConfigRuleName}
         * @param configRuleName The name of the AWS Config rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(java.lang.String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getTargetId}
         * @param targetId Target ID is the name of the SSM document. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetId(java.lang.String targetId) {
            this.targetId = targetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getTargetType}
         * @param targetType The type of the target. This parameter is required.
         *                   Target executes remediation. For example, SSM document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getAutomatic}
         * @param automatic The remediation is triggered automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatic(java.lang.Boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getAutomatic}
         * @param automatic The remediation is triggered automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatic(software.amazon.awscdk.IResolvable automatic) {
            this.automatic = automatic;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getExecutionControls}
         * @param executionControls An ExecutionControls object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionControls(software.amazon.awscdk.IResolvable executionControls) {
            this.executionControls = executionControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getExecutionControls}
         * @param executionControls An ExecutionControls object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionControls(software.amazon.awscdk.services.config.CfnRemediationConfiguration.ExecutionControlsProperty executionControls) {
            this.executionControls = executionControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getMaximumAutomaticAttempts}
         * @param maximumAutomaticAttempts The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
         *                                 For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, AWS Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumAutomaticAttempts(java.lang.Number maximumAutomaticAttempts) {
            this.maximumAutomaticAttempts = maximumAutomaticAttempts;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getParameters}
         * @param parameters An object of the RemediationParameterValue. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RemediationParameterValue.html">RemediationParameterValue</a> .
         *                   <blockquote>
         *                   <p>
         *                   The type is a map of strings to RemediationParameterValue.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getResourceType}
         * @param resourceType The type of a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getRetryAttemptSeconds}
         * @param retryAttemptSeconds Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts.
         *                            If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code> , a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.
         *                            <p>
         *                            For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, AWS Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttemptSeconds(java.lang.Number retryAttemptSeconds) {
            this.retryAttemptSeconds = retryAttemptSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnRemediationConfigurationProps#getTargetVersion}
         * @param targetVersion Version of the target. For example, version of the SSM document.
         *                      <blockquote>
         *                      <p>
         *                      If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetVersion(java.lang.String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRemediationConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRemediationConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRemediationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRemediationConfigurationProps {
        private final java.lang.String configRuleName;
        private final java.lang.String targetId;
        private final java.lang.String targetType;
        private final java.lang.Object automatic;
        private final java.lang.Object executionControls;
        private final java.lang.Number maximumAutomaticAttempts;
        private final java.lang.Object parameters;
        private final java.lang.String resourceType;
        private final java.lang.Number retryAttemptSeconds;
        private final java.lang.String targetVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configRuleName = software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetId = software.amazon.jsii.Kernel.get(this, "targetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automatic = software.amazon.jsii.Kernel.get(this, "automatic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionControls = software.amazon.jsii.Kernel.get(this, "executionControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumAutomaticAttempts = software.amazon.jsii.Kernel.get(this, "maximumAutomaticAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retryAttemptSeconds = software.amazon.jsii.Kernel.get(this, "retryAttemptSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetVersion = software.amazon.jsii.Kernel.get(this, "targetVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configRuleName = java.util.Objects.requireNonNull(builder.configRuleName, "configRuleName is required");
            this.targetId = java.util.Objects.requireNonNull(builder.targetId, "targetId is required");
            this.targetType = java.util.Objects.requireNonNull(builder.targetType, "targetType is required");
            this.automatic = builder.automatic;
            this.executionControls = builder.executionControls;
            this.maximumAutomaticAttempts = builder.maximumAutomaticAttempts;
            this.parameters = builder.parameters;
            this.resourceType = builder.resourceType;
            this.retryAttemptSeconds = builder.retryAttemptSeconds;
            this.targetVersion = builder.targetVersion;
        }

        @Override
        public final java.lang.String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final java.lang.String getTargetId() {
            return this.targetId;
        }

        @Override
        public final java.lang.String getTargetType() {
            return this.targetType;
        }

        @Override
        public final java.lang.Object getAutomatic() {
            return this.automatic;
        }

        @Override
        public final java.lang.Object getExecutionControls() {
            return this.executionControls;
        }

        @Override
        public final java.lang.Number getMaximumAutomaticAttempts() {
            return this.maximumAutomaticAttempts;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.lang.Number getRetryAttemptSeconds() {
            return this.retryAttemptSeconds;
        }

        @Override
        public final java.lang.String getTargetVersion() {
            return this.targetVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configRuleName", om.valueToTree(this.getConfigRuleName()));
            data.set("targetId", om.valueToTree(this.getTargetId()));
            data.set("targetType", om.valueToTree(this.getTargetType()));
            if (this.getAutomatic() != null) {
                data.set("automatic", om.valueToTree(this.getAutomatic()));
            }
            if (this.getExecutionControls() != null) {
                data.set("executionControls", om.valueToTree(this.getExecutionControls()));
            }
            if (this.getMaximumAutomaticAttempts() != null) {
                data.set("maximumAutomaticAttempts", om.valueToTree(this.getMaximumAutomaticAttempts()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }
            if (this.getRetryAttemptSeconds() != null) {
                data.set("retryAttemptSeconds", om.valueToTree(this.getRetryAttemptSeconds()));
            }
            if (this.getTargetVersion() != null) {
                data.set("targetVersion", om.valueToTree(this.getTargetVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnRemediationConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRemediationConfigurationProps.Jsii$Proxy that = (CfnRemediationConfigurationProps.Jsii$Proxy) o;

            if (!configRuleName.equals(that.configRuleName)) return false;
            if (!targetId.equals(that.targetId)) return false;
            if (!targetType.equals(that.targetType)) return false;
            if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) return false;
            if (this.executionControls != null ? !this.executionControls.equals(that.executionControls) : that.executionControls != null) return false;
            if (this.maximumAutomaticAttempts != null ? !this.maximumAutomaticAttempts.equals(that.maximumAutomaticAttempts) : that.maximumAutomaticAttempts != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
            if (this.retryAttemptSeconds != null ? !this.retryAttemptSeconds.equals(that.retryAttemptSeconds) : that.retryAttemptSeconds != null) return false;
            return this.targetVersion != null ? this.targetVersion.equals(that.targetVersion) : that.targetVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configRuleName.hashCode();
            result = 31 * result + (this.targetId.hashCode());
            result = 31 * result + (this.targetType.hashCode());
            result = 31 * result + (this.automatic != null ? this.automatic.hashCode() : 0);
            result = 31 * result + (this.executionControls != null ? this.executionControls.hashCode() : 0);
            result = 31 * result + (this.maximumAutomaticAttempts != null ? this.maximumAutomaticAttempts.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            result = 31 * result + (this.retryAttemptSeconds != null ? this.retryAttemptSeconds.hashCode() : 0);
            result = 31 * result + (this.targetVersion != null ? this.targetVersion.hashCode() : 0);
            return result;
        }
    }
}
