package software.amazon.awscdk.services.connect;

/**
 * <em>This is a preview release for Amazon Connect . It is subject to change.</em>.
 * <p>
 * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis.
 * <p>
 * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnInstance cfnInstance = CfnInstance.Builder.create(this, "MyCfnInstance")
 *         .attributes(AttributesProperty.builder()
 *                 .inboundCalls(false)
 *                 .outboundCalls(false)
 *                 // the properties below are optional
 *                 .autoResolveBestVoices(false)
 *                 .contactflowLogs(false)
 *                 .contactLens(false)
 *                 .earlyMedia(false)
 *                 .useCustomTtsVoices(false)
 *                 .build())
 *         .identityManagementType("identityManagementType")
 *         // the properties below are optional
 *         .directoryId("directoryId")
 *         .instanceAlias("instanceAlias")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:52.842Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When the instance was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     * <p>
     * You can find the instanceId in the ARN of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInstanceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrInstanceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service role of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A toggle for an individual feature at the instance level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A toggle for an individual feature at the instance level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributes", java.util.Objects.requireNonNull(value, "attributes is required"));
    }

    /**
     * A toggle for an individual feature at the instance level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnInstance.AttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "attributes", java.util.Objects.requireNonNull(value, "attributes is required"));
    }

    /**
     * The identity management type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityManagementType() {
        return software.amazon.jsii.Kernel.get(this, "identityManagementType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identity management type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityManagementType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityManagementType", java.util.Objects.requireNonNull(value, "identityManagementType is required"));
    }

    /**
     * The identifier for the directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDirectoryId() {
        return software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDirectoryId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "directoryId", value);
    }

    /**
     * The alias of instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceAlias() {
        return software.amazon.jsii.Kernel.get(this, "instanceAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The alias of instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceAlias(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceAlias", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * *This is a preview release for Amazon Connect .
     * <p>
     * It is subject to change.*
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * AttributesProperty attributesProperty = AttributesProperty.builder()
     *         .inboundCalls(false)
     *         .outboundCalls(false)
     *         // the properties below are optional
     *         .autoResolveBestVoices(false)
     *         .contactflowLogs(false)
     *         .contactLens(false)
     *         .earlyMedia(false)
     *         .useCustomTtsVoices(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnInstance.AttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Mandatory element which enables inbound calls on new instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-inboundcalls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-inboundcalls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInboundCalls();

        /**
         * Mandatory element which enables outbound calls on new instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-outboundcalls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-outboundcalls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundCalls();

        /**
         * Boolean flag which enables AUTO_RESOLVE_BEST_VOICES on an instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-autoresolvebestvoices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-autoresolvebestvoices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoResolveBestVoices() {
            return null;
        }

        /**
         * Boolean flag which enables CONTACTFLOW_LOGS on an instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-contactflowlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-contactflowlogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContactflowLogs() {
            return null;
        }

        /**
         * Boolean flag which enables CONTACT_LENS on an instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-contactlens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-contactlens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContactLens() {
            return null;
        }

        /**
         * Boolean flag which enables EARLY_MEDIA on an instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-earlymedia">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-earlymedia</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEarlyMedia() {
            return null;
        }

        /**
         * Boolean flag which enables USE_CUSTOM_TTS_VOICES on an instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-usecustomttsvoices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-instance-attributes.html#cfn-connect-instance-attributes-usecustomttsvoices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseCustomTtsVoices() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributesProperty> {
            java.lang.Object inboundCalls;
            java.lang.Object outboundCalls;
            java.lang.Object autoResolveBestVoices;
            java.lang.Object contactflowLogs;
            java.lang.Object contactLens;
            java.lang.Object earlyMedia;
            java.lang.Object useCustomTtsVoices;

            /**
             * Sets the value of {@link AttributesProperty#getInboundCalls}
             * @param inboundCalls Mandatory element which enables inbound calls on new instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundCalls(java.lang.Boolean inboundCalls) {
                this.inboundCalls = inboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getInboundCalls}
             * @param inboundCalls Mandatory element which enables inbound calls on new instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundCalls(software.amazon.awscdk.IResolvable inboundCalls) {
                this.inboundCalls = inboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getOutboundCalls}
             * @param outboundCalls Mandatory element which enables outbound calls on new instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundCalls(java.lang.Boolean outboundCalls) {
                this.outboundCalls = outboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getOutboundCalls}
             * @param outboundCalls Mandatory element which enables outbound calls on new instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundCalls(software.amazon.awscdk.IResolvable outboundCalls) {
                this.outboundCalls = outboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getAutoResolveBestVoices}
             * @param autoResolveBestVoices Boolean flag which enables AUTO_RESOLVE_BEST_VOICES on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoResolveBestVoices(java.lang.Boolean autoResolveBestVoices) {
                this.autoResolveBestVoices = autoResolveBestVoices;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getAutoResolveBestVoices}
             * @param autoResolveBestVoices Boolean flag which enables AUTO_RESOLVE_BEST_VOICES on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoResolveBestVoices(software.amazon.awscdk.IResolvable autoResolveBestVoices) {
                this.autoResolveBestVoices = autoResolveBestVoices;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactflowLogs}
             * @param contactflowLogs Boolean flag which enables CONTACTFLOW_LOGS on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactflowLogs(java.lang.Boolean contactflowLogs) {
                this.contactflowLogs = contactflowLogs;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactflowLogs}
             * @param contactflowLogs Boolean flag which enables CONTACTFLOW_LOGS on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactflowLogs(software.amazon.awscdk.IResolvable contactflowLogs) {
                this.contactflowLogs = contactflowLogs;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactLens}
             * @param contactLens Boolean flag which enables CONTACT_LENS on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactLens(java.lang.Boolean contactLens) {
                this.contactLens = contactLens;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactLens}
             * @param contactLens Boolean flag which enables CONTACT_LENS on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactLens(software.amazon.awscdk.IResolvable contactLens) {
                this.contactLens = contactLens;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getEarlyMedia}
             * @param earlyMedia Boolean flag which enables EARLY_MEDIA on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder earlyMedia(java.lang.Boolean earlyMedia) {
                this.earlyMedia = earlyMedia;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getEarlyMedia}
             * @param earlyMedia Boolean flag which enables EARLY_MEDIA on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder earlyMedia(software.amazon.awscdk.IResolvable earlyMedia) {
                this.earlyMedia = earlyMedia;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getUseCustomTtsVoices}
             * @param useCustomTtsVoices Boolean flag which enables USE_CUSTOM_TTS_VOICES on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCustomTtsVoices(java.lang.Boolean useCustomTtsVoices) {
                this.useCustomTtsVoices = useCustomTtsVoices;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getUseCustomTtsVoices}
             * @param useCustomTtsVoices Boolean flag which enables USE_CUSTOM_TTS_VOICES on an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCustomTtsVoices(software.amazon.awscdk.IResolvable useCustomTtsVoices) {
                this.useCustomTtsVoices = useCustomTtsVoices;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributesProperty {
            private final java.lang.Object inboundCalls;
            private final java.lang.Object outboundCalls;
            private final java.lang.Object autoResolveBestVoices;
            private final java.lang.Object contactflowLogs;
            private final java.lang.Object contactLens;
            private final java.lang.Object earlyMedia;
            private final java.lang.Object useCustomTtsVoices;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inboundCalls = software.amazon.jsii.Kernel.get(this, "inboundCalls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundCalls = software.amazon.jsii.Kernel.get(this, "outboundCalls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoResolveBestVoices = software.amazon.jsii.Kernel.get(this, "autoResolveBestVoices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contactflowLogs = software.amazon.jsii.Kernel.get(this, "contactflowLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contactLens = software.amazon.jsii.Kernel.get(this, "contactLens", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.earlyMedia = software.amazon.jsii.Kernel.get(this, "earlyMedia", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useCustomTtsVoices = software.amazon.jsii.Kernel.get(this, "useCustomTtsVoices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inboundCalls = java.util.Objects.requireNonNull(builder.inboundCalls, "inboundCalls is required");
                this.outboundCalls = java.util.Objects.requireNonNull(builder.outboundCalls, "outboundCalls is required");
                this.autoResolveBestVoices = builder.autoResolveBestVoices;
                this.contactflowLogs = builder.contactflowLogs;
                this.contactLens = builder.contactLens;
                this.earlyMedia = builder.earlyMedia;
                this.useCustomTtsVoices = builder.useCustomTtsVoices;
            }

            @Override
            public final java.lang.Object getInboundCalls() {
                return this.inboundCalls;
            }

            @Override
            public final java.lang.Object getOutboundCalls() {
                return this.outboundCalls;
            }

            @Override
            public final java.lang.Object getAutoResolveBestVoices() {
                return this.autoResolveBestVoices;
            }

            @Override
            public final java.lang.Object getContactflowLogs() {
                return this.contactflowLogs;
            }

            @Override
            public final java.lang.Object getContactLens() {
                return this.contactLens;
            }

            @Override
            public final java.lang.Object getEarlyMedia() {
                return this.earlyMedia;
            }

            @Override
            public final java.lang.Object getUseCustomTtsVoices() {
                return this.useCustomTtsVoices;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inboundCalls", om.valueToTree(this.getInboundCalls()));
                data.set("outboundCalls", om.valueToTree(this.getOutboundCalls()));
                if (this.getAutoResolveBestVoices() != null) {
                    data.set("autoResolveBestVoices", om.valueToTree(this.getAutoResolveBestVoices()));
                }
                if (this.getContactflowLogs() != null) {
                    data.set("contactflowLogs", om.valueToTree(this.getContactflowLogs()));
                }
                if (this.getContactLens() != null) {
                    data.set("contactLens", om.valueToTree(this.getContactLens()));
                }
                if (this.getEarlyMedia() != null) {
                    data.set("earlyMedia", om.valueToTree(this.getEarlyMedia()));
                }
                if (this.getUseCustomTtsVoices() != null) {
                    data.set("useCustomTtsVoices", om.valueToTree(this.getUseCustomTtsVoices()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnInstance.AttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributesProperty.Jsii$Proxy that = (AttributesProperty.Jsii$Proxy) o;

                if (!inboundCalls.equals(that.inboundCalls)) return false;
                if (!outboundCalls.equals(that.outboundCalls)) return false;
                if (this.autoResolveBestVoices != null ? !this.autoResolveBestVoices.equals(that.autoResolveBestVoices) : that.autoResolveBestVoices != null) return false;
                if (this.contactflowLogs != null ? !this.contactflowLogs.equals(that.contactflowLogs) : that.contactflowLogs != null) return false;
                if (this.contactLens != null ? !this.contactLens.equals(that.contactLens) : that.contactLens != null) return false;
                if (this.earlyMedia != null ? !this.earlyMedia.equals(that.earlyMedia) : that.earlyMedia != null) return false;
                return this.useCustomTtsVoices != null ? this.useCustomTtsVoices.equals(that.useCustomTtsVoices) : that.useCustomTtsVoices == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inboundCalls.hashCode();
                result = 31 * result + (this.outboundCalls.hashCode());
                result = 31 * result + (this.autoResolveBestVoices != null ? this.autoResolveBestVoices.hashCode() : 0);
                result = 31 * result + (this.contactflowLogs != null ? this.contactflowLogs.hashCode() : 0);
                result = 31 * result + (this.contactLens != null ? this.contactLens.hashCode() : 0);
                result = 31 * result + (this.earlyMedia != null ? this.earlyMedia.hashCode() : 0);
                result = 31 * result + (this.useCustomTtsVoices != null ? this.useCustomTtsVoices.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnInstanceProps.Builder();
        }

        /**
         * A toggle for an individual feature at the instance level.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-attributes</a>
         * @param attributes A toggle for an individual feature at the instance level. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }
        /**
         * A toggle for an individual feature at the instance level.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-attributes</a>
         * @param attributes A toggle for an individual feature at the instance level. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.services.connect.CfnInstance.AttributesProperty attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * The identity management type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-identitymanagementtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-identitymanagementtype</a>
         * @param identityManagementType The identity management type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityManagementType(final java.lang.String identityManagementType) {
            this.props.identityManagementType(identityManagementType);
            return this;
        }

        /**
         * The identifier for the directory.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-directoryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-directoryid</a>
         * @param directoryId The identifier for the directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryId(final java.lang.String directoryId) {
            this.props.directoryId(directoryId);
            return this;
        }

        /**
         * The alias of instance.
         * <p>
         * <code>InstanceAlias</code> is only required when <code>IdentityManagementType</code> is <code>CONNECT_MANAGED</code> or <code>SAML</code> . <code>InstanceAlias</code> is not required when <code>IdentityManagementType</code> is <code>EXISTING_DIRECTORY</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-instancealias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-instancealias</a>
         * @param instanceAlias The alias of instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceAlias(final java.lang.String instanceAlias) {
            this.props.instanceAlias(instanceAlias);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-instance.html#cfn-connect-instance-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connect.CfnInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnInstance build() {
            return new software.amazon.awscdk.services.connect.CfnInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
