package software.amazon.awscdk.services.datazone;

/**
 * In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and environments) to external resources and services.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnConnection cfnConnection = CfnConnection.Builder.create(this, "MyCfnConnection")
 *         .domainIdentifier("domainIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .name("name")
 *         // the properties below are optional
 *         .awsLocation(AwsLocationProperty.builder()
 *                 .accessRole("accessRole")
 *                 .awsAccountId("awsAccountId")
 *                 .awsRegion("awsRegion")
 *                 .iamConnectionId("iamConnectionId")
 *                 .build())
 *         .description("description")
 *         .props(ConnectionPropertiesInputProperty.builder()
 *                 .athenaProperties(AthenaPropertiesInputProperty.builder()
 *                         .workgroupName("workgroupName")
 *                         .build())
 *                 .glueProperties(GluePropertiesInputProperty.builder()
 *                         .glueConnectionInput(GlueConnectionInputProperty.builder()
 *                                 .athenaProperties(Map.of(
 *                                         "athenaPropertiesKey", "athenaProperties"))
 *                                 .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
 *                                         .authenticationType("authenticationType")
 *                                         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
 *                                                 .password("password")
 *                                                 .userName("userName")
 *                                                 .build())
 *                                         .customAuthenticationCredentials(Map.of(
 *                                                 "customAuthenticationCredentialsKey", "customAuthenticationCredentials"))
 *                                         .kmsKeyArn("kmsKeyArn")
 *                                         .oAuth2Properties(OAuth2PropertiesProperty.builder()
 *                                                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
 *                                                         .authorizationCode("authorizationCode")
 *                                                         .redirectUri("redirectUri")
 *                                                         .build())
 *                                                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
 *                                                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
 *                                                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
 *                                                         .build())
 *                                                 .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
 *                                                         .accessToken("accessToken")
 *                                                         .jwtToken("jwtToken")
 *                                                         .refreshToken("refreshToken")
 *                                                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
 *                                                         .build())
 *                                                 .oAuth2GrantType("oAuth2GrantType")
 *                                                 .tokenUrl("tokenUrl")
 *                                                 .tokenUrlParametersMap(Map.of(
 *                                                         "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
 *                                                 .build())
 *                                         .secretArn("secretArn")
 *                                         .build())
 *                                 .connectionProperties(Map.of(
 *                                         "connectionPropertiesKey", "connectionProperties"))
 *                                 .connectionType("connectionType")
 *                                 .description("description")
 *                                 .matchCriteria("matchCriteria")
 *                                 .name("name")
 *                                 .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
 *                                         .availabilityZone("availabilityZone")
 *                                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                                         .subnetId("subnetId")
 *                                         .subnetIdList(List.of("subnetIdList"))
 *                                         .build())
 *                                 .pythonProperties(Map.of(
 *                                         "pythonPropertiesKey", "pythonProperties"))
 *                                 .sparkProperties(Map.of(
 *                                         "sparkPropertiesKey", "sparkProperties"))
 *                                 .validateCredentials(false)
 *                                 .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
 *                                 .build())
 *                         .build())
 *                 .hyperPodProperties(HyperPodPropertiesInputProperty.builder()
 *                         .clusterName("clusterName")
 *                         .build())
 *                 .iamProperties(IamPropertiesInputProperty.builder()
 *                         .glueLineageSyncEnabled(false)
 *                         .build())
 *                 .redshiftProperties(RedshiftPropertiesInputProperty.builder()
 *                         .credentials(RedshiftCredentialsProperty.builder()
 *                                 .secretArn("secretArn")
 *                                 .usernamePassword(UsernamePasswordProperty.builder()
 *                                         .password("password")
 *                                         .username("username")
 *                                         .build())
 *                                 .build())
 *                         .databaseName("databaseName")
 *                         .host("host")
 *                         .lineageSync(RedshiftLineageSyncConfigurationInputProperty.builder()
 *                                 .enabled(false)
 *                                 .schedule(LineageSyncScheduleProperty.builder()
 *                                         .schedule("schedule")
 *                                         .build())
 *                                 .build())
 *                         .port(123)
 *                         .storage(RedshiftStoragePropertiesProperty.builder()
 *                                 .clusterName("clusterName")
 *                                 .workgroupName("workgroupName")
 *                                 .build())
 *                         .build())
 *                 .sparkEmrProperties(SparkEmrPropertiesInputProperty.builder()
 *                         .computeArn("computeArn")
 *                         .instanceProfileArn("instanceProfileArn")
 *                         .javaVirtualEnv("javaVirtualEnv")
 *                         .logUri("logUri")
 *                         .pythonVirtualEnv("pythonVirtualEnv")
 *                         .runtimeRole("runtimeRole")
 *                         .trustedCertificatesS3Uri("trustedCertificatesS3Uri")
 *                         .build())
 *                 .sparkGlueProperties(SparkGluePropertiesInputProperty.builder()
 *                         .additionalArgs(SparkGlueArgsProperty.builder()
 *                                 .connection("connection")
 *                                 .build())
 *                         .glueConnectionName("glueConnectionName")
 *                         .glueVersion("glueVersion")
 *                         .idleTimeout(123)
 *                         .javaVirtualEnv("javaVirtualEnv")
 *                         .numberOfWorkers(123)
 *                         .pythonVirtualEnv("pythonVirtualEnv")
 *                         .workerType("workerType")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:53.164Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection")
public class CfnConnection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datazone.CfnConnection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datazone.CfnConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectionId() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain ID of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainId() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain unit ID of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainUnitId() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The environment user role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentUserRole() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentUserRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectId() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrType() {
        return software.amazon.jsii.Kernel.get(this, "attrType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the domain where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the domain where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainIdentifier", java.util.Objects.requireNonNull(value, "domainIdentifier is required"));
    }

    /**
     * The ID of the environment where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the environment where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentIdentifier", java.util.Objects.requireNonNull(value, "environmentIdentifier is required"));
    }

    /**
     * The name of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The location where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAwsLocation() {
        return software.amazon.jsii.Kernel.get(this, "awsLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The location where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "awsLocation", value);
    }

    /**
     * The location where the connection is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnConnection.AwsLocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "awsLocation", value);
    }

    /**
     * Connection description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Connection description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Connection props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Connection props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "props", value);
    }

    /**
     * Connection props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnConnection.ConnectionPropertiesInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "props", value);
    }
    /**
     * The Amazon Athena properties of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * AthenaPropertiesInputProperty athenaPropertiesInputProperty = AthenaPropertiesInputProperty.builder()
     *         .workgroupName("workgroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-athenapropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-athenapropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.AthenaPropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(AthenaPropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AthenaPropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Athena workgroup name of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-athenapropertiesinput.html#cfn-datazone-connection-athenapropertiesinput-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-athenapropertiesinput.html#cfn-datazone-connection-athenapropertiesinput-workgroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkgroupName();

        /**
         * @return a {@link Builder} of {@link AthenaPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AthenaPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AthenaPropertiesInputProperty> {
            java.lang.String workgroupName;

            /**
             * Sets the value of {@link AthenaPropertiesInputProperty#getWorkgroupName}
             * @param workgroupName The Amazon Athena workgroup name of a connection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupName(java.lang.String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AthenaPropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AthenaPropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AthenaPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AthenaPropertiesInputProperty {
            private final java.lang.String workgroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workgroupName = software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workgroupName = java.util.Objects.requireNonNull(builder.workgroupName, "workgroupName is required");
            }

            @Override
            public final java.lang.String getWorkgroupName() {
                return this.workgroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workgroupName", om.valueToTree(this.getWorkgroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.AthenaPropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AthenaPropertiesInputProperty.Jsii$Proxy that = (AthenaPropertiesInputProperty.Jsii$Proxy) o;

                return this.workgroupName.equals(that.workgroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.workgroupName.hashCode();
                return result;
            }
        }
    }
    /**
     * The authentication configuration of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * AuthenticationConfigurationInputProperty authenticationConfigurationInputProperty = AuthenticationConfigurationInputProperty.builder()
     *         .authenticationType("authenticationType")
     *         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
     *                 .password("password")
     *                 .userName("userName")
     *                 .build())
     *         .customAuthenticationCredentials(Map.of(
     *                 "customAuthenticationCredentialsKey", "customAuthenticationCredentials"))
     *         .kmsKeyArn("kmsKeyArn")
     *         .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                         .authorizationCode("authorizationCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                         .build())
     *                 .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .jwtToken("jwtToken")
     *                         .refreshToken("refreshToken")
     *                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                         .build())
     *                 .oAuth2GrantType("oAuth2GrantType")
     *                 .tokenUrl("tokenUrl")
     *                 .tokenUrlParametersMap(Map.of(
     *                         "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
     *                 .build())
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.AuthenticationConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticationConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticationConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authentication type of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
            return null;
        }

        /**
         * The basic authentication credentials of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-basicauthenticationcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-basicauthenticationcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthenticationCredentials() {
            return null;
        }

        /**
         * The custom authentication credentials of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-customauthenticationcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-customauthenticationcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAuthenticationCredentials() {
            return null;
        }

        /**
         * The KMS key ARN of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * The oAuth2 properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-oauth2properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-oauth2properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2Properties() {
            return null;
        }

        /**
         * The secret ARN of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authenticationconfigurationinput.html#cfn-datazone-connection-authenticationconfigurationinput-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticationConfigurationInputProperty> {
            java.lang.String authenticationType;
            java.lang.Object basicAuthenticationCredentials;
            java.lang.Object customAuthenticationCredentials;
            java.lang.String kmsKeyArn;
            java.lang.Object oAuth2Properties;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getAuthenticationType}
             * @param authenticationType The authentication type of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getBasicAuthenticationCredentials}
             * @param basicAuthenticationCredentials The basic authentication credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthenticationCredentials(software.amazon.awscdk.IResolvable basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getBasicAuthenticationCredentials}
             * @param basicAuthenticationCredentials The basic authentication credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthenticationCredentials(software.amazon.awscdk.services.datazone.CfnConnection.BasicAuthenticationCredentialsProperty basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getCustomAuthenticationCredentials}
             * @param customAuthenticationCredentials The custom authentication credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAuthenticationCredentials(java.util.Map<java.lang.String, java.lang.String> customAuthenticationCredentials) {
                this.customAuthenticationCredentials = customAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getCustomAuthenticationCredentials}
             * @param customAuthenticationCredentials The custom authentication credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAuthenticationCredentials(software.amazon.awscdk.IResolvable customAuthenticationCredentials) {
                this.customAuthenticationCredentials = customAuthenticationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getKmsKeyArn}
             * @param kmsKeyArn The KMS key ARN of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getOAuth2Properties}
             * @param oAuth2Properties The oAuth2 properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Properties(software.amazon.awscdk.IResolvable oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getOAuth2Properties}
             * @param oAuth2Properties The oAuth2 properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Properties(software.amazon.awscdk.services.datazone.CfnConnection.OAuth2PropertiesProperty oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationInputProperty#getSecretArn}
             * @param secretArn The secret ARN of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticationConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticationConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticationConfigurationInputProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object basicAuthenticationCredentials;
            private final java.lang.Object customAuthenticationCredentials;
            private final java.lang.String kmsKeyArn;
            private final java.lang.Object oAuth2Properties;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.basicAuthenticationCredentials = software.amazon.jsii.Kernel.get(this, "basicAuthenticationCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAuthenticationCredentials = software.amazon.jsii.Kernel.get(this, "customAuthenticationCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuth2Properties = software.amazon.jsii.Kernel.get(this, "oAuth2Properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = builder.authenticationType;
                this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
                this.customAuthenticationCredentials = builder.customAuthenticationCredentials;
                this.kmsKeyArn = builder.kmsKeyArn;
                this.oAuth2Properties = builder.oAuth2Properties;
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getBasicAuthenticationCredentials() {
                return this.basicAuthenticationCredentials;
            }

            @Override
            public final java.lang.Object getCustomAuthenticationCredentials() {
                return this.customAuthenticationCredentials;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.Object getOAuth2Properties() {
                return this.oAuth2Properties;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthenticationType() != null) {
                    data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                }
                if (this.getBasicAuthenticationCredentials() != null) {
                    data.set("basicAuthenticationCredentials", om.valueToTree(this.getBasicAuthenticationCredentials()));
                }
                if (this.getCustomAuthenticationCredentials() != null) {
                    data.set("customAuthenticationCredentials", om.valueToTree(this.getCustomAuthenticationCredentials()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getOAuth2Properties() != null) {
                    data.set("oAuth2Properties", om.valueToTree(this.getOAuth2Properties()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.AuthenticationConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticationConfigurationInputProperty.Jsii$Proxy that = (AuthenticationConfigurationInputProperty.Jsii$Proxy) o;

                if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
                if (this.basicAuthenticationCredentials != null ? !this.basicAuthenticationCredentials.equals(that.basicAuthenticationCredentials) : that.basicAuthenticationCredentials != null) return false;
                if (this.customAuthenticationCredentials != null ? !this.customAuthenticationCredentials.equals(that.customAuthenticationCredentials) : that.customAuthenticationCredentials != null) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                if (this.oAuth2Properties != null ? !this.oAuth2Properties.equals(that.oAuth2Properties) : that.oAuth2Properties != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType != null ? this.authenticationType.hashCode() : 0;
                result = 31 * result + (this.basicAuthenticationCredentials != null ? this.basicAuthenticationCredentials.hashCode() : 0);
                result = 31 * result + (this.customAuthenticationCredentials != null ? this.customAuthenticationCredentials.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.oAuth2Properties != null ? this.oAuth2Properties.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The authorization code properties of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * AuthorizationCodePropertiesProperty authorizationCodePropertiesProperty = AuthorizationCodePropertiesProperty.builder()
     *         .authorizationCode("authorizationCode")
     *         .redirectUri("redirectUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authorizationcodeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authorizationcodeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.AuthorizationCodePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationCodePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationCodePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization code of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authorizationcodeproperties.html#cfn-datazone-connection-authorizationcodeproperties-authorizationcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authorizationcodeproperties.html#cfn-datazone-connection-authorizationcodeproperties-authorizationcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationCode() {
            return null;
        }

        /**
         * The redirect URI of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authorizationcodeproperties.html#cfn-datazone-connection-authorizationcodeproperties-redirecturi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-authorizationcodeproperties.html#cfn-datazone-connection-authorizationcodeproperties-redirecturi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRedirectUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizationCodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationCodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationCodePropertiesProperty> {
            java.lang.String authorizationCode;
            java.lang.String redirectUri;

            /**
             * Sets the value of {@link AuthorizationCodePropertiesProperty#getAuthorizationCode}
             * @param authorizationCode The authorization code of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationCode(java.lang.String authorizationCode) {
                this.authorizationCode = authorizationCode;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationCodePropertiesProperty#getRedirectUri}
             * @param redirectUri The redirect URI of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectUri(java.lang.String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationCodePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationCodePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationCodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationCodePropertiesProperty {
            private final java.lang.String authorizationCode;
            private final java.lang.String redirectUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationCode = software.amazon.jsii.Kernel.get(this, "authorizationCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redirectUri = software.amazon.jsii.Kernel.get(this, "redirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationCode = builder.authorizationCode;
                this.redirectUri = builder.redirectUri;
            }

            @Override
            public final java.lang.String getAuthorizationCode() {
                return this.authorizationCode;
            }

            @Override
            public final java.lang.String getRedirectUri() {
                return this.redirectUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizationCode() != null) {
                    data.set("authorizationCode", om.valueToTree(this.getAuthorizationCode()));
                }
                if (this.getRedirectUri() != null) {
                    data.set("redirectUri", om.valueToTree(this.getRedirectUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.AuthorizationCodePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationCodePropertiesProperty.Jsii$Proxy that = (AuthorizationCodePropertiesProperty.Jsii$Proxy) o;

                if (this.authorizationCode != null ? !this.authorizationCode.equals(that.authorizationCode) : that.authorizationCode != null) return false;
                return this.redirectUri != null ? this.redirectUri.equals(that.redirectUri) : that.redirectUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationCode != null ? this.authorizationCode.hashCode() : 0;
                result = 31 * result + (this.redirectUri != null ? this.redirectUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location of a project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * AwsLocationProperty awsLocationProperty = AwsLocationProperty.builder()
     *         .accessRole("accessRole")
     *         .awsAccountId("awsAccountId")
     *         .awsRegion("awsRegion")
     *         .iamConnectionId("iamConnectionId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.AwsLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access role of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-accessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-accessrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessRole() {
            return null;
        }

        /**
         * The account ID of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-awsaccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
            return null;
        }

        /**
         * The Region of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * The IAM connection ID of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-iamconnectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-awslocation.html#cfn-datazone-connection-awslocation-iamconnectionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamConnectionId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsLocationProperty> {
            java.lang.String accessRole;
            java.lang.String awsAccountId;
            java.lang.String awsRegion;
            java.lang.String iamConnectionId;

            /**
             * Sets the value of {@link AwsLocationProperty#getAccessRole}
             * @param accessRole The access role of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessRole(java.lang.String accessRole) {
                this.accessRole = accessRole;
                return this;
            }

            /**
             * Sets the value of {@link AwsLocationProperty#getAwsAccountId}
             * @param awsAccountId The account ID of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(java.lang.String awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link AwsLocationProperty#getAwsRegion}
             * @param awsRegion The Region of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link AwsLocationProperty#getIamConnectionId}
             * @param iamConnectionId The IAM connection ID of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamConnectionId(java.lang.String iamConnectionId) {
                this.iamConnectionId = iamConnectionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsLocationProperty {
            private final java.lang.String accessRole;
            private final java.lang.String awsAccountId;
            private final java.lang.String awsRegion;
            private final java.lang.String iamConnectionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessRole = software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamConnectionId = software.amazon.jsii.Kernel.get(this, "iamConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessRole = builder.accessRole;
                this.awsAccountId = builder.awsAccountId;
                this.awsRegion = builder.awsRegion;
                this.iamConnectionId = builder.iamConnectionId;
            }

            @Override
            public final java.lang.String getAccessRole() {
                return this.accessRole;
            }

            @Override
            public final java.lang.String getAwsAccountId() {
                return this.awsAccountId;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getIamConnectionId() {
                return this.iamConnectionId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessRole() != null) {
                    data.set("accessRole", om.valueToTree(this.getAccessRole()));
                }
                if (this.getAwsAccountId() != null) {
                    data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getIamConnectionId() != null) {
                    data.set("iamConnectionId", om.valueToTree(this.getIamConnectionId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.AwsLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsLocationProperty.Jsii$Proxy that = (AwsLocationProperty.Jsii$Proxy) o;

                if (this.accessRole != null ? !this.accessRole.equals(that.accessRole) : that.accessRole != null) return false;
                if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                return this.iamConnectionId != null ? this.iamConnectionId.equals(that.iamConnectionId) : that.iamConnectionId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessRole != null ? this.accessRole.hashCode() : 0;
                result = 31 * result + (this.awsAccountId != null ? this.awsAccountId.hashCode() : 0);
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.iamConnectionId != null ? this.iamConnectionId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The basic authentication credentials of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * BasicAuthenticationCredentialsProperty basicAuthenticationCredentialsProperty = BasicAuthenticationCredentialsProperty.builder()
     *         .password("password")
     *         .userName("userName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-basicauthenticationcredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-basicauthenticationcredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.BasicAuthenticationCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(BasicAuthenticationCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BasicAuthenticationCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password for a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-basicauthenticationcredentials.html#cfn-datazone-connection-basicauthenticationcredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-basicauthenticationcredentials.html#cfn-datazone-connection-basicauthenticationcredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The user name for the connecion.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-basicauthenticationcredentials.html#cfn-datazone-connection-basicauthenticationcredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-basicauthenticationcredentials.html#cfn-datazone-connection-basicauthenticationcredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BasicAuthenticationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BasicAuthenticationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BasicAuthenticationCredentialsProperty> {
            java.lang.String password;
            java.lang.String userName;

            /**
             * Sets the value of {@link BasicAuthenticationCredentialsProperty#getPassword}
             * @param password The password for a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthenticationCredentialsProperty#getUserName}
             * @param userName The user name for the connecion.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userName(java.lang.String userName) {
                this.userName = userName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BasicAuthenticationCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BasicAuthenticationCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BasicAuthenticationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthenticationCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String userName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = builder.password;
                this.userName = builder.userName;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUserName() {
                return this.userName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUserName() != null) {
                    data.set("userName", om.valueToTree(this.getUserName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.BasicAuthenticationCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BasicAuthenticationCredentialsProperty.Jsii$Proxy that = (BasicAuthenticationCredentialsProperty.Jsii$Proxy) o;

                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password != null ? this.password.hashCode() : 0;
                result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * ConnectionPropertiesInputProperty connectionPropertiesInputProperty = ConnectionPropertiesInputProperty.builder()
     *         .athenaProperties(AthenaPropertiesInputProperty.builder()
     *                 .workgroupName("workgroupName")
     *                 .build())
     *         .glueProperties(GluePropertiesInputProperty.builder()
     *                 .glueConnectionInput(GlueConnectionInputProperty.builder()
     *                         .athenaProperties(Map.of(
     *                                 "athenaPropertiesKey", "athenaProperties"))
     *                         .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
     *                                 .authenticationType("authenticationType")
     *                                 .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
     *                                         .password("password")
     *                                         .userName("userName")
     *                                         .build())
     *                                 .customAuthenticationCredentials(Map.of(
     *                                         "customAuthenticationCredentialsKey", "customAuthenticationCredentials"))
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                                         .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                                                 .authorizationCode("authorizationCode")
     *                                                 .redirectUri("redirectUri")
     *                                                 .build())
     *                                         .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                                                 .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                                                 .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                                                 .build())
     *                                         .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
     *                                                 .accessToken("accessToken")
     *                                                 .jwtToken("jwtToken")
     *                                                 .refreshToken("refreshToken")
     *                                                 .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                                                 .build())
     *                                         .oAuth2GrantType("oAuth2GrantType")
     *                                         .tokenUrl("tokenUrl")
     *                                         .tokenUrlParametersMap(Map.of(
     *                                                 "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
     *                                         .build())
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .connectionProperties(Map.of(
     *                                 "connectionPropertiesKey", "connectionProperties"))
     *                         .connectionType("connectionType")
     *                         .description("description")
     *                         .matchCriteria("matchCriteria")
     *                         .name("name")
     *                         .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
     *                                 .availabilityZone("availabilityZone")
     *                                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                                 .subnetId("subnetId")
     *                                 .subnetIdList(List.of("subnetIdList"))
     *                                 .build())
     *                         .pythonProperties(Map.of(
     *                                 "pythonPropertiesKey", "pythonProperties"))
     *                         .sparkProperties(Map.of(
     *                                 "sparkPropertiesKey", "sparkProperties"))
     *                         .validateCredentials(false)
     *                         .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
     *                         .build())
     *                 .build())
     *         .hyperPodProperties(HyperPodPropertiesInputProperty.builder()
     *                 .clusterName("clusterName")
     *                 .build())
     *         .iamProperties(IamPropertiesInputProperty.builder()
     *                 .glueLineageSyncEnabled(false)
     *                 .build())
     *         .redshiftProperties(RedshiftPropertiesInputProperty.builder()
     *                 .credentials(RedshiftCredentialsProperty.builder()
     *                         .secretArn("secretArn")
     *                         .usernamePassword(UsernamePasswordProperty.builder()
     *                                 .password("password")
     *                                 .username("username")
     *                                 .build())
     *                         .build())
     *                 .databaseName("databaseName")
     *                 .host("host")
     *                 .lineageSync(RedshiftLineageSyncConfigurationInputProperty.builder()
     *                         .enabled(false)
     *                         .schedule(LineageSyncScheduleProperty.builder()
     *                                 .schedule("schedule")
     *                                 .build())
     *                         .build())
     *                 .port(123)
     *                 .storage(RedshiftStoragePropertiesProperty.builder()
     *                         .clusterName("clusterName")
     *                         .workgroupName("workgroupName")
     *                         .build())
     *                 .build())
     *         .sparkEmrProperties(SparkEmrPropertiesInputProperty.builder()
     *                 .computeArn("computeArn")
     *                 .instanceProfileArn("instanceProfileArn")
     *                 .javaVirtualEnv("javaVirtualEnv")
     *                 .logUri("logUri")
     *                 .pythonVirtualEnv("pythonVirtualEnv")
     *                 .runtimeRole("runtimeRole")
     *                 .trustedCertificatesS3Uri("trustedCertificatesS3Uri")
     *                 .build())
     *         .sparkGlueProperties(SparkGluePropertiesInputProperty.builder()
     *                 .additionalArgs(SparkGlueArgsProperty.builder()
     *                         .connection("connection")
     *                         .build())
     *                 .glueConnectionName("glueConnectionName")
     *                 .glueVersion("glueVersion")
     *                 .idleTimeout(123)
     *                 .javaVirtualEnv("javaVirtualEnv")
     *                 .numberOfWorkers(123)
     *                 .pythonVirtualEnv("pythonVirtualEnv")
     *                 .workerType("workerType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.ConnectionPropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionPropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionPropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Athena properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-athenaproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-athenaproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAthenaProperties() {
            return null;
        }

        /**
         * The AWS Glue properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-glueproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-glueproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueProperties() {
            return null;
        }

        /**
         * The hyper pod properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-hyperpodproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-hyperpodproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHyperPodProperties() {
            return null;
        }

        /**
         * The IAM properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-iamproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-iamproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamProperties() {
            return null;
        }

        /**
         * The Amazon Redshift properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-redshiftproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-redshiftproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftProperties() {
            return null;
        }

        /**
         * The Spark EMR properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-sparkemrproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-sparkemrproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSparkEmrProperties() {
            return null;
        }

        /**
         * The Spark AWS Glue properties of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-sparkglueproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-connectionpropertiesinput.html#cfn-datazone-connection-connectionpropertiesinput-sparkglueproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSparkGlueProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionPropertiesInputProperty> {
            java.lang.Object athenaProperties;
            java.lang.Object glueProperties;
            java.lang.Object hyperPodProperties;
            java.lang.Object iamProperties;
            java.lang.Object redshiftProperties;
            java.lang.Object sparkEmrProperties;
            java.lang.Object sparkGlueProperties;

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getAthenaProperties}
             * @param athenaProperties The Amazon Athena properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaProperties(software.amazon.awscdk.IResolvable athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getAthenaProperties}
             * @param athenaProperties The Amazon Athena properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaProperties(software.amazon.awscdk.services.datazone.CfnConnection.AthenaPropertiesInputProperty athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getGlueProperties}
             * @param glueProperties The AWS Glue properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueProperties(software.amazon.awscdk.IResolvable glueProperties) {
                this.glueProperties = glueProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getGlueProperties}
             * @param glueProperties The AWS Glue properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueProperties(software.amazon.awscdk.services.datazone.CfnConnection.GluePropertiesInputProperty glueProperties) {
                this.glueProperties = glueProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getHyperPodProperties}
             * @param hyperPodProperties The hyper pod properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hyperPodProperties(software.amazon.awscdk.IResolvable hyperPodProperties) {
                this.hyperPodProperties = hyperPodProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getHyperPodProperties}
             * @param hyperPodProperties The hyper pod properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hyperPodProperties(software.amazon.awscdk.services.datazone.CfnConnection.HyperPodPropertiesInputProperty hyperPodProperties) {
                this.hyperPodProperties = hyperPodProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getIamProperties}
             * @param iamProperties The IAM properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamProperties(software.amazon.awscdk.IResolvable iamProperties) {
                this.iamProperties = iamProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getIamProperties}
             * @param iamProperties The IAM properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamProperties(software.amazon.awscdk.services.datazone.CfnConnection.IamPropertiesInputProperty iamProperties) {
                this.iamProperties = iamProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getRedshiftProperties}
             * @param redshiftProperties The Amazon Redshift properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftProperties(software.amazon.awscdk.IResolvable redshiftProperties) {
                this.redshiftProperties = redshiftProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getRedshiftProperties}
             * @param redshiftProperties The Amazon Redshift properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftProperties(software.amazon.awscdk.services.datazone.CfnConnection.RedshiftPropertiesInputProperty redshiftProperties) {
                this.redshiftProperties = redshiftProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getSparkEmrProperties}
             * @param sparkEmrProperties The Spark EMR properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkEmrProperties(software.amazon.awscdk.IResolvable sparkEmrProperties) {
                this.sparkEmrProperties = sparkEmrProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getSparkEmrProperties}
             * @param sparkEmrProperties The Spark EMR properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkEmrProperties(software.amazon.awscdk.services.datazone.CfnConnection.SparkEmrPropertiesInputProperty sparkEmrProperties) {
                this.sparkEmrProperties = sparkEmrProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getSparkGlueProperties}
             * @param sparkGlueProperties The Spark AWS Glue properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkGlueProperties(software.amazon.awscdk.IResolvable sparkGlueProperties) {
                this.sparkGlueProperties = sparkGlueProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPropertiesInputProperty#getSparkGlueProperties}
             * @param sparkGlueProperties The Spark AWS Glue properties of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkGlueProperties(software.amazon.awscdk.services.datazone.CfnConnection.SparkGluePropertiesInputProperty sparkGlueProperties) {
                this.sparkGlueProperties = sparkGlueProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionPropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionPropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionPropertiesInputProperty {
            private final java.lang.Object athenaProperties;
            private final java.lang.Object glueProperties;
            private final java.lang.Object hyperPodProperties;
            private final java.lang.Object iamProperties;
            private final java.lang.Object redshiftProperties;
            private final java.lang.Object sparkEmrProperties;
            private final java.lang.Object sparkGlueProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.athenaProperties = software.amazon.jsii.Kernel.get(this, "athenaProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.glueProperties = software.amazon.jsii.Kernel.get(this, "glueProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hyperPodProperties = software.amazon.jsii.Kernel.get(this, "hyperPodProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iamProperties = software.amazon.jsii.Kernel.get(this, "iamProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftProperties = software.amazon.jsii.Kernel.get(this, "redshiftProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sparkEmrProperties = software.amazon.jsii.Kernel.get(this, "sparkEmrProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sparkGlueProperties = software.amazon.jsii.Kernel.get(this, "sparkGlueProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.athenaProperties = builder.athenaProperties;
                this.glueProperties = builder.glueProperties;
                this.hyperPodProperties = builder.hyperPodProperties;
                this.iamProperties = builder.iamProperties;
                this.redshiftProperties = builder.redshiftProperties;
                this.sparkEmrProperties = builder.sparkEmrProperties;
                this.sparkGlueProperties = builder.sparkGlueProperties;
            }

            @Override
            public final java.lang.Object getAthenaProperties() {
                return this.athenaProperties;
            }

            @Override
            public final java.lang.Object getGlueProperties() {
                return this.glueProperties;
            }

            @Override
            public final java.lang.Object getHyperPodProperties() {
                return this.hyperPodProperties;
            }

            @Override
            public final java.lang.Object getIamProperties() {
                return this.iamProperties;
            }

            @Override
            public final java.lang.Object getRedshiftProperties() {
                return this.redshiftProperties;
            }

            @Override
            public final java.lang.Object getSparkEmrProperties() {
                return this.sparkEmrProperties;
            }

            @Override
            public final java.lang.Object getSparkGlueProperties() {
                return this.sparkGlueProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAthenaProperties() != null) {
                    data.set("athenaProperties", om.valueToTree(this.getAthenaProperties()));
                }
                if (this.getGlueProperties() != null) {
                    data.set("glueProperties", om.valueToTree(this.getGlueProperties()));
                }
                if (this.getHyperPodProperties() != null) {
                    data.set("hyperPodProperties", om.valueToTree(this.getHyperPodProperties()));
                }
                if (this.getIamProperties() != null) {
                    data.set("iamProperties", om.valueToTree(this.getIamProperties()));
                }
                if (this.getRedshiftProperties() != null) {
                    data.set("redshiftProperties", om.valueToTree(this.getRedshiftProperties()));
                }
                if (this.getSparkEmrProperties() != null) {
                    data.set("sparkEmrProperties", om.valueToTree(this.getSparkEmrProperties()));
                }
                if (this.getSparkGlueProperties() != null) {
                    data.set("sparkGlueProperties", om.valueToTree(this.getSparkGlueProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.ConnectionPropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionPropertiesInputProperty.Jsii$Proxy that = (ConnectionPropertiesInputProperty.Jsii$Proxy) o;

                if (this.athenaProperties != null ? !this.athenaProperties.equals(that.athenaProperties) : that.athenaProperties != null) return false;
                if (this.glueProperties != null ? !this.glueProperties.equals(that.glueProperties) : that.glueProperties != null) return false;
                if (this.hyperPodProperties != null ? !this.hyperPodProperties.equals(that.hyperPodProperties) : that.hyperPodProperties != null) return false;
                if (this.iamProperties != null ? !this.iamProperties.equals(that.iamProperties) : that.iamProperties != null) return false;
                if (this.redshiftProperties != null ? !this.redshiftProperties.equals(that.redshiftProperties) : that.redshiftProperties != null) return false;
                if (this.sparkEmrProperties != null ? !this.sparkEmrProperties.equals(that.sparkEmrProperties) : that.sparkEmrProperties != null) return false;
                return this.sparkGlueProperties != null ? this.sparkGlueProperties.equals(that.sparkGlueProperties) : that.sparkGlueProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.athenaProperties != null ? this.athenaProperties.hashCode() : 0;
                result = 31 * result + (this.glueProperties != null ? this.glueProperties.hashCode() : 0);
                result = 31 * result + (this.hyperPodProperties != null ? this.hyperPodProperties.hashCode() : 0);
                result = 31 * result + (this.iamProperties != null ? this.iamProperties.hashCode() : 0);
                result = 31 * result + (this.redshiftProperties != null ? this.redshiftProperties.hashCode() : 0);
                result = 31 * result + (this.sparkEmrProperties != null ? this.sparkEmrProperties.hashCode() : 0);
                result = 31 * result + (this.sparkGlueProperties != null ? this.sparkGlueProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The AWS Glue connecton input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * GlueConnectionInputProperty glueConnectionInputProperty = GlueConnectionInputProperty.builder()
     *         .athenaProperties(Map.of(
     *                 "athenaPropertiesKey", "athenaProperties"))
     *         .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
     *                 .authenticationType("authenticationType")
     *                 .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
     *                         .password("password")
     *                         .userName("userName")
     *                         .build())
     *                 .customAuthenticationCredentials(Map.of(
     *                         "customAuthenticationCredentialsKey", "customAuthenticationCredentials"))
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                         .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                                 .authorizationCode("authorizationCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                                 .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                                 .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                                 .build())
     *                         .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
     *                                 .accessToken("accessToken")
     *                                 .jwtToken("jwtToken")
     *                                 .refreshToken("refreshToken")
     *                                 .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                                 .build())
     *                         .oAuth2GrantType("oAuth2GrantType")
     *                         .tokenUrl("tokenUrl")
     *                         .tokenUrlParametersMap(Map.of(
     *                                 "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
     *                         .build())
     *                 .secretArn("secretArn")
     *                 .build())
     *         .connectionProperties(Map.of(
     *                 "connectionPropertiesKey", "connectionProperties"))
     *         .connectionType("connectionType")
     *         .description("description")
     *         .matchCriteria("matchCriteria")
     *         .name("name")
     *         .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                 .subnetId("subnetId")
     *                 .subnetIdList(List.of("subnetIdList"))
     *                 .build())
     *         .pythonProperties(Map.of(
     *                 "pythonPropertiesKey", "pythonProperties"))
     *         .sparkProperties(Map.of(
     *                 "sparkPropertiesKey", "sparkProperties"))
     *         .validateCredentials(false)
     *         .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.GlueConnectionInputProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueConnectionInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueConnectionInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Athena properties of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-athenaproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-athenaproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAthenaProperties() {
            return null;
        }

        /**
         * The authentication configuration of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-authenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-authenticationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationConfiguration() {
            return null;
        }

        /**
         * The connection properties of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-connectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-connectionproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionProperties() {
            return null;
        }

        /**
         * The connection type of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-connectiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-connectiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
            return null;
        }

        /**
         * The description of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The match criteria of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-matchcriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-matchcriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMatchCriteria() {
            return null;
        }

        /**
         * The name of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The physical connection requirements for the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-physicalconnectionrequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-physicalconnectionrequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalConnectionRequirements() {
            return null;
        }

        /**
         * The Python properties of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-pythonproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-pythonproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPythonProperties() {
            return null;
        }

        /**
         * The Spark properties of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-sparkproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-sparkproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSparkProperties() {
            return null;
        }

        /**
         * Speciefies whether to validate credentials of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-validatecredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-validatecredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidateCredentials() {
            return null;
        }

        /**
         * Speciefies whether to validate for compute environments of the AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-validateforcomputeenvironments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueconnectioninput.html#cfn-datazone-connection-glueconnectioninput-validateforcomputeenvironments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValidateForComputeEnvironments() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlueConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueConnectionInputProperty> {
            java.lang.Object athenaProperties;
            java.lang.Object authenticationConfiguration;
            java.lang.Object connectionProperties;
            java.lang.String connectionType;
            java.lang.String description;
            java.lang.String matchCriteria;
            java.lang.String name;
            java.lang.Object physicalConnectionRequirements;
            java.lang.Object pythonProperties;
            java.lang.Object sparkProperties;
            java.lang.Object validateCredentials;
            java.util.List<java.lang.String> validateForComputeEnvironments;

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getAthenaProperties}
             * @param athenaProperties The Amazon Athena properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaProperties(java.util.Map<java.lang.String, java.lang.String> athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getAthenaProperties}
             * @param athenaProperties The Amazon Athena properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaProperties(software.amazon.awscdk.IResolvable athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The authentication configuration of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The authentication configuration of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.datazone.CfnConnection.AuthenticationConfigurationInputProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getConnectionProperties}
             * @param connectionProperties The connection properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionProperties(java.util.Map<java.lang.String, java.lang.String> connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getConnectionProperties}
             * @param connectionProperties The connection properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionProperties(software.amazon.awscdk.IResolvable connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getConnectionType}
             * @param connectionType The connection type of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getDescription}
             * @param description The description of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getMatchCriteria}
             * @param matchCriteria The match criteria of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchCriteria(java.lang.String matchCriteria) {
                this.matchCriteria = matchCriteria;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getName}
             * @param name The name of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getPhysicalConnectionRequirements}
             * @param physicalConnectionRequirements The physical connection requirements for the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalConnectionRequirements(software.amazon.awscdk.IResolvable physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getPhysicalConnectionRequirements}
             * @param physicalConnectionRequirements The physical connection requirements for the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalConnectionRequirements(software.amazon.awscdk.services.datazone.CfnConnection.PhysicalConnectionRequirementsProperty physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getPythonProperties}
             * @param pythonProperties The Python properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pythonProperties(java.util.Map<java.lang.String, java.lang.String> pythonProperties) {
                this.pythonProperties = pythonProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getPythonProperties}
             * @param pythonProperties The Python properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pythonProperties(software.amazon.awscdk.IResolvable pythonProperties) {
                this.pythonProperties = pythonProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getSparkProperties}
             * @param sparkProperties The Spark properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkProperties(java.util.Map<java.lang.String, java.lang.String> sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getSparkProperties}
             * @param sparkProperties The Spark properties of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkProperties(software.amazon.awscdk.IResolvable sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getValidateCredentials}
             * @param validateCredentials Speciefies whether to validate credentials of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateCredentials(java.lang.Boolean validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getValidateCredentials}
             * @param validateCredentials Speciefies whether to validate credentials of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateCredentials(software.amazon.awscdk.IResolvable validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            /**
             * Sets the value of {@link GlueConnectionInputProperty#getValidateForComputeEnvironments}
             * @param validateForComputeEnvironments Speciefies whether to validate for compute environments of the AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateForComputeEnvironments(java.util.List<java.lang.String> validateForComputeEnvironments) {
                this.validateForComputeEnvironments = validateForComputeEnvironments;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueConnectionInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueConnectionInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueConnectionInputProperty {
            private final java.lang.Object athenaProperties;
            private final java.lang.Object authenticationConfiguration;
            private final java.lang.Object connectionProperties;
            private final java.lang.String connectionType;
            private final java.lang.String description;
            private final java.lang.String matchCriteria;
            private final java.lang.String name;
            private final java.lang.Object physicalConnectionRequirements;
            private final java.lang.Object pythonProperties;
            private final java.lang.Object sparkProperties;
            private final java.lang.Object validateCredentials;
            private final java.util.List<java.lang.String> validateForComputeEnvironments;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.athenaProperties = software.amazon.jsii.Kernel.get(this, "athenaProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionProperties = software.amazon.jsii.Kernel.get(this, "connectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchCriteria = software.amazon.jsii.Kernel.get(this, "matchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.physicalConnectionRequirements = software.amazon.jsii.Kernel.get(this, "physicalConnectionRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pythonProperties = software.amazon.jsii.Kernel.get(this, "pythonProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sparkProperties = software.amazon.jsii.Kernel.get(this, "sparkProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateCredentials = software.amazon.jsii.Kernel.get(this, "validateCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateForComputeEnvironments = software.amazon.jsii.Kernel.get(this, "validateForComputeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.athenaProperties = builder.athenaProperties;
                this.authenticationConfiguration = builder.authenticationConfiguration;
                this.connectionProperties = builder.connectionProperties;
                this.connectionType = builder.connectionType;
                this.description = builder.description;
                this.matchCriteria = builder.matchCriteria;
                this.name = builder.name;
                this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
                this.pythonProperties = builder.pythonProperties;
                this.sparkProperties = builder.sparkProperties;
                this.validateCredentials = builder.validateCredentials;
                this.validateForComputeEnvironments = builder.validateForComputeEnvironments;
            }

            @Override
            public final java.lang.Object getAthenaProperties() {
                return this.athenaProperties;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.lang.Object getConnectionProperties() {
                return this.connectionProperties;
            }

            @Override
            public final java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getMatchCriteria() {
                return this.matchCriteria;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getPhysicalConnectionRequirements() {
                return this.physicalConnectionRequirements;
            }

            @Override
            public final java.lang.Object getPythonProperties() {
                return this.pythonProperties;
            }

            @Override
            public final java.lang.Object getSparkProperties() {
                return this.sparkProperties;
            }

            @Override
            public final java.lang.Object getValidateCredentials() {
                return this.validateCredentials;
            }

            @Override
            public final java.util.List<java.lang.String> getValidateForComputeEnvironments() {
                return this.validateForComputeEnvironments;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAthenaProperties() != null) {
                    data.set("athenaProperties", om.valueToTree(this.getAthenaProperties()));
                }
                if (this.getAuthenticationConfiguration() != null) {
                    data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                }
                if (this.getConnectionProperties() != null) {
                    data.set("connectionProperties", om.valueToTree(this.getConnectionProperties()));
                }
                if (this.getConnectionType() != null) {
                    data.set("connectionType", om.valueToTree(this.getConnectionType()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMatchCriteria() != null) {
                    data.set("matchCriteria", om.valueToTree(this.getMatchCriteria()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPhysicalConnectionRequirements() != null) {
                    data.set("physicalConnectionRequirements", om.valueToTree(this.getPhysicalConnectionRequirements()));
                }
                if (this.getPythonProperties() != null) {
                    data.set("pythonProperties", om.valueToTree(this.getPythonProperties()));
                }
                if (this.getSparkProperties() != null) {
                    data.set("sparkProperties", om.valueToTree(this.getSparkProperties()));
                }
                if (this.getValidateCredentials() != null) {
                    data.set("validateCredentials", om.valueToTree(this.getValidateCredentials()));
                }
                if (this.getValidateForComputeEnvironments() != null) {
                    data.set("validateForComputeEnvironments", om.valueToTree(this.getValidateForComputeEnvironments()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.GlueConnectionInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueConnectionInputProperty.Jsii$Proxy that = (GlueConnectionInputProperty.Jsii$Proxy) o;

                if (this.athenaProperties != null ? !this.athenaProperties.equals(that.athenaProperties) : that.athenaProperties != null) return false;
                if (this.authenticationConfiguration != null ? !this.authenticationConfiguration.equals(that.authenticationConfiguration) : that.authenticationConfiguration != null) return false;
                if (this.connectionProperties != null ? !this.connectionProperties.equals(that.connectionProperties) : that.connectionProperties != null) return false;
                if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.matchCriteria != null ? !this.matchCriteria.equals(that.matchCriteria) : that.matchCriteria != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.physicalConnectionRequirements != null ? !this.physicalConnectionRequirements.equals(that.physicalConnectionRequirements) : that.physicalConnectionRequirements != null) return false;
                if (this.pythonProperties != null ? !this.pythonProperties.equals(that.pythonProperties) : that.pythonProperties != null) return false;
                if (this.sparkProperties != null ? !this.sparkProperties.equals(that.sparkProperties) : that.sparkProperties != null) return false;
                if (this.validateCredentials != null ? !this.validateCredentials.equals(that.validateCredentials) : that.validateCredentials != null) return false;
                return this.validateForComputeEnvironments != null ? this.validateForComputeEnvironments.equals(that.validateForComputeEnvironments) : that.validateForComputeEnvironments == null;
            }

            @Override
            public final int hashCode() {
                int result = this.athenaProperties != null ? this.athenaProperties.hashCode() : 0;
                result = 31 * result + (this.authenticationConfiguration != null ? this.authenticationConfiguration.hashCode() : 0);
                result = 31 * result + (this.connectionProperties != null ? this.connectionProperties.hashCode() : 0);
                result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.matchCriteria != null ? this.matchCriteria.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.hashCode() : 0);
                result = 31 * result + (this.pythonProperties != null ? this.pythonProperties.hashCode() : 0);
                result = 31 * result + (this.sparkProperties != null ? this.sparkProperties.hashCode() : 0);
                result = 31 * result + (this.validateCredentials != null ? this.validateCredentials.hashCode() : 0);
                result = 31 * result + (this.validateForComputeEnvironments != null ? this.validateForComputeEnvironments.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The GlueOAuth2 credentials of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * GlueOAuth2CredentialsProperty glueOAuth2CredentialsProperty = GlueOAuth2CredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .jwtToken("jwtToken")
     *         .refreshToken("refreshToken")
     *         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.GlueOAuth2CredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueOAuth2CredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueOAuth2CredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access token of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The jwt token of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-jwttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-jwttoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJwtToken() {
            return null;
        }

        /**
         * The refresh token of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * The user managed client application client secret of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-usermanagedclientapplicationclientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-glueoauth2credentials.html#cfn-datazone-connection-glueoauth2credentials-usermanagedclientapplicationclientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserManagedClientApplicationClientSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlueOAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueOAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueOAuth2CredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String jwtToken;
            java.lang.String refreshToken;
            java.lang.String userManagedClientApplicationClientSecret;

            /**
             * Sets the value of {@link GlueOAuth2CredentialsProperty#getAccessToken}
             * @param accessToken The access token of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link GlueOAuth2CredentialsProperty#getJwtToken}
             * @param jwtToken The jwt token of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtToken(java.lang.String jwtToken) {
                this.jwtToken = jwtToken;
                return this;
            }

            /**
             * Sets the value of {@link GlueOAuth2CredentialsProperty#getRefreshToken}
             * @param refreshToken The refresh token of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Sets the value of {@link GlueOAuth2CredentialsProperty#getUserManagedClientApplicationClientSecret}
             * @param userManagedClientApplicationClientSecret The user managed client application client secret of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userManagedClientApplicationClientSecret(java.lang.String userManagedClientApplicationClientSecret) {
                this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueOAuth2CredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueOAuth2CredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueOAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueOAuth2CredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String jwtToken;
            private final java.lang.String refreshToken;
            private final java.lang.String userManagedClientApplicationClientSecret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jwtToken = software.amazon.jsii.Kernel.get(this, "jwtToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userManagedClientApplicationClientSecret = software.amazon.jsii.Kernel.get(this, "userManagedClientApplicationClientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.jwtToken = builder.jwtToken;
                this.refreshToken = builder.refreshToken;
                this.userManagedClientApplicationClientSecret = builder.userManagedClientApplicationClientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getJwtToken() {
                return this.jwtToken;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            public final java.lang.String getUserManagedClientApplicationClientSecret() {
                return this.userManagedClientApplicationClientSecret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getJwtToken() != null) {
                    data.set("jwtToken", om.valueToTree(this.getJwtToken()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }
                if (this.getUserManagedClientApplicationClientSecret() != null) {
                    data.set("userManagedClientApplicationClientSecret", om.valueToTree(this.getUserManagedClientApplicationClientSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.GlueOAuth2CredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueOAuth2CredentialsProperty.Jsii$Proxy that = (GlueOAuth2CredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.jwtToken != null ? !this.jwtToken.equals(that.jwtToken) : that.jwtToken != null) return false;
                if (this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null) return false;
                return this.userManagedClientApplicationClientSecret != null ? this.userManagedClientApplicationClientSecret.equals(that.userManagedClientApplicationClientSecret) : that.userManagedClientApplicationClientSecret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.jwtToken != null ? this.jwtToken.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                result = 31 * result + (this.userManagedClientApplicationClientSecret != null ? this.userManagedClientApplicationClientSecret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The AWS Glue properties of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * GluePropertiesInputProperty gluePropertiesInputProperty = GluePropertiesInputProperty.builder()
     *         .glueConnectionInput(GlueConnectionInputProperty.builder()
     *                 .athenaProperties(Map.of(
     *                         "athenaPropertiesKey", "athenaProperties"))
     *                 .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
     *                         .authenticationType("authenticationType")
     *                         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
     *                                 .password("password")
     *                                 .userName("userName")
     *                                 .build())
     *                         .customAuthenticationCredentials(Map.of(
     *                                 "customAuthenticationCredentialsKey", "customAuthenticationCredentials"))
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                                         .authorizationCode("authorizationCode")
     *                                         .redirectUri("redirectUri")
     *                                         .build())
     *                                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                                         .build())
     *                                 .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
     *                                         .accessToken("accessToken")
     *                                         .jwtToken("jwtToken")
     *                                         .refreshToken("refreshToken")
     *                                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                                         .build())
     *                                 .oAuth2GrantType("oAuth2GrantType")
     *                                 .tokenUrl("tokenUrl")
     *                                 .tokenUrlParametersMap(Map.of(
     *                                         "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
     *                                 .build())
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .connectionProperties(Map.of(
     *                         "connectionPropertiesKey", "connectionProperties"))
     *                 .connectionType("connectionType")
     *                 .description("description")
     *                 .matchCriteria("matchCriteria")
     *                 .name("name")
     *                 .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
     *                         .availabilityZone("availabilityZone")
     *                         .securityGroupIdList(List.of("securityGroupIdList"))
     *                         .subnetId("subnetId")
     *                         .subnetIdList(List.of("subnetIdList"))
     *                         .build())
     *                 .pythonProperties(Map.of(
     *                         "pythonPropertiesKey", "pythonProperties"))
     *                 .sparkProperties(Map.of(
     *                         "sparkPropertiesKey", "sparkProperties"))
     *                 .validateCredentials(false)
     *                 .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-gluepropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-gluepropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.GluePropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(GluePropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GluePropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Glue connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-gluepropertiesinput.html#cfn-datazone-connection-gluepropertiesinput-glueconnectioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-gluepropertiesinput.html#cfn-datazone-connection-gluepropertiesinput-glueconnectioninput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueConnectionInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GluePropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GluePropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GluePropertiesInputProperty> {
            java.lang.Object glueConnectionInput;

            /**
             * Sets the value of {@link GluePropertiesInputProperty#getGlueConnectionInput}
             * @param glueConnectionInput The AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionInput(software.amazon.awscdk.IResolvable glueConnectionInput) {
                this.glueConnectionInput = glueConnectionInput;
                return this;
            }

            /**
             * Sets the value of {@link GluePropertiesInputProperty#getGlueConnectionInput}
             * @param glueConnectionInput The AWS Glue connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionInput(software.amazon.awscdk.services.datazone.CfnConnection.GlueConnectionInputProperty glueConnectionInput) {
                this.glueConnectionInput = glueConnectionInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GluePropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GluePropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GluePropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GluePropertiesInputProperty {
            private final java.lang.Object glueConnectionInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueConnectionInput = software.amazon.jsii.Kernel.get(this, "glueConnectionInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueConnectionInput = builder.glueConnectionInput;
            }

            @Override
            public final java.lang.Object getGlueConnectionInput() {
                return this.glueConnectionInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueConnectionInput() != null) {
                    data.set("glueConnectionInput", om.valueToTree(this.getGlueConnectionInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.GluePropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GluePropertiesInputProperty.Jsii$Proxy that = (GluePropertiesInputProperty.Jsii$Proxy) o;

                return this.glueConnectionInput != null ? this.glueConnectionInput.equals(that.glueConnectionInput) : that.glueConnectionInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueConnectionInput != null ? this.glueConnectionInput.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The hyper pod properties of a AWS Glue properties patch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * HyperPodPropertiesInputProperty hyperPodPropertiesInputProperty = HyperPodPropertiesInputProperty.builder()
     *         .clusterName("clusterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-hyperpodpropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-hyperpodpropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.HyperPodPropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(HyperPodPropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HyperPodPropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cluster name the hyper pod properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-hyperpodpropertiesinput.html#cfn-datazone-connection-hyperpodpropertiesinput-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-hyperpodpropertiesinput.html#cfn-datazone-connection-hyperpodpropertiesinput-clustername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

        /**
         * @return a {@link Builder} of {@link HyperPodPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HyperPodPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HyperPodPropertiesInputProperty> {
            java.lang.String clusterName;

            /**
             * Sets the value of {@link HyperPodPropertiesInputProperty#getClusterName}
             * @param clusterName The cluster name the hyper pod properties. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterName(java.lang.String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HyperPodPropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HyperPodPropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HyperPodPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HyperPodPropertiesInputProperty {
            private final java.lang.String clusterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            }

            @Override
            public final java.lang.String getClusterName() {
                return this.clusterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterName", om.valueToTree(this.getClusterName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.HyperPodPropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HyperPodPropertiesInputProperty.Jsii$Proxy that = (HyperPodPropertiesInputProperty.Jsii$Proxy) o;

                return this.clusterName.equals(that.clusterName);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterName.hashCode();
                return result;
            }
        }
    }
    /**
     * The IAM properties of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * IamPropertiesInputProperty iamPropertiesInputProperty = IamPropertiesInputProperty.builder()
     *         .glueLineageSyncEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-iampropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-iampropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.IamPropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(IamPropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamPropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether AWS Glue lineage sync is enabled for a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-iampropertiesinput.html#cfn-datazone-connection-iampropertiesinput-gluelineagesyncenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-iampropertiesinput.html#cfn-datazone-connection-iampropertiesinput-gluelineagesyncenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueLineageSyncEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamPropertiesInputProperty> {
            java.lang.Object glueLineageSyncEnabled;

            /**
             * Sets the value of {@link IamPropertiesInputProperty#getGlueLineageSyncEnabled}
             * @param glueLineageSyncEnabled Specifies whether AWS Glue lineage sync is enabled for a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueLineageSyncEnabled(java.lang.Boolean glueLineageSyncEnabled) {
                this.glueLineageSyncEnabled = glueLineageSyncEnabled;
                return this;
            }

            /**
             * Sets the value of {@link IamPropertiesInputProperty#getGlueLineageSyncEnabled}
             * @param glueLineageSyncEnabled Specifies whether AWS Glue lineage sync is enabled for a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueLineageSyncEnabled(software.amazon.awscdk.IResolvable glueLineageSyncEnabled) {
                this.glueLineageSyncEnabled = glueLineageSyncEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamPropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamPropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IamPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamPropertiesInputProperty {
            private final java.lang.Object glueLineageSyncEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueLineageSyncEnabled = software.amazon.jsii.Kernel.get(this, "glueLineageSyncEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueLineageSyncEnabled = builder.glueLineageSyncEnabled;
            }

            @Override
            public final java.lang.Object getGlueLineageSyncEnabled() {
                return this.glueLineageSyncEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueLineageSyncEnabled() != null) {
                    data.set("glueLineageSyncEnabled", om.valueToTree(this.getGlueLineageSyncEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.IamPropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamPropertiesInputProperty.Jsii$Proxy that = (IamPropertiesInputProperty.Jsii$Proxy) o;

                return this.glueLineageSyncEnabled != null ? this.glueLineageSyncEnabled.equals(that.glueLineageSyncEnabled) : that.glueLineageSyncEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueLineageSyncEnabled != null ? this.glueLineageSyncEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The lineage sync schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * LineageSyncScheduleProperty lineageSyncScheduleProperty = LineageSyncScheduleProperty.builder()
     *         .schedule("schedule")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-lineagesyncschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-lineagesyncschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.LineageSyncScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(LineageSyncScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LineageSyncScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lineage sync schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-lineagesyncschedule.html#cfn-datazone-connection-lineagesyncschedule-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-lineagesyncschedule.html#cfn-datazone-connection-lineagesyncschedule-schedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchedule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LineageSyncScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LineageSyncScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LineageSyncScheduleProperty> {
            java.lang.String schedule;

            /**
             * Sets the value of {@link LineageSyncScheduleProperty#getSchedule}
             * @param schedule The lineage sync schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LineageSyncScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LineageSyncScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LineageSyncScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LineageSyncScheduleProperty {
            private final java.lang.String schedule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = builder.schedule;
            }

            @Override
            public final java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSchedule() != null) {
                    data.set("schedule", om.valueToTree(this.getSchedule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.LineageSyncScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LineageSyncScheduleProperty.Jsii$Proxy that = (LineageSyncScheduleProperty.Jsii$Proxy) o;

                return this.schedule != null ? this.schedule.equals(that.schedule) : that.schedule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule != null ? this.schedule.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The OAuth2Client application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * OAuth2ClientApplicationProperty oAuth2ClientApplicationProperty = OAuth2ClientApplicationProperty.builder()
     *         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2clientapplication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2clientapplication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.OAuth2ClientApplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2ClientApplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2ClientApplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS managed client application reference in the OAuth2Client application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2clientapplication.html#cfn-datazone-connection-oauth2clientapplication-awsmanagedclientapplicationreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2clientapplication.html#cfn-datazone-connection-oauth2clientapplication-awsmanagedclientapplicationreference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsManagedClientApplicationReference() {
            return null;
        }

        /**
         * The user managed client application client ID in the OAuth2Client application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2clientapplication.html#cfn-datazone-connection-oauth2clientapplication-usermanagedclientapplicationclientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2clientapplication.html#cfn-datazone-connection-oauth2clientapplication-usermanagedclientapplicationclientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserManagedClientApplicationClientId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2ClientApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2ClientApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2ClientApplicationProperty> {
            java.lang.String awsManagedClientApplicationReference;
            java.lang.String userManagedClientApplicationClientId;

            /**
             * Sets the value of {@link OAuth2ClientApplicationProperty#getAwsManagedClientApplicationReference}
             * @param awsManagedClientApplicationReference The AWS managed client application reference in the OAuth2Client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedClientApplicationReference(java.lang.String awsManagedClientApplicationReference) {
                this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2ClientApplicationProperty#getUserManagedClientApplicationClientId}
             * @param userManagedClientApplicationClientId The user managed client application client ID in the OAuth2Client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userManagedClientApplicationClientId(java.lang.String userManagedClientApplicationClientId) {
                this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2ClientApplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2ClientApplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2ClientApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2ClientApplicationProperty {
            private final java.lang.String awsManagedClientApplicationReference;
            private final java.lang.String userManagedClientApplicationClientId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsManagedClientApplicationReference = software.amazon.jsii.Kernel.get(this, "awsManagedClientApplicationReference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userManagedClientApplicationClientId = software.amazon.jsii.Kernel.get(this, "userManagedClientApplicationClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsManagedClientApplicationReference = builder.awsManagedClientApplicationReference;
                this.userManagedClientApplicationClientId = builder.userManagedClientApplicationClientId;
            }

            @Override
            public final java.lang.String getAwsManagedClientApplicationReference() {
                return this.awsManagedClientApplicationReference;
            }

            @Override
            public final java.lang.String getUserManagedClientApplicationClientId() {
                return this.userManagedClientApplicationClientId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsManagedClientApplicationReference() != null) {
                    data.set("awsManagedClientApplicationReference", om.valueToTree(this.getAwsManagedClientApplicationReference()));
                }
                if (this.getUserManagedClientApplicationClientId() != null) {
                    data.set("userManagedClientApplicationClientId", om.valueToTree(this.getUserManagedClientApplicationClientId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.OAuth2ClientApplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2ClientApplicationProperty.Jsii$Proxy that = (OAuth2ClientApplicationProperty.Jsii$Proxy) o;

                if (this.awsManagedClientApplicationReference != null ? !this.awsManagedClientApplicationReference.equals(that.awsManagedClientApplicationReference) : that.awsManagedClientApplicationReference != null) return false;
                return this.userManagedClientApplicationClientId != null ? this.userManagedClientApplicationClientId.equals(that.userManagedClientApplicationClientId) : that.userManagedClientApplicationClientId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsManagedClientApplicationReference != null ? this.awsManagedClientApplicationReference.hashCode() : 0;
                result = 31 * result + (this.userManagedClientApplicationClientId != null ? this.userManagedClientApplicationClientId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth2 properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * OAuth2PropertiesProperty oAuth2PropertiesProperty = OAuth2PropertiesProperty.builder()
     *         .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
     *                 .authorizationCode("authorizationCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
     *                 .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
     *                 .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
     *                 .build())
     *         .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .jwtToken("jwtToken")
     *                 .refreshToken("refreshToken")
     *                 .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
     *                 .build())
     *         .oAuth2GrantType("oAuth2GrantType")
     *         .tokenUrl("tokenUrl")
     *         .tokenUrlParametersMap(Map.of(
     *                 "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.OAuth2PropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2PropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2PropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization code properties of the OAuth2 properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-authorizationcodeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-authorizationcodeproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationCodeProperties() {
            return null;
        }

        /**
         * The OAuth2 client application of the OAuth2 properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-oauth2clientapplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-oauth2clientapplication</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2ClientApplication() {
            return null;
        }

        /**
         * The OAuth2 credentials of the OAuth2 properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-oauth2credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-oauth2credentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2Credentials() {
            return null;
        }

        /**
         * The OAuth2 grant type of the OAuth2 properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-oauth2granttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-oauth2granttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOAuth2GrantType() {
            return null;
        }

        /**
         * The OAuth2 token URL of the OAuth2 properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-tokenurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-tokenurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenUrl() {
            return null;
        }

        /**
         * The OAuth2 token URL parameter map of the OAuth2 properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-tokenurlparametersmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-oauth2properties.html#cfn-datazone-connection-oauth2properties-tokenurlparametersmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTokenUrlParametersMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2PropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2PropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2PropertiesProperty> {
            java.lang.Object authorizationCodeProperties;
            java.lang.Object oAuth2ClientApplication;
            java.lang.Object oAuth2Credentials;
            java.lang.String oAuth2GrantType;
            java.lang.String tokenUrl;
            java.lang.Object tokenUrlParametersMap;

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getAuthorizationCodeProperties}
             * @param authorizationCodeProperties The authorization code properties of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationCodeProperties(software.amazon.awscdk.IResolvable authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getAuthorizationCodeProperties}
             * @param authorizationCodeProperties The authorization code properties of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationCodeProperties(software.amazon.awscdk.services.datazone.CfnConnection.AuthorizationCodePropertiesProperty authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getOAuth2ClientApplication}
             * @param oAuth2ClientApplication The OAuth2 client application of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2ClientApplication(software.amazon.awscdk.IResolvable oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getOAuth2ClientApplication}
             * @param oAuth2ClientApplication The OAuth2 client application of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2ClientApplication(software.amazon.awscdk.services.datazone.CfnConnection.OAuth2ClientApplicationProperty oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getOAuth2Credentials}
             * @param oAuth2Credentials The OAuth2 credentials of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Credentials(software.amazon.awscdk.IResolvable oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getOAuth2Credentials}
             * @param oAuth2Credentials The OAuth2 credentials of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Credentials(software.amazon.awscdk.services.datazone.CfnConnection.GlueOAuth2CredentialsProperty oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getOAuth2GrantType}
             * @param oAuth2GrantType The OAuth2 grant type of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2GrantType(java.lang.String oAuth2GrantType) {
                this.oAuth2GrantType = oAuth2GrantType;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getTokenUrl}
             * @param tokenUrl The OAuth2 token URL of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrl(java.lang.String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getTokenUrlParametersMap}
             * @param tokenUrlParametersMap The OAuth2 token URL parameter map of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrlParametersMap(java.util.Map<java.lang.String, java.lang.String> tokenUrlParametersMap) {
                this.tokenUrlParametersMap = tokenUrlParametersMap;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getTokenUrlParametersMap}
             * @param tokenUrlParametersMap The OAuth2 token URL parameter map of the OAuth2 properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrlParametersMap(software.amazon.awscdk.IResolvable tokenUrlParametersMap) {
                this.tokenUrlParametersMap = tokenUrlParametersMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2PropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2PropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2PropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2PropertiesProperty {
            private final java.lang.Object authorizationCodeProperties;
            private final java.lang.Object oAuth2ClientApplication;
            private final java.lang.Object oAuth2Credentials;
            private final java.lang.String oAuth2GrantType;
            private final java.lang.String tokenUrl;
            private final java.lang.Object tokenUrlParametersMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationCodeProperties = software.amazon.jsii.Kernel.get(this, "authorizationCodeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2ClientApplication = software.amazon.jsii.Kernel.get(this, "oAuth2ClientApplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2Credentials = software.amazon.jsii.Kernel.get(this, "oAuth2Credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2GrantType = software.amazon.jsii.Kernel.get(this, "oAuth2GrantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrl = software.amazon.jsii.Kernel.get(this, "tokenUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrlParametersMap = software.amazon.jsii.Kernel.get(this, "tokenUrlParametersMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationCodeProperties = builder.authorizationCodeProperties;
                this.oAuth2ClientApplication = builder.oAuth2ClientApplication;
                this.oAuth2Credentials = builder.oAuth2Credentials;
                this.oAuth2GrantType = builder.oAuth2GrantType;
                this.tokenUrl = builder.tokenUrl;
                this.tokenUrlParametersMap = builder.tokenUrlParametersMap;
            }

            @Override
            public final java.lang.Object getAuthorizationCodeProperties() {
                return this.authorizationCodeProperties;
            }

            @Override
            public final java.lang.Object getOAuth2ClientApplication() {
                return this.oAuth2ClientApplication;
            }

            @Override
            public final java.lang.Object getOAuth2Credentials() {
                return this.oAuth2Credentials;
            }

            @Override
            public final java.lang.String getOAuth2GrantType() {
                return this.oAuth2GrantType;
            }

            @Override
            public final java.lang.String getTokenUrl() {
                return this.tokenUrl;
            }

            @Override
            public final java.lang.Object getTokenUrlParametersMap() {
                return this.tokenUrlParametersMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizationCodeProperties() != null) {
                    data.set("authorizationCodeProperties", om.valueToTree(this.getAuthorizationCodeProperties()));
                }
                if (this.getOAuth2ClientApplication() != null) {
                    data.set("oAuth2ClientApplication", om.valueToTree(this.getOAuth2ClientApplication()));
                }
                if (this.getOAuth2Credentials() != null) {
                    data.set("oAuth2Credentials", om.valueToTree(this.getOAuth2Credentials()));
                }
                if (this.getOAuth2GrantType() != null) {
                    data.set("oAuth2GrantType", om.valueToTree(this.getOAuth2GrantType()));
                }
                if (this.getTokenUrl() != null) {
                    data.set("tokenUrl", om.valueToTree(this.getTokenUrl()));
                }
                if (this.getTokenUrlParametersMap() != null) {
                    data.set("tokenUrlParametersMap", om.valueToTree(this.getTokenUrlParametersMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.OAuth2PropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2PropertiesProperty.Jsii$Proxy that = (OAuth2PropertiesProperty.Jsii$Proxy) o;

                if (this.authorizationCodeProperties != null ? !this.authorizationCodeProperties.equals(that.authorizationCodeProperties) : that.authorizationCodeProperties != null) return false;
                if (this.oAuth2ClientApplication != null ? !this.oAuth2ClientApplication.equals(that.oAuth2ClientApplication) : that.oAuth2ClientApplication != null) return false;
                if (this.oAuth2Credentials != null ? !this.oAuth2Credentials.equals(that.oAuth2Credentials) : that.oAuth2Credentials != null) return false;
                if (this.oAuth2GrantType != null ? !this.oAuth2GrantType.equals(that.oAuth2GrantType) : that.oAuth2GrantType != null) return false;
                if (this.tokenUrl != null ? !this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl != null) return false;
                return this.tokenUrlParametersMap != null ? this.tokenUrlParametersMap.equals(that.tokenUrlParametersMap) : that.tokenUrlParametersMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationCodeProperties != null ? this.authorizationCodeProperties.hashCode() : 0;
                result = 31 * result + (this.oAuth2ClientApplication != null ? this.oAuth2ClientApplication.hashCode() : 0);
                result = 31 * result + (this.oAuth2Credentials != null ? this.oAuth2Credentials.hashCode() : 0);
                result = 31 * result + (this.oAuth2GrantType != null ? this.oAuth2GrantType.hashCode() : 0);
                result = 31 * result + (this.tokenUrl != null ? this.tokenUrl.hashCode() : 0);
                result = 31 * result + (this.tokenUrlParametersMap != null ? this.tokenUrlParametersMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Physical connection requirements of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * PhysicalConnectionRequirementsProperty physicalConnectionRequirementsProperty = PhysicalConnectionRequirementsProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .securityGroupIdList(List.of("securityGroupIdList"))
     *         .subnetId("subnetId")
     *         .subnetIdList(List.of("subnetIdList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.PhysicalConnectionRequirementsProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalConnectionRequirementsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalConnectionRequirementsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The availability zone of the physical connection requirements of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The group ID list of the physical connection requirements of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-securitygroupidlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-securitygroupidlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIdList() {
            return null;
        }

        /**
         * The subnet ID of the physical connection requirements of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-subnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * The subnet ID list of the physical connection requirements of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-subnetidlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-physicalconnectionrequirements.html#cfn-datazone-connection-physicalconnectionrequirements-subnetidlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIdList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalConnectionRequirementsProperty> {
            java.lang.String availabilityZone;
            java.util.List<java.lang.String> securityGroupIdList;
            java.lang.String subnetId;
            java.util.List<java.lang.String> subnetIdList;

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getAvailabilityZone}
             * @param availabilityZone The availability zone of the physical connection requirements of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSecurityGroupIdList}
             * @param securityGroupIdList The group ID list of the physical connection requirements of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIdList(java.util.List<java.lang.String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSubnetId}
             * @param subnetId The subnet ID of the physical connection requirements of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSubnetIdList}
             * @param subnetIdList The subnet ID list of the physical connection requirements of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIdList(java.util.List<java.lang.String> subnetIdList) {
                this.subnetIdList = subnetIdList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalConnectionRequirementsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalConnectionRequirementsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalConnectionRequirementsProperty {
            private final java.lang.String availabilityZone;
            private final java.util.List<java.lang.String> securityGroupIdList;
            private final java.lang.String subnetId;
            private final java.util.List<java.lang.String> subnetIdList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIdList = software.amazon.jsii.Kernel.get(this, "securityGroupIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subnetIdList = software.amazon.jsii.Kernel.get(this, "subnetIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.securityGroupIdList = builder.securityGroupIdList;
                this.subnetId = builder.subnetId;
                this.subnetIdList = builder.subnetIdList;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIdList() {
                return this.securityGroupIdList;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIdList() {
                return this.subnetIdList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getSecurityGroupIdList() != null) {
                    data.set("securityGroupIdList", om.valueToTree(this.getSecurityGroupIdList()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getSubnetIdList() != null) {
                    data.set("subnetIdList", om.valueToTree(this.getSubnetIdList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.PhysicalConnectionRequirementsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalConnectionRequirementsProperty.Jsii$Proxy that = (PhysicalConnectionRequirementsProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.securityGroupIdList != null ? !this.securityGroupIdList.equals(that.securityGroupIdList) : that.securityGroupIdList != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.subnetIdList != null ? this.subnetIdList.equals(that.subnetIdList) : that.subnetIdList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.securityGroupIdList != null ? this.securityGroupIdList.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.subnetIdList != null ? this.subnetIdList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Amazon Redshift credentials of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftCredentialsProperty redshiftCredentialsProperty = RedshiftCredentialsProperty.builder()
     *         .secretArn("secretArn")
     *         .usernamePassword(UsernamePasswordProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftcredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftcredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.RedshiftCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The secret ARN of the Amazon Redshift credentials of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftcredentials.html#cfn-datazone-connection-redshiftcredentials-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftcredentials.html#cfn-datazone-connection-redshiftcredentials-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * The username and password of the Amazon Redshift credentials of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftcredentials.html#cfn-datazone-connection-redshiftcredentials-usernamepassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftcredentials.html#cfn-datazone-connection-redshiftcredentials-usernamepassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUsernamePassword() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftCredentialsProperty> {
            java.lang.String secretArn;
            java.lang.Object usernamePassword;

            /**
             * Sets the value of {@link RedshiftCredentialsProperty#getSecretArn}
             * @param secretArn The secret ARN of the Amazon Redshift credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftCredentialsProperty#getUsernamePassword}
             * @param usernamePassword The username and password of the Amazon Redshift credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernamePassword(software.amazon.awscdk.IResolvable usernamePassword) {
                this.usernamePassword = usernamePassword;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftCredentialsProperty#getUsernamePassword}
             * @param usernamePassword The username and password of the Amazon Redshift credentials of a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernamePassword(software.amazon.awscdk.services.datazone.CfnConnection.UsernamePasswordProperty usernamePassword) {
                this.usernamePassword = usernamePassword;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftCredentialsProperty {
            private final java.lang.String secretArn;
            private final java.lang.Object usernamePassword;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usernamePassword = software.amazon.jsii.Kernel.get(this, "usernamePassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = builder.secretArn;
                this.usernamePassword = builder.usernamePassword;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.Object getUsernamePassword() {
                return this.usernamePassword;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }
                if (this.getUsernamePassword() != null) {
                    data.set("usernamePassword", om.valueToTree(this.getUsernamePassword()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.RedshiftCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftCredentialsProperty.Jsii$Proxy that = (RedshiftCredentialsProperty.Jsii$Proxy) o;

                if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
                return this.usernamePassword != null ? this.usernamePassword.equals(that.usernamePassword) : that.usernamePassword == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn != null ? this.secretArn.hashCode() : 0;
                result = 31 * result + (this.usernamePassword != null ? this.usernamePassword.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amaon Redshift lineage sync configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftLineageSyncConfigurationInputProperty redshiftLineageSyncConfigurationInputProperty = RedshiftLineageSyncConfigurationInputProperty.builder()
     *         .enabled(false)
     *         .schedule(LineageSyncScheduleProperty.builder()
     *                 .schedule("schedule")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftlineagesyncconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftlineagesyncconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.RedshiftLineageSyncConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftLineageSyncConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftLineageSyncConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the Amaon Redshift lineage sync configuration is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftlineagesyncconfigurationinput.html#cfn-datazone-connection-redshiftlineagesyncconfigurationinput-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftlineagesyncconfigurationinput.html#cfn-datazone-connection-redshiftlineagesyncconfigurationinput-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The schedule of the Amaon Redshift lineage sync configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftlineagesyncconfigurationinput.html#cfn-datazone-connection-redshiftlineagesyncconfigurationinput-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftlineagesyncconfigurationinput.html#cfn-datazone-connection-redshiftlineagesyncconfigurationinput-schedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftLineageSyncConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftLineageSyncConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftLineageSyncConfigurationInputProperty> {
            java.lang.Object enabled;
            java.lang.Object schedule;

            /**
             * Sets the value of {@link RedshiftLineageSyncConfigurationInputProperty#getEnabled}
             * @param enabled Specifies whether the Amaon Redshift lineage sync configuration is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftLineageSyncConfigurationInputProperty#getEnabled}
             * @param enabled Specifies whether the Amaon Redshift lineage sync configuration is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftLineageSyncConfigurationInputProperty#getSchedule}
             * @param schedule The schedule of the Amaon Redshift lineage sync configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftLineageSyncConfigurationInputProperty#getSchedule}
             * @param schedule The schedule of the Amaon Redshift lineage sync configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(software.amazon.awscdk.services.datazone.CfnConnection.LineageSyncScheduleProperty schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftLineageSyncConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftLineageSyncConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftLineageSyncConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftLineageSyncConfigurationInputProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object schedule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.schedule = builder.schedule;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getSchedule() {
                return this.schedule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getSchedule() != null) {
                    data.set("schedule", om.valueToTree(this.getSchedule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.RedshiftLineageSyncConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftLineageSyncConfigurationInputProperty.Jsii$Proxy that = (RedshiftLineageSyncConfigurationInputProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.schedule != null ? this.schedule.equals(that.schedule) : that.schedule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon Redshift properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftPropertiesInputProperty redshiftPropertiesInputProperty = RedshiftPropertiesInputProperty.builder()
     *         .credentials(RedshiftCredentialsProperty.builder()
     *                 .secretArn("secretArn")
     *                 .usernamePassword(UsernamePasswordProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .build())
     *         .databaseName("databaseName")
     *         .host("host")
     *         .lineageSync(RedshiftLineageSyncConfigurationInputProperty.builder()
     *                 .enabled(false)
     *                 .schedule(LineageSyncScheduleProperty.builder()
     *                         .schedule("schedule")
     *                         .build())
     *                 .build())
     *         .port(123)
     *         .storage(RedshiftStoragePropertiesProperty.builder()
     *                 .clusterName("clusterName")
     *                 .workgroupName("workgroupName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.RedshiftPropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftPropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftPropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amaon Redshift credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-credentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCredentials() {
            return null;
        }

        /**
         * The Amazon Redshift database name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * The Amazon Redshift host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * The lineage sync of the Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-lineagesync">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-lineagesync</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLineageSync() {
            return null;
        }

        /**
         * The Amaon Redshift port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The Amazon Redshift storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-storage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftpropertiesinput.html#cfn-datazone-connection-redshiftpropertiesinput-storage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStorage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftPropertiesInputProperty> {
            java.lang.Object credentials;
            java.lang.String databaseName;
            java.lang.String host;
            java.lang.Object lineageSync;
            java.lang.Number port;
            java.lang.Object storage;

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getCredentials}
             * @param credentials The Amaon Redshift credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getCredentials}
             * @param credentials The Amaon Redshift credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.services.datazone.CfnConnection.RedshiftCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getDatabaseName}
             * @param databaseName The Amazon Redshift database name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getHost}
             * @param host The Amazon Redshift host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getLineageSync}
             * @param lineageSync The lineage sync of the Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineageSync(software.amazon.awscdk.IResolvable lineageSync) {
                this.lineageSync = lineageSync;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getLineageSync}
             * @param lineageSync The lineage sync of the Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineageSync(software.amazon.awscdk.services.datazone.CfnConnection.RedshiftLineageSyncConfigurationInputProperty lineageSync) {
                this.lineageSync = lineageSync;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getPort}
             * @param port The Amaon Redshift port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getStorage}
             * @param storage The Amazon Redshift storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(software.amazon.awscdk.IResolvable storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftPropertiesInputProperty#getStorage}
             * @param storage The Amazon Redshift storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(software.amazon.awscdk.services.datazone.CfnConnection.RedshiftStoragePropertiesProperty storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftPropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftPropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftPropertiesInputProperty {
            private final java.lang.Object credentials;
            private final java.lang.String databaseName;
            private final java.lang.String host;
            private final java.lang.Object lineageSync;
            private final java.lang.Number port;
            private final java.lang.Object storage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lineageSync = software.amazon.jsii.Kernel.get(this, "lineageSync", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentials = builder.credentials;
                this.databaseName = builder.databaseName;
                this.host = builder.host;
                this.lineageSync = builder.lineageSync;
                this.port = builder.port;
                this.storage = builder.storage;
            }

            @Override
            public final java.lang.Object getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Object getLineageSync() {
                return this.lineageSync;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getStorage() {
                return this.storage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getLineageSync() != null) {
                    data.set("lineageSync", om.valueToTree(this.getLineageSync()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getStorage() != null) {
                    data.set("storage", om.valueToTree(this.getStorage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.RedshiftPropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftPropertiesInputProperty.Jsii$Proxy that = (RedshiftPropertiesInputProperty.Jsii$Proxy) o;

                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.lineageSync != null ? !this.lineageSync.equals(that.lineageSync) : that.lineageSync != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.storage != null ? this.storage.equals(that.storage) : that.storage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.credentials != null ? this.credentials.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.lineageSync != null ? this.lineageSync.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon Redshift storage properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * RedshiftStoragePropertiesProperty redshiftStoragePropertiesProperty = RedshiftStoragePropertiesProperty.builder()
     *         .clusterName("clusterName")
     *         .workgroupName("workgroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftstorageproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftstorageproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.RedshiftStoragePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftStoragePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftStoragePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cluster name in the Amazon Redshift storage properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftstorageproperties.html#cfn-datazone-connection-redshiftstorageproperties-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftstorageproperties.html#cfn-datazone-connection-redshiftstorageproperties-clustername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
            return null;
        }

        /**
         * The workgroup name in the Amazon Redshift storage properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftstorageproperties.html#cfn-datazone-connection-redshiftstorageproperties-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-redshiftstorageproperties.html#cfn-datazone-connection-redshiftstorageproperties-workgroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkgroupName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftStoragePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftStoragePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftStoragePropertiesProperty> {
            java.lang.String clusterName;
            java.lang.String workgroupName;

            /**
             * Sets the value of {@link RedshiftStoragePropertiesProperty#getClusterName}
             * @param clusterName The cluster name in the Amazon Redshift storage properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterName(java.lang.String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftStoragePropertiesProperty#getWorkgroupName}
             * @param workgroupName The workgroup name in the Amazon Redshift storage properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupName(java.lang.String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftStoragePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftStoragePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftStoragePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftStoragePropertiesProperty {
            private final java.lang.String clusterName;
            private final java.lang.String workgroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workgroupName = software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterName = builder.clusterName;
                this.workgroupName = builder.workgroupName;
            }

            @Override
            public final java.lang.String getClusterName() {
                return this.clusterName;
            }

            @Override
            public final java.lang.String getWorkgroupName() {
                return this.workgroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClusterName() != null) {
                    data.set("clusterName", om.valueToTree(this.getClusterName()));
                }
                if (this.getWorkgroupName() != null) {
                    data.set("workgroupName", om.valueToTree(this.getWorkgroupName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.RedshiftStoragePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftStoragePropertiesProperty.Jsii$Proxy that = (RedshiftStoragePropertiesProperty.Jsii$Proxy) o;

                if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
                return this.workgroupName != null ? this.workgroupName.equals(that.workgroupName) : that.workgroupName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
                result = 31 * result + (this.workgroupName != null ? this.workgroupName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Spark EMR properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * SparkEmrPropertiesInputProperty sparkEmrPropertiesInputProperty = SparkEmrPropertiesInputProperty.builder()
     *         .computeArn("computeArn")
     *         .instanceProfileArn("instanceProfileArn")
     *         .javaVirtualEnv("javaVirtualEnv")
     *         .logUri("logUri")
     *         .pythonVirtualEnv("pythonVirtualEnv")
     *         .runtimeRole("runtimeRole")
     *         .trustedCertificatesS3Uri("trustedCertificatesS3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.SparkEmrPropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SparkEmrPropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SparkEmrPropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The compute ARN of Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-computearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-computearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComputeArn() {
            return null;
        }

        /**
         * The instance profile ARN of Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-instanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-instanceprofilearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileArn() {
            return null;
        }

        /**
         * The java virtual env of the Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-javavirtualenv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-javavirtualenv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJavaVirtualEnv() {
            return null;
        }

        /**
         * The log URI of the Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-loguri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-loguri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
            return null;
        }

        /**
         * The Python virtual env of the Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-pythonvirtualenv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-pythonvirtualenv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPythonVirtualEnv() {
            return null;
        }

        /**
         * The runtime role of the Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-runtimerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-runtimerole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuntimeRole() {
            return null;
        }

        /**
         * The certificates S3 URI of the Spark EMR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-trustedcertificatess3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkemrpropertiesinput.html#cfn-datazone-connection-sparkemrpropertiesinput-trustedcertificatess3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrustedCertificatesS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SparkEmrPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SparkEmrPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SparkEmrPropertiesInputProperty> {
            java.lang.String computeArn;
            java.lang.String instanceProfileArn;
            java.lang.String javaVirtualEnv;
            java.lang.String logUri;
            java.lang.String pythonVirtualEnv;
            java.lang.String runtimeRole;
            java.lang.String trustedCertificatesS3Uri;

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getComputeArn}
             * @param computeArn The compute ARN of Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeArn(java.lang.String computeArn) {
                this.computeArn = computeArn;
                return this;
            }

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getInstanceProfileArn}
             * @param instanceProfileArn The instance profile ARN of Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceProfileArn(java.lang.String instanceProfileArn) {
                this.instanceProfileArn = instanceProfileArn;
                return this;
            }

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getJavaVirtualEnv}
             * @param javaVirtualEnv The java virtual env of the Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder javaVirtualEnv(java.lang.String javaVirtualEnv) {
                this.javaVirtualEnv = javaVirtualEnv;
                return this;
            }

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getLogUri}
             * @param logUri The log URI of the Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logUri(java.lang.String logUri) {
                this.logUri = logUri;
                return this;
            }

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getPythonVirtualEnv}
             * @param pythonVirtualEnv The Python virtual env of the Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pythonVirtualEnv(java.lang.String pythonVirtualEnv) {
                this.pythonVirtualEnv = pythonVirtualEnv;
                return this;
            }

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getRuntimeRole}
             * @param runtimeRole The runtime role of the Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeRole(java.lang.String runtimeRole) {
                this.runtimeRole = runtimeRole;
                return this;
            }

            /**
             * Sets the value of {@link SparkEmrPropertiesInputProperty#getTrustedCertificatesS3Uri}
             * @param trustedCertificatesS3Uri The certificates S3 URI of the Spark EMR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedCertificatesS3Uri(java.lang.String trustedCertificatesS3Uri) {
                this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SparkEmrPropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SparkEmrPropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SparkEmrPropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SparkEmrPropertiesInputProperty {
            private final java.lang.String computeArn;
            private final java.lang.String instanceProfileArn;
            private final java.lang.String javaVirtualEnv;
            private final java.lang.String logUri;
            private final java.lang.String pythonVirtualEnv;
            private final java.lang.String runtimeRole;
            private final java.lang.String trustedCertificatesS3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeArn = software.amazon.jsii.Kernel.get(this, "computeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceProfileArn = software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.javaVirtualEnv = software.amazon.jsii.Kernel.get(this, "javaVirtualEnv", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logUri = software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pythonVirtualEnv = software.amazon.jsii.Kernel.get(this, "pythonVirtualEnv", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtimeRole = software.amazon.jsii.Kernel.get(this, "runtimeRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trustedCertificatesS3Uri = software.amazon.jsii.Kernel.get(this, "trustedCertificatesS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeArn = builder.computeArn;
                this.instanceProfileArn = builder.instanceProfileArn;
                this.javaVirtualEnv = builder.javaVirtualEnv;
                this.logUri = builder.logUri;
                this.pythonVirtualEnv = builder.pythonVirtualEnv;
                this.runtimeRole = builder.runtimeRole;
                this.trustedCertificatesS3Uri = builder.trustedCertificatesS3Uri;
            }

            @Override
            public final java.lang.String getComputeArn() {
                return this.computeArn;
            }

            @Override
            public final java.lang.String getInstanceProfileArn() {
                return this.instanceProfileArn;
            }

            @Override
            public final java.lang.String getJavaVirtualEnv() {
                return this.javaVirtualEnv;
            }

            @Override
            public final java.lang.String getLogUri() {
                return this.logUri;
            }

            @Override
            public final java.lang.String getPythonVirtualEnv() {
                return this.pythonVirtualEnv;
            }

            @Override
            public final java.lang.String getRuntimeRole() {
                return this.runtimeRole;
            }

            @Override
            public final java.lang.String getTrustedCertificatesS3Uri() {
                return this.trustedCertificatesS3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComputeArn() != null) {
                    data.set("computeArn", om.valueToTree(this.getComputeArn()));
                }
                if (this.getInstanceProfileArn() != null) {
                    data.set("instanceProfileArn", om.valueToTree(this.getInstanceProfileArn()));
                }
                if (this.getJavaVirtualEnv() != null) {
                    data.set("javaVirtualEnv", om.valueToTree(this.getJavaVirtualEnv()));
                }
                if (this.getLogUri() != null) {
                    data.set("logUri", om.valueToTree(this.getLogUri()));
                }
                if (this.getPythonVirtualEnv() != null) {
                    data.set("pythonVirtualEnv", om.valueToTree(this.getPythonVirtualEnv()));
                }
                if (this.getRuntimeRole() != null) {
                    data.set("runtimeRole", om.valueToTree(this.getRuntimeRole()));
                }
                if (this.getTrustedCertificatesS3Uri() != null) {
                    data.set("trustedCertificatesS3Uri", om.valueToTree(this.getTrustedCertificatesS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.SparkEmrPropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SparkEmrPropertiesInputProperty.Jsii$Proxy that = (SparkEmrPropertiesInputProperty.Jsii$Proxy) o;

                if (this.computeArn != null ? !this.computeArn.equals(that.computeArn) : that.computeArn != null) return false;
                if (this.instanceProfileArn != null ? !this.instanceProfileArn.equals(that.instanceProfileArn) : that.instanceProfileArn != null) return false;
                if (this.javaVirtualEnv != null ? !this.javaVirtualEnv.equals(that.javaVirtualEnv) : that.javaVirtualEnv != null) return false;
                if (this.logUri != null ? !this.logUri.equals(that.logUri) : that.logUri != null) return false;
                if (this.pythonVirtualEnv != null ? !this.pythonVirtualEnv.equals(that.pythonVirtualEnv) : that.pythonVirtualEnv != null) return false;
                if (this.runtimeRole != null ? !this.runtimeRole.equals(that.runtimeRole) : that.runtimeRole != null) return false;
                return this.trustedCertificatesS3Uri != null ? this.trustedCertificatesS3Uri.equals(that.trustedCertificatesS3Uri) : that.trustedCertificatesS3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.computeArn != null ? this.computeArn.hashCode() : 0;
                result = 31 * result + (this.instanceProfileArn != null ? this.instanceProfileArn.hashCode() : 0);
                result = 31 * result + (this.javaVirtualEnv != null ? this.javaVirtualEnv.hashCode() : 0);
                result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
                result = 31 * result + (this.pythonVirtualEnv != null ? this.pythonVirtualEnv.hashCode() : 0);
                result = 31 * result + (this.runtimeRole != null ? this.runtimeRole.hashCode() : 0);
                result = 31 * result + (this.trustedCertificatesS3Uri != null ? this.trustedCertificatesS3Uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Spark AWS Glue args.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * SparkGlueArgsProperty sparkGlueArgsProperty = SparkGlueArgsProperty.builder()
     *         .connection("connection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkglueargs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkglueargs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.SparkGlueArgsProperty")
    @software.amazon.jsii.Jsii.Proxy(SparkGlueArgsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SparkGlueArgsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connection in the Spark AWS Glue args.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkglueargs.html#cfn-datazone-connection-sparkglueargs-connection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkglueargs.html#cfn-datazone-connection-sparkglueargs-connection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SparkGlueArgsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SparkGlueArgsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SparkGlueArgsProperty> {
            java.lang.String connection;

            /**
             * Sets the value of {@link SparkGlueArgsProperty#getConnection}
             * @param connection The connection in the Spark AWS Glue args.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connection(java.lang.String connection) {
                this.connection = connection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SparkGlueArgsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SparkGlueArgsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SparkGlueArgsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SparkGlueArgsProperty {
            private final java.lang.String connection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connection = builder.connection;
            }

            @Override
            public final java.lang.String getConnection() {
                return this.connection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnection() != null) {
                    data.set("connection", om.valueToTree(this.getConnection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.SparkGlueArgsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SparkGlueArgsProperty.Jsii$Proxy that = (SparkGlueArgsProperty.Jsii$Proxy) o;

                return this.connection != null ? this.connection.equals(that.connection) : that.connection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connection != null ? this.connection.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The Spark AWS Glue properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * SparkGluePropertiesInputProperty sparkGluePropertiesInputProperty = SparkGluePropertiesInputProperty.builder()
     *         .additionalArgs(SparkGlueArgsProperty.builder()
     *                 .connection("connection")
     *                 .build())
     *         .glueConnectionName("glueConnectionName")
     *         .glueVersion("glueVersion")
     *         .idleTimeout(123)
     *         .javaVirtualEnv("javaVirtualEnv")
     *         .numberOfWorkers(123)
     *         .pythonVirtualEnv("pythonVirtualEnv")
     *         .workerType("workerType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.SparkGluePropertiesInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SparkGluePropertiesInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SparkGluePropertiesInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The additional args in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-additionalargs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-additionalargs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalArgs() {
            return null;
        }

        /**
         * The AWS Glue connection name in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-glueconnectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-glueconnectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGlueConnectionName() {
            return null;
        }

        /**
         * The AWS Glue version in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-glueversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-glueversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGlueVersion() {
            return null;
        }

        /**
         * The idle timeout in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-idletimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-idletimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleTimeout() {
            return null;
        }

        /**
         * The Java virtual env in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-javavirtualenv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-javavirtualenv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJavaVirtualEnv() {
            return null;
        }

        /**
         * The number of workers in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-numberofworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-numberofworkers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfWorkers() {
            return null;
        }

        /**
         * The Python virtual env in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-pythonvirtualenv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-pythonvirtualenv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPythonVirtualEnv() {
            return null;
        }

        /**
         * The worker type in the Spark AWS Glue properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-workertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-sparkgluepropertiesinput.html#cfn-datazone-connection-sparkgluepropertiesinput-workertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkerType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SparkGluePropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SparkGluePropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SparkGluePropertiesInputProperty> {
            java.lang.Object additionalArgs;
            java.lang.String glueConnectionName;
            java.lang.String glueVersion;
            java.lang.Number idleTimeout;
            java.lang.String javaVirtualEnv;
            java.lang.Number numberOfWorkers;
            java.lang.String pythonVirtualEnv;
            java.lang.String workerType;

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getAdditionalArgs}
             * @param additionalArgs The additional args in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalArgs(software.amazon.awscdk.IResolvable additionalArgs) {
                this.additionalArgs = additionalArgs;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getAdditionalArgs}
             * @param additionalArgs The additional args in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalArgs(software.amazon.awscdk.services.datazone.CfnConnection.SparkGlueArgsProperty additionalArgs) {
                this.additionalArgs = additionalArgs;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getGlueConnectionName}
             * @param glueConnectionName The AWS Glue connection name in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionName(java.lang.String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getGlueVersion}
             * @param glueVersion The AWS Glue version in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueVersion(java.lang.String glueVersion) {
                this.glueVersion = glueVersion;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getIdleTimeout}
             * @param idleTimeout The idle timeout in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeout(java.lang.Number idleTimeout) {
                this.idleTimeout = idleTimeout;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getJavaVirtualEnv}
             * @param javaVirtualEnv The Java virtual env in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder javaVirtualEnv(java.lang.String javaVirtualEnv) {
                this.javaVirtualEnv = javaVirtualEnv;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getNumberOfWorkers}
             * @param numberOfWorkers The number of workers in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfWorkers(java.lang.Number numberOfWorkers) {
                this.numberOfWorkers = numberOfWorkers;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getPythonVirtualEnv}
             * @param pythonVirtualEnv The Python virtual env in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pythonVirtualEnv(java.lang.String pythonVirtualEnv) {
                this.pythonVirtualEnv = pythonVirtualEnv;
                return this;
            }

            /**
             * Sets the value of {@link SparkGluePropertiesInputProperty#getWorkerType}
             * @param workerType The worker type in the Spark AWS Glue properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerType(java.lang.String workerType) {
                this.workerType = workerType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SparkGluePropertiesInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SparkGluePropertiesInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SparkGluePropertiesInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SparkGluePropertiesInputProperty {
            private final java.lang.Object additionalArgs;
            private final java.lang.String glueConnectionName;
            private final java.lang.String glueVersion;
            private final java.lang.Number idleTimeout;
            private final java.lang.String javaVirtualEnv;
            private final java.lang.Number numberOfWorkers;
            private final java.lang.String pythonVirtualEnv;
            private final java.lang.String workerType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalArgs = software.amazon.jsii.Kernel.get(this, "additionalArgs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.glueConnectionName = software.amazon.jsii.Kernel.get(this, "glueConnectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.idleTimeout = software.amazon.jsii.Kernel.get(this, "idleTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.javaVirtualEnv = software.amazon.jsii.Kernel.get(this, "javaVirtualEnv", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfWorkers = software.amazon.jsii.Kernel.get(this, "numberOfWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pythonVirtualEnv = software.amazon.jsii.Kernel.get(this, "pythonVirtualEnv", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workerType = software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalArgs = builder.additionalArgs;
                this.glueConnectionName = builder.glueConnectionName;
                this.glueVersion = builder.glueVersion;
                this.idleTimeout = builder.idleTimeout;
                this.javaVirtualEnv = builder.javaVirtualEnv;
                this.numberOfWorkers = builder.numberOfWorkers;
                this.pythonVirtualEnv = builder.pythonVirtualEnv;
                this.workerType = builder.workerType;
            }

            @Override
            public final java.lang.Object getAdditionalArgs() {
                return this.additionalArgs;
            }

            @Override
            public final java.lang.String getGlueConnectionName() {
                return this.glueConnectionName;
            }

            @Override
            public final java.lang.String getGlueVersion() {
                return this.glueVersion;
            }

            @Override
            public final java.lang.Number getIdleTimeout() {
                return this.idleTimeout;
            }

            @Override
            public final java.lang.String getJavaVirtualEnv() {
                return this.javaVirtualEnv;
            }

            @Override
            public final java.lang.Number getNumberOfWorkers() {
                return this.numberOfWorkers;
            }

            @Override
            public final java.lang.String getPythonVirtualEnv() {
                return this.pythonVirtualEnv;
            }

            @Override
            public final java.lang.String getWorkerType() {
                return this.workerType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalArgs() != null) {
                    data.set("additionalArgs", om.valueToTree(this.getAdditionalArgs()));
                }
                if (this.getGlueConnectionName() != null) {
                    data.set("glueConnectionName", om.valueToTree(this.getGlueConnectionName()));
                }
                if (this.getGlueVersion() != null) {
                    data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
                }
                if (this.getIdleTimeout() != null) {
                    data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
                }
                if (this.getJavaVirtualEnv() != null) {
                    data.set("javaVirtualEnv", om.valueToTree(this.getJavaVirtualEnv()));
                }
                if (this.getNumberOfWorkers() != null) {
                    data.set("numberOfWorkers", om.valueToTree(this.getNumberOfWorkers()));
                }
                if (this.getPythonVirtualEnv() != null) {
                    data.set("pythonVirtualEnv", om.valueToTree(this.getPythonVirtualEnv()));
                }
                if (this.getWorkerType() != null) {
                    data.set("workerType", om.valueToTree(this.getWorkerType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.SparkGluePropertiesInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SparkGluePropertiesInputProperty.Jsii$Proxy that = (SparkGluePropertiesInputProperty.Jsii$Proxy) o;

                if (this.additionalArgs != null ? !this.additionalArgs.equals(that.additionalArgs) : that.additionalArgs != null) return false;
                if (this.glueConnectionName != null ? !this.glueConnectionName.equals(that.glueConnectionName) : that.glueConnectionName != null) return false;
                if (this.glueVersion != null ? !this.glueVersion.equals(that.glueVersion) : that.glueVersion != null) return false;
                if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) return false;
                if (this.javaVirtualEnv != null ? !this.javaVirtualEnv.equals(that.javaVirtualEnv) : that.javaVirtualEnv != null) return false;
                if (this.numberOfWorkers != null ? !this.numberOfWorkers.equals(that.numberOfWorkers) : that.numberOfWorkers != null) return false;
                if (this.pythonVirtualEnv != null ? !this.pythonVirtualEnv.equals(that.pythonVirtualEnv) : that.pythonVirtualEnv != null) return false;
                return this.workerType != null ? this.workerType.equals(that.workerType) : that.workerType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalArgs != null ? this.additionalArgs.hashCode() : 0;
                result = 31 * result + (this.glueConnectionName != null ? this.glueConnectionName.hashCode() : 0);
                result = 31 * result + (this.glueVersion != null ? this.glueVersion.hashCode() : 0);
                result = 31 * result + (this.idleTimeout != null ? this.idleTimeout.hashCode() : 0);
                result = 31 * result + (this.javaVirtualEnv != null ? this.javaVirtualEnv.hashCode() : 0);
                result = 31 * result + (this.numberOfWorkers != null ? this.numberOfWorkers.hashCode() : 0);
                result = 31 * result + (this.pythonVirtualEnv != null ? this.pythonVirtualEnv.hashCode() : 0);
                result = 31 * result + (this.workerType != null ? this.workerType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The username and password of a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * UsernamePasswordProperty usernamePasswordProperty = UsernamePasswordProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-usernamepassword.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-usernamepassword.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnection.UsernamePasswordProperty")
    @software.amazon.jsii.Jsii.Proxy(UsernamePasswordProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UsernamePasswordProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-usernamepassword.html#cfn-datazone-connection-usernamepassword-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-usernamepassword.html#cfn-datazone-connection-usernamepassword-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The username of a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-usernamepassword.html#cfn-datazone-connection-usernamepassword-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-connection-usernamepassword.html#cfn-datazone-connection-usernamepassword-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link UsernamePasswordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UsernamePasswordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UsernamePasswordProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link UsernamePasswordProperty#getPassword}
             * @param password The password of a connection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link UsernamePasswordProperty#getUsername}
             * @param username The username of a connection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UsernamePasswordProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UsernamePasswordProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UsernamePasswordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsernamePasswordProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnection.UsernamePasswordProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UsernamePasswordProperty.Jsii$Proxy that = (UsernamePasswordProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datazone.CfnConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datazone.CfnConnection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datazone.CfnConnectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datazone.CfnConnectionProps.Builder();
        }

        /**
         * The ID of the domain where the connection is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-domainidentifier</a>
         * @param domainIdentifier The ID of the domain where the connection is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(final java.lang.String domainIdentifier) {
            this.props.domainIdentifier(domainIdentifier);
            return this;
        }

        /**
         * The ID of the environment where the connection is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-environmentidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-environmentidentifier</a>
         * @param environmentIdentifier The ID of the environment where the connection is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(final java.lang.String environmentIdentifier) {
            this.props.environmentIdentifier(environmentIdentifier);
            return this;
        }

        /**
         * The name of the connection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-name</a>
         * @param name The name of the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The location where the connection is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-awslocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-awslocation</a>
         * @param awsLocation The location where the connection is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsLocation(final software.amazon.awscdk.IResolvable awsLocation) {
            this.props.awsLocation(awsLocation);
            return this;
        }
        /**
         * The location where the connection is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-awslocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-awslocation</a>
         * @param awsLocation The location where the connection is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsLocation(final software.amazon.awscdk.services.datazone.CfnConnection.AwsLocationProperty awsLocation) {
            this.props.awsLocation(awsLocation);
            return this;
        }

        /**
         * Connection description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-description</a>
         * @param description Connection description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Connection props.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-props">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-props</a>
         * @param props Connection props. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(final software.amazon.awscdk.IResolvable props) {
            this.props.props(props);
            return this;
        }
        /**
         * Connection props.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-props">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-props</a>
         * @param props Connection props. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(final software.amazon.awscdk.services.datazone.CfnConnection.ConnectionPropertiesInputProperty props) {
            this.props.props(props);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.datazone.CfnConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datazone.CfnConnection build() {
            return new software.amazon.awscdk.services.datazone.CfnConnection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
