package software.amazon.awscdk.services.directoryservice;

/**
 * Properties for defining a <code>CfnMicrosoftAD</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.directoryservice.*;
 * CfnMicrosoftADProps cfnMicrosoftADProps = CfnMicrosoftADProps.builder()
 *         .name("name")
 *         .password("password")
 *         .vpcSettings(VpcSettingsProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 .vpcId("vpcId")
 *                 .build())
 *         // the properties below are optional
 *         .createAlias(false)
 *         .edition("edition")
 *         .enableSso(false)
 *         .shortName("shortName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:53.319Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_directoryservice.CfnMicrosoftADProps")
@software.amazon.jsii.Jsii.Proxy(CfnMicrosoftADProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMicrosoftADProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The fully qualified domain name for the AWS Managed Microsoft AD directory, such as <code>corp.example.com</code> . This name will resolve inside your VPC only. It does not need to be publicly resolvable.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The password for the default administrative user named <code>Admin</code> .
     * <p>
     * If you need to change the password for the administrator account, see the <a href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html">ResetUserPassword</a> API call in the <em>AWS Directory Service API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPassword();

    /**
     * Specifies the VPC settings of the Microsoft AD directory server in AWS .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVpcSettings();

    /**
     * Specifies an alias for a directory and assigns the alias to the directory.
     * <p>
     * The alias is used to construct the access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code> . By default, AWS CloudFormation does not create an alias.
     * <p>
     * <blockquote>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreateAlias() {
        return null;
    }

    /**
     * AWS Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code> .
     * <p>
     * <code>Enterprise</code> is the default.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEdition() {
        return null;
    }

    /**
     * Whether to enable single sign-on for a Microsoft Active Directory in AWS .
     * <p>
     * Single sign-on allows users in your directory to access certain AWS services from a computer joined to the directory without having to enter their credentials separately. If you don't specify a value, AWS CloudFormation disables single sign-on by default.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSso() {
        return null;
    }

    /**
     * The NetBIOS name for your domain, such as <code>CORP</code> .
     * <p>
     * If you don't specify a NetBIOS name, it will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS <code>corp.example.com</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShortName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMicrosoftADProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMicrosoftADProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMicrosoftADProps> {
        java.lang.String name;
        java.lang.String password;
        java.lang.Object vpcSettings;
        java.lang.Object createAlias;
        java.lang.String edition;
        java.lang.Object enableSso;
        java.lang.String shortName;

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getName}
         * @param name The fully qualified domain name for the AWS Managed Microsoft AD directory, such as <code>corp.example.com</code> . This name will resolve inside your VPC only. It does not need to be publicly resolvable. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getPassword}
         * @param password The password for the default administrative user named <code>Admin</code> . This parameter is required.
         *                 If you need to change the password for the administrator account, see the <a href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html">ResetUserPassword</a> API call in the <em>AWS Directory Service API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getVpcSettings}
         * @param vpcSettings Specifies the VPC settings of the Microsoft AD directory server in AWS . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSettings(software.amazon.awscdk.IResolvable vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getVpcSettings}
         * @param vpcSettings Specifies the VPC settings of the Microsoft AD directory server in AWS . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSettings(software.amazon.awscdk.services.directoryservice.CfnMicrosoftAD.VpcSettingsProperty vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getCreateAlias}
         * @param createAlias Specifies an alias for a directory and assigns the alias to the directory.
         *                    The alias is used to construct the access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code> . By default, AWS CloudFormation does not create an alias.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAlias(java.lang.Boolean createAlias) {
            this.createAlias = createAlias;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getCreateAlias}
         * @param createAlias Specifies an alias for a directory and assigns the alias to the directory.
         *                    The alias is used to construct the access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code> . By default, AWS CloudFormation does not create an alias.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAlias(software.amazon.awscdk.IResolvable createAlias) {
            this.createAlias = createAlias;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getEdition}
         * @param edition AWS Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code> .
         *                <code>Enterprise</code> is the default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(java.lang.String edition) {
            this.edition = edition;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getEnableSso}
         * @param enableSso Whether to enable single sign-on for a Microsoft Active Directory in AWS .
         *                  Single sign-on allows users in your directory to access certain AWS services from a computer joined to the directory without having to enter their credentials separately. If you don't specify a value, AWS CloudFormation disables single sign-on by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSso(java.lang.Boolean enableSso) {
            this.enableSso = enableSso;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getEnableSso}
         * @param enableSso Whether to enable single sign-on for a Microsoft Active Directory in AWS .
         *                  Single sign-on allows users in your directory to access certain AWS services from a computer joined to the directory without having to enter their credentials separately. If you don't specify a value, AWS CloudFormation disables single sign-on by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSso(software.amazon.awscdk.IResolvable enableSso) {
            this.enableSso = enableSso;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftADProps#getShortName}
         * @param shortName The NetBIOS name for your domain, such as <code>CORP</code> .
         *                  If you don't specify a NetBIOS name, it will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS <code>corp.example.com</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortName(java.lang.String shortName) {
            this.shortName = shortName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMicrosoftADProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMicrosoftADProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMicrosoftADProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMicrosoftADProps {
        private final java.lang.String name;
        private final java.lang.String password;
        private final java.lang.Object vpcSettings;
        private final java.lang.Object createAlias;
        private final java.lang.String edition;
        private final java.lang.Object enableSso;
        private final java.lang.String shortName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSettings = software.amazon.jsii.Kernel.get(this, "vpcSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createAlias = software.amazon.jsii.Kernel.get(this, "createAlias", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.edition = software.amazon.jsii.Kernel.get(this, "edition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableSso = software.amazon.jsii.Kernel.get(this, "enableSso", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.shortName = software.amazon.jsii.Kernel.get(this, "shortName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
            this.vpcSettings = java.util.Objects.requireNonNull(builder.vpcSettings, "vpcSettings is required");
            this.createAlias = builder.createAlias;
            this.edition = builder.edition;
            this.enableSso = builder.enableSso;
            this.shortName = builder.shortName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Object getVpcSettings() {
            return this.vpcSettings;
        }

        @Override
        public final java.lang.Object getCreateAlias() {
            return this.createAlias;
        }

        @Override
        public final java.lang.String getEdition() {
            return this.edition;
        }

        @Override
        public final java.lang.Object getEnableSso() {
            return this.enableSso;
        }

        @Override
        public final java.lang.String getShortName() {
            return this.shortName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("password", om.valueToTree(this.getPassword()));
            data.set("vpcSettings", om.valueToTree(this.getVpcSettings()));
            if (this.getCreateAlias() != null) {
                data.set("createAlias", om.valueToTree(this.getCreateAlias()));
            }
            if (this.getEdition() != null) {
                data.set("edition", om.valueToTree(this.getEdition()));
            }
            if (this.getEnableSso() != null) {
                data.set("enableSso", om.valueToTree(this.getEnableSso()));
            }
            if (this.getShortName() != null) {
                data.set("shortName", om.valueToTree(this.getShortName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_directoryservice.CfnMicrosoftADProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMicrosoftADProps.Jsii$Proxy that = (CfnMicrosoftADProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!password.equals(that.password)) return false;
            if (!vpcSettings.equals(that.vpcSettings)) return false;
            if (this.createAlias != null ? !this.createAlias.equals(that.createAlias) : that.createAlias != null) return false;
            if (this.edition != null ? !this.edition.equals(that.edition) : that.edition != null) return false;
            if (this.enableSso != null ? !this.enableSso.equals(that.enableSso) : that.enableSso != null) return false;
            return this.shortName != null ? this.shortName.equals(that.shortName) : that.shortName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.password.hashCode());
            result = 31 * result + (this.vpcSettings.hashCode());
            result = 31 * result + (this.createAlias != null ? this.createAlias.hashCode() : 0);
            result = 31 * result + (this.edition != null ? this.edition.hashCode() : 0);
            result = 31 * result + (this.enableSso != null ? this.enableSso.hashCode() : 0);
            result = 31 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
            return result;
        }
    }
}
