package software.amazon.awscdk.services.dynamodb;

/**
 * Data types for attributes within a table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         // applies to all replicas, i.e., us-west-2, us-east-1, us-east-2
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .replicas(List.of(ReplicaTableProps.builder().region("us-east-1").build(), ReplicaTableProps.builder().region("us-east-2").build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:53.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.AttributeType")
public enum AttributeType {
    /**
     * Up to 400KiB of binary data (which must be encoded as base64 before sending to DynamoDB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BINARY,
    /**
     * Numeric values made of up to 38 digits (positive, negative or zero).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NUMBER,
    /**
     * Up to 400KiB of UTF-8 encoded text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
}
