package software.amazon.awscdk.services.dynamodb;

/**
 * Options used to configure autoscaled capacity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .billing(Billing.provisioned(ThroughputProps.builder()
 *                 .readCapacity(Capacity.fixed(10))
 *                 .writeCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(15).build()))
 *                 .build()))
 *         .replicas(List.of(ReplicaTableProps.builder()
 *                 .region("us-east-1")
 *                 .build(), ReplicaTableProps.builder()
 *                 .region("us-east-2")
 *                 .readCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(20).targetUtilizationPercent(50).build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:53.524Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.AutoscaledCapacityOptions")
@software.amazon.jsii.Jsii.Proxy(AutoscaledCapacityOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoscaledCapacityOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum allowable capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

    /**
     * The minimum allowable capacity.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
        return null;
    }

    /**
     * If you want to switch a table's billing mode from on-demand to provisioned or from provisioned to on-demand, you must specify a value for this property for each autoscaled resource.
     * <p>
     * Default: no seed capacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSeedCapacity() {
        return null;
    }

    /**
     * The ratio of consumed capacity units to provisioned capacity units.
     * <p>
     * Note: Target utilization percent cannot be less than 20 and cannot be greater
     * than 90.
     * <p>
     * Default: 70
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetUtilizationPercent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoscaledCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoscaledCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoscaledCapacityOptions> {
        java.lang.Number maxCapacity;
        java.lang.Number minCapacity;
        java.lang.Number seedCapacity;
        java.lang.Number targetUtilizationPercent;

        /**
         * Sets the value of {@link AutoscaledCapacityOptions#getMaxCapacity}
         * @param maxCapacity The maximum allowable capacity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link AutoscaledCapacityOptions#getMinCapacity}
         * @param minCapacity The minimum allowable capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link AutoscaledCapacityOptions#getSeedCapacity}
         * @param seedCapacity If you want to switch a table's billing mode from on-demand to provisioned or from provisioned to on-demand, you must specify a value for this property for each autoscaled resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder seedCapacity(java.lang.Number seedCapacity) {
            this.seedCapacity = seedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link AutoscaledCapacityOptions#getTargetUtilizationPercent}
         * @param targetUtilizationPercent The ratio of consumed capacity units to provisioned capacity units.
         *                                 Note: Target utilization percent cannot be less than 20 and cannot be greater
         *                                 than 90.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetUtilizationPercent(java.lang.Number targetUtilizationPercent) {
            this.targetUtilizationPercent = targetUtilizationPercent;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoscaledCapacityOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoscaledCapacityOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoscaledCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoscaledCapacityOptions {
        private final java.lang.Number maxCapacity;
        private final java.lang.Number minCapacity;
        private final java.lang.Number seedCapacity;
        private final java.lang.Number targetUtilizationPercent;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.seedCapacity = software.amazon.jsii.Kernel.get(this, "seedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetUtilizationPercent = software.amazon.jsii.Kernel.get(this, "targetUtilizationPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
            this.minCapacity = builder.minCapacity;
            this.seedCapacity = builder.seedCapacity;
            this.targetUtilizationPercent = builder.targetUtilizationPercent;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.lang.Number getSeedCapacity() {
            return this.seedCapacity;
        }

        @Override
        public final java.lang.Number getTargetUtilizationPercent() {
            return this.targetUtilizationPercent;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getSeedCapacity() != null) {
                data.set("seedCapacity", om.valueToTree(this.getSeedCapacity()));
            }
            if (this.getTargetUtilizationPercent() != null) {
                data.set("targetUtilizationPercent", om.valueToTree(this.getTargetUtilizationPercent()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.AutoscaledCapacityOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoscaledCapacityOptions.Jsii$Proxy that = (AutoscaledCapacityOptions.Jsii$Proxy) o;

            if (!maxCapacity.equals(that.maxCapacity)) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.seedCapacity != null ? !this.seedCapacity.equals(that.seedCapacity) : that.seedCapacity != null) return false;
            return this.targetUtilizationPercent != null ? this.targetUtilizationPercent.equals(that.targetUtilizationPercent) : that.targetUtilizationPercent == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxCapacity.hashCode();
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.seedCapacity != null ? this.seedCapacity.hashCode() : 0);
            result = 31 * result + (this.targetUtilizationPercent != null ? this.targetUtilizationPercent.hashCode() : 0);
            return result;
        }
    }
}
