package software.amazon.awscdk.services.ec2;

/**
 * Base options for amazon linux ssm parameters.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * UserData userData;
 * AmazonLinuxImageSsmParameterBaseOptions amazonLinuxImageSsmParameterBaseOptions = AmazonLinuxImageSsmParameterBaseOptions.builder()
 *         .cachedInContext(false)
 *         .userData(userData)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:53.678Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinuxImageSsmParameterBaseOptions")
@software.amazon.jsii.Jsii.Proxy(AmazonLinuxImageSsmParameterBaseOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AmazonLinuxImageSsmParameterBaseOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the AMI ID is cached to be stable between deployments.
     * <p>
     * By default, the newest image is used on each deployment. This will cause
     * instances to be replaced whenever a new version is released, and may cause
     * downtime if there aren't enough running instances in the AutoScalingGroup
     * to reschedule the tasks on.
     * <p>
     * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
     * same value will be used on future runs. Your instances will not be replaced
     * but your AMI version will grow old over time. To refresh the AMI lookup,
     * you will have to evict the value from the cache using the <code>cdk context</code>
     * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
     * more information.
     * <p>
     * Can not be set to <code>true</code> in environment-agnostic stacks.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCachedInContext() {
        return null;
    }

    /**
     * Initial user data.
     * <p>
     * Default: - Empty UserData for Linux machines
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AmazonLinuxImageSsmParameterBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AmazonLinuxImageSsmParameterBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AmazonLinuxImageSsmParameterBaseOptions> {
        java.lang.Boolean cachedInContext;
        software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Sets the value of {@link AmazonLinuxImageSsmParameterBaseOptions#getCachedInContext}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments.
         *                        By default, the newest image is used on each deployment. This will cause
         *                        instances to be replaced whenever a new version is released, and may cause
         *                        downtime if there aren't enough running instances in the AutoScalingGroup
         *                        to reschedule the tasks on.
         *                        <p>
         *                        If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         *                        same value will be used on future runs. Your instances will not be replaced
         *                        but your AMI version will grow old over time. To refresh the AMI lookup,
         *                        you will have to evict the value from the cache using the <code>cdk context</code>
         *                        command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         *                        more information.
         *                        <p>
         *                        Can not be set to <code>true</code> in environment-agnostic stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(java.lang.Boolean cachedInContext) {
            this.cachedInContext = cachedInContext;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageSsmParameterBaseOptions#getUserData}
         * @param userData Initial user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AmazonLinuxImageSsmParameterBaseOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AmazonLinuxImageSsmParameterBaseOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AmazonLinuxImageSsmParameterBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonLinuxImageSsmParameterBaseOptions {
        private final java.lang.Boolean cachedInContext;
        private final software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cachedInContext = software.amazon.jsii.Kernel.get(this, "cachedInContext", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cachedInContext = builder.cachedInContext;
            this.userData = builder.userData;
        }

        @Override
        public final java.lang.Boolean getCachedInContext() {
            return this.cachedInContext;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCachedInContext() != null) {
                data.set("cachedInContext", om.valueToTree(this.getCachedInContext()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AmazonLinuxImageSsmParameterBaseOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AmazonLinuxImageSsmParameterBaseOptions.Jsii$Proxy that = (AmazonLinuxImageSsmParameterBaseOptions.Jsii$Proxy) o;

            if (this.cachedInContext != null ? !this.cachedInContext.equals(that.cachedInContext) : that.cachedInContext != null) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cachedInContext != null ? this.cachedInContext.hashCode() : 0;
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }
    }
}
