package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnRouteServer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnRouteServerProps cfnRouteServerProps = CfnRouteServerProps.builder()
 *         .amazonSideAsn(123)
 *         // the properties below are optional
 *         .persistRoutes("persistRoutes")
 *         .persistRoutesDuration(123)
 *         .snsNotificationsEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:53.971Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnRouteServerProps")
@software.amazon.jsii.Jsii.Proxy(CfnRouteServerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRouteServerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance.
     * <p>
     * Valid values are from 1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit ASN) range.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-amazonsideasn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-amazonsideasn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getAmazonSideAsn();

    /**
     * Indicates whether routes should be persisted after all BGP sessions are terminated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-persistroutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-persistroutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPersistRoutes() {
        return null;
    }

    /**
     * The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB.
     * <p>
     * Value must be in the range of 1-5. The default value is 1. Only valid if <code>persistRoutesState</code> is 'enabled'.
     * <p>
     * If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route server, it has 1 minute to relearn it's adjacent network and advertise those routes to route server before route server resumes normal functionality. In most cases, 1 minute is probably sufficient. If, however, you have concerns that your BGP network may not be capable of fully re-establishing and re-learning everything in 1 minute, you can increase the duration up to 5 minutes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-persistroutesduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-persistroutesduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPersistRoutesDuration() {
        return null;
    }

    /**
     * Indicates whether SNS notifications are enabled for the route server.
     * <p>
     * Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-snsnotificationsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-snsnotificationsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnsNotificationsEnabled() {
        return null;
    }

    /**
     * Any tags assigned to the route server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routeserver.html#cfn-ec2-routeserver-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRouteServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRouteServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRouteServerProps> {
        java.lang.Number amazonSideAsn;
        java.lang.String persistRoutes;
        java.lang.Number persistRoutesDuration;
        java.lang.Object snsNotificationsEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRouteServerProps#getAmazonSideAsn}
         * @param amazonSideAsn The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. This parameter is required.
         *                      Valid values are from 1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit ASN) range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonSideAsn(java.lang.Number amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteServerProps#getPersistRoutes}
         * @param persistRoutes Indicates whether routes should be persisted after all BGP sessions are terminated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder persistRoutes(java.lang.String persistRoutes) {
            this.persistRoutes = persistRoutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteServerProps#getPersistRoutesDuration}
         * @param persistRoutesDuration The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB.
         *                              Value must be in the range of 1-5. The default value is 1. Only valid if <code>persistRoutesState</code> is 'enabled'.
         *                              <p>
         *                              If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route server, it has 1 minute to relearn it's adjacent network and advertise those routes to route server before route server resumes normal functionality. In most cases, 1 minute is probably sufficient. If, however, you have concerns that your BGP network may not be capable of fully re-establishing and re-learning everything in 1 minute, you can increase the duration up to 5 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder persistRoutesDuration(java.lang.Number persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteServerProps#getSnsNotificationsEnabled}
         * @param snsNotificationsEnabled Indicates whether SNS notifications are enabled for the route server.
         *                                Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsNotificationsEnabled(java.lang.Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteServerProps#getSnsNotificationsEnabled}
         * @param snsNotificationsEnabled Indicates whether SNS notifications are enabled for the route server.
         *                                Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsNotificationsEnabled(software.amazon.awscdk.IResolvable snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteServerProps#getTags}
         * @param tags Any tags assigned to the route server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteServerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRouteServerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRouteServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouteServerProps {
        private final java.lang.Number amazonSideAsn;
        private final java.lang.String persistRoutes;
        private final java.lang.Number persistRoutesDuration;
        private final java.lang.Object snsNotificationsEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.amazonSideAsn = software.amazon.jsii.Kernel.get(this, "amazonSideAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.persistRoutes = software.amazon.jsii.Kernel.get(this, "persistRoutes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.persistRoutesDuration = software.amazon.jsii.Kernel.get(this, "persistRoutesDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snsNotificationsEnabled = software.amazon.jsii.Kernel.get(this, "snsNotificationsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.amazonSideAsn = java.util.Objects.requireNonNull(builder.amazonSideAsn, "amazonSideAsn is required");
            this.persistRoutes = builder.persistRoutes;
            this.persistRoutesDuration = builder.persistRoutesDuration;
            this.snsNotificationsEnabled = builder.snsNotificationsEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final java.lang.String getPersistRoutes() {
            return this.persistRoutes;
        }

        @Override
        public final java.lang.Number getPersistRoutesDuration() {
            return this.persistRoutesDuration;
        }

        @Override
        public final java.lang.Object getSnsNotificationsEnabled() {
            return this.snsNotificationsEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("amazonSideAsn", om.valueToTree(this.getAmazonSideAsn()));
            if (this.getPersistRoutes() != null) {
                data.set("persistRoutes", om.valueToTree(this.getPersistRoutes()));
            }
            if (this.getPersistRoutesDuration() != null) {
                data.set("persistRoutesDuration", om.valueToTree(this.getPersistRoutesDuration()));
            }
            if (this.getSnsNotificationsEnabled() != null) {
                data.set("snsNotificationsEnabled", om.valueToTree(this.getSnsNotificationsEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnRouteServerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouteServerProps.Jsii$Proxy that = (CfnRouteServerProps.Jsii$Proxy) o;

            if (!amazonSideAsn.equals(that.amazonSideAsn)) return false;
            if (this.persistRoutes != null ? !this.persistRoutes.equals(that.persistRoutes) : that.persistRoutes != null) return false;
            if (this.persistRoutesDuration != null ? !this.persistRoutesDuration.equals(that.persistRoutesDuration) : that.persistRoutesDuration != null) return false;
            if (this.snsNotificationsEnabled != null ? !this.snsNotificationsEnabled.equals(that.snsNotificationsEnabled) : that.snsNotificationsEnabled != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.amazonSideAsn.hashCode();
            result = 31 * result + (this.persistRoutes != null ? this.persistRoutes.hashCode() : 0);
            result = 31 * result + (this.persistRoutesDuration != null ? this.persistRoutesDuration.hashCode() : 0);
            result = 31 * result + (this.snsNotificationsEnabled != null ? this.snsNotificationsEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
