package software.amazon.awscdk.services.ec2;

/**
 * An abstract Provider of IpAddresses.
 * <p>
 * Note this is specific to the IPv4 CIDR.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "TheVPC")
 *         // 'IpAddresses' configures the IP range and size of the entire VPC.
 *         // The IP space will be divided based on configuration for the subnets.
 *         .ipAddresses(IpAddresses.cidr("10.0.0.0/21"))
 *         // 'maxAzs' configures the maximum number of availability zones to use.
 *         // If you want to specify the exact availability zones you want the VPC
 *         // to use, use `availabilityZones` instead.
 *         .maxAzs(3)
 *         // 'subnetConfiguration' specifies the "subnet groups" to create.
 *         // Every subnet group will have a subnet for each AZ, so this
 *         // configuration will create `3 groups × 3 AZs = 9` subnets.
 *         .subnetConfiguration(List.of(SubnetConfiguration.builder()
 *                 // 'subnetType' controls Internet access, as described above.
 *                 .subnetType(SubnetType.PUBLIC)
 *                 // 'name' is used to name this particular subnet group. You will have to
 *                 // use the name for subnet selection if you have more than one subnet
 *                 // group of the same type.
 *                 .name("Ingress")
 *                 // 'cidrMask' specifies the IP addresses in the range of of individual
 *                 // subnets in the group. Each of the subnets in this group will contain
 *                 // `2^(32 address bits - 24 subnet bits) - 2 reserved addresses = 254`
 *                 // usable IP addresses.
 *                 //
 *                 // If 'cidrMask' is left out the available address space is evenly
 *                 // divided across the remaining subnet groups.
 *                 .cidrMask(24)
 *                 .build(), SubnetConfiguration.builder()
 *                 .cidrMask(24)
 *                 .name("Application")
 *                 .subnetType(SubnetType.PRIVATE_WITH_EGRESS)
 *                 .build(), SubnetConfiguration.builder()
 *                 .cidrMask(28)
 *                 .name("Database")
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 // 'reserved' can be used to reserve IP address space. No resources will
 *                 // be created for this subnet, but the IP range will be kept available for
 *                 // future creation of this subnet, or even for future subdivision.
 *                 .reserved(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.263Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IpAddresses")
public class IpAddresses extends software.amazon.jsii.JsiiObject {

    protected IpAddresses(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IpAddresses(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Used to provide centralized Ip Address Management services for your VPC.
     * <p>
     * Uses VPC CIDR allocations from AWS IPAM
     * <p>
     * Note this is specific to the IPv4 CIDR.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-it-is-ipam.html">https://docs.aws.amazon.com/vpc/latest/ipam/what-it-is-ipam.html</a>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IIpAddresses awsIpamAllocation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AwsIpamProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.IpAddresses.class, "awsIpamAllocation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IIpAddresses.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Used to provide local Ip Address Management services for your VPC.
     * <p>
     * VPC CIDR is supplied at creation and subnets are calculated locally
     * <p>
     * Note this is specific to the IPv4 CIDR.
     * <p>
     * @param cidrBlock This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IIpAddresses cidr(final @org.jetbrains.annotations.NotNull java.lang.String cidrBlock) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.IpAddresses.class, "cidr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IIpAddresses.class), new Object[] { java.util.Objects.requireNonNull(cidrBlock, "cidrBlock is required") });
    }
}
