package software.amazon.awscdk.services.ec2;

/**
 * An EC2 Key Pair.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IKeyPair keyPair = KeyPair.fromKeyPairAttributes(this, "KeyPair", KeyPairAttributes.builder()
 *         .keyPairName("the-keypair-name")
 *         .type(KeyPairType.RSA)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.263Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.KeyPair")
public class KeyPair extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IKeyPair {

    protected KeyPair(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KeyPair(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.KeyPair.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KeyPair(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.KeyPairProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KeyPair(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a key pair with a name and optional type.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IKeyPair fromKeyPairAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.KeyPairAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.KeyPair.class, "fromKeyPairAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Imports a key pair based on the name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param keyPairName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IKeyPair fromKeyPairName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String keyPairName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.KeyPair.class, "fromKeyPairName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(keyPairName, "keyPairName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The format of the key pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.KeyPairFormat getFormat() {
        return software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.KeyPairFormat.class));
    }

    /**
     * Whether the key material was imported.
     * <p>
     * Keys with imported material do not have their private key material stored
     * or returned automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasImportedMaterial() {
        return software.amazon.jsii.Kernel.get(this, "hasImportedMaterial", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The fingerprint of the key pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyPairFingerprint() {
        return software.amazon.jsii.Kernel.get(this, "keyPairFingerprint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the key pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyPairId() {
        return software.amazon.jsii.Kernel.get(this, "keyPairId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the key pair.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyPairName() {
        return software.amazon.jsii.Kernel.get(this, "keyPairName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Systems Manager Parameter Store parameter with the pair's private key material.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IStringParameter getPrivateKey() {
        return software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.IStringParameter.class));
    }

    /**
     * The type of the key pair.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.KeyPairType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.KeyPairType.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.KeyPair}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.KeyPair> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.KeyPairProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The AWS account ID this resource belongs to.
         * <p>
         * Default: - the resource is in the same account as the stack it belongs to
         * <p>
         * @return {@code this}
         * @param account The AWS account ID this resource belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(final java.lang.String account) {
            this.props().account(account);
            return this;
        }

        /**
         * ARN to deduce region and account from.
         * <p>
         * The ARN is parsed and the account and region are taken from the ARN.
         * This should be used for imported resources.
         * <p>
         * Cannot be supplied together with either <code>account</code> or <code>region</code>.
         * <p>
         * Default: - take environment from `account`, `region` parameters, or use Stack environment.
         * <p>
         * @return {@code this}
         * @param environmentFromArn ARN to deduce region and account from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentFromArn(final java.lang.String environmentFromArn) {
            this.props().environmentFromArn(environmentFromArn);
            return this;
        }

        /**
         * The value passed in by users to the physical name prop of the resource.
         * <p>
         * <ul>
         * <li><code>undefined</code> implies that a physical name will be allocated by
         * CloudFormation during deployment.</li>
         * <li>a concrete value implies a specific physical name</li>
         * <li><code>PhysicalName.GENERATE_IF_NEEDED</code> is a marker that indicates that a physical will only be generated
         * by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.</li>
         * </ul>
         * <p>
         * Default: - The physical name will be allocated by CloudFormation at deployment time
         * <p>
         * @return {@code this}
         * @param physicalName The value passed in by users to the physical name prop of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalName(final java.lang.String physicalName) {
            this.props().physicalName(physicalName);
            return this;
        }

        /**
         * The AWS region this resource belongs to.
         * <p>
         * Default: - the resource is in the same region as the stack it belongs to
         * <p>
         * @return {@code this}
         * @param region The AWS region this resource belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props().region(region);
            return this;
        }

        /**
         * The format of the key pair.
         * <p>
         * Default: PEM
         * <p>
         * @return {@code this}
         * @param format The format of the key pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(final software.amazon.awscdk.services.ec2.KeyPairFormat format) {
            this.props().format(format);
            return this;
        }

        /**
         * A unique name for the key pair.
         * <p>
         * Default: A generated name
         * <p>
         * @return {@code this}
         * @param keyPairName A unique name for the key pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPairName(final java.lang.String keyPairName) {
            this.props().keyPairName(keyPairName);
            return this;
        }

        /**
         * The public key material.
         * <p>
         * If this is provided the key is considered "imported". For imported
         * keys, it is assumed that you already have the private key material
         * so the private key material will not be returned or stored in
         * AWS Systems Manager Parameter Store.
         * <p>
         * Default: a public and private key will be generated
         * <p>
         * @return {@code this}
         * @param publicKeyMaterial The public key material. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeyMaterial(final java.lang.String publicKeyMaterial) {
            this.props().publicKeyMaterial(publicKeyMaterial);
            return this;
        }

        /**
         * The type of key pair.
         * <p>
         * Default: RSA (ignored if keyMaterial is provided)
         * <p>
         * @return {@code this}
         * @param type The type of key pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.ec2.KeyPairType type) {
            this.props().type(type);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.KeyPair}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.KeyPair build() {
            return new software.amazon.awscdk.services.ec2.KeyPair(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.KeyPairProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.KeyPairProps.Builder();
            }
            return this.props;
        }
    }
}
