package software.amazon.awscdk.services.ec2;

/**
 * The format of the Key Pair.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * KeyPair keyPair = KeyPair.Builder.create(this, "KeyPair")
 *         .type(KeyPairType.ED25519)
 *         .format(KeyPairFormat.PEM)
 *         .build();
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         // Use the custom key pair
 *         .keyPair(keyPair)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.265Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.KeyPairFormat")
public enum KeyPairFormat {
    /**
     * A PPK file, typically used with PuTTY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PPK,
    /**
     * A PEM file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PEM,
}
