package software.amazon.awscdk.services.ec2;

/**
 * Factory functions for standard Amazon Machine Image objects.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .securityGroup(mySecurityGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.283Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.MachineImage")
public abstract class MachineImage extends software.amazon.jsii.JsiiObject {

    protected MachineImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MachineImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected MachineImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * An image specified in SSM parameter store.
     * <p>
     * By default, the SSM parameter is refreshed at every deployment,
     * causing your instances to be replaced whenever a new version of the AMI
     * is released.
     * <p>
     * Pass <code>{ cachedInContext: true }</code> to keep the AMI ID stable. If you do, you
     * will have to remember to periodically invalidate the context to refresh
     * to the newest AMI ID.
     * <p>
     * @param parameterName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage fromSsmParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SsmParameterImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), options });
    }

    /**
     * An image specified in SSM parameter store.
     * <p>
     * By default, the SSM parameter is refreshed at every deployment,
     * causing your instances to be replaced whenever a new version of the AMI
     * is released.
     * <p>
     * Pass <code>{ cachedInContext: true }</code> to keep the AMI ID stable. If you do, you
     * will have to remember to periodically invalidate the context to refresh
     * to the newest AMI ID.
     * <p>
     * @param parameterName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage fromSsmParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * A Linux image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     * @param props Customize the image by supplying additional props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericLinux(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * A Linux image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericLinux(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * A Windows image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     * @param props Customize the image by supplying additional props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericWindows(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericWindowsImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * A Windows image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericWindows(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * (deprecated) An Amazon Linux image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * N.B.: "latest" in the name of this function indicates that it always uses the most recent
     * image of a particular generation of Amazon Linux, not that it uses the "latest generation".
     * For backwards compatibility, this function uses Amazon Linux 1 if no generation
     * is specified.
     * <p>
     * Specify the desired generation using the <code>generation</code> property:
     * <p>
     * <blockquote><pre>
     * MachineImage.latestAmazonLinux(AmazonLinuxImageProps.builder()
     *         // Use Amazon Linux 2
     *         .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
     *         .build());
     * </pre></blockquote>
     * <p>
     * @deprecated use MachineImage.latestAmazonLinux2 instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { props });
    }

    /**
     * (deprecated) An Amazon Linux image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * N.B.: "latest" in the name of this function indicates that it always uses the most recent
     * image of a particular generation of Amazon Linux, not that it uses the "latest generation".
     * For backwards compatibility, this function uses Amazon Linux 1 if no generation
     * is specified.
     * <p>
     * Specify the desired generation using the <code>generation</code> property:
     * <p>
     * <blockquote><pre>
     * MachineImage.latestAmazonLinux(AmazonLinuxImageProps.builder()
     *         // Use Amazon Linux 2
     *         .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
     *         .build());
     * </pre></blockquote>
     * <p>
     * @deprecated use MachineImage.latestAmazonLinux2 instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
    }

    /**
     * An Amazon Linux 2 image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinux2ImageSsmParameterProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { props });
    }

    /**
     * An Amazon Linux 2 image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
    }

    /**
     * (deprecated) An Amazon Linux 2022 image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @deprecated <ul>
     * <li>use latestAmazonLinux2023() instead</li>
     * </ul>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux2022(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinux2022ImageSsmParameterProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux2022", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { props });
    }

    /**
     * (deprecated) An Amazon Linux 2022 image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @deprecated <ul>
     * <li>use latestAmazonLinux2023() instead</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux2022() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux2022", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
    }

    /**
     * An Amazon Linux 2023 image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux2023(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinux2023ImageSsmParameterProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux2023", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { props });
    }

    /**
     * An Amazon Linux 2023 image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux2023() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux2023", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
    }

    /**
     * A Windows image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param version This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestWindows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.WindowsImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required"), props });
    }

    /**
     * A Windows image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestWindows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Look up a shared Machine Image using DescribeImages.
     * <p>
     * The most recent, available, launchable image matching the given filter
     * criteria will be used. Looking up AMIs may take a long time; specify
     * as many filter criteria as possible to narrow down the search.
     * <p>
     * The AMI selected will be cached in <code>cdk.context.json</code> and the same value
     * will be used on future runs. To refresh the AMI lookup, you will have to
     * evict the value from the cache using the <code>cdk context</code> command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     * <p>
     * This function can not be used in environment-agnostic stacks.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage lookup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LookupMachineImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "lookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * An image specified in SSM parameter store that will be resolved at instance launch time.
     * <p>
     * The AMI ID will be resolved at instance launch time.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/using-systems-manager-parameters.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/using-systems-manager-parameters.html</a>
     * @param parameterName The name of SSM parameter containing the AMI ID. This parameter is required.
     * @param options The parameter image options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage resolveSsmParameterAtLaunch(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SsmParameterImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "resolveSsmParameterAtLaunch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), options });
    }

    /**
     * An image specified in SSM parameter store that will be resolved at instance launch time.
     * <p>
     * The AMI ID will be resolved at instance launch time.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/using-systems-manager-parameters.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/using-systems-manager-parameters.html</a>
     * @param parameterName The name of SSM parameter containing the AMI ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage resolveSsmParameterAtLaunch(final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "resolveSsmParameterAtLaunch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.MachineImage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
