package software.amazon.awscdk.services.ecs.patterns;

/**
 * Properties to define an application listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * Certificate certificate;
 * ApplicationListenerProps applicationListenerProps = ApplicationListenerProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .certificate(certificate)
 *         .port(123)
 *         .protocol(ApplicationProtocol.HTTP)
 *         .sslPolicy(SslPolicy.RECOMMENDED_TLS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.777Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationListenerProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Certificate Manager certificate to associate with the load balancer.
     * <p>
     * Setting this option will set the load balancer protocol to HTTPS.
     * <p>
     * Default: - No certificate associated with the load balancer, if using
     * the HTTP protocol. For HTTPS, a DNS-validated certificate will be
     * created for the load balancer's specified domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * The port on which the listener listens for requests.
     * <p>
     * Default: - Determined from protocol if known.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The protocol for connections from clients to the load balancer.
     * <p>
     * The load balancer port is determined from the protocol (port 80 for
     * HTTP, port 443 for HTTPS).  A domain name and zone must be also be
     * specified if using HTTPS.
     * <p>
     * Default: ApplicationProtocol.HTTP. If a certificate is specified, the protocol will be
     * set by default to ApplicationProtocol.HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
        return null;
    }

    /**
     * The security policy that defines which ciphers and protocols are supported by the ALB Listener.
     * <p>
     * Default: - The recommended elastic load balancing security policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationListenerProps> {
        java.lang.String name;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.lang.Number port;
        software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Sets the value of {@link ApplicationListenerProps#getName}
         * @param name Name of the listener. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getCertificate}
         * @param certificate Certificate Manager certificate to associate with the load balancer.
         *                    Setting this option will set the load balancer protocol to HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getPort}
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getProtocol}
         * @param protocol The protocol for connections from clients to the load balancer.
         *                 The load balancer port is determined from the protocol (port 80 for
         *                 HTTP, port 443 for HTTPS).  A domain name and zone must be also be
         *                 specified if using HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getSslPolicy}
         * @param sslPolicy The security policy that defines which ciphers and protocols are supported by the ALB Listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationListenerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerProps {
        private final java.lang.String name;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class));
            this.sslPolicy = software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.certificate = builder.certificate;
            this.port = builder.port;
            this.protocol = builder.protocol;
            this.sslPolicy = builder.sslPolicy;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSslPolicy() != null) {
                data.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ApplicationListenerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerProps.Jsii$Proxy that = (ApplicationListenerProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sslPolicy != null ? this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            return result;
        }
    }
}
