package software.amazon.awscdk.services.efs;

/**
 * Properties of EFS FileSystem.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * Role role = Role.Builder.create(this, "ClientRole")
 *         .assumedBy(new AnyPrincipal())
 *         .build();
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .allowAnonymousAccess(true)
 *         .build();
 * fileSystem.grantRead(role);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.909Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.FileSystemProps")
@software.amazon.jsii.Jsii.Proxy(FileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC to launch the file system in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Allow access from anonymous client that doesn't use IAM authentication.
     * <p>
     * Default: false when using `grantRead`, `grantWrite`, `grantRootAccess`
     * or set `@aws-cdk/aws-efs:denyAnonymousAccess` feature flag, otherwise true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAnonymousAccess() {
        return null;
    }

    /**
     * Whether to enable automatic backups for the file system.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableAutomaticBackups() {
        return null;
    }

    /**
     * Defines if the data at rest in the file system is encrypted or not.
     * <p>
     * Default: - If your application has the '@aws-cdk/aws-efs:defaultEncryptionAtRest' feature flag set, the default is true, otherwise, the default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypted() {
        return null;
    }

    /**
     * The file system's name.
     * <p>
     * Default: - CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemName() {
        return null;
    }

    /**
     * File system policy is an IAM resource policy used to control NFS access to an EFS file system.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getFileSystemPolicy() {
        return null;
    }

    /**
     * The KMS key used for encryption.
     * <p>
     * This is required to encrypt the data at rest if
     * <p>
     * Default: - if 'encrypted' is true, the default key for EFS (/aws/elasticfilesystem) is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
     * <p>
     * Default: - None. EFS will not transition files to the IA storage class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.LifecyclePolicy getLifecyclePolicy() {
        return null;
    }

    /**
     * Whether this is a One Zone file system.
     * <p>
     * If enabled, <code>performanceMode</code> must be set to <code>GENERAL_PURPOSE</code> and <code>vpcSubnets</code> cannot be set.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOneZone() {
        return null;
    }

    /**
     * A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class.
     * <p>
     * Default: - None. EFS will not transition files from IA storage to primary storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy getOutOfInfrequentAccessPolicy() {
        return null;
    }

    /**
     * The performance mode that the file system will operate under.
     * <p>
     * An Amazon EFS file system's performance mode can't be changed after the file system has been created.
     * Updating this property will replace the file system.
     * <p>
     * Default: PerformanceMode.GENERAL_PURPOSE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.PerformanceMode getPerformanceMode() {
        return null;
    }

    /**
     * Provisioned throughput for the file system.
     * <p>
     * This is a required property if the throughput mode is set to PROVISIONED.
     * Must be at least 1MiB/s.
     * <p>
     * Default: - none, errors out
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getProvisionedThroughputPerSecond() {
        return null;
    }

    /**
     * The removal policy to apply to the file system.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Replication configuration for the file system.
     * <p>
     * Default: - no replication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.ReplicationConfiguration getReplicationConfiguration() {
        return null;
    }

    /**
     * Whether to enable the filesystem's replication overwrite protection or not.
     * <p>
     * Set false if you want to create a read-only filesystem for use as a replication destination.
     * <p>
     * Default: ReplicationOverwriteProtection.ENABLED
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/replication-use-cases.html#replicate-existing-destination">https://docs.aws.amazon.com/efs/latest/ug/replication-use-cases.html#replicate-existing-destination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.ReplicationOverwriteProtection getReplicationOverwriteProtection() {
        return null;
    }

    /**
     * Security Group to assign to this file system.
     * <p>
     * Default: - creates new security group which allows all outbound traffic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Enum to mention the throughput mode of the file system.
     * <p>
     * Default: ThroughputMode.BURSTING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.ThroughputMode getThroughputMode() {
        return null;
    }

    /**
     * The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Archive storage.
     * <p>
     * Metadata operations such as listing the contents of a directory don't count as file access events.
     * <p>
     * Default: - None. EFS will not transition files to Archive storage class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.LifecyclePolicy getTransitionToArchivePolicy() {
        return null;
    }

    /**
     * Which subnets to place the mount target in the VPC.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean allowAnonymousAccess;
        java.lang.Boolean enableAutomaticBackups;
        java.lang.Boolean encrypted;
        java.lang.String fileSystemName;
        software.amazon.awscdk.services.iam.PolicyDocument fileSystemPolicy;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy;
        java.lang.Boolean oneZone;
        software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy;
        software.amazon.awscdk.services.efs.PerformanceMode performanceMode;
        software.amazon.awscdk.Size provisionedThroughputPerSecond;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.efs.ReplicationConfiguration replicationConfiguration;
        software.amazon.awscdk.services.efs.ReplicationOverwriteProtection replicationOverwriteProtection;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.efs.ThroughputMode throughputMode;
        software.amazon.awscdk.services.efs.LifecyclePolicy transitionToArchivePolicy;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link FileSystemProps#getVpc}
         * @param vpc VPC to launch the file system in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getAllowAnonymousAccess}
         * @param allowAnonymousAccess Allow access from anonymous client that doesn't use IAM authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAnonymousAccess(java.lang.Boolean allowAnonymousAccess) {
            this.allowAnonymousAccess = allowAnonymousAccess;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getEnableAutomaticBackups}
         * @param enableAutomaticBackups Whether to enable automatic backups for the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutomaticBackups(java.lang.Boolean enableAutomaticBackups) {
            this.enableAutomaticBackups = enableAutomaticBackups;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getEncrypted}
         * @param encrypted Defines if the data at rest in the file system is encrypted or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getFileSystemName}
         * @param fileSystemName The file system's name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemName(java.lang.String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getFileSystemPolicy}
         * @param fileSystemPolicy File system policy is an IAM resource policy used to control NFS access to an EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPolicy(software.amazon.awscdk.services.iam.PolicyDocument fileSystemPolicy) {
            this.fileSystemPolicy = fileSystemPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getKmsKey}
         * @param kmsKey The KMS key used for encryption.
         *               This is required to encrypt the data at rest if
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getLifecyclePolicy}
         * @param lifecyclePolicy A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getOneZone}
         * @param oneZone Whether this is a One Zone file system.
         *                If enabled, <code>performanceMode</code> must be set to <code>GENERAL_PURPOSE</code> and <code>vpcSubnets</code> cannot be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oneZone(java.lang.Boolean oneZone) {
            this.oneZone = oneZone;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getOutOfInfrequentAccessPolicy}
         * @param outOfInfrequentAccessPolicy A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outOfInfrequentAccessPolicy(software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy) {
            this.outOfInfrequentAccessPolicy = outOfInfrequentAccessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getPerformanceMode}
         * @param performanceMode The performance mode that the file system will operate under.
         *                        An Amazon EFS file system's performance mode can't be changed after the file system has been created.
         *                        Updating this property will replace the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(software.amazon.awscdk.services.efs.PerformanceMode performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getProvisionedThroughputPerSecond}
         * @param provisionedThroughputPerSecond Provisioned throughput for the file system.
         *                                       This is a required property if the throughput mode is set to PROVISIONED.
         *                                       Must be at least 1MiB/s.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputPerSecond(software.amazon.awscdk.Size provisionedThroughputPerSecond) {
            this.provisionedThroughputPerSecond = provisionedThroughputPerSecond;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getReplicationConfiguration}
         * @param replicationConfiguration Replication configuration for the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(software.amazon.awscdk.services.efs.ReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getReplicationOverwriteProtection}
         * @param replicationOverwriteProtection Whether to enable the filesystem's replication overwrite protection or not.
         *                                       Set false if you want to create a read-only filesystem for use as a replication destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationOverwriteProtection(software.amazon.awscdk.services.efs.ReplicationOverwriteProtection replicationOverwriteProtection) {
            this.replicationOverwriteProtection = replicationOverwriteProtection;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getThroughputMode}
         * @param throughputMode Enum to mention the throughput mode of the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(software.amazon.awscdk.services.efs.ThroughputMode throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getTransitionToArchivePolicy}
         * @param transitionToArchivePolicy The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Archive storage.
         *                                  Metadata operations such as listing the contents of a directory don't count as file access events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionToArchivePolicy(software.amazon.awscdk.services.efs.LifecyclePolicy transitionToArchivePolicy) {
            this.transitionToArchivePolicy = transitionToArchivePolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getVpcSubnets}
         * @param vpcSubnets Which subnets to place the mount target in the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean allowAnonymousAccess;
        private final java.lang.Boolean enableAutomaticBackups;
        private final java.lang.Boolean encrypted;
        private final java.lang.String fileSystemName;
        private final software.amazon.awscdk.services.iam.PolicyDocument fileSystemPolicy;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy;
        private final java.lang.Boolean oneZone;
        private final software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy;
        private final software.amazon.awscdk.services.efs.PerformanceMode performanceMode;
        private final software.amazon.awscdk.Size provisionedThroughputPerSecond;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.efs.ReplicationConfiguration replicationConfiguration;
        private final software.amazon.awscdk.services.efs.ReplicationOverwriteProtection replicationOverwriteProtection;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.efs.ThroughputMode throughputMode;
        private final software.amazon.awscdk.services.efs.LifecyclePolicy transitionToArchivePolicy;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.allowAnonymousAccess = software.amazon.jsii.Kernel.get(this, "allowAnonymousAccess", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableAutomaticBackups = software.amazon.jsii.Kernel.get(this, "enableAutomaticBackups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fileSystemName = software.amazon.jsii.Kernel.get(this, "fileSystemName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemPolicy = software.amazon.jsii.Kernel.get(this, "fileSystemPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.lifecyclePolicy = software.amazon.jsii.Kernel.get(this, "lifecyclePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.LifecyclePolicy.class));
            this.oneZone = software.amazon.jsii.Kernel.get(this, "oneZone", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outOfInfrequentAccessPolicy = software.amazon.jsii.Kernel.get(this, "outOfInfrequentAccessPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy.class));
            this.performanceMode = software.amazon.jsii.Kernel.get(this, "performanceMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.PerformanceMode.class));
            this.provisionedThroughputPerSecond = software.amazon.jsii.Kernel.get(this, "provisionedThroughputPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.replicationConfiguration = software.amazon.jsii.Kernel.get(this, "replicationConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class));
            this.replicationOverwriteProtection = software.amazon.jsii.Kernel.get(this, "replicationOverwriteProtection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationOverwriteProtection.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.throughputMode = software.amazon.jsii.Kernel.get(this, "throughputMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ThroughputMode.class));
            this.transitionToArchivePolicy = software.amazon.jsii.Kernel.get(this, "transitionToArchivePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.LifecyclePolicy.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.allowAnonymousAccess = builder.allowAnonymousAccess;
            this.enableAutomaticBackups = builder.enableAutomaticBackups;
            this.encrypted = builder.encrypted;
            this.fileSystemName = builder.fileSystemName;
            this.fileSystemPolicy = builder.fileSystemPolicy;
            this.kmsKey = builder.kmsKey;
            this.lifecyclePolicy = builder.lifecyclePolicy;
            this.oneZone = builder.oneZone;
            this.outOfInfrequentAccessPolicy = builder.outOfInfrequentAccessPolicy;
            this.performanceMode = builder.performanceMode;
            this.provisionedThroughputPerSecond = builder.provisionedThroughputPerSecond;
            this.removalPolicy = builder.removalPolicy;
            this.replicationConfiguration = builder.replicationConfiguration;
            this.replicationOverwriteProtection = builder.replicationOverwriteProtection;
            this.securityGroup = builder.securityGroup;
            this.throughputMode = builder.throughputMode;
            this.transitionToArchivePolicy = builder.transitionToArchivePolicy;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getAllowAnonymousAccess() {
            return this.allowAnonymousAccess;
        }

        @Override
        public final java.lang.Boolean getEnableAutomaticBackups() {
            return this.enableAutomaticBackups;
        }

        @Override
        public final java.lang.Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.String getFileSystemName() {
            return this.fileSystemName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getFileSystemPolicy() {
            return this.fileSystemPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.efs.LifecyclePolicy getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public final java.lang.Boolean getOneZone() {
            return this.oneZone;
        }

        @Override
        public final software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy getOutOfInfrequentAccessPolicy() {
            return this.outOfInfrequentAccessPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.efs.PerformanceMode getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final software.amazon.awscdk.Size getProvisionedThroughputPerSecond() {
            return this.provisionedThroughputPerSecond;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.efs.ReplicationConfiguration getReplicationConfiguration() {
            return this.replicationConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.efs.ReplicationOverwriteProtection getReplicationOverwriteProtection() {
            return this.replicationOverwriteProtection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.efs.ThroughputMode getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public final software.amazon.awscdk.services.efs.LifecyclePolicy getTransitionToArchivePolicy() {
            return this.transitionToArchivePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAllowAnonymousAccess() != null) {
                data.set("allowAnonymousAccess", om.valueToTree(this.getAllowAnonymousAccess()));
            }
            if (this.getEnableAutomaticBackups() != null) {
                data.set("enableAutomaticBackups", om.valueToTree(this.getEnableAutomaticBackups()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getFileSystemName() != null) {
                data.set("fileSystemName", om.valueToTree(this.getFileSystemName()));
            }
            if (this.getFileSystemPolicy() != null) {
                data.set("fileSystemPolicy", om.valueToTree(this.getFileSystemPolicy()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getLifecyclePolicy() != null) {
                data.set("lifecyclePolicy", om.valueToTree(this.getLifecyclePolicy()));
            }
            if (this.getOneZone() != null) {
                data.set("oneZone", om.valueToTree(this.getOneZone()));
            }
            if (this.getOutOfInfrequentAccessPolicy() != null) {
                data.set("outOfInfrequentAccessPolicy", om.valueToTree(this.getOutOfInfrequentAccessPolicy()));
            }
            if (this.getPerformanceMode() != null) {
                data.set("performanceMode", om.valueToTree(this.getPerformanceMode()));
            }
            if (this.getProvisionedThroughputPerSecond() != null) {
                data.set("provisionedThroughputPerSecond", om.valueToTree(this.getProvisionedThroughputPerSecond()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicationConfiguration() != null) {
                data.set("replicationConfiguration", om.valueToTree(this.getReplicationConfiguration()));
            }
            if (this.getReplicationOverwriteProtection() != null) {
                data.set("replicationOverwriteProtection", om.valueToTree(this.getReplicationOverwriteProtection()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getThroughputMode() != null) {
                data.set("throughputMode", om.valueToTree(this.getThroughputMode()));
            }
            if (this.getTransitionToArchivePolicy() != null) {
                data.set("transitionToArchivePolicy", om.valueToTree(this.getTransitionToArchivePolicy()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.FileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemProps.Jsii$Proxy that = (FileSystemProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.allowAnonymousAccess != null ? !this.allowAnonymousAccess.equals(that.allowAnonymousAccess) : that.allowAnonymousAccess != null) return false;
            if (this.enableAutomaticBackups != null ? !this.enableAutomaticBackups.equals(that.enableAutomaticBackups) : that.enableAutomaticBackups != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.fileSystemName != null ? !this.fileSystemName.equals(that.fileSystemName) : that.fileSystemName != null) return false;
            if (this.fileSystemPolicy != null ? !this.fileSystemPolicy.equals(that.fileSystemPolicy) : that.fileSystemPolicy != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.lifecyclePolicy != null ? !this.lifecyclePolicy.equals(that.lifecyclePolicy) : that.lifecyclePolicy != null) return false;
            if (this.oneZone != null ? !this.oneZone.equals(that.oneZone) : that.oneZone != null) return false;
            if (this.outOfInfrequentAccessPolicy != null ? !this.outOfInfrequentAccessPolicy.equals(that.outOfInfrequentAccessPolicy) : that.outOfInfrequentAccessPolicy != null) return false;
            if (this.performanceMode != null ? !this.performanceMode.equals(that.performanceMode) : that.performanceMode != null) return false;
            if (this.provisionedThroughputPerSecond != null ? !this.provisionedThroughputPerSecond.equals(that.provisionedThroughputPerSecond) : that.provisionedThroughputPerSecond != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicationConfiguration != null ? !this.replicationConfiguration.equals(that.replicationConfiguration) : that.replicationConfiguration != null) return false;
            if (this.replicationOverwriteProtection != null ? !this.replicationOverwriteProtection.equals(that.replicationOverwriteProtection) : that.replicationOverwriteProtection != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.throughputMode != null ? !this.throughputMode.equals(that.throughputMode) : that.throughputMode != null) return false;
            if (this.transitionToArchivePolicy != null ? !this.transitionToArchivePolicy.equals(that.transitionToArchivePolicy) : that.transitionToArchivePolicy != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.allowAnonymousAccess != null ? this.allowAnonymousAccess.hashCode() : 0);
            result = 31 * result + (this.enableAutomaticBackups != null ? this.enableAutomaticBackups.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.fileSystemName != null ? this.fileSystemName.hashCode() : 0);
            result = 31 * result + (this.fileSystemPolicy != null ? this.fileSystemPolicy.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicy != null ? this.lifecyclePolicy.hashCode() : 0);
            result = 31 * result + (this.oneZone != null ? this.oneZone.hashCode() : 0);
            result = 31 * result + (this.outOfInfrequentAccessPolicy != null ? this.outOfInfrequentAccessPolicy.hashCode() : 0);
            result = 31 * result + (this.performanceMode != null ? this.performanceMode.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughputPerSecond != null ? this.provisionedThroughputPerSecond.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicationConfiguration != null ? this.replicationConfiguration.hashCode() : 0);
            result = 31 * result + (this.replicationOverwriteProtection != null ? this.replicationOverwriteProtection.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.throughputMode != null ? this.throughputMode.hashCode() : 0);
            result = 31 * result + (this.transitionToArchivePolicy != null ? this.transitionToArchivePolicy.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
