package software.amazon.awscdk.services.efs;

/**
 * EFS Throughput mode.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.915Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.ThroughputMode")
public enum ThroughputMode {
    /**
     * This mode scales as the size of the file system in the standard storage class grows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTING,
    /**
     * This mode can instantly provision the throughput of the file system (in MiB/s) independent of the amount of data stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PROVISIONED,
    /**
     * This mode scales the throughput automatically regardless of file system size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTIC,
}
