package software.amazon.awscdk.services.eks;

/**
 * Helm chart options that can be set for AlbControllerChart To add any new supported values refer https://github.com/kubernetes-sigs/aws-load-balancer-controller/blob/main/helm/aws-load-balancer-controller/values.yaml.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v32.KubectlV32Layer;
 * Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_32)
 *         .albController(AlbControllerOptions.builder()
 *                 .version(AlbControllerVersion.V2_8_2)
 *                 .additionalHelmChartValues(AlbControllerHelmChartOptions.builder()
 *                         .enableWafv2(false)
 *                         .build())
 *                 .build())
 *         .kubectlLayer(new KubectlV32Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:54.955Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AlbControllerHelmChartOptions")
@software.amazon.jsii.Jsii.Proxy(AlbControllerHelmChartOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlbControllerHelmChartOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enable or disable AWS WAF on the ALB ingress controller.
     * <p>
     * Default: - no value defined for this helm chart option, so it will not be set in the helm chart values
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableWaf() {
        return null;
    }

    /**
     * Enable or disable AWS WAFv2 on the ALB ingress controller.
     * <p>
     * Default: - no value defined for this helm chart option, so it will not be set in the helm chart values
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableWafv2() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AlbControllerHelmChartOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlbControllerHelmChartOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlbControllerHelmChartOptions> {
        java.lang.Boolean enableWaf;
        java.lang.Boolean enableWafv2;

        /**
         * Sets the value of {@link AlbControllerHelmChartOptions#getEnableWaf}
         * @param enableWaf Enable or disable AWS WAF on the ALB ingress controller.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableWaf(java.lang.Boolean enableWaf) {
            this.enableWaf = enableWaf;
            return this;
        }

        /**
         * Sets the value of {@link AlbControllerHelmChartOptions#getEnableWafv2}
         * @param enableWafv2 Enable or disable AWS WAFv2 on the ALB ingress controller.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableWafv2(java.lang.Boolean enableWafv2) {
            this.enableWafv2 = enableWafv2;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlbControllerHelmChartOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlbControllerHelmChartOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlbControllerHelmChartOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlbControllerHelmChartOptions {
        private final java.lang.Boolean enableWaf;
        private final java.lang.Boolean enableWafv2;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enableWaf = software.amazon.jsii.Kernel.get(this, "enableWaf", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableWafv2 = software.amazon.jsii.Kernel.get(this, "enableWafv2", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enableWaf = builder.enableWaf;
            this.enableWafv2 = builder.enableWafv2;
        }

        @Override
        public final java.lang.Boolean getEnableWaf() {
            return this.enableWaf;
        }

        @Override
        public final java.lang.Boolean getEnableWafv2() {
            return this.enableWafv2;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnableWaf() != null) {
                data.set("enableWaf", om.valueToTree(this.getEnableWaf()));
            }
            if (this.getEnableWafv2() != null) {
                data.set("enableWafv2", om.valueToTree(this.getEnableWafv2()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AlbControllerHelmChartOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlbControllerHelmChartOptions.Jsii$Proxy that = (AlbControllerHelmChartOptions.Jsii$Proxy) o;

            if (this.enableWaf != null ? !this.enableWaf.equals(that.enableWaf) : that.enableWaf != null) return false;
            return this.enableWafv2 != null ? this.enableWafv2.equals(that.enableWafv2) : that.enableWafv2 == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enableWaf != null ? this.enableWaf.hashCode() : 0;
            result = 31 * result + (this.enableWafv2 != null ? this.enableWafv2.hashCode() : 0);
            return result;
        }
    }
}
