package software.amazon.awscdk.services.eks;

/**
 * Properties for KubernetesManifest.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * Map&lt;String, String&gt; appLabel = Map.of("app", "hello-kubernetes");
 * Map&lt;String, Object&gt; deployment = Map.of(
 *         "apiVersion", "apps/v1",
 *         "kind", "Deployment",
 *         "metadata", Map.of("name", "hello-kubernetes"),
 *         "spec", Map.of(
 *                 "replicas", 3,
 *                 "selector", Map.of("matchLabels", appLabel),
 *                 "template", Map.of(
 *                         "metadata", Map.of("labels", appLabel),
 *                         "spec", Map.of(
 *                                 "containers", List.of(Map.of(
 *                                         "name", "hello-kubernetes",
 *                                         "image", "paulbouwer/hello-kubernetes:1.5",
 *                                         "ports", List.of(Map.of("containerPort", 8080))))))));
 * Map&lt;String, Object&gt; service = Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Service",
 *         "metadata", Map.of("name", "hello-kubernetes"),
 *         "spec", Map.of(
 *                 "type", "LoadBalancer",
 *                 "ports", List.of(Map.of("port", 80, "targetPort", 8080)),
 *                 "selector", appLabel));
 * // option 1: use a construct
 * // option 1: use a construct
 * KubernetesManifest.Builder.create(this, "hello-kub")
 *         .cluster(cluster)
 *         .manifest(List.of(deployment, service))
 *         .build();
 * // or, option2: use `addManifest`
 * cluster.addManifest("hello-kub", service, deployment);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:55.060Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesManifestProps")
@software.amazon.jsii.Jsii.Proxy(KubernetesManifestProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KubernetesManifestProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.KubernetesManifestOptions {

    /**
     * The EKS cluster to apply this manifest to.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * The manifest to apply.
     * <p>
     * Consists of any number of child resources.
     * <p>
     * When the resources are created/updated, this manifest will be applied to the
     * cluster through <code>kubectl apply</code> and when the resources or the stack is
     * deleted, the resources in the manifest will be deleted through <code>kubectl delete</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * List.of(Map.of(
     *         "apiVersion", "v1",
     *         "kind", "Pod",
     *         "metadata", Map.of("name", "mypod"),
     *         "spec", Map.of(
     *                 "containers", List.of(Map.of("name", "hello", "image", "paulbouwer/hello-kubernetes:1.5", "ports", List.of(Map.of("containerPort", 8080)))))));
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getManifest();

    /**
     * Overwrite any existing resources.
     * <p>
     * If this is set, we will use <code>kubectl apply</code> instead of <code>kubectl create</code>
     * when the resource is created. Otherwise, if there is already a resource
     * in the cluster with the same name, the operation will fail.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOverwrite() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KubernetesManifestProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubernetesManifestProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KubernetesManifestProps> {
        software.amazon.awscdk.services.eks.ICluster cluster;
        java.util.List<java.util.Map<java.lang.String, java.lang.Object>> manifest;
        java.lang.Boolean overwrite;
        java.lang.Boolean ingressAlb;
        software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme;
        java.lang.Boolean prune;
        java.lang.Boolean skipValidation;

        /**
         * Sets the value of {@link KubernetesManifestProps#getCluster}
         * @param cluster The EKS cluster to apply this manifest to. This parameter is required.
         *                [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestProps#getManifest}
         * @param manifest The manifest to apply. This parameter is required.
         *                 Consists of any number of child resources.
         *                 <p>
         *                 When the resources are created/updated, this manifest will be applied to the
         *                 cluster through <code>kubectl apply</code> and when the resources or the stack is
         *                 deleted, the resources in the manifest will be deleted through <code>kubectl delete</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder manifest(java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> manifest) {
            this.manifest = (java.util.List<java.util.Map<java.lang.String, java.lang.Object>>)manifest;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestProps#getOverwrite}
         * @param overwrite Overwrite any existing resources.
         *                  If this is set, we will use <code>kubectl apply</code> instead of <code>kubectl create</code>
         *                  when the resource is created. Otherwise, if there is already a resource
         *                  in the cluster with the same name, the operation will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overwrite(java.lang.Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestProps#getIngressAlb}
         * @param ingressAlb Automatically detect <code>Ingress</code> resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAlb(java.lang.Boolean ingressAlb) {
            this.ingressAlb = ingressAlb;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestProps#getIngressAlbScheme}
         * @param ingressAlbScheme Specify the ALB scheme that should be applied to <code>Ingress</code> resources.
         *                         Only applicable if <code>ingressAlb</code> is set to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAlbScheme(software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme) {
            this.ingressAlbScheme = ingressAlbScheme;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestProps#getPrune}
         * @param prune When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
         *              To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
         *              query the cluster for all resources with a specific label and will remove
         *              all the labeld resources that are not part of the applied manifest. If this
         *              option is disabled and a resource is removed, it will become "orphaned" and
         *              will not be deleted from the cluster.
         *              <p>
         *              When this option is enabled (default), the construct will inject a label to
         *              all Kubernetes resources included in this manifest which will be used to
         *              prune resources when the manifest changes via <code>kubectl apply --prune</code>.
         *              <p>
         *              The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
         *              42-char unique address of this construct in the construct tree. Value is
         *              empty.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestProps#getSkipValidation}
         * @param skipValidation A flag to signify if the manifest validation should be skipped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipValidation(java.lang.Boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubernetesManifestProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KubernetesManifestProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KubernetesManifestProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesManifestProps {
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final java.util.List<java.util.Map<java.lang.String, java.lang.Object>> manifest;
        private final java.lang.Boolean overwrite;
        private final java.lang.Boolean ingressAlb;
        private final software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme;
        private final java.lang.Boolean prune;
        private final java.lang.Boolean skipValidation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.manifest = software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
            this.overwrite = software.amazon.jsii.Kernel.get(this, "overwrite", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ingressAlb = software.amazon.jsii.Kernel.get(this, "ingressAlb", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ingressAlbScheme = software.amazon.jsii.Kernel.get(this, "ingressAlbScheme", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbScheme.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.skipValidation = software.amazon.jsii.Kernel.get(this, "skipValidation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.manifest = (java.util.List<java.util.Map<java.lang.String, java.lang.Object>>)java.util.Objects.requireNonNull(builder.manifest, "manifest is required");
            this.overwrite = builder.overwrite;
            this.ingressAlb = builder.ingressAlb;
            this.ingressAlbScheme = builder.ingressAlbScheme;
            this.prune = builder.prune;
            this.skipValidation = builder.skipValidation;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getManifest() {
            return this.manifest;
        }

        @Override
        public final java.lang.Boolean getOverwrite() {
            return this.overwrite;
        }

        @Override
        public final java.lang.Boolean getIngressAlb() {
            return this.ingressAlb;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AlbScheme getIngressAlbScheme() {
            return this.ingressAlbScheme;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.lang.Boolean getSkipValidation() {
            return this.skipValidation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("manifest", om.valueToTree(this.getManifest()));
            if (this.getOverwrite() != null) {
                data.set("overwrite", om.valueToTree(this.getOverwrite()));
            }
            if (this.getIngressAlb() != null) {
                data.set("ingressAlb", om.valueToTree(this.getIngressAlb()));
            }
            if (this.getIngressAlbScheme() != null) {
                data.set("ingressAlbScheme", om.valueToTree(this.getIngressAlbScheme()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getSkipValidation() != null) {
                data.set("skipValidation", om.valueToTree(this.getSkipValidation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.KubernetesManifestProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubernetesManifestProps.Jsii$Proxy that = (KubernetesManifestProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!manifest.equals(that.manifest)) return false;
            if (this.overwrite != null ? !this.overwrite.equals(that.overwrite) : that.overwrite != null) return false;
            if (this.ingressAlb != null ? !this.ingressAlb.equals(that.ingressAlb) : that.ingressAlb != null) return false;
            if (this.ingressAlbScheme != null ? !this.ingressAlbScheme.equals(that.ingressAlbScheme) : that.ingressAlbScheme != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            return this.skipValidation != null ? this.skipValidation.equals(that.skipValidation) : that.skipValidation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.manifest.hashCode());
            result = 31 * result + (this.overwrite != null ? this.overwrite.hashCode() : 0);
            result = 31 * result + (this.ingressAlb != null ? this.ingressAlb.hashCode() : 0);
            result = 31 * result + (this.ingressAlbScheme != null ? this.ingressAlbScheme.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.skipValidation != null ? this.skipValidation.hashCode() : 0);
            return result;
        }
    }
}
