package software.amazon.awscdk.services.eks;

/**
 * Kubernetes cluster version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v32.KubectlV32Layer;
 * // or
 * Vpc vpc;
 * Cluster.Builder.create(this, "MyCluster")
 *         .kubectlMemory(Size.gibibytes(4))
 *         .version(KubernetesVersion.V1_32)
 *         .kubectlLayer(new KubectlV32Layer(this, "kubectl"))
 *         .build();
 * Cluster.fromClusterAttributes(this, "MyCluster", ClusterAttributes.builder()
 *         .kubectlMemory(Size.gibibytes(4))
 *         .vpc(vpc)
 *         .clusterName("cluster-name")
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/kubernetes-versions.html#kubernetes-release-calendar">https://docs.aws.amazon.com/eks/latest/userguide/kubernetes-versions.html#kubernetes-release-calendar</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:55.064Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesVersion")
public class KubernetesVersion extends software.amazon.jsii.JsiiObject {

    protected KubernetesVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KubernetesVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        V1_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_27 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_27", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_29 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_29", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_30 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_30", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
    }

    /**
     * Custom cluster version.
     * <p>
     * @param version custom version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.KubernetesVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * (deprecated) Kubernetes version 1.14.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_14;

    /**
     * (deprecated) Kubernetes version 1.15.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_15;

    /**
     * (deprecated) Kubernetes version 1.16.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_16;

    /**
     * (deprecated) Kubernetes version 1.17.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_17;

    /**
     * (deprecated) Kubernetes version 1.18.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_18;

    /**
     * (deprecated) Kubernetes version 1.19.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_19;

    /**
     * (deprecated) Kubernetes version 1.20.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_20;

    /**
     * (deprecated) Kubernetes version 1.21.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_21;

    /**
     * (deprecated) Kubernetes version 1.22.
     * <p>
     * @deprecated Use newer version of EKS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_22;

    /**
     * Kubernetes version 1.23.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV23Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v23</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_23;

    /**
     * Kubernetes version 1.24.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV24Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v24</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_24;

    /**
     * Kubernetes version 1.25.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV25Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v25</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_25;

    /**
     * Kubernetes version 1.26.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV26Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v26</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_26;

    /**
     * Kubernetes version 1.27.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV27Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v27</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_27;

    /**
     * Kubernetes version 1.28.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV28Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v28</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_28;

    /**
     * Kubernetes version 1.29.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV29Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v29</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_29;

    /**
     * Kubernetes version 1.30.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV30Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v30</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_30;

    /**
     * Kubernetes version 1.31.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV31Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v31</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_31;

    /**
     * Kubernetes version 1.32.
     * <p>
     * When creating a <code>Cluster</code> with this version, you need to also specify the
     * <code>kubectlLayer</code> property with a <code>KubectlV32Layer</code> from
     * <code>&#64;aws-cdk/lambda-layer-kubectl-v32</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_32;

    /**
     * cluster version number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
