package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Contains all metrics for an Application Load Balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:55.347Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.IApplicationLoadBalancerMetrics")
@software.amazon.jsii.Jsii.Proxy(IApplicationLoadBalancerMetrics.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IApplicationLoadBalancerMetrics extends software.amazon.jsii.JsiiSerializable {

    /**
     * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric activeConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric activeConnectionCount();

    /**
     * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * <p>
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric clientTlsNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * <p>
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric clientTlsNegotiationErrorCount();

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric consumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric consumedLCUs();

    /**
     * Return the given named metric for this Application Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric custom(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Return the given named metric for this Application Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric custom(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * The number of user authentications that could not be completed.
     * <p>
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of user authentications that could not be completed.
     * <p>
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthError();

    /**
     * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthFailure();

    /**
     * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * <p>
     * If one or more of these operations fail, this is the time to failure.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * <p>
     * If one or more of these operations fail, this is the time to failure.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthLatency();

    /**
     * The number of authenticate actions that were successful.
     * <p>
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of authenticate actions that were successful.
     * <p>
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthSuccess();

    /**
     * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * <p>
     * This does not include any response codes generated by the targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * <p>
     * This does not include any response codes generated by the targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code);

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code);

    /**
     * The number of fixed-response actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpFixedResponseCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of fixed-response actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpFixedResponseCount();

    /**
     * The number of redirect actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of redirect actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectCount();

    /**
     * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectUrlLimitExceededCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectUrlLimitExceededCount();

    /**
     * The total number of bytes processed by the load balancer over IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6ProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total number of bytes processed by the load balancer over IPv6.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6ProcessedBytes();

    /**
     * The number of IPv6 requests received by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6RequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of IPv6 requests received by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6RequestCount();

    /**
     * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric newConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric newConnectionCount();

    /**
     * The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric processedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric processedBytes();

    /**
     * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric rejectedConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric rejectedConnectionCount();

    /**
     * The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric requestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric requestCount();

    /**
     * The number of rules processed by the load balancer given a request rate averaged over an hour.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ruleEvaluations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of rules processed by the load balancer given a request rate averaged over an hour.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ruleEvaluations();

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetConnectionErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetConnectionErrorCount();

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetResponseTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetResponseTime();

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetTLSNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetTLSNegotiationErrorCount();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerMetrics.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric activeConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "activeConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric activeConnectionCount() {
            return software.amazon.jsii.Kernel.call(this, "activeConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
         * <p>
         * Possible causes include a
         * mismatch of ciphers or protocols.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric clientTlsNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "clientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
         * <p>
         * Possible causes include a
         * mismatch of ciphers or protocols.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric clientTlsNegotiationErrorCount() {
            return software.amazon.jsii.Kernel.call(this, "clientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of load balancer capacity units (LCU) used by your load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric consumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "consumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of load balancer capacity units (LCU) used by your load balancer.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric consumedLCUs() {
            return software.amazon.jsii.Kernel.call(this, "consumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * Return the given named metric for this Application Load Balancer.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric custom(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Return the given named metric for this Application Load Balancer.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric custom(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * The number of user authentications that could not be completed.
         * <p>
         * Because an authenticate action was misconfigured, the load balancer
         * couldn't establish a connection with the IdP, or the load balancer
         * couldn't complete the authentication flow due to an internal error.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of user authentications that could not be completed.
         * <p>
         * Because an authenticate action was misconfigured, the load balancer
         * couldn't establish a connection with the IdP, or the load balancer
         * couldn't complete the authentication flow due to an internal error.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthError() {
            return software.amazon.jsii.Kernel.call(this, "elbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthFailure() {
            return software.amazon.jsii.Kernel.call(this, "elbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
         * <p>
         * If one or more of these operations fail, this is the time to failure.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
         * <p>
         * If one or more of these operations fail, this is the time to failure.
         * <p>
         * Default: Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthLatency() {
            return software.amazon.jsii.Kernel.call(this, "elbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of authenticate actions that were successful.
         * <p>
         * This metric is incremented at the end of the authentication workflow,
         * after the load balancer has retrieved the user claims from the IdP.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of authenticate actions that were successful.
         * <p>
         * This metric is incremented at the end of the authentication workflow,
         * after the load balancer has retrieved the user claims from the IdP.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthSuccess() {
            return software.amazon.jsii.Kernel.call(this, "elbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
         * <p>
         * This does not include any response codes generated by the targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param code This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
        }

        /**
         * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
         * <p>
         * This does not include any response codes generated by the targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param code This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code) {
            return software.amazon.jsii.Kernel.call(this, "httpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
        }

        /**
         * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
         * <p>
         * This does not include any response codes generated by the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param code This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
        }

        /**
         * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
         * <p>
         * This does not include any response codes generated by the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param code This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
            return software.amazon.jsii.Kernel.call(this, "httpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
        }

        /**
         * The number of fixed-response actions that were successful.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpFixedResponseCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of fixed-response actions that were successful.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpFixedResponseCount() {
            return software.amazon.jsii.Kernel.call(this, "httpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of redirect actions that were successful.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of redirect actions that were successful.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectCount() {
            return software.amazon.jsii.Kernel.call(this, "httpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectUrlLimitExceededCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectUrlLimitExceededCount() {
            return software.amazon.jsii.Kernel.call(this, "httpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The total number of bytes processed by the load balancer over IPv6.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6ProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "ipv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of bytes processed by the load balancer over IPv6.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6ProcessedBytes() {
            return software.amazon.jsii.Kernel.call(this, "ipv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of IPv6 requests received by the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6RequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "ipv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of IPv6 requests received by the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6RequestCount() {
            return software.amazon.jsii.Kernel.call(this, "ipv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric newConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "newConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric newConnectionCount() {
            return software.amazon.jsii.Kernel.call(this, "newConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The total number of bytes processed by the load balancer over IPv4 and IPv6.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric processedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "processedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of bytes processed by the load balancer over IPv4 and IPv6.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric processedBytes() {
            return software.amazon.jsii.Kernel.call(this, "processedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric rejectedConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "rejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric rejectedConnectionCount() {
            return software.amazon.jsii.Kernel.call(this, "rejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of requests processed over IPv4 and IPv6.
         * <p>
         * This count includes only the requests with a response generated by a target of the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric requestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "requestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of requests processed over IPv4 and IPv6.
         * <p>
         * This count includes only the requests with a response generated by a target of the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric requestCount() {
            return software.amazon.jsii.Kernel.call(this, "requestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of rules processed by the load balancer given a request rate averaged over an hour.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ruleEvaluations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "ruleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of rules processed by the load balancer given a request rate averaged over an hour.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ruleEvaluations() {
            return software.amazon.jsii.Kernel.call(this, "ruleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of connections that were not successfully established between the load balancer and target.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetConnectionErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "targetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of connections that were not successfully established between the load balancer and target.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetConnectionErrorCount() {
            return software.amazon.jsii.Kernel.call(this, "targetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetResponseTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "targetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
         * <p>
         * Default: Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetResponseTime() {
            return software.amazon.jsii.Kernel.call(this, "targetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
         * <p>
         * Possible causes include a mismatch of ciphers or protocols.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetTLSNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "targetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
         * <p>
         * Possible causes include a mismatch of ciphers or protocols.
         * <p>
         * Default: Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetTLSNegotiationErrorCount() {
            return software.amazon.jsii.Kernel.call(this, "targetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IApplicationLoadBalancerMetrics}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IApplicationLoadBalancerMetrics {

        /**
         * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric activeConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "activeConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
         * <p>
         * Possible causes include a
         * mismatch of ciphers or protocols.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric clientTlsNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "clientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of load balancer capacity units (LCU) used by your load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric consumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "consumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * Return the given named metric for this Application Load Balancer.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric custom(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * The number of user authentications that could not be completed.
         * <p>
         * Because an authenticate action was misconfigured, the load balancer
         * couldn't establish a connection with the IdP, or the load balancer
         * couldn't complete the authentication flow due to an internal error.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
         * <p>
         * If one or more of these operations fail, this is the time to failure.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of authenticate actions that were successful.
         * <p>
         * This metric is incremented at the end of the authentication workflow,
         * after the load balancer has retrieved the user claims from the IdP.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric elbAuthSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "elbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
         * <p>
         * This does not include any response codes generated by the targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param code This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
        }

        /**
         * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
         * <p>
         * This does not include any response codes generated by the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param code This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
        }

        /**
         * The number of fixed-response actions that were successful.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpFixedResponseCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of redirect actions that were successful.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric httpRedirectUrlLimitExceededCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "httpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of bytes processed by the load balancer over IPv6.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6ProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "ipv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of IPv6 requests received by the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ipv6RequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "ipv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric newConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "newConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of bytes processed by the load balancer over IPv4 and IPv6.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric processedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "processedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric rejectedConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "rejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of requests processed over IPv4 and IPv6.
         * <p>
         * This count includes only the requests with a response generated by a target of the load balancer.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric requestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "requestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of rules processed by the load balancer given a request rate averaged over an hour.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric ruleEvaluations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "ruleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of connections that were not successfully established between the load balancer and target.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetConnectionErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "targetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
         * <p>
         * Default: Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetResponseTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "targetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
         * <p>
         * Possible causes include a mismatch of ciphers or protocols.
         * <p>
         * Default: Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric targetTLSNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "targetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
