package software.amazon.awscdk.services.events;

/**
 * Properties for defining a <code>CfnConnection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * CfnConnectionProps cfnConnectionProps = CfnConnectionProps.builder()
 *         .authorizationType("authorizationType")
 *         .authParameters(AuthParametersProperty.builder()
 *                 .apiKeyAuthParameters(ApiKeyAuthParametersProperty.builder()
 *                         .apiKeyName("apiKeyName")
 *                         .apiKeyValue("apiKeyValue")
 *                         .build())
 *                 .basicAuthParameters(BasicAuthParametersProperty.builder()
 *                         .password("password")
 *                         .username("username")
 *                         .build())
 *                 .connectivityParameters(ConnectivityParametersProperty.builder()
 *                         .resourceParameters(ResourceParametersProperty.builder()
 *                                 .resourceConfigurationArn("resourceConfigurationArn")
 *                                 // the properties below are optional
 *                                 .resourceAssociationArn("resourceAssociationArn")
 *                                 .build())
 *                         .build())
 *                 .invocationHttpParameters(ConnectionHttpParametersProperty.builder()
 *                         .bodyParameters(List.of(ParameterProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .isValueSecret(false)
 *                                 .build()))
 *                         .headerParameters(List.of(ParameterProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .isValueSecret(false)
 *                                 .build()))
 *                         .queryStringParameters(List.of(ParameterProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .isValueSecret(false)
 *                                 .build()))
 *                         .build())
 *                 .oAuthParameters(OAuthParametersProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientParameters(ClientParametersProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 .build())
 *                         .httpMethod("httpMethod")
 *                         // the properties below are optional
 *                         .oAuthHttpParameters(ConnectionHttpParametersProperty.builder()
 *                                 .bodyParameters(List.of(ParameterProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .isValueSecret(false)
 *                                         .build()))
 *                                 .headerParameters(List.of(ParameterProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .isValueSecret(false)
 *                                         .build()))
 *                                 .queryStringParameters(List.of(ParameterProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .isValueSecret(false)
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .invocationConnectivityParameters(InvocationConnectivityParametersProperty.builder()
 *                 .resourceParameters(ResourceParametersProperty.builder()
 *                         .resourceConfigurationArn("resourceConfigurationArn")
 *                         // the properties below are optional
 *                         .resourceAssociationArn("resourceAssociationArn")
 *                         .build())
 *                 .build())
 *         .kmsKeyIdentifier("kmsKeyIdentifier")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:55.942Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of authorization to use for the connection.
     * <p>
     * <blockquote>
     * <p>
     * OAUTH tokens are refreshed when a 401 or 407 response is returned.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authorizationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authorizationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return null;
    }

    /**
     * The authorization parameters to use to authorize with the endpoint.
     * <p>
     * You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthParameters() {
        return null;
    }

    /**
     * A description for the connection to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * For connections to private APIs, the parameters to use for invoking the API.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private APIs</a> in the <strong>Amazon EventBridge User Guide</strong> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-invocationconnectivityparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-invocationconnectivityparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInvocationConnectivityParameters() {
        return null;
    }

    /**
     * The identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection.
     * <p>
     * The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
     * <p>
     * If you do not specify a customer managed key identifier, EventBridge uses an AWS owned key to encrypt the connection.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-kmskeyidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-kmskeyidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyIdentifier() {
        return null;
    }

    /**
     * The name for the connection to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectionProps> {
        java.lang.String authorizationType;
        java.lang.Object authParameters;
        java.lang.String description;
        java.lang.Object invocationConnectivityParameters;
        java.lang.String kmsKeyIdentifier;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnConnectionProps#getAuthorizationType}
         * @param authorizationType The type of authorization to use for the connection.
         *                          <blockquote>
         *                          <p>
         *                          OAUTH tokens are refreshed when a 401 or 407 response is returned.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(java.lang.String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getAuthParameters}
         * @param authParameters The authorization parameters to use to authorize with the endpoint.
         *                       You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authParameters(software.amazon.awscdk.IResolvable authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getAuthParameters}
         * @param authParameters The authorization parameters to use to authorize with the endpoint.
         *                       You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authParameters(software.amazon.awscdk.services.events.CfnConnection.AuthParametersProperty authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getDescription}
         * @param description A description for the connection to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getInvocationConnectivityParameters}
         * @param invocationConnectivityParameters For connections to private APIs, the parameters to use for invoking the API.
         *                                         For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private APIs</a> in the <strong>Amazon EventBridge User Guide</strong> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationConnectivityParameters(software.amazon.awscdk.IResolvable invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getInvocationConnectivityParameters}
         * @param invocationConnectivityParameters For connections to private APIs, the parameters to use for invoking the API.
         *                                         For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private APIs</a> in the <strong>Amazon EventBridge User Guide</strong> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationConnectivityParameters(software.amazon.awscdk.services.events.CfnConnection.InvocationConnectivityParametersProperty invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getKmsKeyIdentifier}
         * @param kmsKeyIdentifier The identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection.
         *                         The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
         *                         <p>
         *                         If you do not specify a customer managed key identifier, EventBridge uses an AWS owned key to encrypt the connection.
         *                         <p>
         *                         For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyIdentifier(java.lang.String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getName}
         * @param name The name for the connection to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectionProps {
        private final java.lang.String authorizationType;
        private final java.lang.Object authParameters;
        private final java.lang.String description;
        private final java.lang.Object invocationConnectivityParameters;
        private final java.lang.String kmsKeyIdentifier;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authParameters = software.amazon.jsii.Kernel.get(this, "authParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invocationConnectivityParameters = software.amazon.jsii.Kernel.get(this, "invocationConnectivityParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyIdentifier = software.amazon.jsii.Kernel.get(this, "kmsKeyIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationType = builder.authorizationType;
            this.authParameters = builder.authParameters;
            this.description = builder.description;
            this.invocationConnectivityParameters = builder.invocationConnectivityParameters;
            this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
            this.name = builder.name;
        }

        @Override
        public final java.lang.String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final java.lang.Object getAuthParameters() {
            return this.authParameters;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getInvocationConnectivityParameters() {
            return this.invocationConnectivityParameters;
        }

        @Override
        public final java.lang.String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizationType() != null) {
                data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            }
            if (this.getAuthParameters() != null) {
                data.set("authParameters", om.valueToTree(this.getAuthParameters()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getInvocationConnectivityParameters() != null) {
                data.set("invocationConnectivityParameters", om.valueToTree(this.getInvocationConnectivityParameters()));
            }
            if (this.getKmsKeyIdentifier() != null) {
                data.set("kmsKeyIdentifier", om.valueToTree(this.getKmsKeyIdentifier()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectionProps.Jsii$Proxy that = (CfnConnectionProps.Jsii$Proxy) o;

            if (this.authorizationType != null ? !this.authorizationType.equals(that.authorizationType) : that.authorizationType != null) return false;
            if (this.authParameters != null ? !this.authParameters.equals(that.authParameters) : that.authParameters != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.invocationConnectivityParameters != null ? !this.invocationConnectivityParameters.equals(that.invocationConnectivityParameters) : that.invocationConnectivityParameters != null) return false;
            if (this.kmsKeyIdentifier != null ? !this.kmsKeyIdentifier.equals(that.kmsKeyIdentifier) : that.kmsKeyIdentifier != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationType != null ? this.authorizationType.hashCode() : 0;
            result = 31 * result + (this.authParameters != null ? this.authParameters.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.invocationConnectivityParameters != null ? this.invocationConnectivityParameters.hashCode() : 0);
            result = 31 * result + (this.kmsKeyIdentifier != null ? this.kmsKeyIdentifier.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
