package software.amazon.awscdk.services.events;

/**
 * The input to send to the event target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.appsync.*;
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .definition(Definition.fromFile("schema.graphql"))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder().authorizationType(AuthorizationType.IAM).build())
 *                 .build())
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(AppSync.Builder.create(api)
 *         .graphQLOperation("mutation Publish($message: String!){ publish(message: $message) { message } }")
 *         .variables(RuleTargetInput.fromObject(Map.of(
 *                 "message", "hello world")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:56.115Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.RuleTargetInput")
public abstract class RuleTargetInput extends software.amazon.jsii.JsiiObject {

    protected RuleTargetInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RuleTargetInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RuleTargetInput() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Take the event target input from a path in the event JSON.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInput fromEventPath(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.RuleTargetInput.class, "fromEventPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Pass text to the event target, splitting on newlines.
     * <p>
     * This is only useful when passing to a target that does not
     * take a single argument.
     * <p>
     * May contain strings returned by <code>EventField.from()</code> to substitute in parts
     * of the matched event.
     * <p>
     * @param text This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInput fromMultilineText(final @org.jetbrains.annotations.NotNull java.lang.String text) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.RuleTargetInput.class, "fromMultilineText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class), new Object[] { java.util.Objects.requireNonNull(text, "text is required") });
    }

    /**
     * Pass a JSON object to the event target.
     * <p>
     * May contain strings returned by <code>EventField.from()</code> to substitute in parts of the
     * matched event.
     * <p>
     * @return RuleTargetInput
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInput fromObject(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.RuleTargetInput.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class), new Object[] { obj });
    }

    /**
     * Pass text to the event target.
     * <p>
     * May contain strings returned by <code>EventField.from()</code> to substitute in parts of the
     * matched event.
     * <p>
     * The Rule Target input value will be a single string: the string you pass
     * here.  Do not use this method to pass a complex value like a JSON object to
     * a Rule Target.  Use <code>RuleTargetInput.fromObject()</code> instead.
     * <p>
     * @param text This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInput fromText(final @org.jetbrains.annotations.NotNull java.lang.String text) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.RuleTargetInput.class, "fromText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class), new Object[] { java.util.Objects.requireNonNull(text, "text is required") });
    }

    /**
     * Return the input properties for this input object.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInputProperties bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.events.RuleTargetInput {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Return the input properties for this input object.
         * <p>
         * @param rule This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInputProperties bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInputProperties.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
        }
    }
}
