package software.amazon.awscdk.services.events.targets;

/**
 * Override ephemeral storage for the task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.targets.*;
 * EphemeralStorageOverride ephemeralStorageOverride = EphemeralStorageOverride.builder()
 *         .sizeInGiB(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:56.195Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.EphemeralStorageOverride")
@software.amazon.jsii.Jsii.Proxy(EphemeralStorageOverride.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EphemeralStorageOverride extends software.amazon.jsii.JsiiSerializable {

    /**
     * The total amount, in GiB, of ephemeral storage to set for the task.
     * <p>
     * The minimum supported value is 20 GiB and the maximum supported value is 200 GiB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGiB();

    /**
     * @return a {@link Builder} of {@link EphemeralStorageOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EphemeralStorageOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EphemeralStorageOverride> {
        java.lang.Number sizeInGiB;

        /**
         * Sets the value of {@link EphemeralStorageOverride#getSizeInGiB}
         * @param sizeInGiB The total amount, in GiB, of ephemeral storage to set for the task. This parameter is required.
         *                  The minimum supported value is 20 GiB and the maximum supported value is 200 GiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sizeInGiB(java.lang.Number sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EphemeralStorageOverride}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EphemeralStorageOverride build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EphemeralStorageOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EphemeralStorageOverride {
        private final java.lang.Number sizeInGiB;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sizeInGiB = software.amazon.jsii.Kernel.get(this, "sizeInGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sizeInGiB = java.util.Objects.requireNonNull(builder.sizeInGiB, "sizeInGiB is required");
        }

        @Override
        public final java.lang.Number getSizeInGiB() {
            return this.sizeInGiB;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sizeInGiB", om.valueToTree(this.getSizeInGiB()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.EphemeralStorageOverride"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EphemeralStorageOverride.Jsii$Proxy that = (EphemeralStorageOverride.Jsii$Proxy) o;

            return this.sizeInGiB.equals(that.sizeInGiB);
        }

        @Override
        public final int hashCode() {
            int result = this.sizeInGiB.hashCode();
            return result;
        }
    }
}
