package software.amazon.awscdk.services.fsx;

/**
 * The type of drive cache used by PERSISTENT_1 file systems that are provisioned with HDD storage devices.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder()
 *                 .deploymentType(LustreDeploymentType.PERSISTENT_1)
 *                 .driveCacheType(DriveCacheType.READ)
 *                 .build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .storageType(StorageType.HDD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:56.679Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.DriveCacheType")
public enum DriveCacheType {
    /**
     * The Lustre file system is configured with no data cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * The Lustre file system is configured with a read cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ,
}
