package software.amazon.awscdk.services.gameliftstreams;

/**
 * The <code>AWS::GameLiftStreams::StreamGroup</code> resource defines a group of compute resources that will be running and streaming your game.
 * <p>
 * When you create a stream group, you specify the hardware configuration (CPU, GPU, RAM) that will run your game (known as the <em>stream class</em> ), the geographical locations where your game can run, and the number of streams that can run simultaneously in each location (known as <em>stream capacity</em> ). Stream groups manage how Amazon GameLift Streams allocates resources and handles concurrent streams, allowing you to effectively manage capacity and costs.
 * <p>
 * There are two types of stream capacity: always-on and on-demand.
 * <p>
 * <ul>
 * <li><em>Always-on</em> : The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.</li>
 * <li><em>On-demand</em> : The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * Application association is not currently supported in AWS CloudFormation . To link additional applications to a stream group, use the Amazon GameLift Streams console or the AWS CLI .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gameliftstreams.*;
 * CfnStreamGroup cfnStreamGroup = CfnStreamGroup.Builder.create(this, "MyCfnStreamGroup")
 *         .description("description")
 *         .locationConfigurations(List.of(LocationConfigurationProperty.builder()
 *                 .locationName("locationName")
 *                 // the properties below are optional
 *                 .alwaysOnCapacity(123)
 *                 .onDemandCapacity(123)
 *                 .build()))
 *         .streamClass("streamClass")
 *         // the properties below are optional
 *         .defaultApplication(DefaultApplicationProperty.builder()
 *                 .arn("arn")
 *                 .id("id")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:56.980Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gameliftstreams.CfnStreamGroup")
public class CfnStreamGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnStreamGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStreamGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStreamGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.gameliftstreams.CfnStreamGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a> that uniquely identifies the stream group resource. For example: <code>arn:aws:gameliftstreams:us-west-2:123456789012:streamgroup/sg-1AB2C3De4</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID that uniquely identifies the stream group resource.
     * <p>
     * For example: <code>sg-1AB2C3De4</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A descriptive label for the stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive label for the stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * A set of one or more locations and the streaming capacity for each location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLocationConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "locationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of one or more locations and the streaming capacity for each location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocationConfigurations(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "locationConfigurations", java.util.Objects.requireNonNull(value, "locationConfigurations is required"));
    }

    /**
     * A set of one or more locations and the streaming capacity for each location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocationConfigurations(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup.LocationConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup.LocationConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "locationConfigurations", java.util.Objects.requireNonNull(value, "locationConfigurations is required"));
    }

    /**
     * The target stream quality for sessions that are hosted in this stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStreamClass() {
        return software.amazon.jsii.Kernel.get(this, "streamClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The target stream quality for sessions that are hosted in this stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamClass(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "streamClass", java.util.Objects.requireNonNull(value, "streamClass is required"));
    }

    /**
     * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultApplication() {
        return software.amazon.jsii.Kernel.get(this, "defaultApplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultApplication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultApplication", value);
    }

    /**
     * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultApplication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup.DefaultApplicationProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultApplication", value);
    }

    /**
     * A list of labels to assign to the new stream group resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * A list of labels to assign to the new stream group resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Represents the default Amazon GameLift Streams application that a stream group hosts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gameliftstreams.*;
     * DefaultApplicationProperty defaultApplicationProperty = DefaultApplicationProperty.builder()
     *         .arn("arn")
     *         .id("id")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gameliftstreams.CfnStreamGroup.DefaultApplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultApplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultApplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a> that uniquely identifies the application resource. Example ARN: <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html#cfn-gameliftstreams-streamgroup-defaultapplication-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html#cfn-gameliftstreams-streamgroup-defaultapplication-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * An ID that uniquely identifies the application resource.
         * <p>
         * Example ID: <code>a-9ZY8X7Wv6</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html#cfn-gameliftstreams-streamgroup-defaultapplication-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html#cfn-gameliftstreams-streamgroup-defaultapplication-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultApplicationProperty> {
            java.lang.String arn;
            java.lang.String id;

            /**
             * Sets the value of {@link DefaultApplicationProperty#getArn}
             * @param arn An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a> that uniquely identifies the application resource. Example ARN: <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link DefaultApplicationProperty#getId}
             * @param id An ID that uniquely identifies the application resource.
             *           Example ID: <code>a-9ZY8X7Wv6</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultApplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultApplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultApplicationProperty {
            private final java.lang.String arn;
            private final java.lang.String id;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.id = builder.id;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gameliftstreams.CfnStreamGroup.DefaultApplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultApplicationProperty.Jsii$Proxy that = (DefaultApplicationProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.id != null ? this.id.equals(that.id) : that.id == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings that define a stream group's stream capacity for a location.
     * <p>
     * When configuring a location for the first time, you must specify a numeric value for at least one of the two capacity types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gameliftstreams.*;
     * LocationConfigurationProperty locationConfigurationProperty = LocationConfigurationProperty.builder()
     *         .locationName("locationName")
     *         // the properties below are optional
     *         .alwaysOnCapacity(123)
     *         .onDemandCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gameliftstreams.CfnStreamGroup.LocationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A location's name.
         * <p>
         * For example, <code>us-east-1</code> . For a complete list of locations that Amazon GameLift Streams supports, refer to <a href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas, and limitations</a> in the <em>Amazon GameLift Streams Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-locationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-locationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocationName();

        /**
         * The streaming capacity that is allocated and ready to handle stream requests without delay.
         * <p>
         * You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-alwaysoncapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-alwaysoncapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAlwaysOnCapacity() {
            return null;
        }

        /**
         * The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated.
         * <p>
         * This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-ondemandcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-ondemandcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationConfigurationProperty> {
            java.lang.String locationName;
            java.lang.Number alwaysOnCapacity;
            java.lang.Number onDemandCapacity;

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocationName}
             * @param locationName A location's name. This parameter is required.
             *                     For example, <code>us-east-1</code> . For a complete list of locations that Amazon GameLift Streams supports, refer to <a href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas, and limitations</a> in the <em>Amazon GameLift Streams Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationName(java.lang.String locationName) {
                this.locationName = locationName;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getAlwaysOnCapacity}
             * @param alwaysOnCapacity The streaming capacity that is allocated and ready to handle stream requests without delay.
             *                         You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alwaysOnCapacity(java.lang.Number alwaysOnCapacity) {
                this.alwaysOnCapacity = alwaysOnCapacity;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getOnDemandCapacity}
             * @param onDemandCapacity The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated.
             *                         This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandCapacity(java.lang.Number onDemandCapacity) {
                this.onDemandCapacity = onDemandCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationConfigurationProperty {
            private final java.lang.String locationName;
            private final java.lang.Number alwaysOnCapacity;
            private final java.lang.Number onDemandCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.locationName = software.amazon.jsii.Kernel.get(this, "locationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.alwaysOnCapacity = software.amazon.jsii.Kernel.get(this, "alwaysOnCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.onDemandCapacity = software.amazon.jsii.Kernel.get(this, "onDemandCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.locationName = java.util.Objects.requireNonNull(builder.locationName, "locationName is required");
                this.alwaysOnCapacity = builder.alwaysOnCapacity;
                this.onDemandCapacity = builder.onDemandCapacity;
            }

            @Override
            public final java.lang.String getLocationName() {
                return this.locationName;
            }

            @Override
            public final java.lang.Number getAlwaysOnCapacity() {
                return this.alwaysOnCapacity;
            }

            @Override
            public final java.lang.Number getOnDemandCapacity() {
                return this.onDemandCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("locationName", om.valueToTree(this.getLocationName()));
                if (this.getAlwaysOnCapacity() != null) {
                    data.set("alwaysOnCapacity", om.valueToTree(this.getAlwaysOnCapacity()));
                }
                if (this.getOnDemandCapacity() != null) {
                    data.set("onDemandCapacity", om.valueToTree(this.getOnDemandCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gameliftstreams.CfnStreamGroup.LocationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationConfigurationProperty.Jsii$Proxy that = (LocationConfigurationProperty.Jsii$Proxy) o;

                if (!locationName.equals(that.locationName)) return false;
                if (this.alwaysOnCapacity != null ? !this.alwaysOnCapacity.equals(that.alwaysOnCapacity) : that.alwaysOnCapacity != null) return false;
                return this.onDemandCapacity != null ? this.onDemandCapacity.equals(that.onDemandCapacity) : that.onDemandCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.locationName.hashCode();
                result = 31 * result + (this.alwaysOnCapacity != null ? this.alwaysOnCapacity.hashCode() : 0);
                result = 31 * result + (this.onDemandCapacity != null ? this.onDemandCapacity.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.gameliftstreams.CfnStreamGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.gameliftstreams.CfnStreamGroupProps.Builder();
        }

        /**
         * A descriptive label for the stream group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-description</a>
         * @param description A descriptive label for the stream group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A set of one or more locations and the streaming capacity for each location.
         * <p>
         * One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations</a>
         * @param locationConfigurations A set of one or more locations and the streaming capacity for each location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationConfigurations(final software.amazon.awscdk.IResolvable locationConfigurations) {
            this.props.locationConfigurations(locationConfigurations);
            return this;
        }
        /**
         * A set of one or more locations and the streaming capacity for each location.
         * <p>
         * One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations</a>
         * @param locationConfigurations A set of one or more locations and the streaming capacity for each location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationConfigurations(final java.util.List<? extends java.lang.Object> locationConfigurations) {
            this.props.locationConfigurations(locationConfigurations);
            return this;
        }

        /**
         * The target stream quality for sessions that are hosted in this stream group.
         * <p>
         * Set a stream class that is appropriate to the type of content that you're streaming. Stream class determines the type of computing resources Amazon GameLift Streams uses and impacts the cost of streaming. The following options are available:
         * <p>
         * A stream class can be one of the following:
         * <p>
         * <ul>
         * <li><em><code>gen5n_win2022</code> (NVIDIA, ultra)</em> Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.</li>
         * <li>Reference resolution: 1080p</li>
         * <li>Reference frame rate: 60 fps</li>
         * <li>Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM</li>
         * <li>Tenancy: Supports 1 concurrent stream session</li>
         * <li><em><code>gen5n_high</code> (NVIDIA, high)</em> Supports applications with moderate to high 3D scene complexity. Uses NVIDIA A10G Tensor GPU.</li>
         * <li>Reference resolution: 1080p</li>
         * <li>Reference frame rate: 60 fps</li>
         * <li>Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM</li>
         * <li>Tenancy: Supports up to 2 concurrent stream sessions</li>
         * <li><em><code>gen5n_ultra</code> (NVIDIA, ultra)</em> Supports applications with extremely high 3D scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.</li>
         * <li>Reference resolution: 1080p</li>
         * <li>Reference frame rate: 60 fps</li>
         * <li>Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM</li>
         * <li>Tenancy: Supports 1 concurrent stream session</li>
         * <li><em><code>gen4n_win2022</code> (NVIDIA, ultra)</em> Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.</li>
         * <li>Reference resolution: 1080p</li>
         * <li>Reference frame rate: 60 fps</li>
         * <li>Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM</li>
         * <li>Tenancy: Supports 1 concurrent stream session</li>
         * <li><em><code>gen4n_high</code> (NVIDIA, high)</em> Supports applications with moderate to high 3D scene complexity. Uses NVIDIA T4 Tensor GPU.</li>
         * <li>Reference resolution: 1080p</li>
         * <li>Reference frame rate: 60 fps</li>
         * <li>Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM</li>
         * <li>Tenancy: Supports up to 2 concurrent stream sessions</li>
         * <li><em><code>gen4n_ultra</code> (NVIDIA, ultra)</em> Supports applications with high 3D scene complexity. Uses dedicated NVIDIA T4 Tensor GPU.</li>
         * <li>Reference resolution: 1080p</li>
         * <li>Reference frame rate: 60 fps</li>
         * <li>Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM</li>
         * <li>Tenancy: Supports 1 concurrent stream session</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-streamclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-streamclass</a>
         * @param streamClass The target stream quality for sessions that are hosted in this stream group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamClass(final java.lang.String streamClass) {
            this.props.streamClass(streamClass);
            return this;
        }

        /**
         * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication</a>
         * @param defaultApplication Object that identifies the Amazon GameLift Streams application to stream with this stream group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultApplication(final software.amazon.awscdk.IResolvable defaultApplication) {
            this.props.defaultApplication(defaultApplication);
            return this;
        }
        /**
         * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication</a>
         * @param defaultApplication Object that identifies the Amazon GameLift Streams application to stream with this stream group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultApplication(final software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup.DefaultApplicationProperty defaultApplication) {
            this.props.defaultApplication(defaultApplication);
            return this;
        }

        /**
         * A list of labels to assign to the new stream group resource.
         * <p>
         * Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-tags</a>
         * @param tags A list of labels to assign to the new stream group resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup build() {
            return new software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
