package software.amazon.awscdk.services.iam;

/**
 * An IAM principal that represents an AWS service (i.e. <code>sqs.amazonaws.com</code>).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IChainable definition;
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .build();
 * StateMachine stateMachine = StateMachine.Builder.create(this, "StateMachine")
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .build();
 * // Give role permission to get execution history of ALL executions for the state machine
 * stateMachine.grantExecution(role, "states:GetExecutionHistory");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:57.502Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.ServicePrincipal")
public class ServicePrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected ServicePrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServicePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Reference an AWS service, optionally in a given region.
     * <p>
     * @param service AWS service (i.e. sqs.amazonaws.com). This parameter is required.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * Reference an AWS service, optionally in a given region.
     * <p>
     * @param service AWS service (i.e. sqs.amazonaws.com). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Return the service principal using the service principal name as it is passed to the function without any change regardless of the region used in the stack if it is Opted in or not.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ServicePrincipal principalName = ServicePrincipal.fromStaticServicePrincipleName("elasticmapreduce.amazonaws.com.cn");
     * </pre></blockquote>
     * <p>
     * @param servicePrincipalName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.ServicePrincipal fromStaticServicePrincipleName(final @org.jetbrains.annotations.NotNull java.lang.String servicePrincipalName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ServicePrincipal.class, "fromStaticServicePrincipleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ServicePrincipal.class), new Object[] { java.util.Objects.requireNonNull(servicePrincipalName, "servicePrincipalName is required") });
    }

    /**
     * Return the service principal name based on the region it's used in.
     * <p>
     * Some service principal names used to be different for different partitions,
     * and some were not. This method would return the appropriate region-specific
     * service principal name, getting that information from the <code>region-info</code>
     * module.
     * <p>
     * These days all service principal names are standardized, and they are all
     * of the form <code>&lt;servicename&gt;.amazonaws.com</code>.
     * <p>
     * To avoid breaking changes, handling is provided for services added with the formats below,
     * however, no additional handling will be added for new regions or partitions.
     * <p>
     * <ul>
     * <li>s3</li>
     * <li>s3.amazonaws.com</li>
     * <li>s3.amazonaws.com.cn</li>
     * <li>s3.c2s.ic.gov</li>
     * <li>s3.sc2s.sgov.gov</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * String principalName = ServicePrincipal.servicePrincipalName("ec2.amazonaws.com");
     * </pre></blockquote>
     * <p>
     * @param service This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String servicePrincipalName(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ServicePrincipal.class, "servicePrincipalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Return whether or not this principal is equal to the given principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable java.lang.String dedupeString() {
        return software.amazon.jsii.Kernel.call(this, "dedupeString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * AWS service (i.e. sqs.amazonaws.com).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.ServicePrincipal}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.ServicePrincipal> {
        /**
         * @return a new instance of {@link Builder}.
         * @param service AWS service (i.e. sqs.amazonaws.com). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String service) {
            return new Builder(service);
        }

        private final java.lang.String service;
        private software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder opts;

        private Builder(final java.lang.String service) {
            this.service = service;
        }

        /**
         * Additional conditions to add to the Service Principal.
         * <p>
         * Default: - No conditions
         * <p>
         * @return {@code this}
         * @param conditions Additional conditions to add to the Service Principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.Map<java.lang.String, ? extends java.lang.Object> conditions) {
            this.opts().conditions(conditions);
            return this;
        }

        /**
         * The region in which you want to reference the service.
         * <p>
         * This is only necessary for <em>cross-region</em> references to <em>opt-in</em> regions. In those
         * cases, the region name needs to be included to reference the correct service principal.
         * In all other cases, the global service principal name is sufficient.
         * <p>
         * This field behaves differently depending on whether the <code>&#64;aws-cdk/aws-iam:standardizedServicePrincipals</code>
         * flag is set or not:
         * <p>
         * <ul>
         * <li>If the flag is set, the input service principal is assumed to be of the form <code>SERVICE.amazonaws.com</code>.
         * That value will always be returned, unless the given region is an opt-in region and the service
         * principal is rendered in a stack in a different region, in which case <code>SERVICE.REGION.amazonaws.com</code>
         * will be rendered. Under this regime, there is no downside to always specifying the region property:
         * it will be rendered only if necessary.</li>
         * <li>If the flag is not set, the service principal will resolve to a single principal
         * whose name comes from the <code>&#64;aws-cdk/region-info</code> package, using the region to override
         * the stack region. If there is no entry for this service principal in the database,, the input
         * service name is returned literally. This is legacy behavior and is not recommended.</li>
         * </ul>
         * <p>
         * Default: - the resolving Stack's region.
         * <p>
         * @return {@code this}
         * @param region The region in which you want to reference the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.opts().region(region);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iam.ServicePrincipal}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.ServicePrincipal build() {
            return new software.amazon.awscdk.services.iam.ServicePrincipal(
                this.service,
                this.opts != null ? this.opts.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder opts() {
            if (this.opts == null) {
                this.opts = new software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder();
            }
            return this.opts;
        }
    }
}
