package software.amazon.awscdk.services.iottwinmaker;

/**
 * Properties for defining a <code>CfnEntity</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iottwinmaker.*;
 * DataValueProperty dataValueProperty_;
 * Object definition;
 * Object error;
 * Object relationshipValue;
 * CfnEntityProps cfnEntityProps = CfnEntityProps.builder()
 *         .entityName("entityName")
 *         .workspaceId("workspaceId")
 *         // the properties below are optional
 *         .components(Map.of(
 *                 "componentsKey", ComponentProperty.builder()
 *                         .componentName("componentName")
 *                         .componentTypeId("componentTypeId")
 *                         .definedIn("definedIn")
 *                         .description("description")
 *                         .properties(Map.of(
 *                                 "propertiesKey", PropertyProperty.builder()
 *                                         .definition(definition)
 *                                         .value(DataValueProperty.builder()
 *                                                 .booleanValue(false)
 *                                                 .doubleValue(123)
 *                                                 .expression("expression")
 *                                                 .integerValue(123)
 *                                                 .listValue(List.of(dataValueProperty_))
 *                                                 .longValue(123)
 *                                                 .mapValue(Map.of(
 *                                                         "mapValueKey", dataValueProperty_))
 *                                                 .relationshipValue(relationshipValue)
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build()))
 *                         .propertyGroups(Map.of(
 *                                 "propertyGroupsKey", PropertyGroupProperty.builder()
 *                                         .groupType("groupType")
 *                                         .propertyNames(List.of("propertyNames"))
 *                                         .build()))
 *                         .status(StatusProperty.builder()
 *                                 .error(error)
 *                                 .state("state")
 *                                 .build())
 *                         .build()))
 *         .compositeComponents(Map.of(
 *                 "compositeComponentsKey", CompositeComponentProperty.builder()
 *                         .componentName("componentName")
 *                         .componentPath("componentPath")
 *                         .componentTypeId("componentTypeId")
 *                         .description("description")
 *                         .properties(Map.of(
 *                                 "propertiesKey", PropertyProperty.builder()
 *                                         .definition(definition)
 *                                         .value(DataValueProperty.builder()
 *                                                 .booleanValue(false)
 *                                                 .doubleValue(123)
 *                                                 .expression("expression")
 *                                                 .integerValue(123)
 *                                                 .listValue(List.of(dataValueProperty_))
 *                                                 .longValue(123)
 *                                                 .mapValue(Map.of(
 *                                                         "mapValueKey", dataValueProperty_))
 *                                                 .relationshipValue(relationshipValue)
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build()))
 *                         .propertyGroups(Map.of(
 *                                 "propertyGroupsKey", PropertyGroupProperty.builder()
 *                                         .groupType("groupType")
 *                                         .propertyNames(List.of("propertyNames"))
 *                                         .build()))
 *                         .status(StatusProperty.builder()
 *                                 .error(error)
 *                                 .state("state")
 *                                 .build())
 *                         .build()))
 *         .description("description")
 *         .entityId("entityId")
 *         .parentEntityId("parentEntityId")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:57.997Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntityProps")
@software.amazon.jsii.Jsii.Proxy(CfnEntityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEntityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The entity name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntityName();

    /**
     * The ID of the workspace that contains the entity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-workspaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-workspaceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceId();

    /**
     * An object that maps strings to the components in the entity.
     * <p>
     * Each string in the mapping must be unique to this object.
     * <p>
     * For information on the component object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_ComponentResponse.html">component</a> API reference.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComponents() {
        return null;
    }

    /**
     * Maps string to <code>compositeComponent</code> updates in the request.
     * <p>
     * Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-compositecomponents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-compositecomponents</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCompositeComponents() {
        return null;
    }

    /**
     * The description of the entity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ID of the entity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEntityId() {
        return null;
    }

    /**
     * The ID of the parent entity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-parententityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-parententityid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getParentEntityId() {
        return null;
    }

    /**
     * Metadata that you can use to manage the entity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEntityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEntityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEntityProps> {
        java.lang.String entityName;
        java.lang.String workspaceId;
        java.lang.Object components;
        java.lang.Object compositeComponents;
        java.lang.String description;
        java.lang.String entityId;
        java.lang.String parentEntityId;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnEntityProps#getEntityName}
         * @param entityName The entity name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityName(java.lang.String entityName) {
            this.entityName = entityName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getWorkspaceId}
         * @param workspaceId The ID of the workspace that contains the entity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceId(java.lang.String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getComponents}
         * @param components An object that maps strings to the components in the entity.
         *                   Each string in the mapping must be unique to this object.
         *                   <p>
         *                   For information on the component object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_ComponentResponse.html">component</a> API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(software.amazon.awscdk.IResolvable components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getComponents}
         * @param components An object that maps strings to the components in the entity.
         *                   Each string in the mapping must be unique to this object.
         *                   <p>
         *                   For information on the component object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_ComponentResponse.html">component</a> API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(java.util.Map<java.lang.String, ? extends java.lang.Object> components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getCompositeComponents}
         * @param compositeComponents Maps string to <code>compositeComponent</code> updates in the request.
         *                            Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponents(software.amazon.awscdk.IResolvable compositeComponents) {
            this.compositeComponents = compositeComponents;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getCompositeComponents}
         * @param compositeComponents Maps string to <code>compositeComponent</code> updates in the request.
         *                            Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponents(java.util.Map<java.lang.String, ? extends java.lang.Object> compositeComponents) {
            this.compositeComponents = compositeComponents;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getDescription}
         * @param description The description of the entity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getEntityId}
         * @param entityId The ID of the entity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityId(java.lang.String entityId) {
            this.entityId = entityId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getParentEntityId}
         * @param parentEntityId The ID of the parent entity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentEntityId(java.lang.String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEntityProps#getTags}
         * @param tags Metadata that you can use to manage the entity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEntityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEntityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEntityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEntityProps {
        private final java.lang.String entityName;
        private final java.lang.String workspaceId;
        private final java.lang.Object components;
        private final java.lang.Object compositeComponents;
        private final java.lang.String description;
        private final java.lang.String entityId;
        private final java.lang.String parentEntityId;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entityName = software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceId = software.amazon.jsii.Kernel.get(this, "workspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.components = software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.compositeComponents = software.amazon.jsii.Kernel.get(this, "compositeComponents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entityId = software.amazon.jsii.Kernel.get(this, "entityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parentEntityId = software.amazon.jsii.Kernel.get(this, "parentEntityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entityName = java.util.Objects.requireNonNull(builder.entityName, "entityName is required");
            this.workspaceId = java.util.Objects.requireNonNull(builder.workspaceId, "workspaceId is required");
            this.components = builder.components;
            this.compositeComponents = builder.compositeComponents;
            this.description = builder.description;
            this.entityId = builder.entityId;
            this.parentEntityId = builder.parentEntityId;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getEntityName() {
            return this.entityName;
        }

        @Override
        public final java.lang.String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        public final java.lang.Object getComponents() {
            return this.components;
        }

        @Override
        public final java.lang.Object getCompositeComponents() {
            return this.compositeComponents;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEntityId() {
            return this.entityId;
        }

        @Override
        public final java.lang.String getParentEntityId() {
            return this.parentEntityId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entityName", om.valueToTree(this.getEntityName()));
            data.set("workspaceId", om.valueToTree(this.getWorkspaceId()));
            if (this.getComponents() != null) {
                data.set("components", om.valueToTree(this.getComponents()));
            }
            if (this.getCompositeComponents() != null) {
                data.set("compositeComponents", om.valueToTree(this.getCompositeComponents()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEntityId() != null) {
                data.set("entityId", om.valueToTree(this.getEntityId()));
            }
            if (this.getParentEntityId() != null) {
                data.set("parentEntityId", om.valueToTree(this.getParentEntityId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEntityProps.Jsii$Proxy that = (CfnEntityProps.Jsii$Proxy) o;

            if (!entityName.equals(that.entityName)) return false;
            if (!workspaceId.equals(that.workspaceId)) return false;
            if (this.components != null ? !this.components.equals(that.components) : that.components != null) return false;
            if (this.compositeComponents != null ? !this.compositeComponents.equals(that.compositeComponents) : that.compositeComponents != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) return false;
            if (this.parentEntityId != null ? !this.parentEntityId.equals(that.parentEntityId) : that.parentEntityId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.entityName.hashCode();
            result = 31 * result + (this.workspaceId.hashCode());
            result = 31 * result + (this.components != null ? this.components.hashCode() : 0);
            result = 31 * result + (this.compositeComponents != null ? this.compositeComponents.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
            result = 31 * result + (this.parentEntityId != null ? this.parentEntityId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
